/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.jps.service.SharedThreadPool;

public class JdkVersionDetectorImpl
extends JdkVersionDetector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.SdkVersionUtil");
    private static final JdkVersionDetector.ActionRunner ACTION_RUNNER = r -> SharedThreadPool.getInstance().executeOnPooledThread(r);

    @Override
    @Nullable
    public String detectJdkVersion(@NotNull String homePath) {
        if (homePath == null) {
            JdkVersionDetectorImpl.$$$reportNull$$$0(0);
        }
        return this.detectJdkVersion(homePath, ACTION_RUNNER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public String detectJdkVersion(@NotNull String homePath, @NotNull JdkVersionDetector.ActionRunner runner) {
        JdkVersionDetector.JdkVersionInfo info;
        File rtFile;
        if (homePath == null) {
            JdkVersionDetectorImpl.$$$reportNull$$$0(1);
        }
        if (runner == null) {
            JdkVersionDetectorImpl.$$$reportNull$$$0(2);
        }
        if ((rtFile = new File(homePath, "jre/lib/rt.jar")).isFile()) {
            try (JarFile rtJar = new JarFile(rtFile, false);){
                String version;
                Manifest manifest2 = rtJar.getManifest();
                if (manifest2 != null && (version = manifest2.getMainAttributes().getValue("Implementation-Version")) != null) {
                    String string = "java version \"" + version + "\"";
                    return string;
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        if ((info = this.detectJdkVersionInfo(homePath, runner)) == null) return null;
        String string = info.getVersion();
        return string;
    }

    @Override
    public JdkVersionDetector.JdkVersionInfo detectJdkVersionInfo(@NotNull String homePath) {
        if (homePath == null) {
            JdkVersionDetectorImpl.$$$reportNull$$$0(3);
        }
        return this.detectJdkVersionInfo(homePath, ACTION_RUNNER);
    }

    @Override
    public JdkVersionDetector.JdkVersionInfo detectJdkVersionInfo(@NotNull String homePath, @NotNull JdkVersionDetector.ActionRunner runner) {
        String javaExe;
        File releaseFile;
        if (homePath == null) {
            JdkVersionDetectorImpl.$$$reportNull$$$0(4);
        }
        if (runner == null) {
            JdkVersionDetectorImpl.$$$reportNull$$$0(5);
        }
        if ((releaseFile = new File(homePath, "release")).isFile()) {
            try {
                Properties p = new Properties();
                p.load(new FileInputStream(releaseFile));
                String version = p.getProperty("JAVA_FULL_VERSION", p.getProperty("JAVA_VERSION"));
                if (version != null) {
                    String arch;
                    int i = (version = StringUtil.unquoteString((String)version)).indexOf(43);
                    if (i > 0) {
                        version = version.substring(0, i);
                    }
                    boolean x64 = "x86_64".equals(arch = StringUtil.unquoteString((String)p.getProperty("OS_ARCH", ""))) || "amd64".equals(arch);
                    return new JdkVersionDetector.JdkVersionInfo("java version \"" + version + "\"", x64 ? Bitness.x64 : Bitness.x32);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        if (new File(javaExe = homePath + File.separator + "bin" + File.separator + (SystemInfo.isWindows ? "java.exe" : "java")).canExecute()) {
            try {
                Process process2 = new ProcessBuilder(javaExe, "-version").redirectErrorStream(true).start();
                VersionOutputReader reader = new VersionOutputReader(process2.getInputStream(), runner);
                try {
                    reader.waitFor();
                }
                catch (InterruptedException e) {
                    LOG.info((Throwable)e);
                    process2.destroy();
                }
                return reader.getVersionInfo();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "detectJdkVersion";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "detectJdkVersionInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VersionOutputReader
    extends BaseOutputReader {
        private static final BaseOutputReader.Options OPTIONS = new BaseOutputReader.Options(){

            public BaseDataReader.SleepingPolicy policy() {
                return BaseDataReader.SleepingPolicy.BLOCKING;
            }

            public boolean splitToLines() {
                return true;
            }

            public boolean sendIncompleteLines() {
                return false;
            }

            public boolean withSeparators() {
                return false;
            }
        };
        private final JdkVersionDetector.ActionRunner myRunner;
        private final List<String> myLines;

        public VersionOutputReader(@NotNull InputStream stream2, @NotNull JdkVersionDetector.ActionRunner runner) {
            if (stream2 == null) {
                VersionOutputReader.$$$reportNull$$$0(0);
            }
            if (runner == null) {
                VersionOutputReader.$$$reportNull$$$0(1);
            }
            super(stream2, CharsetToolkit.getDefaultSystemCharset(), OPTIONS);
            this.myRunner = runner;
            this.myLines = new CopyOnWriteArrayList<String>();
            this.start("java -version");
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                VersionOutputReader.$$$reportNull$$$0(2);
            }
            Future<?> future = this.myRunner.run(runnable);
            if (future == null) {
                VersionOutputReader.$$$reportNull$$$0(3);
            }
            return future;
        }

        protected void onTextAvailable(@NotNull String text2) {
            if (text2 == null) {
                VersionOutputReader.$$$reportNull$$$0(4);
            }
            this.myLines.add(text2);
            LOG.debug("text: " + text2);
        }

        @Nullable
        public JdkVersionDetector.JdkVersionInfo getVersionInfo() {
            String version = null;
            Bitness arch = Bitness.x32;
            for (String line : this.myLines) {
                if (line.contains("version")) {
                    if (version != null) continue;
                    version = line;
                    continue;
                }
                if (!line.contains("64-Bit") && !line.contains("x86_64") && !line.contains("amd64")) continue;
                arch = Bitness.x64;
            }
            LOG.debug("Returning " + version + " " + arch);
            return version != null ? new JdkVersionDetector.JdkVersionInfo(version, arch) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl$VersionOutputReader";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl$VersionOutputReader";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "onTextAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

