/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;

public class MessageUtil {
    private MessageUtil() {
    }

    @Nullable
    public static CompilerMessageLocation psiElementToMessageLocation(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile file2 = element.getContainingFile();
        return MessageUtil.psiFileToMessageLocation(file2, "<no path>", DiagnosticUtils.getLineAndColumnInPsiFile(file2, element.getTextRange()));
    }

    @Nullable
    public static CompilerMessageLocation psiFileToMessageLocation(@NotNull PsiFile file2, @Nullable String defaultValue, @NotNull DiagnosticUtils.LineAndColumn lineAndColumn) {
        VirtualFile virtualFile2 = file2.getVirtualFile();
        String path2 = virtualFile2 != null ? MessageUtil.virtualFileToPath(virtualFile2) : defaultValue;
        return CompilerMessageLocation.create(path2, lineAndColumn.getLine(), lineAndColumn.getColumn(), lineAndColumn.getLineContent());
    }

    @NotNull
    public static String virtualFileToPath(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 instanceof CoreLocalVirtualFile || virtualFile2 instanceof CoreJarVirtualFile) {
            return FileUtil.toSystemDependentName((String)virtualFile2.getPath());
        }
        return virtualFile2.getPath();
    }
}

