/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.operation.AssignmentTranslator;
import org.jetbrains.kotlin.js.translate.operation.CompareToTranslator;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public final class BinaryOperationTranslator
extends AbstractTranslator {
    @NotNull
    private final KtBinaryExpression expression;
    @NotNull
    private final KtExpression leftKtExpression;
    @NotNull
    private final KtExpression rightKtExpression;
    @NotNull
    private final KtToken operationToken;
    @Nullable
    private final CallableDescriptor operationDescriptor;

    @NotNull
    public static JsExpression translate(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        JsExpression jsExpression = new BinaryOperationTranslator(expression2, context).translate();
        return jsExpression.source(expression2);
    }

    @NotNull
    static JsExpression translateAsOverloadedCall(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        JsExpression jsExpression = new BinaryOperationTranslator(expression2, context).translateAsOverloadedBinaryOperation();
        return jsExpression.source(expression2);
    }

    private BinaryOperationTranslator(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression2;
        assert (expression2.getLeft() != null) : "Binary expression should have a left expression: " + expression2.getText();
        this.leftKtExpression = expression2.getLeft();
        assert (expression2.getRight() != null) : "Binary expression should have a right expression: " + expression2.getText();
        this.rightKtExpression = expression2.getRight();
        this.operationToken = PsiUtils.getOperationToken(expression2);
        this.operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(this.bindingContext(), expression2);
    }

    @NotNull
    private JsExpression translate() {
        BinaryOperationIntrinsic intrinsic = this.getIntrinsicForExpression();
        if (intrinsic.exists()) {
            return this.applyIntrinsic(intrinsic);
        }
        if (this.operationToken == KtTokens.ELVIS) {
            return this.translateElvis();
        }
        if (AssignmentTranslator.isAssignmentOperator(this.operationToken)) {
            return AssignmentTranslator.translate(this.expression, this.context());
        }
        if (this.isNotOverloadable()) {
            return this.translateAsUnOverloadableBinaryOperation();
        }
        if (CompareToTranslator.isCompareToCall(this.operationToken, this.operationDescriptor)) {
            return CompareToTranslator.translate(this.expression, this.context());
        }
        if (this.isEquals()) {
            return this.translateEquals();
        }
        assert (this.operationDescriptor != null) : "Overloadable operations must have not null descriptor";
        return this.translateAsOverloadedBinaryOperation();
    }

    @NotNull
    private JsExpression translateElvis() {
        JsIf ifStatement;
        JsExpression result2;
        KotlinType expressionType = this.context().bindingContext().getType(this.expression);
        assert (expressionType != null);
        JsExpression leftExpression = TranslationUtils.coerce(this.context(), Translation.translateAsExpression(this.leftKtExpression, this.context()), TypeUtilsKt.makeNullable(expressionType));
        JsBlock rightBlock = new JsBlock();
        JsExpression rightExpression = TranslationUtils.coerce(this.context(), Translation.translateAsExpression(this.rightKtExpression, this.context(), rightBlock), expressionType);
        if (rightBlock.isEmpty()) {
            return TranslationUtils.notNullConditional(leftExpression, rightExpression, this.context());
        }
        if (BindingContextUtilsKt.isUsedAsExpression(this.expression, this.context().bindingContext())) {
            result2 = this.context().cacheExpressionIfNeeded(leftExpression);
            JsBinaryOperation testExpression = TranslationUtils.isNullCheck(result2);
            rightBlock.getStatements().add(JsAstUtils.assignment(result2, rightExpression).makeStmt());
            ifStatement = JsAstUtils.newJsIf(testExpression, rightBlock);
        } else {
            result2 = new JsNullLiteral();
            JsBinaryOperation testExpression = TranslationUtils.isNullCheck(leftExpression);
            ifStatement = JsAstUtils.newJsIf(testExpression, rightBlock);
        }
        ifStatement.setSource(this.expression);
        this.context().addStatementToCurrentBlock(ifStatement);
        return result2;
    }

    @NotNull
    private BinaryOperationIntrinsic getIntrinsicForExpression() {
        return this.context().intrinsics().getBinaryOperationIntrinsic(this.expression, this.context());
    }

    @NotNull
    private JsExpression applyIntrinsic(@NotNull BinaryOperationIntrinsic intrinsic) {
        JsExpression leftExpression = Translation.translateAsExpression(this.leftKtExpression, this.context());
        JsBlock rightBlock = new JsBlock();
        JsExpression rightExpression = Translation.translateAsExpression(this.rightKtExpression, this.context(), rightBlock);
        if (rightBlock.isEmpty()) {
            return intrinsic.apply(this.expression, leftExpression, rightExpression, this.context());
        }
        leftExpression = this.context().cacheExpressionIfNeeded(leftExpression);
        this.context().addStatementsToCurrentBlockFrom(rightBlock);
        return intrinsic.apply(this.expression, leftExpression, rightExpression, this.context());
    }

    private boolean isNotOverloadable() {
        return OperatorConventions.NOT_OVERLOADABLE.contains((Object)this.operationToken);
    }

    @NotNull
    private JsExpression translateAsUnOverloadableBinaryOperation() {
        JsIf ifStatement;
        JsExpression result2;
        assert (OperatorConventions.NOT_OVERLOADABLE.contains((Object)this.operationToken));
        JsBinaryOperator operator = OperatorTable.getBinaryOperator(this.operationToken);
        JsExpression leftExpression = Translation.translateAsExpression(this.leftKtExpression, this.context());
        JsBlock rightBlock = new JsBlock();
        JsExpression rightExpression = Translation.translateAsExpression(this.rightKtExpression, this.context(), rightBlock);
        if (rightBlock.isEmpty()) {
            return new JsBinaryOperation(operator, leftExpression, rightExpression);
        }
        if (OperatorConventions.IDENTITY_EQUALS_OPERATIONS.contains((Object)this.operationToken)) {
            this.context().addStatementsToCurrentBlockFrom(rightBlock);
            return new JsBinaryOperation(operator, leftExpression, rightExpression);
        }
        assert (((Object)((Object)this.operationToken)).equals((Object)KtTokens.ANDAND) || ((Object)((Object)this.operationToken)).equals((Object)KtTokens.OROR)) : "Unsupported binary operation: " + this.expression.getText();
        boolean isOror = ((Object)((Object)this.operationToken)).equals((Object)KtTokens.OROR);
        JsExpression literalResult = new JsBooleanLiteral(isOror).source(this.rightKtExpression);
        JsExpression jsExpression = leftExpression = isOror ? JsAstUtils.not(leftExpression) : leftExpression;
        if (BindingContextUtilsKt.isUsedAsExpression(this.expression, this.context().bindingContext())) {
            if (rightExpression instanceof JsNameRef) {
                result2 = rightExpression;
            } else {
                result2 = this.context().declareTemporary(null, this.rightKtExpression).reference();
                JsExpression rightAssignment = JsAstUtils.assignment(result2.deepCopy(), rightExpression).source(this.rightKtExpression);
                rightBlock.getStatements().add(JsAstUtils.asSyntheticStatement(rightAssignment));
            }
            JsStatement assignmentStatement = JsAstUtils.asSyntheticStatement(JsAstUtils.assignment(result2.deepCopy(), literalResult).source(this.rightKtExpression));
            ifStatement = JsAstUtils.newJsIf(leftExpression, rightBlock, assignmentStatement);
            MetadataProperties.setSynthetic(ifStatement, true);
        } else {
            ifStatement = JsAstUtils.newJsIf(leftExpression, rightBlock);
            result2 = new JsNullLiteral();
        }
        ifStatement.source(this.expression);
        this.context().addStatementToCurrentBlock(ifStatement);
        return result2;
    }

    private boolean isEquals() {
        return this.operationToken == KtTokens.EQEQ || this.operationToken == KtTokens.EXCLEQ;
    }

    private JsExpression translateEquals() {
        JsExpression left = Translation.translateAsExpression(this.leftKtExpression, this.context());
        JsExpression right = Translation.translateAsExpression(this.rightKtExpression, this.context());
        if (left instanceof JsNullLiteral || right instanceof JsNullLiteral) {
            JsBinaryOperator operator = this.operationToken == KtTokens.EXCLEQ ? JsBinaryOperator.NEQ : JsBinaryOperator.EQ;
            return new JsBinaryOperation(operator, left, right);
        }
        KotlinType leftType = this.context().bindingContext().getType(this.leftKtExpression);
        KotlinType rightType = this.context().bindingContext().getType(this.rightKtExpression);
        if (leftType != null && TypeUtils.isNullableType(leftType) || rightType != null && TypeUtils.isNullableType(rightType)) {
            return this.mayBeWrapWithNegation(TopLevelFIF.KOTLIN_EQUALS.apply(left, Collections.singletonList(right), this.context()));
        }
        return this.translateAsOverloadedBinaryOperation();
    }

    @NotNull
    private JsExpression translateAsOverloadedBinaryOperation() {
        ResolvedCall<? extends FunctionDescriptor> resolvedCall2 = CallUtilKt.getFunctionResolvedCallWithAssert(this.expression, this.bindingContext());
        JsExpression result2 = CallTranslator.translate(this.context(), resolvedCall2, this.getReceiver());
        return this.mayBeWrapWithNegation(result2);
    }

    @NotNull
    private JsExpression getReceiver() {
        if (KtPsiUtil.isInOrNotInOperation(this.expression)) {
            return Translation.translateAsExpression(this.rightKtExpression, this.context());
        }
        return Translation.translateAsExpression(this.leftKtExpression, this.context());
    }

    @NotNull
    private JsExpression mayBeWrapWithNegation(@NotNull JsExpression result2) {
        if (PsiUtils.isNegatedOperation(this.expression)) {
            return JsAstUtils.not(result2);
        }
        return result2;
    }
}

