/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.general;

import com.intellij.psi.PsiElement;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameBinding;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationUnit;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationException;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationRuntimeException;
import org.jetbrains.kotlin.js.facade.exceptions.UnsupportedFeatureException;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.StaticContext;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.FileDeclarationVisitor;
import org.jetbrains.kotlin.js.translate.expression.ExpressionVisitor;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.general.AstGenerationResult;
import org.jetbrains.kotlin.js.translate.general.Merger;
import org.jetbrains.kotlin.js.translate.general.ModuleWrapperTranslation;
import org.jetbrains.kotlin.js.translate.test.JSTestGenerator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.mutator.AssignToExpressionMutator;
import org.jetbrains.kotlin.js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.serialization.js.ast.JsAstDeserializer;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public final class Translation {
    private static final String ENUM_SIGNATURE = "kotlin$Enum";

    private Translation() {
    }

    @NotNull
    public static PatternTranslator patternTranslator(@NotNull TranslationContext context) {
        return PatternTranslator.newInstance(context);
    }

    @NotNull
    public static JsNode translateExpression(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        return Translation.translateExpression(expression2, context, context.dynamicContext().jsBlock());
    }

    @NotNull
    public static JsNode translateExpression(@NotNull KtExpression expression2, @NotNull TranslationContext context, @NotNull JsBlock block) {
        JsExpression constantResult;
        KotlinType type2;
        JsExpression aliasForExpression = context.aliasingContext().getAliasForExpression(expression2);
        if (aliasForExpression != null) {
            return aliasForExpression;
        }
        CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression2, context.bindingContext());
        if (compileTimeValue != null && !compileTimeValue.getUsesNonConstValAsConstant() && (type2 = context.bindingContext().getType(expression2)) != null && (KotlinBuiltIns.isLong(type2) || KotlinBuiltIns.isInt(type2)) && (constantResult = Translation.translateConstant(compileTimeValue, expression2, context)) != null) {
            constantResult.setSource(expression2);
            if (KotlinBuiltIns.isLong(type2)) {
                DeclarationDescriptor descriptor2;
                KtSimpleNameExpression referenceExpression = PsiUtils.getSimpleName(expression2);
                if (referenceExpression != null && (descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), referenceExpression)) != null) {
                    return context.declareConstantValue(descriptor2, referenceExpression, constantResult);
                }
                String name = NameSuggestion.sanitizeName("L" + compileTimeValue.getValue(type2).toString());
                return context.declareConstantValue(name, "constant:" + name, constantResult);
            }
            if (KotlinBuiltIns.isInt(type2)) {
                return constantResult;
            }
        }
        TranslationContext innerContext = context.innerBlock();
        JsNode result2 = Translation.doTranslateExpression(expression2, innerContext);
        context.moveVarsFrom(innerContext);
        block.getStatements().addAll(innerContext.dynamicContext().jsBlock().getStatements());
        return result2;
    }

    @Nullable
    public static JsExpression translateConstant(@NotNull CompileTimeConstant compileTimeValue, @NotNull KtExpression expression2, @NotNull TranslationContext context) {
        KotlinType expectedType = context.bindingContext().getType(expression2);
        ConstantValue constant = compileTimeValue.toConstantValue(expectedType != null ? expectedType : TypeUtils.NO_EXPECTED_TYPE);
        JsExpression result2 = Translation.translateConstantWithoutType(constant);
        if (result2 != null) {
            MetadataProperties.setType(result2, expectedType);
        }
        return result2;
    }

    @Nullable
    private static JsExpression translateConstantWithoutType(@NotNull ConstantValue<?> constant) {
        if (constant instanceof NullValue) {
            return new JsNullLiteral();
        }
        Object value = constant.getValue();
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return new JsIntLiteral(((Number)value).intValue());
        }
        if (value instanceof Long) {
            return JsAstUtils.newLong((Long)value);
        }
        if (value instanceof Float) {
            float floatValue = ((Float)value).floatValue();
            double doubleValue = Float.isInfinite(floatValue) || Float.isNaN(floatValue) ? (double)floatValue : Double.parseDouble(Float.toString(floatValue));
            return new JsDoubleLiteral(doubleValue);
        }
        if (value instanceof Number) {
            return new JsDoubleLiteral(((Number)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return new JsBooleanLiteral((Boolean)value);
        }
        if (value instanceof String) {
            return new JsStringLiteral((String)value);
        }
        if (value instanceof Character) {
            return new JsIntLiteral(((Character)value).charValue());
        }
        return null;
    }

    @NotNull
    private static JsNode doTranslateExpression(KtExpression expression2, TranslationContext context) {
        try {
            return expression2.accept(new ExpressionVisitor(), context);
        }
        catch (TranslationRuntimeException e) {
            throw e;
        }
        catch (AssertionError | RuntimeException e) {
            throw new TranslationRuntimeException((PsiElement)expression2, (Throwable)e);
        }
    }

    @NotNull
    public static JsExpression translateAsExpression(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        return Translation.translateAsExpression(expression2, context, context.dynamicContext().jsBlock());
    }

    @NotNull
    public static JsExpression translateAsExpression(@NotNull KtExpression expression2, @NotNull TranslationContext context, @NotNull JsBlock block) {
        JsNode jsNode = Translation.translateExpression(expression2, context, block);
        if (jsNode instanceof JsExpression) {
            JsExpression jsExpression = (JsExpression)jsNode;
            KotlinType type2 = context.bindingContext().getType(expression2);
            if (MetadataProperties.getType(jsExpression) == null) {
                MetadataProperties.setType(jsExpression, type2);
            } else if (type2 != null) {
                jsExpression = TranslationUtils.coerce(context, jsExpression, type2);
            }
            return jsExpression;
        }
        assert (jsNode instanceof JsStatement) : "Unexpected node of type: " + jsNode.getClass().toString();
        if (BindingContextUtilsKt.isUsedAsExpression(expression2, context.bindingContext())) {
            TemporaryVariable result2 = context.declareTemporary(null, expression2);
            AssignToExpressionMutator saveResultToTemporaryMutator = new AssignToExpressionMutator(result2.reference());
            block.getStatements().add(LastExpressionMutator.mutateLastExpression(jsNode, saveResultToTemporaryMutator));
            JsNameRef tmpVar = result2.reference();
            MetadataProperties.setType(tmpVar, context.bindingContext().getType(expression2));
            return tmpVar;
        }
        block.getStatements().add(JsAstUtils.convertToStatement(jsNode));
        return new JsNullLiteral().source(expression2);
    }

    @NotNull
    public static JsStatement translateAsStatement(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        return Translation.translateAsStatement(expression2, context, context.dynamicContext().jsBlock());
    }

    @NotNull
    public static JsStatement translateAsStatement(@NotNull KtExpression expression2, @NotNull TranslationContext context, @NotNull JsBlock block) {
        return JsAstUtils.convertToStatement(Translation.translateExpression(expression2, context, block));
    }

    @NotNull
    public static JsStatement translateAsStatementAndMergeInBlockIfNeeded(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        JsBlock block = new JsBlock();
        JsNode node = Translation.translateExpression(expression2, context, block);
        return JsAstUtils.mergeStatementInBlockIfNeeded(JsAstUtils.convertToStatement(node), block);
    }

    @NotNull
    public static AstGenerationResult generateAst(@NotNull BindingTrace bindingTrace, @NotNull Collection<TranslationUnit> units, @NotNull MainCallParameters mainCallParameters, @NotNull ModuleDescriptor moduleDescriptor, @NotNull JsConfig config, @NotNull SourceFilePathResolver sourceFilePathResolver) throws TranslationException {
        try {
            return Translation.doGenerateAst(bindingTrace, units, mainCallParameters, moduleDescriptor, config, sourceFilePathResolver);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedFeatureException("Unsupported feature used.", e);
        }
        catch (Throwable e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
    }

    @NotNull
    private static AstGenerationResult doGenerateAst(@NotNull BindingTrace bindingTrace, @NotNull Collection<TranslationUnit> units, @NotNull MainCallParameters mainCallParameters, @NotNull ModuleDescriptor moduleDescriptor, @NotNull JsConfig config, @NotNull SourceFilePathResolver sourceFilePathResolver) {
        JsProgramFragment mainCallFragment;
        JsProgram program = new JsProgram();
        JsFunction rootFunction = new JsFunction((JsScope)program.getRootScope(), new JsBlock(), "root function");
        JsName internalModuleName = program.getScope().declareName("_");
        Merger merger = new Merger(rootFunction, internalModuleName, moduleDescriptor);
        HashMap<KtFile, JsProgramFragment> fragmentMap = new HashMap<KtFile, JsProgramFragment>();
        ArrayList<JsProgramFragment> fragments2 = new ArrayList<JsProgramFragment>();
        ArrayList<JsProgramFragment> newFragments = new ArrayList<JsProgramFragment>();
        HashMap<KtFile, ArrayList<DeclarationDescriptor>> fileMemberScopes = new HashMap<KtFile, ArrayList<DeclarationDescriptor>>();
        List sourceRoots = config.getSourceMapRoots().stream().map(File::new).collect(Collectors.toList());
        JsAstDeserializer deserializer = new JsAstDeserializer(program, sourceRoots);
        for (TranslationUnit unit : units) {
            if (unit instanceof TranslationUnit.SourceFile) {
                KtFile file2 = ((TranslationUnit.SourceFile)unit).getFile();
                StaticContext staticContext = new StaticContext(bindingTrace, config, moduleDescriptor, sourceFilePathResolver);
                TranslationContext context = TranslationContext.rootContext(staticContext);
                ArrayList<DeclarationDescriptor> fileMemberScope = new ArrayList<DeclarationDescriptor>();
                Translation.translateFile(context, file2, fileMemberScope);
                fragments2.add(staticContext.getFragment());
                newFragments.add(staticContext.getFragment());
                fragmentMap.put(file2, staticContext.getFragment());
                fileMemberScopes.put(file2, fileMemberScope);
                merger.addFragment(staticContext.getFragment());
                continue;
            }
            if (!(unit instanceof TranslationUnit.BinaryAst)) continue;
            byte[] astData = ((TranslationUnit.BinaryAst)unit).getData();
            JsProgramFragment fragment = deserializer.deserialize(new ByteArrayInputStream(astData));
            merger.addFragment(fragment);
            fragments2.add(fragment);
        }
        JsProgramFragment testFragment = Translation.mayBeGenerateTests(config, bindingTrace, moduleDescriptor, sourceFilePathResolver);
        fragments2.add(testFragment);
        newFragments.add(testFragment);
        merger.addFragment(testFragment);
        rootFunction.getParameters().add(new JsParameter(internalModuleName));
        if (mainCallParameters.shouldBeGenerated() && (mainCallFragment = Translation.generateCallToMain(bindingTrace, config, moduleDescriptor, sourceFilePathResolver, mainCallParameters.arguments())) != null) {
            fragments2.add(mainCallFragment);
            newFragments.add(mainCallFragment);
            merger.addFragment(mainCallFragment);
        }
        merger.merge();
        JsBlock rootBlock = rootFunction.getBody();
        List<JsStatement> statements = rootBlock.getStatements();
        statements.add(0, new JsStringLiteral("use strict").makeStmt());
        if (!Translation.isBuiltinModule(fragments2)) {
            Translation.defineModule(program, statements, config.getModuleId());
        }
        List<JsImportedModule> importedModuleList = merger.getImportedModules();
        for (JsImportedModule importedModule : importedModuleList) {
            rootFunction.getParameters().add(new JsParameter(importedModule.getInternalName()));
        }
        statements.add(new JsReturn(internalModuleName.makeRef()));
        JsGlobalBlock block = program.getGlobalBlock();
        block.getStatements().addAll(ModuleWrapperTranslation.wrapIfNecessary(config.getModuleId(), rootFunction, importedModuleList, program, config.getModuleKind()));
        return new AstGenerationResult(program, internalModuleName, fragments2, fragmentMap, newFragments, merger.getImportBlock().getStatements(), fileMemberScopes, importedModuleList);
    }

    private static boolean isBuiltinModule(@NotNull List<JsProgramFragment> fragments2) {
        for (JsProgramFragment fragment : fragments2) {
            for (JsNameBinding nameBinding : fragment.getNameBindings()) {
                if (!nameBinding.getKey().equals(ENUM_SIGNATURE) || fragment.getImports().containsKey(ENUM_SIGNATURE)) continue;
                return true;
            }
        }
        return false;
    }

    private static void translateFile(@NotNull TranslationContext context, @NotNull KtFile file2, @NotNull List<DeclarationDescriptor> fileMemberScope) {
        FileDeclarationVisitor fileVisitor = new FileDeclarationVisitor(context);
        try {
            for (KtDeclaration declaration : file2.getDeclarations()) {
                DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForElement(context.bindingContext(), declaration);
                fileMemberScope.add(descriptor2);
                if (AnnotationsUtils.isPredefinedObject(descriptor2)) continue;
                declaration.accept(fileVisitor, context);
            }
        }
        catch (TranslationRuntimeException e) {
            throw e;
        }
        catch (AssertionError | RuntimeException e) {
            throw new TranslationRuntimeException((PsiElement)file2, (Throwable)e);
        }
    }

    private static void defineModule(@NotNull JsProgram program, @NotNull List<JsStatement> statements, @NotNull String moduleId) {
        JsName rootPackageName = program.getScope().findName(Namer.getRootPackageName());
        if (rootPackageName != null) {
            Namer namer = Namer.newInstance(program.getScope());
            statements.add(new JsInvocation((JsExpression)namer.kotlin("defineModule"), new JsStringLiteral(moduleId), rootPackageName.makeRef()).makeStmt());
        }
    }

    @NotNull
    private static JsProgramFragment mayBeGenerateTests(@NotNull JsConfig config, @NotNull BindingTrace trace, @NotNull ModuleDescriptor moduleDescriptor, @NotNull SourceFilePathResolver sourceFilePathResolver) {
        StaticContext staticContext = new StaticContext(trace, config, moduleDescriptor, sourceFilePathResolver);
        TranslationContext context = TranslationContext.rootContext(staticContext);
        new JSTestGenerator(context).generateTestCalls(moduleDescriptor);
        return staticContext.getFragment();
    }

    @Nullable
    private static JsProgramFragment generateCallToMain(@NotNull BindingTrace trace, @NotNull JsConfig config, @NotNull ModuleDescriptor moduleDescriptor, @NotNull SourceFilePathResolver sourceFilePathResolver, @NotNull List<String> arguments2) {
        StaticContext staticContext = new StaticContext(trace, config, moduleDescriptor, sourceFilePathResolver);
        TranslationContext context = TranslationContext.rootContext(staticContext);
        MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(context.bindingContext());
        FunctionDescriptor functionDescriptor = mainFunctionDetector.getMainFunction(moduleDescriptor);
        if (functionDescriptor == null) {
            return null;
        }
        JsArrayLiteral argument = new JsArrayLiteral(JsAstUtils.toStringLiteralList(arguments2));
        JsExpression call2 = CallTranslator.INSTANCE.buildCall(context, functionDescriptor, Collections.singletonList(argument), null);
        context.addTopLevelStatement(call2.makeStmt());
        return staticContext.getFragment();
    }
}

