/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class DiagnosticUtils {
    @NotNull
    private static final Comparator<TextRange> TEXT_RANGE_COMPARATOR = (o1, o2) -> {
        if (o1.getStartOffset() != o2.getStartOffset()) {
            return o1.getStartOffset() - o2.getStartOffset();
        }
        return o1.getEndOffset() - o2.getEndOffset();
    };

    private DiagnosticUtils() {
    }

    public static String atLocation(DeclarationDescriptor descriptor2) {
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (element == null) {
            element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2.getOriginal());
        }
        if (element == null && descriptor2 instanceof ASTNode) {
            element = PsiUtilsKt.closestPsiElement((ASTNode)descriptor2);
        }
        if (element != null) {
            return PsiDiagnosticUtils.atLocation(element);
        }
        return "unknown location";
    }

    @NotNull
    public static PsiFile getContainingFile(@NotNull ASTNode node) {
        PsiElement closestPsiElement = PsiUtilsKt.closestPsiElement(node);
        assert (closestPsiElement != null) : "This node is not contained by a file";
        return closestPsiElement.getContainingFile();
    }

    @NotNull
    public static PsiDiagnosticUtils.LineAndColumn getLineAndColumn(@NotNull Diagnostic diagnostic) {
        PsiFile file2 = diagnostic.getPsiFile();
        List<TextRange> textRanges = diagnostic.getTextRanges();
        if (textRanges.isEmpty()) {
            return PsiDiagnosticUtils.LineAndColumn.NONE;
        }
        TextRange firstRange = DiagnosticUtils.firstRange(textRanges);
        return DiagnosticUtils.getLineAndColumnInPsiFile(file2, firstRange);
    }

    @NotNull
    public static PsiDiagnosticUtils.LineAndColumn getLineAndColumnInPsiFile(PsiFile file2, TextRange range) {
        Document document = file2.getViewProvider().getDocument();
        return PsiDiagnosticUtils.offsetToLineAndColumn(document, range.getStartOffset());
    }

    public static void throwIfRunningOnServer(Throwable e) {
        if (System.getProperty("kotlin.running.in.server.mode", "false").equals("true") || ApplicationManager.getApplication().isUnitTestMode()) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static TextRange firstRange(@NotNull List<TextRange> ranges2) {
        return Collections.min(ranges2, TEXT_RANGE_COMPARATOR);
    }

    @NotNull
    public static List<Diagnostic> sortedDiagnostics(@NotNull Collection<Diagnostic> diagnostics2) {
        ArrayList result2 = Lists.newArrayList(diagnostics2);
        result2.sort((d1, d2) -> {
            TextRange range2;
            String path2;
            String path1 = d1.getPsiFile().getViewProvider().getVirtualFile().getPath();
            if (!path1.equals(path2 = d2.getPsiFile().getViewProvider().getVirtualFile().getPath())) {
                return path1.compareTo(path2);
            }
            TextRange range1 = DiagnosticUtils.firstRange(d1.getTextRanges());
            if (!range1.equals((Object)(range2 = DiagnosticUtils.firstRange(d2.getTextRanges())))) {
                return TEXT_RANGE_COMPARATOR.compare(range1, range2);
            }
            return d1.getFactory().getName().compareTo(d2.getFactory().getName());
        });
        return result2;
    }

    public static boolean hasError(Diagnostics diagnostics2) {
        for (Diagnostic diagnostic : diagnostics2.all()) {
            if (diagnostic.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }
}

