/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.ConstantExpressionEvaluator;
import com.intellij.psi.impl.LanguageConstantExpressionEvaluator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.elements.KtLightAnnotationsValuesKt;
import org.jetbrains.kotlin.asJava.elements.KtLightElementBase;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0006H\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0015\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/asJava/elements/KtLightPsiLiteral;", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElementBase;", "Lcom/intellij/psi/PsiLiteralExpression;", "kotlinOrigin", "Lorg/jetbrains/kotlin/psi/KtExpression;", "lightParent", "Lcom/intellij/psi/PsiElement;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/psi/PsiElement;)V", "getKotlinOrigin", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getLightParent", "()Lcom/intellij/psi/PsiElement;", "getParent", "getReference", "Lcom/intellij/psi/PsiReference;", "getReferences", "", "()[Lcom/intellij/psi/PsiReference;", "getType", "Lcom/intellij/psi/PsiType;", "getValue", "", "isPhysical", "", "replace", "newElement", "light-classes"})
public class KtLightPsiLiteral
extends KtLightElementBase
implements PsiLiteralExpression {
    @NotNull
    private final KtExpression kotlinOrigin;
    @NotNull
    private final PsiElement lightParent;

    @Nullable
    public Object getValue() {
        ConstantExpressionEvaluator constantExpressionEvaluator = (ConstantExpressionEvaluator)LanguageConstantExpressionEvaluator.INSTANCE.forLanguage(this.getKotlinOrigin().getLanguage());
        return constantExpressionEvaluator != null ? constantExpressionEvaluator.computeConstantExpression((PsiElement)this, false) : null;
    }

    @Nullable
    public PsiType getType() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"this.project");
        BindingContext bindingContext = LightClassGenerationSupport.Companion.getInstance(project).analyze(this.getKotlinOrigin());
        KotlinType kotlinType2 = (KotlinType)bindingContext.get(BindingContext.EXPECTED_EXPRESSION_TYPE, this.getKotlinOrigin());
        if (kotlinType2 == null) {
            return null;
        }
        KotlinType kotlinType3 = kotlinType2;
        Object object = kotlinType3.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) == null || (object = ((FqName)object).asString()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"kotlinType.constructor.d\u2026asString() ?: return null");
        Object typeFqName = object;
        return KtLightAnnotationsValuesKt.psiType$default((String)typeFqName, (PsiElement)this.getKotlinOrigin(), false, 4, null);
    }

    @Override
    @NotNull
    public PsiElement getParent() {
        return this.lightParent;
    }

    public boolean isPhysical() {
        return false;
    }

    @NotNull
    public PsiElement replace(@NotNull PsiElement newElement) {
        Intrinsics.checkParameterIsNotNull((Object)newElement, (String)"newElement");
        PsiElement psiElement = newElement;
        if (!(psiElement instanceof PsiLiteral)) {
            psiElement = null;
        }
        PsiLiteral psiLiteral = (PsiLiteral)psiElement;
        Object object = psiLiteral != null ? psiLiteral.getValue() : null;
        if (!(object instanceof String)) {
            object = null;
        }
        String string = (String)object;
        if (string == null) {
            return (PsiElement)this;
        }
        String value = string;
        this.getKotlinOrigin().replace((PsiElement)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)this, false, 2, null).createExpression('\"' + StringUtil.escapeStringCharacters((String)value) + '\"'));
        return (PsiElement)this;
    }

    @Nullable
    public PsiReference getReference() {
        return (PsiReference)ArraysKt.singleOrNull((Object[])this.getReferences());
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = this.getKotlinOrigin().getReferences();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"kotlinOrigin.references");
        return psiReferenceArray;
    }

    @Override
    @NotNull
    public KtExpression getKotlinOrigin() {
        return this.kotlinOrigin;
    }

    @NotNull
    public final PsiElement getLightParent() {
        return this.lightParent;
    }

    public KtLightPsiLiteral(@NotNull KtExpression kotlinOrigin2, @NotNull PsiElement lightParent) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinOrigin2, (String)"kotlinOrigin");
        Intrinsics.checkParameterIsNotNull((Object)lightParent, (String)"lightParent");
        super(lightParent);
        this.kotlinOrigin = kotlinOrigin2;
        this.lightParent = lightParent;
    }
}

