/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.facet;

import com.intellij.openapi.util.JDOMUtil;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.facet.FacetState;

public abstract class JpsFacetConfigurationSerializer<E extends JpsElement> {
    private final JpsElementChildRole<E> myRole;
    private final String myFacetTypeId;
    private final String myFacetName;

    public JpsFacetConfigurationSerializer(JpsElementChildRole<E> role, String facetTypeId, @Nullable String facetName) {
        this.myRole = role;
        this.myFacetTypeId = facetTypeId;
        this.myFacetName = facetName;
    }

    public String getFacetTypeId() {
        return this.myFacetTypeId;
    }

    public E loadExtension(Element configurationElement, String facetName, JpsModule module2, JpsElement parentFacet) {
        E e = this.loadExtension(configurationElement, facetName, parentFacet, module2);
        return module2.getContainer().setChild(this.myRole, e);
    }

    protected abstract E loadExtension(@NotNull Element var1, String var2, JpsElement var3, JpsModule var4);

    public boolean hasExtension(JpsModule module2) {
        return module2.getContainer().getChild(this.myRole) != null;
    }

    public void saveExtension(JpsModule module2, @NotNull List<FacetState> states) {
        E extension;
        if (states == null) {
            JpsFacetConfigurationSerializer.$$$reportNull$$$0(0);
        }
        if ((extension = module2.getContainer().getChild(this.myRole)) != null) {
            FacetState state2 = new FacetState();
            state2.setFacetType(this.myFacetTypeId);
            state2.setName(this.myFacetName);
            Element tag = new Element("configuration");
            this.saveExtension(extension, tag, module2);
            if (!JDOMUtil.isEmpty((Element)tag)) {
                state2.setConfiguration(tag);
            }
            states.add(state2);
        }
    }

    protected abstract void saveExtension(E var1, Element var2, JpsModule var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states", "org/jetbrains/jps/model/serialization/facet/JpsFacetConfigurationSerializer", "saveExtension"));
    }
}

