/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import java.util.List;

public class IncrementalCompilation {
    public static final String INCREMENTAL_COMPILATION_JVM_PROPERTY = "kotlin.incremental.compilation";
    public static final String INCREMENTAL_COMPILATION_JS_PROPERTY = "kotlin.incremental.compilation.js";

    public static boolean isEnabledForJvm() {
        return "true".equals(System.getProperty(INCREMENTAL_COMPILATION_JVM_PROPERTY));
    }

    public static boolean isEnabledForJs() {
        return "true".equals(System.getProperty(INCREMENTAL_COMPILATION_JS_PROPERTY));
    }

    public static void setIsEnabledForJvm(boolean value) {
        System.setProperty(INCREMENTAL_COMPILATION_JVM_PROPERTY, String.valueOf(value));
    }

    public static void setIsEnabledForJs(boolean value) {
        System.setProperty(INCREMENTAL_COMPILATION_JS_PROPERTY, String.valueOf(value));
    }

    public static void toJvmArgs(List<String> jvmArgs) {
        if (IncrementalCompilation.isEnabledForJvm()) {
            IncrementalCompilation.addJvmSystemFlag(jvmArgs, INCREMENTAL_COMPILATION_JVM_PROPERTY);
        }
        if (IncrementalCompilation.isEnabledForJs()) {
            IncrementalCompilation.addJvmSystemFlag(jvmArgs, INCREMENTAL_COMPILATION_JS_PROPERTY);
        }
    }

    private static void addJvmSystemFlag(List<String> jvmArgs, String name2) {
        jvmArgs.add("D" + name2 + "=true");
    }
}

