/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.tree.IElementType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.BinaryOperationKey;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt$WhenMappings;
import org.jetbrains.kotlin.resolve.constants.evaluate.UnaryOperationKey;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u009e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u00b8\u0001\u0010\"\u001aN\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H&0$\u00128\u00126\u0012\u001a\u0012\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00020'\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(0'0#0#\"\u0004\b\u0000\u0010%\"\u0004\b\u0001\u0010&2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H%0\u00012\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H&0\u00012\u0006\u0010+\u001a\u00020\u00102\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020\u00020'2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(0'H\u0000\u001a \u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010\u00022\u0006\u00101\u001a\u000202H\u0002\u001a \u00103\u001a\b\u0012\u0002\b\u0003\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010\u00022\u0006\u00101\u001a\u000202H\u0002\u001a\u0016\u00104\u001a\u0004\u0018\u0001052\n\u00106\u001a\u0006\u0012\u0002\b\u000307H\u0002\u001a\u0010\u00108\u001a\u00020\u00062\b\u00109\u001a\u0004\u0018\u00010\u0002\u001a\u0084\u0001\u0010:\u001a:\u0012\n\u0012\b\u0012\u0004\u0012\u0002H%0;\u0012*\u0012(\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00020<\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0<0#0#\"\u0004\b\u0000\u0010%2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H%0\u00012\u0006\u0010+\u001a\u00020\u00102\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u00020\u00020<2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0<H\u0000\u001a\u000e\u0010=\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030>\u001a\u000e\u0010=\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030/\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0004\"\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0004\"\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0004\"\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0004\"\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0004\"\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0004\"\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0004\"\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0004\"\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0004\u00a8\u0006?"}, d2={"ANY", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "", "getANY", "()Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "BOOLEAN", "", "getBOOLEAN", "BYTE", "", "getBYTE", "CHAR", "", "getCHAR", "DIVISION_OPERATION_NAMES", "", "", "DOUBLE", "", "getDOUBLE", "FLOAT", "", "getFLOAT", "INT", "", "getINT", "LONG", "", "getLONG", "SHORT", "", "getSHORT", "STRING", "getSTRING", "binaryOperation", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/BinaryOperationKey;", "A", "B", "Lkotlin/Function2;", "Ljava/math/BigInteger;", "a", "b", "functionName", "operation", "checker", "createCompileTimeConstantForCompareTo", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "result", "operationReference", "Lorg/jetbrains/kotlin/psi/KtExpression;", "createCompileTimeConstantForEquals", "getReceiverExpressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "isIntegerType", "value", "unaryOperation", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/UnaryOperationKey;", "Lkotlin/Function1;", "isStandaloneOnlyConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "frontend"})
public final class ConstantExpressionEvaluatorKt {
    private static final Set<String> DIVISION_OPERATION_NAMES;
    @NotNull
    private static final CompileTimeType<Byte> BYTE;
    @NotNull
    private static final CompileTimeType<Short> SHORT;
    @NotNull
    private static final CompileTimeType<Integer> INT;
    @NotNull
    private static final CompileTimeType<Long> LONG;
    @NotNull
    private static final CompileTimeType<Double> DOUBLE;
    @NotNull
    private static final CompileTimeType<Float> FLOAT;
    @NotNull
    private static final CompileTimeType<Character> CHAR;
    @NotNull
    private static final CompileTimeType<Boolean> BOOLEAN;
    @NotNull
    private static final CompileTimeType<String> STRING;
    @NotNull
    private static final CompileTimeType<Object> ANY;

    private static final ConstantValue<?> createCompileTimeConstantForEquals(Object result2, KtExpression operationReference) {
        if (result2 instanceof Boolean) {
            boolean bl;
            boolean bl2 = operationReference instanceof KtSimpleNameExpression;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string = "This method should be called only for equals operations";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            KtExpression ktExpression = operationReference;
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
            }
            IElementType operationToken = ((KtSimpleNameExpression)ktExpression).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ))) {
                bl = (Boolean)result2;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ))) {
                bl = !((Boolean)result2).booleanValue();
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.IDENTIFIER))) {
                boolean bl5 = Intrinsics.areEqual((Object)((KtSimpleNameExpression)operationReference).getReferencedNameAsName(), (Object)OperatorNameConventions.EQUALS);
                boolean bl6 = false;
                if (_Assertions.ENABLED && !bl5) {
                    boolean bl7 = false;
                    String string = "This method should be called only for equals operations";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                bl = (Boolean)result2;
            } else {
                throw (Throwable)new IllegalStateException("Unknown equals operation token: " + operationToken + ' ' + ((KtSimpleNameExpression)operationReference).getText());
            }
            boolean value = bl;
            return new BooleanValue(value);
        }
        return null;
    }

    private static final ConstantValue<?> createCompileTimeConstantForCompareTo(Object result2, KtExpression operationReference) {
        if (result2 instanceof Integer) {
            BooleanValue booleanValue;
            boolean bl = operationReference instanceof KtSimpleNameExpression;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "This method should be called only for compareTo operations";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            KtExpression ktExpression = operationReference;
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
            }
            IElementType operationToken = ((KtSimpleNameExpression)ktExpression).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT))) {
                booleanValue = new BooleanValue(((Number)result2).intValue() < 0);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ))) {
                booleanValue = new BooleanValue(((Number)result2).intValue() <= 0);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT))) {
                booleanValue = new BooleanValue(((Number)result2).intValue() > 0);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ))) {
                booleanValue = new BooleanValue(((Number)result2).intValue() >= 0);
            } else {
                if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.IDENTIFIER))) {
                    boolean bl4 = Intrinsics.areEqual((Object)((KtSimpleNameExpression)operationReference).getReferencedNameAsName(), (Object)OperatorNameConventions.COMPARE_TO);
                    boolean bl5 = false;
                    if (_Assertions.ENABLED && !bl4) {
                        boolean bl6 = false;
                        String string = "This method should be called only for compareTo operations";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    return new IntValue(((Number)result2).intValue());
                }
                throw (Throwable)new IllegalStateException("Unknown compareTo operation token: " + operationToken);
            }
            return booleanValue;
        }
        return null;
    }

    public static final boolean isIntegerType(@Nullable Object value) {
        return value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long;
    }

    private static final KotlinType getReceiverExpressionType(ResolvedCall<?> resolvedCall2) {
        KotlinType kotlinType2;
        switch (ConstantExpressionEvaluatorKt$WhenMappings.$EnumSwitchMapping$0[resolvedCall2.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
                if (receiverValue == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)receiverValue, (String)"resolvedCall.dispatchReceiver!!");
                kotlinType2 = receiverValue.getType();
                break;
            }
            case 2: {
                ReceiverValue receiverValue = resolvedCall2.getExtensionReceiver();
                if (receiverValue == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)receiverValue, (String)"resolvedCall.extensionReceiver!!");
                kotlinType2 = receiverValue.getType();
                break;
            }
            case 3: {
                kotlinType2 = null;
                break;
            }
            case 4: {
                kotlinType2 = null;
                break;
            }
            default: {
                kotlinType2 = null;
            }
        }
        return kotlinType2;
    }

    @NotNull
    public static final CompileTimeType<Byte> getBYTE() {
        return BYTE;
    }

    @NotNull
    public static final CompileTimeType<Short> getSHORT() {
        return SHORT;
    }

    @NotNull
    public static final CompileTimeType<Integer> getINT() {
        return INT;
    }

    @NotNull
    public static final CompileTimeType<Long> getLONG() {
        return LONG;
    }

    @NotNull
    public static final CompileTimeType<Double> getDOUBLE() {
        return DOUBLE;
    }

    @NotNull
    public static final CompileTimeType<Float> getFLOAT() {
        return FLOAT;
    }

    @NotNull
    public static final CompileTimeType<Character> getCHAR() {
        return CHAR;
    }

    @NotNull
    public static final CompileTimeType<Boolean> getBOOLEAN() {
        return BOOLEAN;
    }

    @NotNull
    public static final CompileTimeType<String> getSTRING() {
        return STRING;
    }

    @NotNull
    public static final CompileTimeType<Object> getANY() {
        return ANY;
    }

    @NotNull
    public static final <A, B> Pair<BinaryOperationKey<A, B>, Pair<Function2<Object, Object, Object>, Function2<BigInteger, BigInteger, BigInteger>>> binaryOperation(@NotNull CompileTimeType<A> a, @NotNull CompileTimeType<B> b, @NotNull String functionName, @NotNull Function2<? super A, ? super B, ? extends Object> operation, @NotNull Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> checker) {
        Intrinsics.checkParameterIsNotNull(a, (String)"a");
        Intrinsics.checkParameterIsNotNull(b, (String)"b");
        Intrinsics.checkParameterIsNotNull((Object)functionName, (String)"functionName");
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull(checker, (String)"checker");
        return TuplesKt.to(new BinaryOperationKey<A, B>(a, b, functionName), (Object)new Pair(operation, checker));
    }

    @NotNull
    public static final <A> Pair<UnaryOperationKey<A>, Pair<Function1<Object, Object>, Function1<Long, Long>>> unaryOperation(@NotNull CompileTimeType<A> a, @NotNull String functionName, @NotNull Function1<? super A, ? extends Object> operation, @NotNull Function1<? super Long, Long> checker) {
        Intrinsics.checkParameterIsNotNull(a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)functionName, (String)"functionName");
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull(checker, (String)"checker");
        return TuplesKt.to(new UnaryOperationKey<A>(a, functionName), (Object)new Pair(operation, checker));
    }

    public static final boolean isStandaloneOnlyConstant(@NotNull ConstantValue<?> $this$isStandaloneOnlyConstant) {
        Intrinsics.checkParameterIsNotNull($this$isStandaloneOnlyConstant, (String)"$this$isStandaloneOnlyConstant");
        return $this$isStandaloneOnlyConstant instanceof KClassValue || $this$isStandaloneOnlyConstant instanceof EnumValue || $this$isStandaloneOnlyConstant instanceof AnnotationValue || $this$isStandaloneOnlyConstant instanceof ArrayValue;
    }

    public static final boolean isStandaloneOnlyConstant(@NotNull CompileTimeConstant<?> $this$isStandaloneOnlyConstant) {
        Intrinsics.checkParameterIsNotNull($this$isStandaloneOnlyConstant, (String)"$this$isStandaloneOnlyConstant");
        CompileTimeConstant<?> compileTimeConstant = $this$isStandaloneOnlyConstant;
        if (!(compileTimeConstant instanceof TypedCompileTimeConstant)) {
            return false;
        }
        return ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(((TypedCompileTimeConstant)$this$isStandaloneOnlyConstant).getConstantValue());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])new Name[]{OperatorNameConventions.DIV, OperatorNameConventions.REM, OperatorNameConventions.MOD});
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            Name name2 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = p1.asString();
            collection.add(string);
        }
        DIVISION_OPERATION_NAMES = CollectionsKt.toSet((Iterable)((List)var3_3));
        BYTE = new CompileTimeType("Byte");
        SHORT = new CompileTimeType("Short");
        INT = new CompileTimeType("Int");
        LONG = new CompileTimeType("Long");
        DOUBLE = new CompileTimeType("Double");
        FLOAT = new CompileTimeType("Float");
        CHAR = new CompileTimeType("Char");
        BOOLEAN = new CompileTimeType("Boolean");
        STRING = new CompileTimeType("String");
        ANY = new CompileTimeType("Any");
    }

    public static final /* synthetic */ ConstantValue access$createCompileTimeConstantForCompareTo(Object result2, KtExpression operationReference) {
        return ConstantExpressionEvaluatorKt.createCompileTimeConstantForCompareTo(result2, operationReference);
    }

    public static final /* synthetic */ ConstantValue access$createCompileTimeConstantForEquals(Object result2, KtExpression operationReference) {
        return ConstantExpressionEvaluatorKt.createCompileTimeConstantForEquals(result2, operationReference);
    }

    public static final /* synthetic */ Set access$getDIVISION_OPERATION_NAMES$p() {
        return DIVISION_OPERATION_NAMES;
    }

    public static final /* synthetic */ KotlinType access$getReceiverExpressionType(ResolvedCall resolvedCall2) {
        return ConstantExpressionEvaluatorKt.getReceiverExpressionType(resolvedCall2);
    }
}

