/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.FoldConstantLowering;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0003\u0013\u0014\u0015B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FoldConstantLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "buildIrConstant", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "v", "", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "tryFoldingBinaryOps", "tryFoldingBuiltinBinaryOps", "tryFoldingUnaryOps", "BinaryOp", "Companion", "PrimitiveType", "backend.jvm"})
public final class FoldConstantLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    private final JvmBackendContext context;
    private static final PrimitiveType<Byte> BYTE;
    private static final PrimitiveType<Short> SHORT;
    private static final PrimitiveType<Integer> INT;
    private static final PrimitiveType<Long> LONG;
    private static final PrimitiveType<Double> DOUBLE;
    private static final PrimitiveType<Float> FLOAT;
    private static final PrimitiveType<Character> CHAR;
    private static final PrimitiveType<Boolean> BOOLEAN;
    private static final PrimitiveType<String> STRING;
    private static final HashMap<BinaryOp, Function2<Object, Object, Object>> BINARY_OP_TO_EVALUATOR;
    public static final Companion Companion;

    private final IrExpression buildIrConstant(IrCall call2, Object v) {
        IrExpression irExpression;
        if (IrTypePredicatesKt.isInt(call2.getType())) {
            Object object = v;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
            }
            irExpression = IrConstImpl.Companion.int(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), (Integer)object);
        } else if (IrTypePredicatesKt.isChar(call2.getType())) {
            Object object = v;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Char");
            }
            irExpression = IrConstImpl.Companion.char(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), ((Character)object).charValue());
        } else if (IrTypePredicatesKt.isBoolean(call2.getType())) {
            Object object = v;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
            }
            irExpression = IrConstImpl.Companion.boolean(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), (Boolean)object);
        } else if (IrTypePredicatesKt.isByte(call2.getType())) {
            Object object = v;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Byte");
            }
            irExpression = IrConstImpl.Companion.byte(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), (Byte)object);
        } else if (IrTypePredicatesKt.isShort(call2.getType())) {
            Object object = v;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Short");
            }
            irExpression = IrConstImpl.Companion.short(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), (Short)object);
        } else if (IrTypePredicatesKt.isLong(call2.getType())) {
            Object object = v;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
            }
            irExpression = IrConstImpl.Companion.long(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), (Long)object);
        } else if (IrTypePredicatesKt.isDouble(call2.getType())) {
            Object object = v;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
            }
            irExpression = IrConstImpl.Companion.double(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), (Double)object);
        } else if (IrTypePredicatesKt.isFloat(call2.getType())) {
            Object object = v;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
            }
            irExpression = IrConstImpl.Companion.float(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), ((Float)object).floatValue());
        } else if (IrTypePredicatesKt.isString(call2.getType())) {
            Object object = v;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            irExpression = IrConstImpl.Companion.string(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), (String)object);
        } else {
            throw (Throwable)new IllegalArgumentException("Unexpected IrCall return type");
        }
        return irExpression;
    }

    private final IrExpression tryFoldingUnaryOps(IrCall call2) {
        IrExpression irExpression = call2.getDispatchReceiver();
        if (!(irExpression instanceof IrConst)) {
            irExpression = null;
        }
        IrConst irConst = (IrConst)irExpression;
        if (irConst == null) {
            return call2;
        }
        IrConst operand = irConst;
        String string = call2.getSymbol().getOwner().getName().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"call.symbol.owner.name.toString()");
        String string2 = operand.getKind().toString();
        Object t = operand.getValue();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        Object object = ConstantExpressionEvaluatorKt.evaluateUnary$default(string, string2, t, null, 8, null);
        if (object == null) {
            return call2;
        }
        Object evaluated2 = object;
        return this.buildIrConstant(call2, evaluated2);
    }

    private final IrExpression tryFoldingBinaryOps(IrCall call2) {
        Object object;
        IrExpression irExpression = call2.getDispatchReceiver();
        if (!(irExpression instanceof IrConst)) {
            irExpression = null;
        }
        IrConst irConst = (IrConst)irExpression;
        if (irConst == null) {
            return call2;
        }
        IrConst lhs = irConst;
        IrExpression irExpression2 = call2.getValueArgument(0);
        if (!(irExpression2 instanceof IrConst)) {
            irExpression2 = null;
        }
        IrConst irConst2 = (IrConst)irExpression2;
        if (irConst2 == null) {
            return call2;
        }
        IrConst rhs = irConst2;
        try {
            tryFoldingBinaryOps.evaluated.1 $fun$toNonNullable$1 = tryFoldingBinaryOps.evaluated.1.INSTANCE;
            String string = call2.getSymbol().getOwner().getName().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"call.symbol.owner.name.toString()");
            String string2 = lhs.getKind().toString();
            Object t = lhs.getValue();
            if (t == null) {
                Intrinsics.throwNpe();
            }
            String string3 = $fun$toNonNullable$1.invoke(IrTypesKt.toKotlinType(call2.getSymbol().getOwner().getValueParameters().get(0).getType()).toString());
            Object t2 = rhs.getValue();
            if (t2 == null) {
                Intrinsics.throwNpe();
            }
            Object object2 = ConstantExpressionEvaluatorKt.evaluateBinary(string, string2, t, string3, t2);
            if (object2 == null) {
                return call2;
            }
            object = object2;
        }
        catch (Exception e) {
            return call2;
        }
        Object evaluated2 = object;
        return this.buildIrConstant(call2, evaluated2);
    }

    private final IrExpression tryFoldingBuiltinBinaryOps(IrCall call2) {
        Object object;
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(call2.getSymbol().getOwner());
        if (Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.parent() : null), (Object)IrBuiltIns.Companion.getKOTLIN_INTERNAL_IR_FQN()) ^ true) {
            return call2;
        }
        IrExpression irExpression = call2.getValueArgument(0);
        if (!(irExpression instanceof IrConst)) {
            irExpression = null;
        }
        IrConst irConst = (IrConst)irExpression;
        if (irConst == null) {
            return call2;
        }
        IrConst lhs = irConst;
        IrExpression irExpression2 = call2.getValueArgument(1);
        if (!(irExpression2 instanceof IrConst)) {
            irExpression2 = null;
        }
        IrConst irConst2 = (IrConst)irExpression2;
        if (irConst2 == null) {
            return call2;
        }
        IrConst rhs = irConst2;
        try {
            String string = lhs.getKind().toString();
            String string2 = rhs.getKind().toString();
            String string3 = call2.getSymbol().getOwner().getName().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"call.symbol.owner.name.toString()");
            Function2<Object, Object, Object> function2 = BINARY_OP_TO_EVALUATOR.get(new BinaryOp(string, string2, string3));
            if (function2 == null) {
                return call2;
            }
            Intrinsics.checkExpressionValueIsNotNull(function2, (String)"BINARY_OP_TO_EVALUATOR[B\u2026String())] ?: return call");
            Function2<Object, Object, Object> evaluator = function2;
            Object t = lhs.getValue();
            if (t == null) {
                Intrinsics.throwNpe();
            }
            Object t2 = rhs.getValue();
            if (t2 == null) {
                Intrinsics.throwNpe();
            }
            object = evaluator.invoke(t, t2);
        }
        catch (Exception e) {
            return call2;
        }
        Object evaluated2 = object;
        return this.buildIrConstant(call2, evaluated2);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this){
            final /* synthetic */ FoldConstantLowering this$0;

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                return expression2.getExtensionReceiver() != null ? (IrExpression)expression2 : (expression2.getDispatchReceiver() != null && expression2.getValueArgumentsCount() == 0 ? FoldConstantLowering.access$tryFoldingUnaryOps(this.this$0, expression2) : (expression2.getDispatchReceiver() != null && expression2.getValueArgumentsCount() == 1 ? FoldConstantLowering.access$tryFoldingBinaryOps(this.this$0, expression2) : (expression2.getDispatchReceiver() == null && expression2.getValueArgumentsCount() == 2 ? FoldConstantLowering.access$tryFoldingBuiltinBinaryOps(this.this$0, expression2) : (IrExpression)expression2)));
            }

            @NotNull
            public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                boolean bl = false;
                List folded = new ArrayList<E>();
                for (IrExpression next : expression2.getArguments()) {
                    Collection collection;
                    IrExpression last2 = (IrExpression)CollectionsKt.lastOrNull((List)folded);
                    if (!(next instanceof IrConst)) {
                        collection = folded;
                        boolean bl2 = false;
                        collection.add(next);
                        continue;
                    }
                    if (!(last2 instanceof IrConst)) {
                        collection = folded;
                        IrConstImpl<String> irConstImpl = IrConstImpl.Companion.string(next.getStartOffset(), next.getEndOffset(), FoldConstantLowering.access$getContext$p(this.this$0).getIrBuiltIns().getStringType(), String.valueOf(((IrConst)next).getValue()));
                        boolean bl3 = false;
                        collection.add(irConstImpl);
                        continue;
                    }
                    folded.set(folded.size() - 1, IrConstImpl.Companion.string(last2.getStartOffset(), next.getEndOffset(), FoldConstantLowering.access$getContext$p(this.this$0).getIrBuiltIns().getStringType(), String.valueOf(((IrConst)last2).getValue()) + String.valueOf(((IrConst)next).getValue())));
                }
                Object object = CollectionsKt.singleOrNull((List)folded);
                if (!(object instanceof IrConst)) {
                    object = null;
                }
                IrConst irConst = (IrConst)object;
                return irConst != null ? (IrExpression)irConst : (IrExpression)new IrStringConcatenationImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), folded);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public FoldConstantLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
    }

    static {
        Companion = new Companion(null);
        BYTE = new PrimitiveType("Byte");
        SHORT = new PrimitiveType("Short");
        INT = new PrimitiveType("Int");
        LONG = new PrimitiveType("Long");
        DOUBLE = new PrimitiveType("Double");
        FLOAT = new PrimitiveType("Float");
        CHAR = new PrimitiveType("Char");
        BOOLEAN = new PrimitiveType("Boolean");
        STRING = new PrimitiveType("String");
        BINARY_OP_TO_EVALUATOR = new HashMap();
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "less", Companion.1.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "lessOrEqual", Companion.2.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "greater", Companion.3.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "greaterOrEqual", Companion.4.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.DOUBLE, "ieee754equals", Companion.5.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "less", Companion.6.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "lessOrEqual", Companion.7.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "greater", Companion.8.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "greaterOrEqual", Companion.9.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.FLOAT, "ieee754equals", Companion.10.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "less", Companion.11.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "lessOrEqual", Companion.12.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "greater", Companion.13.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "greaterOrEqual", Companion.14.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.INT, "EQEQ", Companion.15.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "less", Companion.16.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "lessOrEqual", Companion.17.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "greater", Companion.18.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "greaterOrEqual", Companion.19.INSTANCE);
        FoldConstantLowering.Companion.registerBuiltinBinaryOp(FoldConstantLowering.LONG, "EQEQ", Companion.20.INSTANCE);
    }

    public static final /* synthetic */ IrExpression access$tryFoldingUnaryOps(FoldConstantLowering $this, IrCall call2) {
        return $this.tryFoldingUnaryOps(call2);
    }

    public static final /* synthetic */ IrExpression access$tryFoldingBinaryOps(FoldConstantLowering $this, IrCall call2) {
        return $this.tryFoldingBinaryOps(call2);
    }

    public static final /* synthetic */ IrExpression access$tryFoldingBuiltinBinaryOps(FoldConstantLowering $this, IrCall call2) {
        return $this.tryFoldingBuiltinBinaryOps(call2);
    }

    public static final /* synthetic */ JvmBackendContext access$getContext$p(FoldConstantLowering $this) {
        return $this.context;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FoldConstantLowering$BinaryOp;", "", "lhsType", "", "rhsType", "operatorName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLhsType", "()Ljava/lang/String;", "getOperatorName", "getRhsType", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "backend.jvm"})
    private static final class BinaryOp {
        @NotNull
        private final String lhsType;
        @NotNull
        private final String rhsType;
        @NotNull
        private final String operatorName;

        @NotNull
        public final String getLhsType() {
            return this.lhsType;
        }

        @NotNull
        public final String getRhsType() {
            return this.rhsType;
        }

        @NotNull
        public final String getOperatorName() {
            return this.operatorName;
        }

        public BinaryOp(@NotNull String lhsType, @NotNull String rhsType, @NotNull String operatorName) {
            Intrinsics.checkParameterIsNotNull((Object)lhsType, (String)"lhsType");
            Intrinsics.checkParameterIsNotNull((Object)rhsType, (String)"rhsType");
            Intrinsics.checkParameterIsNotNull((Object)operatorName, (String)"operatorName");
            this.lhsType = lhsType;
            this.rhsType = rhsType;
            this.operatorName = operatorName;
        }

        @NotNull
        public final String component1() {
            return this.lhsType;
        }

        @NotNull
        public final String component2() {
            return this.rhsType;
        }

        @NotNull
        public final String component3() {
            return this.operatorName;
        }

        @NotNull
        public final BinaryOp copy(@NotNull String lhsType, @NotNull String rhsType, @NotNull String operatorName) {
            Intrinsics.checkParameterIsNotNull((Object)lhsType, (String)"lhsType");
            Intrinsics.checkParameterIsNotNull((Object)rhsType, (String)"rhsType");
            Intrinsics.checkParameterIsNotNull((Object)operatorName, (String)"operatorName");
            return new BinaryOp(lhsType, rhsType, operatorName);
        }

        public static /* synthetic */ BinaryOp copy$default(BinaryOp binaryOp, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = binaryOp.lhsType;
            }
            if ((n & 2) != 0) {
                string2 = binaryOp.rhsType;
            }
            if ((n & 4) != 0) {
                string3 = binaryOp.operatorName;
            }
            return binaryOp.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "BinaryOp(lhsType=" + this.lhsType + ", rhsType=" + this.rhsType + ", operatorName=" + this.operatorName + ")";
        }

        public int hashCode() {
            String string = this.lhsType;
            String string2 = this.rhsType;
            String string3 = this.operatorName;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BinaryOp)) break block3;
                    BinaryOp binaryOp = (BinaryOp)object;
                    if (!Intrinsics.areEqual((Object)this.lhsType, (Object)binaryOp.lhsType) || !Intrinsics.areEqual((Object)this.rhsType, (Object)binaryOp.rhsType) || !Intrinsics.areEqual((Object)this.operatorName, (Object)binaryOp.operatorName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FoldConstantLowering$PrimitiveType;", "T", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "backend.jvm"})
    private static final class PrimitiveType<T> {
        @NotNull
        private final String name;

        @NotNull
        public final String getName() {
            return this.name;
        }

        public PrimitiveType(@NotNull String name2) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            this.name = name2;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final PrimitiveType<T> copy(@NotNull String name2) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            return new PrimitiveType<T>(name2);
        }

        public static /* synthetic */ PrimitiveType copy$default(PrimitiveType primitiveType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = primitiveType.name;
            }
            return primitiveType.copy(string);
        }

        @NotNull
        public String toString() {
            return "PrimitiveType(name=" + this.name + ")";
        }

        public int hashCode() {
            String string = this.name;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PrimitiveType)) break block3;
                    PrimitiveType primitiveType = (PrimitiveType)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)primitiveType.name)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u001b\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\t2\u0006\u0010\u001f\u001a\u00020\u001a2\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u00010\u0006H\u0002RV\u0010\u0003\u001aJ\u0012\u0004\u0012\u00020\u0005\u0012\u001a\u0012\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00010\u00060\u0004j$\u0012\u0004\u0012\u00020\u0005\u0012\u001a\u0012\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00010\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FoldConstantLowering$Companion;", "", "()V", "BINARY_OP_TO_EVALUATOR", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/backend/jvm/lower/FoldConstantLowering$BinaryOp;", "Lkotlin/Function2;", "Lkotlin/collections/HashMap;", "BOOLEAN", "Lorg/jetbrains/kotlin/backend/jvm/lower/FoldConstantLowering$PrimitiveType;", "", "BYTE", "", "CHAR", "", "DOUBLE", "", "FLOAT", "", "INT", "", "LONG", "", "SHORT", "", "STRING", "", "registerBuiltinBinaryOp", "", "T", "operandType", "operatorName", "f", "backend.jvm"})
    public static final class Companion {
        private final <T> void registerBuiltinBinaryOp(PrimitiveType<T> operandType, String operatorName, Function2<? super T, ? super T, ? extends Object> f) {
            Function2<? super T, ? super T, ? extends Object> function2 = f;
            if (function2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type (kotlin.Any?, kotlin.Any?) -> kotlin.Any");
            }
            ((Map)BINARY_OP_TO_EVALUATOR).put(new BinaryOp(operandType.getName(), operandType.getName(), operatorName), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity(function2, (int)2));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

