/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreterKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.CleanBoxedValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.TaintedBoxedValue;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\r\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\"\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J \u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0016J \u0010\u001e\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0014J \u0010!\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0014J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0014J\u0018\u0010#\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0014J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0014J\u0010\u0010%\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0014J \u0010&\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0013H\u0014J\u001a\u0010(\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010)\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter;", "insnList", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/org/objectweb/asm/tree/InsnList;Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "boxingPlaces", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue;", "checkUsedValue", "", "value", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "createNewBoxing", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "progressionIterator", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue;", "isExactValue", "", "merge", "v", "w", "naryOperation", "values", "", "onAreEqual", "value1", "value2", "onCompareTo", "onMergeFail", "onMergeSuccess", "onMethodCallWithBoxedValue", "onNewBoxedValue", "onUnboxing", "resultType", "unaryOperation", "markBoxedArgumentValues", "backend"})
public class BoxingInterpreter
extends OptimizationBasicInterpreter {
    private final HashMap<Integer, BoxedBasicValue> boxingPlaces;
    private final InsnList insnList;
    private final GenerationState generationState;

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected BasicValue createNewBoxing(@NotNull AbstractInsnNode insn, @NotNull Type type2, @Nullable ProgressionIteratorBasicValue progressionIterator) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Map map2 = this.boxingPlaces;
        Integer key$iv = this.insnList.indexOf(insn);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            CleanBoxedValue boxedBasicValue = new CleanBoxedValue(type2, insn, progressionIterator, this.generationState);
            this.onNewBoxedValue(boxedBasicValue);
            BoxedBasicValue answer$iv = boxedBasicValue;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (BasicValue)object;
    }

    protected final void checkUsedValue(@NotNull BasicValue value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (value instanceof TaintedBoxedValue) {
            this.onMergeFail((BoxedBasicValue)value);
        }
    }

    @Override
    @Nullable
    public BasicValue naryOperation(@NotNull AbstractInsnNode insn, @NotNull List<? extends BasicValue> values) {
        BasicValue basicValue;
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        Iterable $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicValue it = (BasicValue)element$iv;
            boolean bl = false;
            this.checkUsedValue(it);
        }
        BasicValue value = super.naryOperation(insn, values);
        BasicValue basicValue2 = (BasicValue)CollectionsKt.firstOrNull(values);
        if (basicValue2 == null) {
            return value;
        }
        BasicValue firstArg = basicValue2;
        if (BoxingInterpreterKt.isBoxing(insn, this.generationState)) {
            this.markBoxedArgumentValues(values);
            BasicValue basicValue3 = value;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicValue3, (String)"value");
            Type type2 = basicValue3.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"value.type");
            basicValue = this.createNewBoxing(insn, type2, null);
        } else if (BoxingInterpreterKt.isUnboxing(insn, this.generationState) && firstArg instanceof BoxedBasicValue) {
            BoxedBasicValue boxedBasicValue = (BoxedBasicValue)firstArg;
            BasicValue basicValue4 = value;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicValue4, (String)"value");
            Type type3 = basicValue4.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"value.type");
            this.onUnboxing(insn, boxedBasicValue, type3);
            basicValue = value;
        } else if (BoxingInterpreterKt.isIteratorMethodCallOfProgression(insn, values)) {
            Type type4 = firstArg.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"firstArg.type");
            basicValue = ProgressionIteratorBasicValue.Companion.byProgressionClassType(type4);
        } else if (BoxingInterpreterKt.isNextMethodCallOfProgressionIterator(insn, values)) {
            BasicValue basicValue5 = firstArg;
            if (!(basicValue5 instanceof ProgressionIteratorBasicValue)) {
                basicValue5 = null;
            }
            ProgressionIteratorBasicValue progressionIteratorBasicValue = (ProgressionIteratorBasicValue)basicValue5;
            if (progressionIteratorBasicValue == null) {
                throw (Throwable)((Object)new AssertionError((Object)"firstArg should be progression iterator"));
            }
            ProgressionIteratorBasicValue progressionIterator = progressionIteratorBasicValue;
            basicValue = this.createNewBoxing(insn, progressionIterator.getBoxedElementType(), progressionIterator);
        } else if (BoxingInterpreterKt.isAreEqualIntrinsicForSameTypedBoxedValues(insn, values) && BoxingInterpreterKt.canValuesBeUnboxedForAreEqual(values, this.generationState)) {
            BasicValue basicValue6 = values.get(0);
            if (basicValue6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            }
            BasicValue basicValue7 = values.get(1);
            if (basicValue7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            }
            this.onAreEqual(insn, (BoxedBasicValue)basicValue6, (BoxedBasicValue)basicValue7);
            basicValue = value;
        } else if (BoxingInterpreterKt.isJavaLangComparableCompareToForSameTypedBoxedValues(insn, values)) {
            BasicValue basicValue8 = values.get(0);
            if (basicValue8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            }
            BasicValue basicValue9 = values.get(1);
            if (basicValue9 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            }
            this.onCompareTo(insn, (BoxedBasicValue)basicValue8, (BoxedBasicValue)basicValue9);
            basicValue = value;
        } else {
            this.markBoxedArgumentValues(values);
            basicValue = value;
        }
        return basicValue;
    }

    private final void markBoxedArgumentValues(@NotNull List<? extends BasicValue> $this$markBoxedArgumentValues) {
        for (BasicValue basicValue : $this$markBoxedArgumentValues) {
            if (!(basicValue instanceof BoxedBasicValue)) continue;
            this.onMethodCallWithBoxedValue((BoxedBasicValue)basicValue);
        }
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value) {
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.checkUsedValue(value);
        return insn.getOpcode() == 192 && this.isExactValue(value) ? value : super.unaryOperation(insn, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isExactValue(@NotNull BasicValue value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (value instanceof ProgressionIteratorBasicValue) return true;
        if (value instanceof CleanBoxedValue) return true;
        if (value.getType() == null) return false;
        Type type2 = value.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"value.type");
        if (!BoxingInterpreterKt.access$isProgressionClass(type2)) return false;
        return true;
    }

    @Override
    @NotNull
    public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
        BasicValue basicValue;
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
        if (Intrinsics.areEqual((Object)v, (Object)((Object)StrictBasicValue.UNINITIALIZED_VALUE)) || Intrinsics.areEqual((Object)w, (Object)((Object)StrictBasicValue.UNINITIALIZED_VALUE))) {
            basicValue = StrictBasicValue.UNINITIALIZED_VALUE;
        } else if (v instanceof BoxedBasicValue && w instanceof BoxedBasicValue) {
            this.onMergeSuccess((BoxedBasicValue)v, (BoxedBasicValue)w);
            basicValue = v instanceof TaintedBoxedValue ? (BoxedBasicValue)v : (w instanceof TaintedBoxedValue ? (BoxedBasicValue)w : (Intrinsics.areEqual((Object)((BoxedBasicValue)v).getType(), (Object)((BoxedBasicValue)w).getType()) ^ true ? ((BoxedBasicValue)v).taint() : (BoxedBasicValue)v));
        } else {
            basicValue = v instanceof BoxedBasicValue ? (BasicValue)((BoxedBasicValue)v).taint() : (w instanceof BoxedBasicValue ? (BasicValue)((BoxedBasicValue)w).taint() : super.merge(v, w));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)basicValue, (String)"when {\n            v == \u2026per.merge(v, w)\n        }");
        return basicValue;
    }

    protected void onNewBoxedValue(@NotNull BoxedBasicValue value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
    }

    protected void onUnboxing(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value, @NotNull Type resultType) {
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)resultType, (String)"resultType");
    }

    protected void onAreEqual(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value1, @NotNull BoxedBasicValue value2) {
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull((Object)((Object)value1), (String)"value1");
        Intrinsics.checkParameterIsNotNull((Object)((Object)value2), (String)"value2");
    }

    protected void onCompareTo(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value1, @NotNull BoxedBasicValue value2) {
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull((Object)((Object)value1), (String)"value1");
        Intrinsics.checkParameterIsNotNull((Object)((Object)value2), (String)"value2");
    }

    protected void onMethodCallWithBoxedValue(@NotNull BoxedBasicValue value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
    }

    protected void onMergeFail(@NotNull BoxedBasicValue value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
    }

    protected void onMergeSuccess(@NotNull BoxedBasicValue v, @NotNull BoxedBasicValue w) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)v), (String)"v");
        Intrinsics.checkParameterIsNotNull((Object)((Object)w), (String)"w");
    }

    public BoxingInterpreter(@NotNull InsnList insnList, @NotNull GenerationState generationState) {
        Intrinsics.checkParameterIsNotNull((Object)insnList, (String)"insnList");
        Intrinsics.checkParameterIsNotNull((Object)generationState, (String)"generationState");
        this.insnList = insnList;
        this.generationState = generationState;
        this.boxingPlaces = new HashMap();
    }
}

