/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.jvm.impl;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u001a\u001e\u0010\r\u001a\u0004\u0018\u00010\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u001a\u0018\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\n*\u00020\u0007H\u0000\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\n*\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"FILE_PROTOCOL", "", "JAR_PROTOCOL", "JAR_SEPARATOR", "SCHEME_SEPARATOR", "extractRoot", "resourceURL", "Ljava/net/URL;", "resourcePath", "getResourcePathForClass", "Ljava/io/File;", "aClass", "Ljava/lang/Class;", "getResourceRoot", "context", "path", "splitJarUrl", "Lkotlin/Pair;", "url", "tryGetResourcePathForClass", "tryGetResourcePathForClassByName", "name", "classLoader", "Ljava/lang/ClassLoader;", "toContainingJarOrNull", "toFileOrNull", "kotlin-scripting-jvm"})
public final class PathUtilKt {
    private static final String JAR_PROTOCOL = "jar";
    private static final String FILE_PROTOCOL = "file";
    private static final String JAR_SEPARATOR = "!/";
    private static final String SCHEME_SEPARATOR = "://";

    @Nullable
    public static final String getResourceRoot(@NotNull Class<?> context2, @NotNull String path2) {
        Intrinsics.checkParameterIsNotNull(context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        URL url = context2.getResource(path2);
        if (url == null) {
            String string = path2;
            int n = 1;
            boolean bl = false;
            String string2 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            url = ClassLoader.getSystemResource(string2);
        }
        return url != null ? PathUtilKt.extractRoot(url, path2) : null;
    }

    private static final String extractRoot(URL resourceURL, String resourcePath) {
        if (!StringsKt.startsWith$default((CharSequence)resourcePath, (char)'/', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)resourcePath, (char)'\\', (boolean)false, (int)2, null)) {
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if (Intrinsics.areEqual((Object)protocol, (Object)FILE_PROTOCOL)) {
            String path2;
            File file2 = PathUtilKt.toFileOrNull(resourceURL);
            if (file2 == null) {
                Intrinsics.throwNpe();
            }
            String string = path2 = file2.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
            String testPath = StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            String testResourcePath = StringsKt.replace$default((String)resourcePath, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            if (StringsKt.endsWith((String)testPath, (String)testResourcePath, (boolean)true)) {
                String string2 = path2;
                int n = 0;
                int n2 = path2.length() - resourcePath.length();
                boolean bl = false;
                String string3 = string2.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                resultPath = string3;
            }
        } else if (Intrinsics.areEqual((Object)protocol, (Object)JAR_PROTOCOL)) {
            Pair<String, String> paths;
            String string = resourceURL.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resourceURL.file");
            Pair<String, String> pair = paths = PathUtilKt.splitJarUrl(string);
            if ((pair != null ? (String)pair.getFirst() : null) != null) {
                resultPath = new File((String)paths.getFirst()).getCanonicalPath();
            }
        }
        String string = resultPath;
        return string != null ? StringsKt.trimEnd((String)string, (char[])new char[]{File.separatorChar}) : null;
    }

    private static final Pair<String, String> splitJarUrl(String url) {
        String jarPath;
        String resourcePath;
        block13: {
            Integer n = StringsKt.indexOf$default((CharSequence)url, (String)JAR_SEPARATOR, (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            int n2 = 0;
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            Integer n3 = it >= 0 ? n : null;
            if (n3 == null) {
                return null;
            }
            int pivot = n3;
            String string = url;
            n2 = pivot + 2;
            int n4 = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            resourcePath = string3;
            String string4 = url;
            n4 = 0;
            int n5 = 0;
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n4, pivot);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            jarPath = string6;
            if (StringsKt.startsWith$default((String)jarPath, (String)"jar:", (boolean)false, (int)2, null)) {
                string4 = jarPath;
                n4 = 4;
                n5 = 0;
                String string7 = string4;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.substring(n4);
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                jarPath = string8;
            }
            if (StringsKt.startsWith$default((String)jarPath, (String)FILE_PROTOCOL, (boolean)false, (int)2, null)) {
                try {
                    File file2 = PathUtilKt.toFileOrNull(new URL(jarPath));
                    if (file2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String string9 = file2.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"URL(jarPath).toFileOrNull()!!.path");
                    jarPath = StringsKt.replace$default((String)string9, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                }
                catch (Exception e) {
                    String string10 = jarPath;
                    n5 = FILE_PROTOCOL.length();
                    boolean bl3 = false;
                    String string11 = string10;
                    if (string11 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string12 = string11.substring(n5);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"(this as java.lang.String).substring(startIndex)");
                    jarPath = string12;
                    if (StringsKt.startsWith$default((String)jarPath, (String)SCHEME_SEPARATOR, (boolean)false, (int)2, null)) {
                        string10 = jarPath;
                        n5 = SCHEME_SEPARATOR.length();
                        bl3 = false;
                        String string13 = string10;
                        if (string13 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string14 = string13.substring(n5);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"(this as java.lang.String).substring(startIndex)");
                        jarPath = string14;
                    }
                    if (!StringsKt.startsWith$default((CharSequence)jarPath, (char)':', (boolean)false, (int)2, null)) break block13;
                    string10 = jarPath;
                    n5 = 1;
                    bl3 = false;
                    String string15 = string10;
                    if (string15 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string16 = string15.substring(n5);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string16, (String)"(this as java.lang.String).substring(startIndex)");
                    jarPath = string16;
                }
            }
        }
        return new Pair((Object)jarPath, (Object)resourcePath);
    }

    @Nullable
    public static final File tryGetResourcePathForClass(@NotNull Class<?> aClass2) {
        File file2;
        Intrinsics.checkParameterIsNotNull(aClass2, (String)"aClass");
        StringBuilder stringBuilder = new StringBuilder().append("/");
        String string = aClass2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"aClass.name");
        String path2 = stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(".class").toString();
        String string2 = PathUtilKt.getResourceRoot(aClass2, path2);
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            file2 = new File(it).getAbsoluteFile();
        } else {
            file2 = null;
        }
        return file2;
    }

    @NotNull
    public static final File getResourcePathForClass(@NotNull Class<?> aClass2) {
        Intrinsics.checkParameterIsNotNull(aClass2, (String)"aClass");
        File file2 = PathUtilKt.tryGetResourcePathForClass(aClass2);
        if (file2 == null) {
            throw (Throwable)new IllegalStateException("Resource for class: " + aClass2.getName() + " not found");
        }
        return file2;
    }

    @Nullable
    public static final File tryGetResourcePathForClassByName(@NotNull String name2, @NotNull ClassLoader classLoader2) {
        Class<?> clazz;
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)classLoader2, (String)"classLoader");
        try {
            File file2;
            Class<?> clazz2 = classLoader2.loadClass(name2);
            if (clazz2 != null) {
                clazz = clazz2;
                boolean bl = false;
                boolean bl2 = false;
                Class<?> p1 = clazz;
                boolean bl3 = false;
                file2 = PathUtilKt.tryGetResourcePathForClass(p1);
            } else {
                file2 = null;
            }
            clazz = file2;
        }
        catch (ClassNotFoundException _) {
            clazz = null;
        }
        catch (NoClassDefFoundError _) {
            clazz = null;
        }
        return clazz;
    }

    @Nullable
    public static final File toFileOrNull(@NotNull URL $this$toFileOrNull) {
        File file2;
        Intrinsics.checkParameterIsNotNull((Object)$this$toFileOrNull, (String)"$this$toFileOrNull");
        try {
            URI uRI = $this$toFileOrNull.toURI();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"toURI()");
            file2 = new File(uRI.getSchemeSpecificPart()).getCanonicalFile();
        }
        catch (URISyntaxException e) {
            file2 = Intrinsics.areEqual((Object)$this$toFileOrNull.getProtocol(), (Object)FILE_PROTOCOL) ^ true ? null : new File($this$toFileOrNull.getFile()).getCanonicalFile();
        }
        return file2;
    }

    @Nullable
    public static final File toContainingJarOrNull(@NotNull URL $this$toContainingJarOrNull) {
        File file2;
        Intrinsics.checkParameterIsNotNull((Object)$this$toContainingJarOrNull, (String)"$this$toContainingJarOrNull");
        if (Intrinsics.areEqual((Object)$this$toContainingJarOrNull.getProtocol(), (Object)JAR_PROTOCOL)) {
            Object object;
            URLConnection uRLConnection = $this$toContainingJarOrNull.openConnection();
            if (!(uRLConnection instanceof JarURLConnection)) {
                uRLConnection = null;
            }
            file2 = (object = (JarURLConnection)uRLConnection) != null && (object = ((JarURLConnection)object).getJarFileURL()) != null ? PathUtilKt.toFileOrNull((URL)object) : null;
        } else {
            file2 = null;
        }
        return file2;
    }
}

