/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateApplicability;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactoryKt;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.PostponedArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.symbols.ConeSymbol;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtomMarker;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001ah\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00010\u00102\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0010\u001a6\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\u001aN\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0010\u001aL\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0010\u001a\u001c\u0010\u0018\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001a$\u0010\u001d\u001a\u00020\u0007*\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001aJ\u0010\u001f\u001a\u00020\u0001*\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0014\u0010 \u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006!"}, d2={"resolveArgumentExpression", "", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "expectedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "isReceiver", "", "isSafeCall", "acceptLambdaAtoms", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedResolvedAtomMarker;", "typeProvider", "resolvePlainArgumentType", "argumentType", "resolvePlainExpressionArgument", "resolveSubCallArgument", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "getExpectedType", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "prepareExpectedType", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "resolveArgument", "varargElementType", "resolve"})
public final class ArgumentsKt {
    public static final void resolveArgumentExpression(@NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument, @NotNull ConeKotlinType expectedType, @NotNull FirTypeRef expectedTypeRef, @NotNull CheckerSink sink, boolean isReceiver, boolean isSafeCall, @NotNull Function1<? super PostponedResolvedAtomMarker, Unit> acceptLambdaAtoms, @NotNull Function1<? super FirExpression, ? extends FirTypeRef> typeProvider) {
        Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)expectedTypeRef, (String)"expectedTypeRef");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        Intrinsics.checkParameterIsNotNull(acceptLambdaAtoms, (String)"acceptLambdaAtoms");
        Intrinsics.checkParameterIsNotNull(typeProvider, (String)"typeProvider");
        FirExpression firExpression2 = argument;
        if (firExpression2 instanceof FirFunctionCall) {
            ArgumentsKt.resolveSubCallArgument(csBuilder, (FirFunctionCall)argument, expectedType, sink, isReceiver, isSafeCall, typeProvider);
        } else if (firExpression2 instanceof FirQualifiedAccessExpression) {
            ArgumentsKt.resolvePlainExpressionArgument(csBuilder, argument, expectedType, sink, isReceiver, isSafeCall, typeProvider);
        } else if (firExpression2 instanceof FirAnonymousFunction) {
            PostponedArgumentsKt.preprocessLambdaArgument$default(csBuilder, (FirAnonymousFunction)argument, expectedType, expectedTypeRef, acceptLambdaAtoms, false, 32, null);
        } else if (!(firExpression2 instanceof FirCallableReferenceAccess)) {
            if (firExpression2 instanceof FirWrappedArgumentExpression) {
                ArgumentsKt.resolveArgumentExpression(csBuilder, ((FirWrappedArgumentExpression)argument).getExpression(), expectedType, expectedTypeRef, sink, isReceiver, isSafeCall, acceptLambdaAtoms, typeProvider);
            } else {
                ArgumentsKt.resolvePlainExpressionArgument(csBuilder, argument, expectedType, sink, isReceiver, isSafeCall, typeProvider);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void resolveSubCallArgument(@NotNull ConstraintSystemBuilder csBuilder, @NotNull FirFunctionCall argument, @NotNull ConeKotlinType expectedType, @NotNull CheckerSink sink, boolean isReceiver, boolean isSafeCall, @NotNull Function1<? super FirExpression, ? extends FirTypeRef> typeProvider) {
        void $this$firUnsafe$iv;
        Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        Intrinsics.checkParameterIsNotNull(typeProvider, (String)"typeProvider");
        Candidate candidate2 = CandidateFactoryKt.candidate(argument);
        if (candidate2 == null) {
            ArgumentsKt.resolvePlainExpressionArgument(csBuilder, argument, expectedType, sink, isReceiver, isSafeCall, typeProvider);
            return;
        }
        Candidate candidate3 = candidate2;
        ConeSymbol coneSymbol = candidate3.getSymbol();
        ReturnTypeCalculator returnTypeCalculator = sink.getComponents().getReturnTypeCalculator();
        boolean $i$f$firUnsafe = false;
        boolean bl = $this$firUnsafe$iv instanceof FirBasedSymbol;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Not a fir based symbol: " + $this$firUnsafe$iv;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object fir$iv = ((FirBasedSymbol)$this$firUnsafe$iv).getFir();
        bl2 = fir$iv instanceof FirTypedDeclaration;
        bl3 = false;
        boolean bl5 = false;
        if (!bl2) {
            boolean bl6 = false;
            String string = "Not an expected fir element type = " + Reflection.getOrCreateKotlinClass(FirTypedDeclaration.class) + ", symbol = " + $this$firUnsafe$iv + ", fir = " + FirRendererKt.renderWithType(fir$iv);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object e = fir$iv;
        FirTypeRef $this$coneTypeUnsafe$iv = returnTypeCalculator.tryCalculateReturnType((FirTypedDeclaration)e);
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
        if (coneKotlinType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        ConeKotlinType type2 = coneKotlinType;
        ConeKotlinType argumentType = candidate3.getSubstitutor().substituteOrSelf(type2);
        ArgumentsKt.resolvePlainArgumentType(csBuilder, argumentType, expectedType, sink, isReceiver, isSafeCall);
    }

    public static final void resolvePlainExpressionArgument(@NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument, @Nullable ConeKotlinType expectedType, @NotNull CheckerSink sink, boolean isReceiver, boolean isSafeCall, @NotNull Function1<? super FirExpression, ? extends FirTypeRef> typeProvider) {
        Object object;
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
                Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
                Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
                Intrinsics.checkParameterIsNotNull(typeProvider, (String)"typeProvider");
                if (expectedType == null) {
                    return;
                }
                object = (FirTypeRef)typeProvider.invoke((Object)argument);
                if (object == null) break block6;
                FirTypeRef $this$coneTypeSafe$iv = object;
                boolean $i$f$coneTypeSafe = false;
                FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
                if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                    firTypeRef = null;
                }
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
                Object object2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                if (!(object2 instanceof ConeKotlinType)) {
                    object2 = object = null;
                }
                if (object2 != null) break block7;
            }
            return;
        }
        Object argumentType = object;
        ArgumentsKt.resolvePlainArgumentType(csBuilder, (ConeKotlinType)argumentType, expectedType, sink, isReceiver, isSafeCall);
    }

    public static final void resolvePlainArgumentType(@NotNull ConstraintSystemBuilder csBuilder, @NotNull ConeKotlinType argumentType, @NotNull ConeKotlinType expectedType, @NotNull CheckerSink sink, boolean isReceiver, boolean isSafeCall) {
        Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkParameterIsNotNull((Object)argumentType, (String)"argumentType");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        SimpleConstraintSystemConstraintPosition position = SimpleConstraintSystemConstraintPosition.INSTANCE;
        ConeKotlinType nullableExpectedType = ResolveUtilsKt.withNullability(expectedType, ConeNullability.NULLABLE);
        if (isReceiver && isSafeCall) {
            if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, nullableExpectedType, position)) {
                sink.reportApplicability(CandidateApplicability.WRONG_RECEIVER);
            }
            return;
        }
        if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedType, position)) {
            if (!isReceiver) {
                if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, nullableExpectedType, position)) {
                    csBuilder.addSubtypeConstraint(argumentType, expectedType, position);
                }
                return;
            }
            if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, nullableExpectedType, position)) {
                sink.reportApplicability(CandidateApplicability.WRONG_RECEIVER);
            } else {
                csBuilder.addSubtypeConstraint(argumentType, expectedType, position);
                sink.reportApplicability(CandidateApplicability.WRONG_RECEIVER);
            }
        }
    }

    public static final void resolveArgument(@NotNull Candidate $this$resolveArgument, @NotNull FirExpression argument, @NotNull FirValueParameter parameter, boolean isReceiver, boolean isSafeCall, @NotNull Function1<? super FirExpression, ? extends FirTypeRef> typeProvider, @NotNull CheckerSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)$this$resolveArgument, (String)"$this$resolveArgument");
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        Intrinsics.checkParameterIsNotNull(typeProvider, (String)"typeProvider");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        ConeKotlinType expectedType = ArgumentsKt.prepareExpectedType($this$resolveArgument, sink.getComponents().getSession(), argument, parameter);
        ArgumentsKt.resolveArgumentExpression($this$resolveArgument.getSystem().getBuilder(), argument, expectedType, parameter.getReturnTypeRef(), sink, isReceiver, isSafeCall, (Function1<? super PostponedResolvedAtomMarker, Unit>)((Function1)new Function1<PostponedResolvedAtomMarker, Unit>($this$resolveArgument){
            final /* synthetic */ Candidate $this_resolveArgument;

            public final void invoke(@NotNull PostponedResolvedAtomMarker it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Collection collection = this.$this_resolveArgument.getPostponedAtoms();
                boolean bl = false;
                collection.add(it);
            }
            {
                this.$this_resolveArgument = candidate2;
                super(1);
            }
        }), typeProvider);
    }

    private static final ConeKotlinType prepareExpectedType(@NotNull Candidate $this$prepareExpectedType, FirSession session, FirExpression argument, FirValueParameter parameter) {
        ConeKotlinType expectedType = ArgumentsKt.getExpectedType(argument, session, parameter);
        return $this$prepareExpectedType.getSubstitutor().substituteOrSelf(expectedType);
    }

    @NotNull
    public static final ConeKotlinType getExpectedType(@NotNull FirExpression $this$getExpectedType, @NotNull FirSession session, @NotNull FirValueParameter parameter) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkParameterIsNotNull((Object)$this$getExpectedType, (String)"$this$getExpectedType");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        if (!(!parameter.isVararg() || $this$getExpectedType instanceof FirWrappedArgumentExpression && ((FirWrappedArgumentExpression)$this$getExpectedType).isSpread())) {
            FirTypeRef $this$coneTypeUnsafe$iv = parameter.getReturnTypeRef();
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType2 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            coneKotlinType = ArgumentsKt.varargElementType(coneKotlinType2, session);
        } else {
            FirTypeRef $this$coneTypeUnsafe$iv = parameter.getReturnTypeRef();
            boolean $i$f$coneTypeUnsafe = false;
            coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
        }
        return coneKotlinType;
    }

    private static final ConeKotlinType varargElementType(@NotNull ConeKotlinType $this$varargElementType, FirSession session) {
        ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType($this$varargElementType, session);
        if (coneKotlinType == null) {
            String string = "Failed to extract! " + FirRendererKt.render($this$varargElementType) + '!';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return coneKotlinType;
    }
}

