/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;
import org.jetbrains.kotlin.konan.util.UtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0004\b\u0086\b\u0018\u0000 ]2\u00020\u0001:\u0001]B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB\r\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\u0016\u0010*\u001a\n +*\u0004\u0018\u00010\u00030\u00032\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\n +*\u0004\u0018\u00010/0/J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0005J\u000e\u00100\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b1J\u0013\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\u0003H\u00c6\u0001J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0000J\u000e\u00106\u001a\u0002042\u0006\u00107\u001a\u00020\u0005J\u0006\u00108\u001a\u00020\u0014J\u0006\u00109\u001a\u00020\u0000J\u0006\u0010:\u001a\u000204J\u0006\u0010;\u001a\u000204J\u0013\u0010<\u001a\u00020\u00142\b\u0010=\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001a\u0010>\u001a\u0002042\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002040@J\b\u0010A\u001a\u00020BH\u0016J$\u0010C\u001a\u00020D2\b\b\u0002\u0010E\u001a\u00020F2\b\b\u0002\u0010G\u001a\u00020H2\b\b\u0002\u0010I\u001a\u00020HJ\u000e\u0010J\u001a\n +*\u0004\u0018\u00010\u00030\u0003J\u000e\u0010K\u001a\n +*\u0004\u0018\u00010L0LJ\u001a\u0010M\u001a\u0002042\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002040@J\u001a\u0010O\u001a\u0002042\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002040@J\u0006\u0010P\u001a\u00020QJ\u000e\u0010R\u001a\n +*\u0004\u0018\u00010-0-J\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00050TJ\u000e\u0010U\u001a\u0002042\u0006\u00105\u001a\u00020\u0000J\b\u0010V\u001a\u00020\u0005H\u0016J\u0016\u0010W\u001a\n +*\u0004\u0018\u00010\u00030\u00032\u0006\u0010,\u001a\u00020-J\u0014\u0010X\u001a\u0002042\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00050ZJ\u000e\u0010[\u001a\u0002042\u0006\u0010\\\u001a\u00020\u0005R\u0011\u0010\r\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u001a\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u001b\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00000\u001f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0011\u0010$\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012R\u0011\u0010'\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000fR\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0012\u00a8\u0006^"}, d2={"Lorg/jetbrains/kotlin/konan/file/File;", "", "parent", "Ljava/nio/file/Path;", "child", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "(Lorg/jetbrains/kotlin/konan/file/File;Ljava/lang/String;)V", "path", "(Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "javaPath", "(Ljava/nio/file/Path;)V", "absoluteFile", "getAbsoluteFile", "()Lorg/jetbrains/kotlin/konan/file/File;", "absolutePath", "getAbsolutePath", "()Ljava/lang/String;", "exists", "", "getExists", "()Z", "extension", "getExtension", "isAbsolute", "isDirectory", "isFile", "getJavaPath$kotlin_util_io", "()Ljava/nio/file/Path;", "listFiles", "", "getListFiles", "()Ljava/util/List;", "listFilesOrEmpty", "getListFilesOrEmpty", "name", "getName", "getParent", "parentFile", "getParentFile", "getPath", "appendBytes", "kotlin.jvm.PlatformType", "bytes", "", "bufferedReader", "Ljava/io/BufferedReader;", "component1", "component1$kotlin_util_io", "copy", "copyTo", "", "destination", "createAsSymlink", "target", "delete", "deleteOnExit", "deleteOnExitRecursively", "deleteRecursively", "equals", "other", "forEachLine", "action", "Lkotlin/Function1;", "hashCode", "", "map", "Ljava/nio/MappedByteBuffer;", "mode", "Ljava/nio/channels/FileChannel$MapMode;", "start", "", "size", "mkdirs", "outputStream", "Ljava/io/OutputStream;", "postorder", "task", "preorder", "printWriter", "Ljava/io/PrintWriter;", "readBytes", "readStrings", "", "recursiveCopyTo", "toString", "writeBytes", "writeLines", "lines", "", "writeText", "text", "Companion", "kotlin-util-io"})
public final class File {
    @NotNull
    private final Path javaPath;
    private static final String pathSeparator;
    private static final String separator;
    public static final Companion Companion;

    @NotNull
    public final String getPath() {
        return ((Object)this.javaPath).toString();
    }

    @NotNull
    public final String getAbsolutePath() {
        return ((Object)this.javaPath.toAbsolutePath()).toString();
    }

    @NotNull
    public final File getAbsoluteFile() {
        return new File(this.getAbsolutePath());
    }

    @NotNull
    public final String getName() {
        return UtilKt.removeSuffixIfPresent(((Object)this.javaPath.getFileName()).toString(), "/");
    }

    @NotNull
    public final String getExtension() {
        return StringsKt.substringAfterLast((String)this.getName(), (char)'.', (String)"");
    }

    @NotNull
    public final String getParent() {
        return ((Object)this.javaPath.getParent()).toString();
    }

    @NotNull
    public final File getParentFile() {
        Path path2 = this.javaPath.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"javaPath.parent");
        return new File(path2);
    }

    public final boolean getExists() {
        return Files.exists(this.javaPath, new LinkOption[0]);
    }

    public final boolean isDirectory() {
        return Files.isDirectory(this.javaPath, new LinkOption[0]);
    }

    public final boolean isFile() {
        return Files.isRegularFile(this.javaPath, new LinkOption[0]);
    }

    public final boolean isAbsolute() {
        return this.javaPath.isAbsolute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getListFiles() {
        Iterable stream;
        AutoCloseable $this$use$iv = Files.newDirectoryStream(this.javaPath);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            void $this$mapTo$iv$iv;
            stream = (DirectoryStream)$this$use$iv;
            boolean bl = false;
            DirectoryStream directoryStream = stream;
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryStream, (String)"stream");
            Iterable $this$map$iv = directoryStream;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path2 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                File file2 = new File((Path)v1);
                collection.add(file2);
            }
            stream = (List)destination$iv$iv;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw (Throwable)e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        return stream;
    }

    @NotNull
    public final List<File> getListFilesOrEmpty() {
        return this.getExists() ? this.getListFiles() : CollectionsKt.emptyList();
    }

    @NotNull
    public final File child(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        return new File(this, name2);
    }

    public final void copyTo(@NotNull File destination) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Files.copy(this.javaPath, destination.javaPath, StandardCopyOption.REPLACE_EXISTING);
    }

    public final void recursiveCopyTo(@NotNull File destination) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Path sourcePath = this.javaPath;
        Path destPath = destination.javaPath;
        FileKt.recursiveCopyTo(sourcePath, destPath);
    }

    public final Path mkdirs() {
        return Files.createDirectories(this.javaPath, new FileAttribute[0]);
    }

    public final boolean delete() {
        return Files.deleteIfExists(this.javaPath);
    }

    public final void deleteRecursively() {
        this.postorder((Function1<? super Path, Unit>)((Function1)deleteRecursively.1.INSTANCE));
    }

    public final void deleteOnExitRecursively() {
        this.preorder((Function1<? super Path, Unit>)((Function1)deleteOnExitRecursively.1.INSTANCE));
    }

    public final void preorder(@NotNull Function1<? super Path, Unit> task) {
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        if (!this.getExists()) {
            return;
        }
        Files.walkFileTree(this.javaPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(task){
            final /* synthetic */ Function1 $task;

            @NotNull
            public FileVisitResult visitFile(@Nullable Path file2, @Nullable BasicFileAttributes attrs) {
                Path path2 = file2;
                if (path2 == null) {
                    Intrinsics.throwNpe();
                }
                this.$task.invoke((Object)path2);
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult preVisitDirectory(@Nullable Path dir, @Nullable BasicFileAttributes attrs) {
                Path path2 = dir;
                if (path2 == null) {
                    Intrinsics.throwNpe();
                }
                this.$task.invoke((Object)path2);
                return FileVisitResult.CONTINUE;
            }
            {
                this.$task = $captured_local_variable$0;
            }
        });
    }

    public final void postorder(@NotNull Function1<? super Path, Unit> task) {
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        if (!this.getExists()) {
            return;
        }
        Files.walkFileTree(this.javaPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(task){
            final /* synthetic */ Function1 $task;

            @NotNull
            public FileVisitResult visitFile(@Nullable Path file2, @Nullable BasicFileAttributes attrs) {
                Path path2 = file2;
                if (path2 == null) {
                    Intrinsics.throwNpe();
                }
                this.$task.invoke((Object)path2);
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@Nullable Path dir, @Nullable IOException exc) {
                Path path2 = dir;
                if (path2 == null) {
                    Intrinsics.throwNpe();
                }
                this.$task.invoke((Object)path2);
                return FileVisitResult.CONTINUE;
            }
            {
                this.$task = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public final MappedByteBuffer map(@NotNull FileChannel.MapMode mode, long start, long size) {
        boolean bl;
        long l;
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        RandomAccessFile file2 = new RandomAccessFile(this.getPath(), Intrinsics.areEqual((Object)mode, (Object)FileChannel.MapMode.READ_ONLY) ? "r" : "rw");
        if (Intrinsics.areEqual((Object)mode, (Object)FileChannel.MapMode.READ_ONLY)) {
            l = file2.length();
        } else {
            long l2 = size;
            boolean bl2 = false;
            bl = false;
            long it = l2;
            boolean bl3 = false;
            boolean bl4 = size != -1L;
            boolean bl5 = false;
            boolean bl6 = false;
            if (_Assertions.ENABLED && !bl4) {
                boolean bl7 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            l = l2;
        }
        long fileSize = l;
        FileChannel channel2 = file2.getChannel();
        MappedByteBuffer mappedByteBuffer = channel2.map(mode, start, fileSize);
        bl = false;
        boolean bl8 = false;
        MappedByteBuffer it = mappedByteBuffer;
        boolean bl9 = false;
        channel2.close();
        MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)mappedByteBuffer2, (String)"channel.map(mode, start,\u2026.also { channel.close() }");
        return mappedByteBuffer2;
    }

    public static /* synthetic */ MappedByteBuffer map$default(File file2, FileChannel.MapMode mapMode, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            FileChannel.MapMode mapMode2 = FileChannel.MapMode.READ_ONLY;
            Intrinsics.checkExpressionValueIsNotNull((Object)mapMode2, (String)"FileChannel.MapMode.READ_ONLY");
            mapMode = mapMode2;
        }
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = -1L;
        }
        return file2.map(mapMode, l, l2);
    }

    @NotNull
    public final File deleteOnExit() {
        this.javaPath.toFile().deleteOnExit();
        return this;
    }

    public final byte[] readBytes() {
        return Files.readAllBytes(this.javaPath);
    }

    public final Path writeBytes(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        return Files.write(this.javaPath, bytes, new OpenOption[0]);
    }

    public final Path appendBytes(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        return Files.write(this.javaPath, bytes, StandardOpenOption.APPEND);
    }

    public final void writeLines(@NotNull Iterable<String> lines) {
        Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
        Files.write(this.javaPath, lines, new OpenOption[0]);
    }

    public final void writeText(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        this.writeLines(CollectionsKt.listOf((Object)text2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forEachLine(@NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        AutoCloseable $this$use$iv = Files.lines(this.javaPath);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            Stream lines = (Stream)$this$use$iv;
            boolean bl = false;
            lines.forEach((Consumer)new Consumer<String>(action){
                final /* synthetic */ Function1 $action$inlined;
                {
                    this.$action$inlined = function1;
                }

                public final void accept(String it) {
                    String string = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    this.$action$inlined.invoke((Object)string);
                }
            });
            lines = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw (Throwable)e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
    }

    public final void createAsSymlink(@NotNull String target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Path targetPath = Paths.get(target, new String[0]);
        if (Files.isSymbolicLink(this.javaPath) && Intrinsics.areEqual((Object)Files.readSymbolicLink(this.javaPath), (Object)targetPath)) {
            return;
        }
        Files.createSymbolicLink(this.javaPath, targetPath, new FileAttribute[0]);
    }

    @NotNull
    public String toString() {
        return this.getPath();
    }

    public final BufferedReader bufferedReader() {
        return Files.newBufferedReader(this.javaPath);
    }

    public final OutputStream outputStream() {
        return Files.newOutputStream(this.javaPath, new OpenOption[0]);
    }

    @NotNull
    public final PrintWriter printWriter() {
        java.io.File file2 = this.javaPath.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"javaPath.toFile()");
        java.io.File file3 = file2;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        java.io.File file4 = file3;
        int n = 8192;
        boolean bl2 = false;
        Object object = file4;
        boolean bl3 = false;
        Object object2 = object;
        boolean bl4 = false;
        object2 = new FileOutputStream((java.io.File)object2);
        bl4 = false;
        object = new OutputStreamWriter((OutputStream)object2, charset);
        bl3 = false;
        BufferedWriter bufferedWriter = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        Writer writer = bufferedWriter;
        return new PrintWriter(writer);
    }

    @NotNull
    public final List<String> readStrings() {
        boolean bl = false;
        List list2 = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List list3 = list2;
        boolean bl4 = false;
        this.forEachLine((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(list3){
            final /* synthetic */ List $list;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$list.add(it);
            }
            {
                this.$list = list2;
                super(1);
            }
        }));
        return list2;
    }

    public boolean equals(@Nullable Object other) {
        Object object = other;
        if (!(object instanceof File)) {
            object = null;
        }
        File file2 = (File)object;
        if (file2 == null) {
            return false;
        }
        File otherFile = file2;
        return Intrinsics.areEqual((Object)otherFile.javaPath.toAbsolutePath(), (Object)this.javaPath.toAbsolutePath());
    }

    public int hashCode() {
        return ((Object)this.javaPath.toAbsolutePath()).hashCode();
    }

    @NotNull
    public final Path getJavaPath$kotlin_util_io() {
        return this.javaPath;
    }

    public File(@NotNull Path javaPath) {
        Intrinsics.checkParameterIsNotNull((Object)javaPath, (String)"javaPath");
        this.javaPath = javaPath;
    }

    public File(@NotNull Path parent2, @NotNull String child) {
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        Path path2 = parent2.resolve(child);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"parent.resolve(child)");
        this(path2);
    }

    public File(@NotNull File parent2, @NotNull String child) {
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        Path path2 = parent2.javaPath.resolve(child);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"parent.javaPath.resolve(child)");
        this(path2);
    }

    public File(@NotNull String path2) {
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        Path path3 = Paths.get(path2, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Paths.get(path)");
        this(path3);
    }

    public File(@NotNull String parent2, @NotNull String child) {
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        Path path2 = Paths.get(parent2, child);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(parent, child)");
        this(path2);
    }

    static {
        Companion = new Companion(null);
        pathSeparator = java.io.File.pathSeparator;
        separator = java.io.File.separator;
    }

    @NotNull
    public final Path component1$kotlin_util_io() {
        return this.javaPath;
    }

    @NotNull
    public final File copy(@NotNull Path javaPath) {
        Intrinsics.checkParameterIsNotNull((Object)javaPath, (String)"javaPath");
        return new File(javaPath);
    }

    public static /* synthetic */ File copy$default(File file2, Path path2, int n, Object object) {
        if ((n & 1) != 0) {
            path2 = file2.javaPath;
        }
        return file2.copy(path2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006R\u0011\u0010\u0010\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/konan/file/File$Companion;", "", "()V", "javaHome", "Lorg/jetbrains/kotlin/konan/file/File;", "getJavaHome", "()Lorg/jetbrains/kotlin/konan/file/File;", "pathSeparator", "", "kotlin.jvm.PlatformType", "getPathSeparator", "()Ljava/lang/String;", "separator", "getSeparator", "userDir", "getUserDir", "userHome", "getUserHome", "kotlin-util-io"})
    public static final class Companion {
        @NotNull
        public final File getUserDir() {
            String string = System.getProperty("user.dir");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"user.dir\")");
            return new File(string);
        }

        @NotNull
        public final File getUserHome() {
            String string = System.getProperty("user.home");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"user.home\")");
            return new File(string);
        }

        @NotNull
        public final File getJavaHome() {
            String string = System.getProperty("java.home");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"java.home\")");
            return new File(string);
        }

        public final String getPathSeparator() {
            return pathSeparator;
        }

        public final String getSeparator() {
            return separator;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

