/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u0002H\u00040\fj\b\u0012\u0004\u0012\u0002H\u0004`\r\"\u0004\b\u0000\u0010\u0004H\u0000\u001a*\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f*\u00060\u0010j\u0002`\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013H\u0080\b\u00a2\u0006\u0002\u0010\u0014\"\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\f\b\u0000\u0010\u0015\"\u00020\u00102\u00020\u0010\u00a8\u0006\u0016"}, d2={"REMOVE_FUTURE_ON_CANCEL", "Ljava/lang/reflect/Method;", "identitySet", "", "E", "expectedSize", "", "removeFutureOnCancel", "", "executor", "Ljava/util/concurrent/Executor;", "subscriberList", "", "Lkotlinx/coroutines/internal/SubscribersList;", "withLock", "T", "Ljava/util/concurrent/locks/ReentrantLock;", "Lkotlinx/coroutines/internal/ReentrantLock;", "action", "Lkotlin/Function0;", "(Ljava/util/concurrent/locks/ReentrantLock;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ReentrantLock", "kotlinx-coroutines-core"})
public final class ConcurrentKt {
    private static final Method REMOVE_FUTURE_ON_CANCEL;

    @NotNull
    public static final <E> List<E> subscriberList() {
        return new CopyOnWriteArrayList();
    }

    public static /* synthetic */ void ReentrantLock$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withLock(@NotNull ReentrantLock $this$withLock, @NotNull Function0<? extends T> action) {
        Object object;
        int $i$f$withLock = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$withLock, (String)"$this$withLock");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Lock lock = $this$withLock;
        boolean bl = false;
        lock.lock();
        try {
            object = action.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            lock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    @NotNull
    public static final <E> Set<E> identitySet(int expectedSize) {
        Set set = Collections.newSetFromMap(new IdentityHashMap(expectedSize));
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"Collections.newSetFromMa\u2026ityHashMap(expectedSize))");
        return set;
    }

    public static final boolean removeFutureOnCancel(@NotNull Executor executor2) {
        Intrinsics.checkParameterIsNotNull((Object)executor2, (String)"executor");
        try {
            Executor executor3 = executor2;
            if (!(executor3 instanceof ScheduledExecutorService)) {
                executor3 = null;
            }
            ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executor3;
            if (scheduledExecutorService == null) {
                return false;
            }
            ScheduledExecutorService executor4 = scheduledExecutorService;
            Method method = REMOVE_FUTURE_ON_CANCEL;
            if (method == null) {
                return false;
            }
            method.invoke((Object)executor4, true);
            return true;
        }
        catch (Throwable e) {
            return true;
        }
    }

    static {
        Method method;
        try {
            method = ScheduledThreadPoolExecutor.class.getMethod("setRemoveOnCancelPolicy", Boolean.TYPE);
        }
        catch (Throwable e) {
            method = null;
        }
        REMOVE_FUTURE_ON_CANCEL = method;
    }
}

