/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanVariableReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.ContractDescriptionValue;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.contracts.parsing.ContractCallContext;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingDiagnosticsCollector;
import org.jetbrains.kotlin.contracts.parsing.ContractsDslNames;
import org.jetbrains.kotlin.contracts.parsing.PsiConditionParser;
import org.jetbrains.kotlin.contracts.parsing.PsiConstantParser;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.contracts.parsing.PsiEffectParser;
import org.jetbrains.kotlin.contracts.parsing.effects.PsiCallsEffectParser;
import org.jetbrains.kotlin.contracts.parsing.effects.PsiConditionalEffectParser;
import org.jetbrains.kotlin.contracts.parsing.effects.PsiReturnsEffectParser;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u0011\u001a\u00020\u00122\u001a\u0010\u0013\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\u00170\u00150\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017J\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0012\u0010!\u001a\u0004\u0018\u00010\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017J\u0012\u0010$\u001a\u0004\u0018\u00010%2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;", "", "collector", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;", "callContext", "Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "conditionParser", "Lorg/jetbrains/kotlin/contracts/parsing/PsiConditionParser;", "constantParser", "Lorg/jetbrains/kotlin/contracts/parsing/PsiConstantParser;", "effectsParsers", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/contracts/parsing/PsiEffectParser;", "checkDuplicatedCallsEffectsAndReport", "", "effects", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isValidEffectDeclaration", "", "expression", "parseCondition", "Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "parseConstant", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "parseContract", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "parseEffect", "parseValue", "Lorg/jetbrains/kotlin/contracts/description/expressions/ContractDescriptionValue;", "parseVariable", "Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;", "frontend"})
public final class PsiContractParserDispatcher {
    private final PsiConditionParser conditionParser;
    private final PsiConstantParser constantParser;
    private final Map<Name, PsiEffectParser> effectsParsers;
    private final ContractParsingDiagnosticsCollector collector;
    private final ContractCallContext callContext;
    private final StorageManager storageManager;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ContractDescription parseContract() {
        void $this$mapNotNullTo$iv$iv;
        Iterable destination$iv$iv;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(this.callContext.getContractCallExpression(), this.callContext.getBindingContext());
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        KtExpression firstArgumentExpression = PsiContractsUtilsKt.firstArgumentAsExpressionOrNull(resolvedCall3);
        if (!(firstArgumentExpression instanceof KtLambdaExpression)) {
            KtExpression ktExpression = firstArgumentExpression;
            if (ktExpression == null) {
                ktExpression = this.callContext.getContractCallExpression();
            }
            KtExpression reportOn = ktExpression;
            this.collector.badDescription("first argument of 'contract'-call should be a lambda expression", reportOn);
            return null;
        }
        KtLambdaExpression lambda2 = (KtLambdaExpression)firstArgumentExpression;
        Object object = lambda2.getBodyExpression();
        if (object != null && (object = ((KtBlockExpression)object).getStatements()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtExpression ktExpression = (KtExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)this.parseEffect((KtExpression)it), (Object)it);
                collection.add(pair);
            }
        } else {
            return null;
        }
        List effectsWithExpression = (List)destination$iv$iv;
        this.checkDuplicatedCallsEffectsAndReport(effectsWithExpression);
        Iterable $this$mapNotNull$iv = effectsWithExpression;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            EffectDeclaration effectDeclaration;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            if ((EffectDeclaration)it.getFirst() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            EffectDeclaration it$iv$iv = effectDeclaration;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List effects = (List)destination$iv$iv2;
        if (effects.isEmpty()) {
            return null;
        }
        return new ContractDescription(effects, this.callContext.getFunctionDescriptor(), this.storageManager);
    }

    @Nullable
    public final BooleanExpression parseCondition(@Nullable KtExpression expression2) {
        KtExpression ktExpression = expression2;
        return ktExpression != null ? (BooleanExpression)ktExpression.accept(this.conditionParser, Unit.INSTANCE) : null;
    }

    @Nullable
    public final EffectDeclaration parseEffect(@Nullable KtExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        if (!this.isValidEffectDeclaration(expression2)) {
            return null;
        }
        KotlinType kotlinType2 = CallUtilKt.getType(expression2, this.callContext.getBindingContext());
        if (kotlinType2 == null) {
            return null;
        }
        KotlinType returnType2 = kotlinType2;
        Map<Name, PsiEffectParser> map2 = this.effectsParsers;
        ClassifierDescriptor classifierDescriptor = returnType2.getConstructor().getDeclarationDescriptor();
        Name name2 = classifierDescriptor != null ? classifierDescriptor.getName() : null;
        boolean bl = false;
        PsiEffectParser parser = map2.get(name2);
        if (parser == null) {
            this.collector.badDescription("unrecognized effect", expression2);
            return null;
        }
        return parser.tryParseEffect(expression2);
    }

    private final void checkDuplicatedCallsEffectsAndReport(List<? extends Pair<? extends EffectDeclaration, ? extends KtExpression>> effects) {
        boolean bl = false;
        Set descriptorsWithCallsEffect = new LinkedHashSet();
        for (Pair<? extends EffectDeclaration, ? extends KtExpression> pair : effects) {
            EffectDeclaration effect = (EffectDeclaration)pair.component1();
            KtExpression expression2 = (KtExpression)pair.component2();
            if (!(effect instanceof CallsEffectDeclaration)) continue;
            ParameterDescriptor descriptor2 = ((CallsEffectDeclaration)effect).getVariableReference().getDescriptor();
            if (descriptorsWithCallsEffect.contains(descriptor2)) {
                this.collector.badDescription("Duplicated contract for " + descriptor2.getName() + ". Only one `callsInPlace` contract per parameter is allowed.", expression2);
                continue;
            }
            descriptorsWithCallsEffect.add(descriptor2);
        }
    }

    private final boolean isValidEffectDeclaration(KtExpression expression2) {
        if (!(expression2 instanceof KtCallExpression) && !(expression2 instanceof KtBinaryExpression)) {
            this.collector.badDescription("unexpected construction in contract description", expression2);
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.callContext.getBindingContext());
        if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resultingDescriptor = resolvedCall2;
        if (!PsiContractsUtilsKt.isFromContractDsl((DeclarationDescriptor)((Object)resultingDescriptor))) {
            this.collector.badDescription("effects can be produced only by direct calls to ContractsDSL", expression2);
            return false;
        }
        return true;
    }

    @Nullable
    public final ConstantReference parseConstant(@Nullable KtExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        return (ConstantReference)expression2.accept(this.constantParser, Unit.INSTANCE);
    }

    @Nullable
    public final VariableReference parseVariable(@Nullable KtExpression expression2) {
        CallableDescriptor descriptor2;
        if (expression2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.callContext.getBindingContext());
        CallableDescriptor callableDescriptor = descriptor2 = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
        if (!(descriptor2 instanceof ParameterDescriptor)) {
            if (!(expression2 instanceof KtConstantExpression)) {
                this.collector.badDescription("only references to parameters are allowed in contract description", expression2);
            }
            return null;
        }
        if (descriptor2 instanceof ReceiverParameterDescriptor) {
            ClassifierDescriptor classifierDescriptor = ((ReceiverParameterDescriptor)descriptor2).getType().getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor != null) {
                if (PsiContractsUtilsKt.isFromContractDsl(classifierDescriptor)) {
                    this.collector.badDescription("only references to parameters are allowed. Did you miss label on <this>?", expression2);
                    return null;
                }
            }
        }
        return KotlinBuiltIns.isBoolean(((ParameterDescriptor)descriptor2).getType()) ? (VariableReference)new BooleanVariableReference((ParameterDescriptor)descriptor2) : new VariableReference((ParameterDescriptor)descriptor2);
    }

    @Nullable
    public final ContractDescriptionValue parseValue(@Nullable KtExpression expression2) {
        VariableReference variable2 = this.parseVariable(expression2);
        if (variable2 != null) {
            return variable2;
        }
        return this.parseConstant(expression2);
    }

    public PsiContractParserDispatcher(@NotNull ContractParsingDiagnosticsCollector collector2, @NotNull ContractCallContext callContext, @NotNull StorageManager storageManager) {
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        Intrinsics.checkParameterIsNotNull((Object)callContext, (String)"callContext");
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        this.collector = collector2;
        this.callContext = callContext;
        this.storageManager = storageManager;
        this.conditionParser = new PsiConditionParser(this.collector, this.callContext, this);
        this.constantParser = new PsiConstantParser(this.callContext);
        this.effectsParsers = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ContractsDslNames.INSTANCE.getRETURNS_EFFECT(), (Object)new PsiReturnsEffectParser(this.collector, this.callContext, this)), TuplesKt.to((Object)ContractsDslNames.INSTANCE.getRETURNS_NOT_NULL_EFFECT(), (Object)new PsiReturnsEffectParser(this.collector, this.callContext, this)), TuplesKt.to((Object)ContractsDslNames.INSTANCE.getCALLS_IN_PLACE_EFFECT(), (Object)new PsiCallsEffectParser(this.collector, this.callContext, this)), TuplesKt.to((Object)ContractsDslNames.INSTANCE.getCONDITIONAL_EFFECT(), (Object)new PsiConditionalEffectParser(this.collector, this.callContext, this))});
    }
}

