/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.LookupSymbol;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0002R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/incremental/ChangedJavaFilesProcessor;", "", "reporter", "Lorg/jetbrains/kotlin/incremental/ICReporter;", "psiFileFactory", "Lkotlin/Function1;", "Ljava/io/File;", "Lcom/intellij/psi/PsiFile;", "(Lorg/jetbrains/kotlin/incremental/ICReporter;Lkotlin/jvm/functions/Function1;)V", "allChangedSymbols", "", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "getAllChangedSymbols", "()Ljava/util/Collection;", "allSymbols", "Ljava/util/HashSet;", "process", "Lorg/jetbrains/kotlin/incremental/ChangesEither;", "filesDiff", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;", "addLookupSymbols", "", "Lcom/intellij/psi/PsiClass;", "symbols", "", "incremental-compilation-impl"})
public final class ChangedJavaFilesProcessor {
    private final HashSet<LookupSymbol> allSymbols;
    private final ICReporter reporter;
    private final Function1<File, PsiFile> psiFileFactory;

    @NotNull
    public final Collection<LookupSymbol> getAllChangedSymbols() {
        return this.allSymbols;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChangesEither process(@NotNull ChangedFiles.Known filesDiff) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)filesDiff, (String)"filesDiff");
        Iterable $this$filter$iv = filesDiff.getModified();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            File p1 = (File)element$iv$iv;
            boolean bl = false;
            if (!FileUtilsKt.isJavaFile(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modifiedJava = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = filesDiff.getRemoved();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv22 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File p1 = (File)element$iv$iv;
            boolean bl = false;
            if (!FileUtilsKt.isJavaFile(p1)) continue;
            destination$iv$iv22.add(element$iv$iv);
        }
        List removedJava = (List)destination$iv$iv22;
        if (CollectionsKt.any((Iterable)removedJava)) {
            this.reporter.report((Function0<String>)((Function0)new Function0<String>(removedJava){
                final /* synthetic */ List $removedJava;

                @NotNull
                public final String invoke() {
                    return "Some java files are removed: [" + CollectionsKt.joinToString$default((Iterable)this.$removedJava, null, null, null, (int)0, null, null, (int)63, null) + ']';
                }
                {
                    this.$removedJava = list2;
                    super(0);
                }
            }));
            return new ChangesEither.Unknown(null, 1, null);
        }
        HashSet symbols2 = new HashSet();
        for (File javaFile : modifiedJava) {
            PsiClass[] $this$forEach$iv;
            boolean destination$iv$iv22 = StringsKt.equals((String)FilesKt.getExtension((File)javaFile), (String)"java", (boolean)true);
            $i$f$filterTo2 = false;
            boolean element$iv$iv = false;
            if (_Assertions.ENABLED && !destination$iv$iv22) {
                boolean bl = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            PsiFile psiFile = (PsiFile)this.psiFileFactory.invoke((Object)javaFile);
            if (!(psiFile instanceof PsiJavaFile)) {
                this.reporter.report((Function0<String>)((Function0)new Function0<String>(psiFile){
                    final /* synthetic */ PsiFile $psiFile;

                    @NotNull
                    public final String invoke() {
                        PsiFile psiFile = this.$psiFile;
                        return "Expected PsiJavaFile, got " + (psiFile != null ? psiFile.getClass() : null);
                    }
                    {
                        this.$psiFile = psiFile;
                        super(0);
                    }
                }));
                return new ChangesEither.Unknown(null, 1, null);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((PsiJavaFile)psiFile).getClasses(), (String)"psiFile.classes");
            boolean $i$f$forEach = false;
            PsiClass[] psiClassArray = $this$forEach$iv;
            int n = psiClassArray.length;
            for (int i = 0; i < n; ++i) {
                PsiClass element$iv;
                PsiClass it = element$iv = psiClassArray[i];
                boolean bl = false;
                PsiClass psiClass = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"it");
                this.addLookupSymbols(psiClass, symbols2);
            }
        }
        this.allSymbols.addAll(symbols2);
        return new ChangesEither.Known(symbols2, null, 2, null);
    }

    private final void addLookupSymbols(@NotNull PsiClass $this$addLookupSymbols, Set<LookupSymbol> symbols2) {
        PsiMethod it;
        PsiMethod element$iv;
        int n;
        String string;
        String string2;
        String string3 = $this$addLookupSymbols.getQualifiedName();
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            string4 = "";
        }
        String fqn = string4;
        string3 = $this$addLookupSymbols.getName();
        Set<LookupSymbol> set = symbols2;
        bl = false;
        String string5 = string3;
        if (string5 == null) {
            string5 = string2 = "";
        }
        if (Intrinsics.areEqual((Object)fqn, (Object)$this$addLookupSymbols.getName())) {
            string = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(".");
            String string6 = $this$addLookupSymbols.getName();
            if (string6 == null) {
                Intrinsics.throwNpe();
            }
            string = StringsKt.removeSuffix((String)fqn, (CharSequence)stringBuilder.append(string6).toString());
        }
        String string7 = string;
        String string8 = string2;
        set.add(new LookupSymbol(string8, string7));
        PsiMethod[] psiMethodArray = $this$addLookupSymbols.getMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"methods");
        PsiMethod[] $this$forEach$iv = psiMethodArray;
        boolean $i$f$forEach = false;
        PsiMethod[] psiMethodArray2 = $this$forEach$iv;
        int n2 = psiMethodArray2.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = psiMethodArray2[n];
            boolean bl2 = false;
            PsiMethod psiMethod = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"it");
            String string9 = psiMethod.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"it.name");
            symbols2.add(new LookupSymbol(string9, fqn));
        }
        PsiField[] psiFieldArray = $this$addLookupSymbols.getFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFieldArray, (String)"fields");
        $this$forEach$iv = psiFieldArray;
        $i$f$forEach = false;
        psiMethodArray2 = $this$forEach$iv;
        n2 = psiMethodArray2.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = psiMethodArray2[n];
            boolean bl3 = false;
            PsiMethod psiMethod = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"it");
            String string10 = psiMethod.getName();
            Set<LookupSymbol> set2 = symbols2;
            boolean bl4 = false;
            String string11 = string10;
            if (string11 == null) {
                string11 = "";
            }
            String string12 = string11;
            String string13 = fqn;
            String string14 = string12;
            set2.add(new LookupSymbol(string14, string13));
        }
        PsiClass[] psiClassArray = $this$addLookupSymbols.getInnerClasses();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClassArray, (String)"innerClasses");
        $this$forEach$iv = psiClassArray;
        $i$f$forEach = false;
        psiMethodArray2 = $this$forEach$iv;
        n2 = psiMethodArray2.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = psiMethodArray2[n];
            boolean bl5 = false;
            PsiMethod psiMethod = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"it");
            this.addLookupSymbols((PsiClass)psiMethod, symbols2);
        }
    }

    public ChangedJavaFilesProcessor(@NotNull ICReporter reporter2, @NotNull Function1<? super File, ? extends PsiFile> psiFileFactory2) {
        Intrinsics.checkParameterIsNotNull((Object)reporter2, (String)"reporter");
        Intrinsics.checkParameterIsNotNull(psiFileFactory2, (String)"psiFileFactory");
        this.reporter = reporter2;
        this.psiFileFactory = psiFileFactory2;
        this.allSymbols = new HashSet();
    }
}

