/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.context;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public abstract class ResolutionContext<Context extends ResolutionContext<Context>> {
    @NotNull
    public final BindingTrace trace;
    @NotNull
    public final LexicalScope scope;
    @NotNull
    public final KotlinType expectedType;
    @NotNull
    public final DataFlowInfo dataFlowInfo;
    @NotNull
    public final ContextDependency contextDependency;
    @NotNull
    public final ResolutionResultsCache resolutionResultsCache;
    @NotNull
    public final StatementFilter statementFilter;
    public final boolean isAnnotationContext;
    public final boolean isDebuggerContext;
    public final boolean collectAllCandidates;
    @NotNull
    public final CallPosition callPosition;
    @NotNull
    public final LanguageVersionSettings languageVersionSettings;
    @NotNull
    public final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    public final InferenceSession inferenceSession;
    @NotNull
    public final Function1<KtExpression, KtExpression> expressionContextProvider;
    public static final Function1<KtExpression, KtExpression> DEFAULT_EXPRESSION_CONTEXT_PROVIDER = expression2 -> null;

    protected ResolutionContext(@NotNull BindingTrace trace, @NotNull LexicalScope scope2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull ContextDependency contextDependency, @NotNull ResolutionResultsCache resolutionResultsCache, @NotNull StatementFilter statementFilter, boolean isAnnotationContext, boolean isDebuggerContext, boolean collectAllCandidates, @NotNull CallPosition callPosition, @NotNull Function1<KtExpression, KtExpression> expressionContextProvider, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory factory2, @NotNull InferenceSession inferenceSession) {
        if (trace == null) {
            ResolutionContext.$$$reportNull$$$0(0);
        }
        if (scope2 == null) {
            ResolutionContext.$$$reportNull$$$0(1);
        }
        if (expectedType == null) {
            ResolutionContext.$$$reportNull$$$0(2);
        }
        if (dataFlowInfo == null) {
            ResolutionContext.$$$reportNull$$$0(3);
        }
        if (contextDependency == null) {
            ResolutionContext.$$$reportNull$$$0(4);
        }
        if (resolutionResultsCache == null) {
            ResolutionContext.$$$reportNull$$$0(5);
        }
        if (statementFilter == null) {
            ResolutionContext.$$$reportNull$$$0(6);
        }
        if (callPosition == null) {
            ResolutionContext.$$$reportNull$$$0(7);
        }
        if (expressionContextProvider == null) {
            ResolutionContext.$$$reportNull$$$0(8);
        }
        if (languageVersionSettings == null) {
            ResolutionContext.$$$reportNull$$$0(9);
        }
        if (factory2 == null) {
            ResolutionContext.$$$reportNull$$$0(10);
        }
        if (inferenceSession == null) {
            ResolutionContext.$$$reportNull$$$0(11);
        }
        this.trace = trace;
        this.scope = scope2;
        this.expectedType = expectedType;
        this.dataFlowInfo = dataFlowInfo;
        this.contextDependency = contextDependency;
        this.resolutionResultsCache = resolutionResultsCache;
        this.statementFilter = statementFilter;
        this.isAnnotationContext = isAnnotationContext;
        this.isDebuggerContext = isDebuggerContext;
        this.collectAllCandidates = collectAllCandidates;
        this.callPosition = callPosition;
        this.expressionContextProvider = expressionContextProvider;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = factory2;
        this.inferenceSession = inferenceSession;
    }

    protected abstract Context create(@NotNull BindingTrace var1, @NotNull LexicalScope var2, @NotNull DataFlowInfo var3, @NotNull KotlinType var4, @NotNull ContextDependency var5, @NotNull ResolutionResultsCache var6, @NotNull StatementFilter var7, boolean var8, @NotNull CallPosition var9, @NotNull Function1<KtExpression, KtExpression> var10, @NotNull LanguageVersionSettings var11, @NotNull DataFlowValueFactory var12, @NotNull InferenceSession var13);

    @NotNull
    private Context self() {
        ResolutionContext resolutionContext = this;
        if (resolutionContext == null) {
            ResolutionContext.$$$reportNull$$$0(12);
        }
        return (Context)resolutionContext;
    }

    @NotNull
    public Context replaceBindingTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            ResolutionContext.$$$reportNull$$$0(13);
        }
        if (this.trace == trace) {
            return this.self();
        }
        Context Context2 = this.create(trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
        if (Context2 == null) {
            ResolutionContext.$$$reportNull$$$0(14);
        }
        return Context2;
    }

    @NotNull
    public Context replaceDataFlowInfo(@NotNull DataFlowInfo newDataFlowInfo) {
        if (newDataFlowInfo == null) {
            ResolutionContext.$$$reportNull$$$0(15);
        }
        if (newDataFlowInfo == this.dataFlowInfo) {
            return this.self();
        }
        Context Context2 = this.create(this.trace, this.scope, newDataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
        if (Context2 == null) {
            ResolutionContext.$$$reportNull$$$0(16);
        }
        return Context2;
    }

    @NotNull
    public Context replaceInferenceSession(@NotNull InferenceSession newInferenceSession) {
        if (newInferenceSession == null) {
            ResolutionContext.$$$reportNull$$$0(17);
        }
        if (newInferenceSession == this.inferenceSession) {
            return this.self();
        }
        Context Context2 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, newInferenceSession);
        if (Context2 == null) {
            ResolutionContext.$$$reportNull$$$0(18);
        }
        return Context2;
    }

    @NotNull
    public Context replaceExpectedType(@Nullable KotlinType newExpectedType) {
        if (newExpectedType == null) {
            Context Context2 = this.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
            if (Context2 == null) {
                ResolutionContext.$$$reportNull$$$0(19);
            }
            return Context2;
        }
        if (this.expectedType == newExpectedType) {
            return this.self();
        }
        Context Context3 = this.create(this.trace, this.scope, this.dataFlowInfo, newExpectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
        if (Context3 == null) {
            ResolutionContext.$$$reportNull$$$0(20);
        }
        return Context3;
    }

    @NotNull
    public Context replaceScope(@NotNull LexicalScope newScope) {
        if (newScope == null) {
            ResolutionContext.$$$reportNull$$$0(21);
        }
        if (newScope == this.scope) {
            return this.self();
        }
        Context Context2 = this.create(this.trace, newScope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
        if (Context2 == null) {
            ResolutionContext.$$$reportNull$$$0(22);
        }
        return Context2;
    }

    @NotNull
    public Context replaceContextDependency(@NotNull ContextDependency newContextDependency) {
        if (newContextDependency == null) {
            ResolutionContext.$$$reportNull$$$0(23);
        }
        if (newContextDependency == this.contextDependency) {
            return this.self();
        }
        Context Context2 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, newContextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
        if (Context2 == null) {
            ResolutionContext.$$$reportNull$$$0(24);
        }
        return Context2;
    }

    @NotNull
    public Context replaceResolutionResultsCache(@NotNull ResolutionResultsCache newResolutionResultsCache) {
        if (newResolutionResultsCache == null) {
            ResolutionContext.$$$reportNull$$$0(25);
        }
        if (newResolutionResultsCache == this.resolutionResultsCache) {
            return this.self();
        }
        Context Context2 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, newResolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
        if (Context2 == null) {
            ResolutionContext.$$$reportNull$$$0(26);
        }
        return Context2;
    }

    @NotNull
    public Context replaceTraceAndCache(@NotNull TemporaryTraceAndCache traceAndCache) {
        if (traceAndCache == null) {
            ResolutionContext.$$$reportNull$$$0(27);
        }
        Context Context2 = ((ResolutionContext)this.replaceBindingTrace(traceAndCache.trace)).replaceResolutionResultsCache(traceAndCache.cache);
        if (Context2 == null) {
            ResolutionContext.$$$reportNull$$$0(28);
        }
        return Context2;
    }

    @NotNull
    public Context replaceCollectAllCandidates(boolean newCollectAllCandidates) {
        Context Context2 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, newCollectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
        if (Context2 == null) {
            ResolutionContext.$$$reportNull$$$0(29);
        }
        return Context2;
    }

    @NotNull
    public Context replaceStatementFilter(@NotNull StatementFilter statementFilter) {
        if (statementFilter == null) {
            ResolutionContext.$$$reportNull$$$0(30);
        }
        Context Context2 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
        if (Context2 == null) {
            ResolutionContext.$$$reportNull$$$0(31);
        }
        return Context2;
    }

    @NotNull
    public Context replaceCallPosition(@NotNull CallPosition callPosition) {
        if (callPosition == null) {
            ResolutionContext.$$$reportNull$$$0(32);
        }
        Context Context2 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, callPosition, this.expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
        if (Context2 == null) {
            ResolutionContext.$$$reportNull$$$0(33);
        }
        return Context2;
    }

    @NotNull
    public Context replaceExpressionContextProvider(@NotNull Function1<KtExpression, KtExpression> expressionContextProvider) {
        if (expressionContextProvider == null) {
            ResolutionContext.$$$reportNull$$$0(34);
        }
        Context Context2 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, expressionContextProvider, this.languageVersionSettings, this.dataFlowValueFactory, this.inferenceSession);
        if (Context2 == null) {
            ResolutionContext.$$$reportNull$$$0(35);
        }
        return Context2;
    }

    @SafeVarargs
    @Nullable
    public final <T extends PsiElement> T getContextParentOfType(@NotNull KtExpression expression2, Class<? extends T> ... classes2) {
        KtExpression context2;
        KtExpression current;
        if (expression2 == null) {
            ResolutionContext.$$$reportNull$$$0(36);
        }
        if (classes2 == null) {
            ResolutionContext.$$$reportNull$$$0(37);
        }
        KtExpression ktExpression = current = (context2 = (KtExpression)this.expressionContextProvider.invoke((Object)expression2)) != null ? context2 : expression2.getParent();
        while (current != null) {
            for (Class<T> clazz : classes2) {
                if (!clazz.isInstance(current)) continue;
                return (T)current;
            }
            if (current instanceof PsiFile) {
                return null;
            }
            if (current instanceof KtExpression && (context2 = (KtExpression)this.expressionContextProvider.invoke((Object)current)) != null) {
                current = context2;
                continue;
            }
            current = current.getParent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 35: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDependency";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolutionResultsCache";
                break;
            }
            case 6: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementFilter";
                break;
            }
            case 7: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callPosition";
                break;
            }
            case 8: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionContextProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferenceSession";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDataFlowInfo";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInferenceSession";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newScope";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContextDependency";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newResolutionResultsCache";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceAndCache";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "self";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceBindingTrace";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceDataFlowInfo";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceInferenceSession";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceExpectedType";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceScope";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceContextDependency";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceResolutionResultsCache";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceTraceAndCache";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceCollectAllCandidates";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceStatementFilter";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceCallPosition";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceExpressionContextProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 35: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceBindingTrace";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceDataFlowInfo";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceInferenceSession";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "replaceScope";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "replaceContextDependency";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "replaceResolutionResultsCache";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "replaceTraceAndCache";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatementFilter";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "replaceCallPosition";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionContextProvider";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getContextParentOfType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 35: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

