/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.stubs.ConstantValueKind;
import org.jetbrains.kotlin.psi.stubs.KotlinConstantExpressionStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType$Companion$WhenMappings;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinConstantExpressionStubImpl;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000 \u00162\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0016B\u000f\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nH\u0016J\u001e\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType;", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinConstantExpressionStub;", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "debugName", "", "(Ljava/lang/String;)V", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "deserialize", "dataStream", "Lcom/intellij/psi/stubs/StubInputStream;", "serialize", "", "stub", "Lcom/intellij/psi/stubs/StubOutputStream;", "shouldCreateStub", "", "node", "Lcom/intellij/lang/ASTNode;", "Companion"})
public final class KtConstantExpressionElementType
extends KtStubElementType<KotlinConstantExpressionStub, KtConstantExpression> {
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean shouldCreateStub(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        ASTNode aSTNode = node.getTreeParent();
        if (aSTNode == null) {
            return false;
        }
        ASTNode parent2 = aSTNode;
        if (Intrinsics.areEqual((Object)parent2.getElementType(), KtStubElementTypes.VALUE_ARGUMENT) ^ true) {
            return false;
        }
        return super.shouldCreateStub(node);
    }

    @NotNull
    public KotlinConstantExpressionStub createStub(@NotNull KtConstantExpression psi, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkParameterIsNotNull((Object)psi, (String)"psi");
        ASTNode aSTNode = psi.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"psi.node");
        IElementType iElementType = aSTNode.getElementType();
        if (!(iElementType instanceof KtConstantExpressionElementType)) {
            iElementType = null;
        }
        KtConstantExpressionElementType ktConstantExpressionElementType = (KtConstantExpressionElementType)iElementType;
        if (ktConstantExpressionElementType == null) {
            throw (Throwable)new IllegalStateException("Stub element type is expected for constant");
        }
        KtConstantExpressionElementType elementType = ktConstantExpressionElementType;
        String string2 = psi.getText();
        if (string2 == null) {
            string2 = "";
        }
        String value2 = string2;
        ConstantValueKind constantValueKind = KtConstantExpressionElementType.Companion.constantElementTypeToKind(elementType);
        StringRef stringRef = StringRef.fromString((String)value2);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringRef, (String)"StringRef.fromString(value)");
        return new KotlinConstantExpressionStubImpl(parentStub, elementType, constantValueKind, stringRef);
    }

    public void serialize(@NotNull KotlinConstantExpressionStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkParameterIsNotNull((Object)stub, (String)"stub");
        Intrinsics.checkParameterIsNotNull((Object)dataStream, (String)"dataStream");
        dataStream.writeInt(stub.kind().ordinal());
        dataStream.writeName(stub.value());
    }

    @NotNull
    public KotlinConstantExpressionStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkParameterIsNotNull((Object)dataStream, (String)"dataStream");
        int kindOrdinal = dataStream.readInt();
        StringRef stringRef = dataStream.readName();
        if (stringRef == null) {
            stringRef = StringRef.fromString((String)"");
        }
        StringRef value2 = stringRef;
        ConstantValueKind valueKind = ConstantValueKind.values()[kindOrdinal];
        KtConstantExpressionElementType ktConstantExpressionElementType = Companion.kindToConstantElementType(valueKind);
        StringRef stringRef2 = value2;
        Intrinsics.checkExpressionValueIsNotNull((Object)stringRef2, (String)"value");
        return new KotlinConstantExpressionStubImpl(parentStub, ktConstantExpressionElementType, valueKind, stringRef2);
    }

    public KtConstantExpressionElementType(@NonNls @NotNull String debugName) {
        Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
        super(debugName, KtConstantExpression.class, KotlinConstantExpressionStub.class);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType$Companion;", "", "()V", "constantElementTypeToKind", "Lorg/jetbrains/kotlin/psi/stubs/ConstantValueKind;", "elementType", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType;", "kindToConstantElementType", "kind", "psi"})
    public static final class Companion {
        @NotNull
        public final KtConstantExpressionElementType kindToConstantElementType(@NotNull ConstantValueKind kind) {
            KtConstantExpressionElementType ktConstantExpressionElementType;
            Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
            switch (KtConstantExpressionElementType$Companion$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    ktConstantExpressionElementType = KtStubElementTypes.NULL;
                    break;
                }
                case 2: {
                    ktConstantExpressionElementType = KtStubElementTypes.BOOLEAN_CONSTANT;
                    break;
                }
                case 3: {
                    ktConstantExpressionElementType = KtStubElementTypes.FLOAT_CONSTANT;
                    break;
                }
                case 4: {
                    ktConstantExpressionElementType = KtStubElementTypes.CHARACTER_CONSTANT;
                    break;
                }
                case 5: {
                    ktConstantExpressionElementType = KtStubElementTypes.INTEGER_CONSTANT;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktConstantExpressionElementType), (String)"when (kind) {\n          \u2026ER_CONSTANT\n            }");
            return ktConstantExpressionElementType;
        }

        private final ConstantValueKind constantElementTypeToKind(KtConstantExpressionElementType elementType) {
            ConstantValueKind constantValueKind;
            KtConstantExpressionElementType ktConstantExpressionElementType = elementType;
            if (Intrinsics.areEqual((Object)((Object)ktConstantExpressionElementType), (Object)((Object)KtStubElementTypes.NULL))) {
                constantValueKind = ConstantValueKind.NULL;
            } else if (Intrinsics.areEqual((Object)((Object)ktConstantExpressionElementType), (Object)((Object)KtStubElementTypes.BOOLEAN_CONSTANT))) {
                constantValueKind = ConstantValueKind.BOOLEAN_CONSTANT;
            } else if (Intrinsics.areEqual((Object)((Object)ktConstantExpressionElementType), (Object)((Object)KtStubElementTypes.INTEGER_CONSTANT))) {
                constantValueKind = ConstantValueKind.INTEGER_CONSTANT;
            } else if (Intrinsics.areEqual((Object)((Object)ktConstantExpressionElementType), (Object)((Object)KtStubElementTypes.FLOAT_CONSTANT))) {
                constantValueKind = ConstantValueKind.FLOAT_CONSTANT;
            } else if (Intrinsics.areEqual((Object)((Object)ktConstantExpressionElementType), (Object)((Object)KtStubElementTypes.CHARACTER_CONSTANT))) {
                constantValueKind = ConstantValueKind.CHARACTER_CONSTANT;
            } else {
                throw (Throwable)new IllegalStateException("Unknown constant node type: " + (Object)((Object)elementType));
            }
            return constantValueKind;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

