/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/BuiltInsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "irBuiltins", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "backend.wasm"})
public final class BuiltInsLowering
implements FileLoweringPass {
    private final IrBuiltIns irBuiltins;
    private final WasmSymbols symbols;
    @NotNull
    private final WasmBackendContext context;

    @NotNull
    public final IrExpression transformCall(@NotNull IrCall call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        IrFunctionSymbol symbol2 = call2.getSymbol();
        if (Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getEqeqSymbol()) || Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getEqeqeqSymbol()) || CollectionsKt.contains((Iterable)this.irBuiltins.getIeee754equalsFunByOperandType().values(), (Object)symbol2)) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrType type2 = irExpression.getType();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.symbols.getEqualityFunctions().get(type2);
            if (irSimpleFunctionSymbol == null) {
                String string2 = "Unsupported equality operator with type: " + RenderIrElementKt.render(type2);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            IrSimpleFunctionSymbol newSymbol = irSimpleFunctionSymbol;
            return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, newSymbol, false, false, null, 28, null);
        }
        if (CollectionsKt.contains((Iterable)this.symbols.getIrBuiltInsToWasmIntrinsics().keySet(), (Object)symbol2)) {
            Map<IrSimpleFunctionSymbol, IrSimpleFunctionSymbol> map2 = this.symbols.getIrBuiltInsToWasmIntrinsics();
            boolean bl = false;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = map2.get(symbol2);
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            IrSimpleFunctionSymbol newSymbol = irSimpleFunctionSymbol;
            return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, newSymbol, false, false, null, 28, null);
        }
        return call2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this){
            final /* synthetic */ BuiltInsLowering this$0;

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression newExpression = this.this$0.transformCall(expression2);
                IrElementTransformerVoidKt.transformChildrenVoid(newExpression, this);
                return newExpression;
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    public BuiltInsLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.irBuiltins = this.context.getIrBuiltIns();
        this.symbols = this.context.getWasmSymbols();
    }
}

