/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DataClassMethodGenerator;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBodyCodegen;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CollectionStubMethodGenerator;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.ConstructorCodegen;
import org.jetbrains.kotlin.codegen.DelegationFieldsInfo;
import org.jetbrains.kotlin.codegen.ErasedInlineClassBodyCodegen;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.FunctionsFromAnyGeneratorImpl;
import org.jetbrains.kotlin.codegen.InterfaceImplBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.SuperClassInfo;
import org.jetbrains.kotlin.codegen.WriteAnnotationUtilKt;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializerExtension;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DelegationResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmClassSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class ImplementationBodyCodegen
extends ClassBodyCodegen {
    public static final String ENUM_VALUES_FIELD_NAME = "$VALUES";
    private Type superClassAsmType;
    @NotNull
    private SuperClassInfo superClassInfo;
    private final Type classAsmType;
    private final boolean isLocal;
    private List<PropertyAndDefaultValue> companionObjectPropertiesToCopy;
    private final DelegationFieldsInfo delegationFieldsInfo;
    private final List<Function2<ImplementationBodyCodegen, ClassBuilder, Unit>> additionalTasks;
    private final DescriptorSerializer serializer;
    private final ConstructorCodegen constructorCodegen;
    private static final Map<FqName, String> KOTLIN_MARKER_INTERFACES = new HashMap<FqName, String>();

    public ImplementationBodyCodegen(@NotNull KtPureClassOrObject aClass2, @NotNull ClassContext context2, @NotNull ClassBuilder v, @NotNull GenerationState state2, @Nullable MemberCodegen<?> parentCodegen, boolean isLocal) {
        if (aClass2 == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(1);
        }
        if (v == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(2);
        }
        if (state2 == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(3);
        }
        super(aClass2, context2, v, state2, parentCodegen);
        this.additionalTasks = new ArrayList<Function2<ImplementationBodyCodegen, ClassBuilder, Unit>>();
        this.classAsmType = Type.getObjectType((String)this.typeMapper.classInternalName(this.descriptor));
        this.isLocal = isLocal;
        this.delegationFieldsInfo = new DelegationFieldsInfo(this.classAsmType, this.descriptor, state2, this.bindingContext).getDelegationFieldsInfo(this.myClass.getSuperTypeListEntries());
        JvmSerializerExtension extension = new JvmSerializerExtension(v.getSerializationBindings(), state2);
        this.serializer = DescriptorSerializer.create(this.descriptor, extension, parentCodegen instanceof ImplementationBodyCodegen ? ((ImplementationBodyCodegen)parentCodegen).serializer : DescriptorSerializer.createTopLevel(extension));
        this.constructorCodegen = new ConstructorCodegen(this.descriptor, context2, this.functionCodegen, this, this, state2, this.kind, v, this.classAsmType, this.myClass, this.bindingContext);
    }

    @Override
    protected void generateDeclaration() {
        this.superClassInfo = SuperClassInfo.getSuperClassInfo(this.descriptor, this.typeMapper);
        this.superClassAsmType = this.superClassInfo.getType();
        JvmClassSignature signature2 = this.signature();
        boolean isAbstract = false;
        boolean isInterface = false;
        boolean isFinal = false;
        boolean isAnnotation = false;
        boolean isEnum = false;
        ClassKind kind = this.descriptor.getKind();
        Modality modality = this.descriptor.getModality();
        if (modality == Modality.ABSTRACT || modality == Modality.SEALED) {
            isAbstract = true;
        }
        if (kind == ClassKind.INTERFACE) {
            isAbstract = true;
            isInterface = true;
        } else if (kind == ClassKind.ANNOTATION_CLASS) {
            isAbstract = true;
            isInterface = true;
            isAnnotation = true;
        } else if (kind == ClassKind.ENUM_CLASS) {
            isAbstract = DescriptorUtils.hasAbstractMembers(this.descriptor);
            isEnum = true;
        }
        if (modality != Modality.OPEN && !isAbstract) {
            isFinal = kind == ClassKind.OBJECT || kind != ClassKind.ENUM_CLASS || this.state.getClassBuilderMode().generateBodies;
        }
        int access = 0;
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES && !DescriptorUtils.isTopLevelDeclaration(this.descriptor)) {
            access |= AsmUtil.getVisibilityAccessFlag(this.descriptor);
            if (!this.descriptor.isInner()) {
                access |= 8;
            }
        } else {
            access |= AsmUtil.getVisibilityAccessFlagForClass(this.descriptor);
        }
        if (isAbstract) {
            access |= 0x400;
        }
        access = isInterface ? (access |= 0x200) : (access |= 0x20);
        if (isFinal) {
            access |= 0x10;
        }
        if (isAnnotation) {
            access |= 0x2000;
        }
        if (KotlinBuiltIns.isDeprecated(this.descriptor)) {
            access |= 0x20000;
        }
        if (isEnum) {
            for (KtDeclaration declaration2 : this.myClass.getDeclarations()) {
                if (!(declaration2 instanceof KtEnumEntry) || !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, (KtEnumEntry)declaration2)) continue;
                access &= 0xFFFFFFEF;
            }
            access |= 0x4000;
        }
        this.v.defineClass((PsiElement)this.myClass.getPsiOrParent(), this.state.getClassFileVersion(), access, signature2.getName(), signature2.getJavaGenericSignature(), signature2.getSuperclassName(), ArrayUtil.toStringArray(signature2.getInterfaces()));
        this.v.visitSource(this.myClass.getContainingKtFile().getName(), null);
        this.initDefaultSourceMappingIfNeeded();
        this.writeEnclosingMethod();
        AnnotationCodegen.forClass(this.v.getVisitor(), this, this.state).genAnnotations(this.descriptor, null, null);
        this.generateEnumEntries();
    }

    @Override
    protected void generateDefaultImplsIfNeeded() {
        if (DescriptorUtils.isInterface(this.descriptor) && !this.isLocal) {
            Type defaultImplsType = this.state.getTypeMapper().mapDefaultImpls(this.descriptor);
            ClassBuilder defaultImplsBuilder = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.DefaultImpls((PsiElement)this.myClass.getPsiOrParent(), this.descriptor), defaultImplsType, (PsiFile)this.myClass.getContainingKtFile());
            CodegenContext parentContext = this.context.getParentContext();
            assert (parentContext != null) : "Parent context of interface declaration should not be null";
            ClassContext defaultImplsContext = parentContext.intoDefaultImplsClass(this.descriptor, (ClassContext)this.context, this.state);
            new InterfaceImplBodyCodegen(this.myClass, defaultImplsContext, defaultImplsBuilder, this.state, this).generate();
        }
    }

    @Override
    protected void generateErasedInlineClassIfNeeded() {
        if (!(this.myClass instanceof KtClass)) {
            return;
        }
        if (!this.descriptor.isInline()) {
            return;
        }
        ClassContext erasedInlineClassContext = this.context.intoWrapperForErasedInlineClass(this.descriptor, this.state);
        new ErasedInlineClassBodyCodegen((KtClass)this.myClass, erasedInlineClassContext, this.v, this.state, this).generate();
    }

    @Override
    protected void generateUnboxMethodForInlineClass() {
        if (!(this.myClass instanceof KtClass)) {
            return;
        }
        if (!this.descriptor.isInline()) {
            return;
        }
        final Type ownerType = this.typeMapper.mapClass(this.descriptor);
        final ValueParameterDescriptor inlinedValue = InlineClassesUtilsKt.underlyingRepresentation(this.descriptor);
        if (inlinedValue == null) {
            return;
        }
        final Type valueType = this.typeMapper.mapType(inlinedValue.getType());
        SimpleFunctionDescriptor functionDescriptor = InlineClassDescriptorResolver.createUnboxFunctionDescriptor(this.descriptor);
        assert (functionDescriptor != null) : "FunctionDescriptor for unbox method should be not null during codegen";
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.UnboxMethodOfInlineClass(functionDescriptor), functionDescriptor, new FunctionGenerationStrategy.CodegenBased(this.state){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen2, @NotNull JvmMethodSignature signature2) {
                if (codegen2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (signature2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                InstructionAdapter iv = codegen2.v;
                iv.load(0, AsmTypes.OBJECT_TYPE);
                iv.getfield(ownerType.getInternalName(), inlinedValue.getName().asString(), valueType.getDescriptor());
                iv.areturn(valueType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "codegen";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "signature";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$1";
                objectArray[2] = "doGenerateBody";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    protected void generateKotlinMetadataAnnotation() {
        ProtoBuf.Class classProto = this.serializer.classProto(this.descriptor).build();
        WriteAnnotationUtilKt.writeKotlinMetadata(this.v, this.state, KotlinClassHeader.Kind.CLASS, 0, (Function1<? super AnnotationVisitor, Unit>)((Function1)av -> {
            AsmUtil.writeAnnotationData(av, this.serializer, classProto);
            return Unit.INSTANCE;
        }));
    }

    private void writeEnclosingMethod() {
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        if (DescriptorUtils.isAnonymousObject(this.descriptor) || !(this.descriptor.getContainingDeclaration() instanceof ClassOrPackageFragmentDescriptor)) {
            this.writeOuterClassAndEnclosingMethod();
        }
    }

    @NotNull
    private JvmClassSignature signature() {
        return ImplementationBodyCodegen.signature(this.descriptor, this.classAsmType, this.superClassInfo, this.typeMapper);
    }

    @NotNull
    public static JvmClassSignature signature(@NotNull ClassDescriptor descriptor2, @NotNull Type classAsmType, @NotNull SuperClassInfo superClassInfo, @NotNull KotlinTypeMapper typeMapper) {
        if (descriptor2 == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(4);
        }
        if (classAsmType == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(5);
        }
        if (superClassInfo == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(6);
        }
        if (typeMapper == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(7);
        }
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.CLASS);
        typeMapper.writeFormalTypeParameters(descriptor2.getDeclaredTypeParameters(), sw);
        ((JvmSignatureWriter)sw).writeSuperclass();
        if (superClassInfo.getKotlinType() == null) {
            ((JvmSignatureWriter)sw).writeClassBegin(superClassInfo.getType());
            ((JvmSignatureWriter)sw).writeClassEnd();
        } else {
            typeMapper.mapSupertype(superClassInfo.getKotlinType(), sw);
        }
        ((JvmSignatureWriter)sw).writeSuperclassEnd();
        LinkedHashSet<String> superInterfaces = new LinkedHashSet<String>();
        LinkedHashSet<String> kotlinMarkerInterfaces = new LinkedHashSet<String>();
        for (KotlinType supertype2 : descriptor2.getTypeConstructor().getSupertypes()) {
            if (!JvmCodegenUtil.isJvmInterface(supertype2.getConstructor().getDeclarationDescriptor())) continue;
            FqName kotlinInterfaceName = DescriptorUtils.getFqName(supertype2.getConstructor().getDeclarationDescriptor()).toSafe();
            ((JvmSignatureWriter)sw).writeInterface();
            Type jvmInterfaceType = typeMapper.mapSupertype(supertype2, sw);
            ((JvmSignatureWriter)sw).writeInterfaceEnd();
            String jvmInterfaceInternalName = jvmInterfaceType.getInternalName();
            superInterfaces.add(jvmInterfaceInternalName);
            String kotlinMarkerInterfaceInternalName = KOTLIN_MARKER_INTERFACES.get(kotlinInterfaceName);
            if (kotlinMarkerInterfaceInternalName == null) continue;
            if (typeMapper.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
                ((JvmSignatureWriter)sw).writeInterface();
                Type kotlinCollectionType = typeMapper.mapType(supertype2, sw, TypeMappingMode.SUPER_TYPE_KOTLIN_COLLECTIONS_AS_IS);
                ((JvmSignatureWriter)sw).writeInterfaceEnd();
                superInterfaces.add(kotlinCollectionType.getInternalName());
            }
            kotlinMarkerInterfaces.add(kotlinMarkerInterfaceInternalName);
        }
        for (String kotlinMarkerInterface : kotlinMarkerInterfaces) {
            ((JvmSignatureWriter)sw).writeInterface();
            ((JvmSignatureWriter)sw).writeAsmType(Type.getObjectType((String)kotlinMarkerInterface));
            ((JvmSignatureWriter)sw).writeInterfaceEnd();
        }
        superInterfaces.addAll(kotlinMarkerInterfaces);
        return new JvmClassSignature(classAsmType.getInternalName(), superClassInfo.getType().getInternalName(), new ArrayList<String>(superInterfaces), ((JvmSignatureWriter)sw).makeJavaGenericSignature());
    }

    @Override
    protected void generateSyntheticPartsBeforeBody() {
        this.generatePropertyMetadataArrayFieldIfNeeded(this.classAsmType);
    }

    @Override
    protected void generateSyntheticPartsAfterBody() {
        this.generateFieldForSingleton();
        this.initializeObjects();
        this.generateCompanionObjectBackingFieldCopies();
        this.generateDelegatesToDefaultImpl();
        this.generateDelegates(this.delegationFieldsInfo);
        this.generateSyntheticAccessors();
        this.generateEnumMethods();
        this.generateFunctionsForDataClasses();
        this.generateFunctionsFromAnyForInlineClasses();
        if (this.state.getClassBuilderMode() != ClassBuilderMode.LIGHT_CLASSES) {
            new CollectionStubMethodGenerator(this.typeMapper, this.descriptor).generate(this.functionCodegen, this.v);
            this.generateToArray();
        }
        if (this.context.closure != null) {
            AsmUtil.genClosureFields(this.context.closure, this.v, this.typeMapper, this.state.getLanguageVersionSettings());
        }
        for (ExpressionCodegenExtension extension : ExpressionCodegenExtension.Companion.getInstances(this.state.getProject())) {
            if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES && !extension.getShouldGenerateClassSyntheticPartsInLightClassesMode()) continue;
            extension.generateClassSyntheticParts(this);
        }
    }

    @Override
    protected void generateConstructors() {
        try {
            this.lookupConstructorExpressionsInClosureIfPresent();
            this.constructorCodegen.generatePrimaryConstructor(this.delegationFieldsInfo, this.superClassAsmType);
            if (!this.descriptor.isInline() && !(this.descriptor instanceof SyntheticClassOrObjectDescriptor)) {
                for (ClassConstructorDescriptor secondaryConstructor : DescriptorUtilsKt.getSecondaryConstructors(this.descriptor)) {
                    this.constructorCodegen.generateSecondaryConstructor(secondaryConstructor, this.superClassAsmType);
                }
            }
        }
        catch (ProcessCanceledException | CompilationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error generating constructors of class " + this.myClass.getName() + " with kind " + (Object)((Object)this.kind), e);
        }
    }

    private void generateToArray() {
        MethodVisitor mv;
        if (this.descriptor.getKind() == ClassKind.INTERFACE) {
            return;
        }
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(this.descriptor);
        if (!DescriptorUtils.isSubclass(this.descriptor, builtIns.getCollection())) {
            return;
        }
        if (CollectionsKt.any(DescriptorUtilsKt.getAllSuperclassesWithoutAny(this.descriptor), classDescriptor2 -> !(classDescriptor2 instanceof JavaClassDescriptor) && DescriptorUtils.isSubclass(classDescriptor2, builtIns.getCollection()))) {
            return;
        }
        Collection<? extends SimpleFunctionDescriptor> functions2 = this.descriptor.getDefaultType().getMemberScope().getContributedFunctions(Name.identifier("toArray"), NoLookupLocation.FROM_BACKEND);
        boolean hasGenericToArray = false;
        boolean hasNonGenericToArray = false;
        for (FunctionDescriptor functionDescriptor : functions2) {
            hasGenericToArray |= CodegenUtilKt.isGenericToArray(functionDescriptor);
            hasNonGenericToArray |= CodegenUtilKt.isNonGenericToArray(functionDescriptor);
        }
        if (!hasNonGenericToArray) {
            mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, 1, "toArray", "()[Ljava/lang/Object;", null, null);
            InstructionAdapter instructionAdapter = new InstructionAdapter(mv);
            mv.visitCode();
            instructionAdapter.load(0, this.classAsmType);
            instructionAdapter.invokestatic("kotlin/jvm/internal/CollectionToArray", "toArray", "(Ljava/util/Collection;)[Ljava/lang/Object;", false);
            instructionAdapter.areturn(Type.getType((String)"[Ljava/lang/Object;"));
            FunctionCodegen.endVisit(mv, "toArray", this.myClass);
        }
        if (!hasGenericToArray) {
            mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, 1, "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;", "<T:Ljava/lang/Object;>([TT;)[TT;", null);
            InstructionAdapter instructionAdapter = new InstructionAdapter(mv);
            mv.visitCode();
            instructionAdapter.load(0, this.classAsmType);
            instructionAdapter.load(1, Type.getType((String)"[Ljava/lang/Object;"));
            instructionAdapter.invokestatic("kotlin/jvm/internal/CollectionToArray", "toArray", "(Ljava/util/Collection;[Ljava/lang/Object;)[Ljava/lang/Object;", false);
            instructionAdapter.areturn(Type.getType((String)"[Ljava/lang/Object;"));
            FunctionCodegen.endVisit(mv, "toArray", this.myClass);
        }
    }

    public static JvmKotlinType genPropertyOnStack(InstructionAdapter iv, MethodContext context2, @NotNull PropertyDescriptor propertyDescriptor, Type classAsmType, int index2, GenerationState state2) {
        if (propertyDescriptor == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(8);
        }
        iv.load(index2, classAsmType);
        if (JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, true, false, context2, state2.getShouldInlineConstVals())) {
            KotlinType kotlinType = propertyDescriptor.getType();
            Type type2 = state2.getTypeMapper().mapType(kotlinType);
            String fieldName = ((FieldOwnerContext)context2.getParentContext()).getFieldName(propertyDescriptor, false);
            iv.getfield(classAsmType.getInternalName(), fieldName, type2.getDescriptor());
            return new JvmKotlinType(type2, kotlinType);
        }
        PropertyGetterDescriptor getter2 = propertyDescriptor.getGetter();
        Method method = state2.getTypeMapper().mapAsmMethod(getter2);
        iv.invokevirtual(classAsmType.getInternalName(), method.getName(), method.getDescriptor(), false);
        return new JvmKotlinType(method.getReturnType(), getter2.getReturnType());
    }

    private void generateFunctionsForDataClasses() {
        if (!this.descriptor.isData()) {
            return;
        }
        if (!(this.myClass instanceof KtClassOrObject)) {
            return;
        }
        new DataClassMethodGeneratorImpl((KtClassOrObject)this.myClass, this.bindingContext).generate();
    }

    private void generateFunctionsFromAnyForInlineClasses() {
        if (!this.descriptor.isInline()) {
            return;
        }
        if (!(this.myClass instanceof KtClassOrObject)) {
            return;
        }
        new FunctionsFromAnyGeneratorImpl((KtClassOrObject)this.myClass, this.bindingContext, this.descriptor, this.classAsmType, this.context, this.v, this.state).generate();
    }

    @NotNull
    private static ConstructorDescriptor getPrimaryConstructorOfDataClass(@NotNull ClassDescriptor classDescriptor2) {
        if (classDescriptor2 == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(9);
        }
        ClassConstructorDescriptor constructor = classDescriptor2.getUnsubstitutedPrimaryConstructor();
        assert (constructor != null) : "Data class must have primary constructor: " + classDescriptor2;
        ClassConstructorDescriptor classConstructorDescriptor = constructor;
        if (classConstructorDescriptor == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(10);
        }
        return classConstructorDescriptor;
    }

    private void generateEnumMethods() {
        if (DescriptorUtils.isEnumClass(this.descriptor)) {
            this.generateEnumValuesMethod();
            this.generateEnumValueOfMethod();
        }
    }

    private void generateEnumValuesMethod() {
        Type type2 = this.typeMapper.mapType(DescriptorUtilsKt.getBuiltIns(this.descriptor).getArrayType(Variance.INVARIANT, this.descriptor.getDefaultType()));
        FunctionDescriptor valuesFunction = (FunctionDescriptor)CollectionsKt.single(this.descriptor.getStaticScope().getContributedFunctions(DescriptorUtils.ENUM_VALUES, NoLookupLocation.FROM_BACKEND));
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOriginFromPure(this.myClass, valuesFunction), 9, DescriptorUtils.ENUM_VALUES.asString(), "()" + type2.getDescriptor(), null, null);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        mv.visitCode();
        mv.visitFieldInsn(178, this.classAsmType.getInternalName(), ENUM_VALUES_FIELD_NAME, type2.getDescriptor());
        mv.visitMethodInsn(182, type2.getInternalName(), "clone", "()Ljava/lang/Object;", false);
        mv.visitTypeInsn(192, type2.getInternalName());
        mv.visitInsn(176);
        FunctionCodegen.endVisit(mv, "values()", this.myClass);
    }

    private void generateEnumValueOfMethod() {
        FunctionDescriptor valueOfFunction = (FunctionDescriptor)CollectionsKt.single(this.descriptor.getStaticScope().getContributedFunctions(DescriptorUtils.ENUM_VALUE_OF, NoLookupLocation.FROM_BACKEND), DescriptorUtilsKt::isEnumValueOfMethod);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOriginFromPure(this.myClass, valueOfFunction), 9, DescriptorUtils.ENUM_VALUE_OF.asString(), "(Ljava/lang/String;)" + this.classAsmType.getDescriptor(), null, null);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        mv.visitCode();
        mv.visitLdcInsn((Object)this.classAsmType);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;", false);
        mv.visitTypeInsn(192, this.classAsmType.getInternalName());
        mv.visitInsn(176);
        FunctionCodegen.endVisit(mv, "valueOf()", this.myClass);
    }

    private void generateFieldForSingleton() {
        StackValue.Field field;
        if (JvmCodegenUtil.isCompanionObjectInInterfaceNotIntrinsic(this.descriptor)) {
            field = StackValue.createSingletonViaInstance(this.descriptor, this.typeMapper, "$$INSTANCE");
            this.v.newField(JvmDeclarationOriginKt.OtherOrigin(this.descriptor), 4120, field.name, field.type.getDescriptor(), null, null);
        }
        if (DescriptorUtils.isEnumEntry(this.descriptor) || DescriptorUtils.isCompanionObject(this.descriptor)) {
            return;
        }
        if (DescriptorUtils.isNonCompanionObject(this.descriptor)) {
            field = StackValue.createSingletonViaInstance(this.descriptor, this.typeMapper, "INSTANCE");
            this.v.newField(JvmDeclarationOriginKt.OtherOriginFromPure(this.myClass), 25, field.name, field.type.getDescriptor(), null, null);
            return;
        }
        ClassDescriptor companionObjectDescriptor2 = this.descriptor.getCompanionObjectDescriptor();
        if (companionObjectDescriptor2 == null) {
            return;
        }
        KtObjectDeclaration companionObject = (KtObjectDeclaration)CollectionsKt.firstOrNull(this.myClass.getCompanionObjects());
        int properFieldVisibilityFlag = AsmUtil.getVisibilityAccessFlag(companionObjectDescriptor2);
        boolean deprecatedFieldForInvisibleCompanionObject = this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.DeprecatedFieldForInvisibleCompanionObject);
        boolean properVisibilityForCompanionObjectInstanceField = this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperVisibilityForCompanionObjectInstanceField);
        boolean hasPrivateOrProtectedProperVisibility = (properFieldVisibilityFlag & 6) != 0;
        boolean hasPackagePrivateProperVisibility = (properFieldVisibilityFlag & 7) == 0;
        boolean fieldShouldBeDeprecated = deprecatedFieldForInvisibleCompanionObject && !properVisibilityForCompanionObjectInstanceField && (hasPrivateOrProtectedProperVisibility || hasPackagePrivateProperVisibility || JvmCodegenUtil.isNonIntrinsicPrivateCompanionObjectInInterface(companionObjectDescriptor2));
        boolean fieldIsForcedToBePublic = JvmCodegenUtil.isJvmInterface(this.descriptor) || !properVisibilityForCompanionObjectInstanceField;
        int fieldAccessFlags = 24;
        fieldAccessFlags = fieldIsForcedToBePublic ? (fieldAccessFlags |= 1) : (fieldAccessFlags |= properFieldVisibilityFlag);
        if (fieldShouldBeDeprecated) {
            fieldAccessFlags |= 0x20000;
        }
        if (properVisibilityForCompanionObjectInstanceField && JvmCodegenUtil.isCompanionObjectInInterfaceNotIntrinsic(companionObjectDescriptor2) && Visibilities.isPrivate(companionObjectDescriptor2.getVisibility())) {
            fieldAccessFlags |= 0x1000;
        }
        StackValue.Field field2 = StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
        FieldVisitor fv = this.v.newField(JvmDeclarationOriginKt.OtherOrigin((PsiElement)(companionObject == null ? this.myClass.getPsiOrParent() : companionObject)), fieldAccessFlags, field2.name, field2.type.getDescriptor(), null, null);
        if (fieldShouldBeDeprecated) {
            AnnotationCodegen.forField(fv, this, this.state).visitAnnotation("Ljava/lang/Deprecated;", true).visitEnd();
        }
    }

    private void initializeObjects() {
        if (!DescriptorUtils.isObject(this.descriptor)) {
            return;
        }
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        boolean isNonCompanionObject = DescriptorUtils.isNonCompanionObject(this.descriptor);
        boolean isInterfaceCompanion = JvmCodegenUtil.isCompanionObjectInInterfaceNotIntrinsic(this.descriptor);
        boolean isInterfaceCompanionWithBackingFieldsInOuter = ImplementationBodyCodegen.isInterfaceCompanionWithBackingFieldsInOuter(this.descriptor);
        boolean isMappedIntrinsicCompanionObject = JvmAbi.isMappedIntrinsicCompanionObject(this.descriptor);
        boolean isClassCompanionWithBackingFieldsInOuter = JvmAbi.isClassCompanionObjectWithBackingFieldsInOuter(this.descriptor);
        if (isNonCompanionObject || isInterfaceCompanion && !isInterfaceCompanionWithBackingFieldsInOuter || isMappedIntrinsicCompanionObject) {
            ExpressionCodegen clInitCodegen = this.createOrGetClInitCodegen();
            InstructionAdapter v = clInitCodegen.v;
            ImplementationBodyCodegen.markLineNumberForElement((PsiElement)((KtPureClassOrObject)this.element).getPsiOrParent(), v);
            v.anew(this.classAsmType);
            v.dup();
            v.invokespecial(this.classAsmType.getInternalName(), "<init>", "()V", false);
            int local0Index = clInitCodegen.getFrameMap().enterTemp(this.classAsmType);
            assert (local0Index == 0) : "Local variable with index 0 in clInit should be used only for singleton instance keeping";
            StackValue.Local local0 = StackValue.local(0, this.classAsmType);
            local0.store(StackValue.onStack(this.classAsmType), clInitCodegen.v);
            StackValue.Field singleton = StackValue.createSingletonViaInstance(this.descriptor, this.typeMapper, isInterfaceCompanion ? "$$INSTANCE" : "INSTANCE");
            singleton.store(local0, clInitCodegen.v);
            this.generateInitializers(clInitCodegen);
            if (isInterfaceCompanion) {
                StackValue.singleton(this.descriptor, this.typeMapper).store(singleton, this.getParentCodegen().createOrGetClInitCodegen().v, true);
            }
        } else if (isClassCompanionWithBackingFieldsInOuter || isInterfaceCompanionWithBackingFieldsInOuter) {
            ImplementationBodyCodegen parentCodegen = (ImplementationBodyCodegen)this.getParentCodegen();
            ExpressionCodegen parentClInitCodegen = parentCodegen.createOrGetClInitCodegen();
            InstructionAdapter parentVisitor = parentClInitCodegen.v;
            FunctionDescriptor constructor = (FunctionDescriptor)parentCodegen.context.accessibleDescriptor((CallableMemberDescriptor)CollectionsKt.single(this.descriptor.getConstructors()), null);
            parentCodegen.generateMethodCallTo(constructor, null, parentVisitor);
            StackValue instance = StackValue.onStack(parentCodegen.typeMapper.mapClass(this.descriptor));
            StackValue.singleton(this.descriptor, parentCodegen.typeMapper).store(instance, parentVisitor, true);
            this.generateInitializers(parentClInitCodegen);
        } else assert (false) : "Unknown object type: " + this.descriptor;
    }

    private static boolean isInterfaceCompanionWithBackingFieldsInOuter(@NotNull DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(11);
        }
        DeclarationDescriptor interfaceClass = declarationDescriptor.getContainingDeclaration();
        if (!DescriptorUtils.isCompanionObject(declarationDescriptor) || !JvmCodegenUtil.isJvmInterface(interfaceClass)) {
            return false;
        }
        Collection<DeclarationDescriptor> descriptors = ((ClassDescriptor)declarationDescriptor).getUnsubstitutedMemberScope().getContributedDescriptors(DescriptorKindFilter.ALL, MemberScope.Companion.getALL_NAME_FILTER());
        return CollectionsKt.any(descriptors, d -> d instanceof PropertyDescriptor && JvmAbi.hasJvmFieldAnnotation((PropertyDescriptor)d));
    }

    private void generateCompanionObjectBackingFieldCopies() {
        if (this.companionObjectPropertiesToCopy == null) {
            return;
        }
        for (PropertyAndDefaultValue info : this.companionObjectPropertiesToCopy) {
            PropertyDescriptor property2 = info.descriptor;
            Type type2 = this.typeMapper.mapType(property2);
            int modifiers2 = 25;
            FieldVisitor fv = this.v.newField(JvmDeclarationOriginKt.Synthetic(DescriptorToSourceUtils.descriptorToDeclaration(property2), property2), modifiers2, this.context.getFieldName(property2, false), type2.getDescriptor(), this.typeMapper.mapFieldSignature(property2.getType(), property2), info.defaultValue);
            AnnotationCodegen.forField(fv, this, this.state).genAnnotations(property2, type2, null);
            if (!this.state.getClassBuilderMode().generateBodies || info.defaultValue != null) continue;
            ExpressionCodegen codegen2 = this.createOrGetClInitCodegen();
            int companionObjectIndex = this.putCompanionObjectInLocalVar(codegen2);
            StackValue.local(companionObjectIndex, AsmTypes.OBJECT_TYPE).put(codegen2.v);
            this.copyFieldFromCompanionObject(property2);
        }
    }

    private int putCompanionObjectInLocalVar(ExpressionCodegen codegen2) {
        FrameMap frameMap = codegen2.myFrameMap;
        ClassDescriptor companionObjectDescriptor2 = this.descriptor.getCompanionObjectDescriptor();
        int companionObjectIndex = frameMap.getIndex(companionObjectDescriptor2);
        if (companionObjectIndex == -1) {
            companionObjectIndex = frameMap.enter(companionObjectDescriptor2, AsmTypes.OBJECT_TYPE);
            StackValue.Field companionObject = StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
            StackValue.local(companionObjectIndex, companionObject.type).store(companionObject, codegen2.v);
        }
        return companionObjectIndex;
    }

    private void copyFieldFromCompanionObject(PropertyDescriptor propertyDescriptor) {
        ExpressionCodegen codegen2 = this.createOrGetClInitCodegen();
        StackValue.Property property2 = codegen2.intermediateValueForProperty(propertyDescriptor, false, null, StackValue.none());
        StackValue.Field field = StackValue.field(property2.type, property2.kotlinType, this.classAsmType, propertyDescriptor.getName().asString(), true, StackValue.none(), propertyDescriptor);
        field.store(property2, codegen2.v);
    }

    public void generateInitializers(@NotNull ExpressionCodegen codegen2) {
        if (codegen2 == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(12);
        }
        this.generateInitializers((Function0<ExpressionCodegen>)((Function0)() -> codegen2));
    }

    private void lookupConstructorExpressionsInClosureIfPresent() {
        if (!this.state.getClassBuilderMode().generateBodies || this.descriptor.getConstructors().isEmpty()) {
            return;
        }
        KtVisitorVoid visitor2 = new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                e.acceptChildren(this);
            }

            @Override
            public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expr) {
                DeclarationDescriptor descriptor2;
                if (expr == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (ExpressionTypingUtils.isLocalFunction(descriptor2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.REFERENCE_TARGET, expr))) {
                    this.lookupInContext(descriptor2);
                } else if (descriptor2 instanceof CallableMemberDescriptor) {
                    ResolvedCall<? extends CallableDescriptor> call2 = CallUtilKt.getResolvedCall(expr, ImplementationBodyCodegen.this.bindingContext);
                    if (call2 != null) {
                        this.lookupReceivers(call2);
                    }
                    if (call2 instanceof VariableAsFunctionResolvedCall) {
                        this.lookupReceivers(((VariableAsFunctionResolvedCall)((Object)call2)).getVariableCall());
                    }
                } else if (descriptor2 instanceof VariableDescriptor) {
                    ClassDescriptor classDescriptor2;
                    DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
                    if (containingDeclaration instanceof ConstructorDescriptor && (classDescriptor2 = ((ConstructorDescriptor)containingDeclaration).getConstructedClass()) == ImplementationBodyCodegen.this.descriptor) {
                        return;
                    }
                    if (this.lookupInContext(descriptor2) && JvmCodegenUtil.isDelegatedLocalVariable(descriptor2)) {
                        VariableDescriptor metadata = CodegenBinding.getDelegatedLocalVariableMetadata((VariableDescriptor)descriptor2, ImplementationBodyCodegen.this.bindingContext);
                        this.lookupInContext(metadata);
                    }
                }
            }

            private void lookupReceivers(@NotNull ResolvedCall<? extends CallableDescriptor> call2) {
                if (call2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                this.lookupReceiver(call2.getDispatchReceiver());
                this.lookupReceiver(call2.getExtensionReceiver());
            }

            private void lookupReceiver(@Nullable ReceiverValue value2) {
                if (value2 instanceof ImplicitReceiver) {
                    if (value2 instanceof ExtensionReceiver) {
                        ReceiverParameterDescriptor parameter = ((ExtensionReceiver)value2).getDeclarationDescriptor().getExtensionReceiverParameter();
                        assert (parameter != null) : "Extension receiver should exist: " + ((ExtensionReceiver)value2).getDeclarationDescriptor();
                        this.lookupInContext(parameter);
                    } else {
                        this.lookupInContext(((ImplicitReceiver)value2).getDeclarationDescriptor());
                    }
                }
            }

            private boolean lookupInContext(@NotNull DeclarationDescriptor toLookup) {
                if (toLookup == null) {
                    2.$$$reportNull$$$0(3);
                }
                return ImplementationBodyCodegen.this.context.lookupInContext(toLookup, StackValue.LOCAL_0, ImplementationBodyCodegen.this.state, true) != null;
            }

            @Override
            public void visitThisExpression(@NotNull KtThisExpression expression2) {
                ReceiverParameterDescriptor parameter;
                if (expression2 == null) {
                    2.$$$reportNull$$$0(4);
                }
                DeclarationDescriptor descriptor2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference());
                assert (descriptor2 instanceof CallableDescriptor || descriptor2 instanceof ClassDescriptor) : "'This' reference target should be class or callable descriptor but was " + descriptor2;
                if (descriptor2 instanceof ClassDescriptor) {
                    this.lookupInContext(descriptor2);
                }
                if (descriptor2 instanceof CallableDescriptor && (parameter = ((CallableDescriptor)descriptor2).getExtensionReceiverParameter()) != null) {
                    this.lookupInContext(parameter);
                }
            }

            @Override
            public void visitSuperExpression(@NotNull KtSuperExpression expression2) {
                if (expression2 == null) {
                    2.$$$reportNull$$$0(5);
                }
                this.lookupInContext(ExpressionCodegen.getSuperCallLabelTarget(ImplementationBodyCodegen.this.context, expression2));
            }

            @Override
            public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
                ResolvedCall<FunctionDescriptor> resolvedSetCall;
                ResolvedCall<FunctionDescriptor> resolvedGetCall;
                if (expression2 == null) {
                    2.$$$reportNull$$$0(6);
                }
                if ((resolvedGetCall = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.INDEXED_LVALUE_GET, expression2)) != null) {
                    ReceiverValue receiver = resolvedGetCall.getDispatchReceiver();
                    this.lookupReceiver(receiver);
                }
                if ((resolvedSetCall = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.INDEXED_LVALUE_SET, expression2)) != null) {
                    ReceiverValue receiver = resolvedSetCall.getDispatchReceiver();
                    this.lookupReceiver(receiver);
                }
                super.visitArrayAccessExpression(expression2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expr";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "toLookup";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitKtElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSimpleNameExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lookupReceivers";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lookupInContext";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitThisExpression";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSuperExpression";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayAccessExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (KtDeclaration declaration2 : this.myClass.getDeclarations()) {
            if (declaration2 instanceof KtProperty) {
                KtProperty property2 = (KtProperty)declaration2;
                KtExpression initializer2 = property2.getDelegateExpressionOrInitializer();
                if (initializer2 == null) continue;
                initializer2.accept(visitor2);
                continue;
            }
            if (declaration2 instanceof KtAnonymousInitializer) {
                KtAnonymousInitializer initializer3 = (KtAnonymousInitializer)declaration2;
                initializer3.accept(visitor2);
                continue;
            }
            if (!(declaration2 instanceof KtSecondaryConstructor)) continue;
            KtSecondaryConstructor constructor = (KtSecondaryConstructor)declaration2;
            constructor.accept(visitor2);
        }
        for (KtSuperTypeListEntry specifier : this.myClass.getSuperTypeListEntries()) {
            if (specifier instanceof KtDelegatedSuperTypeEntry) {
                KtExpression delegateExpression2 = ((KtDelegatedSuperTypeEntry)specifier).getDelegateExpression();
                assert (delegateExpression2 != null);
                delegateExpression2.accept(visitor2);
                continue;
            }
            if (!(specifier instanceof KtSuperTypeCallEntry)) continue;
            specifier.accept(visitor2);
        }
    }

    private void generateEnumEntries() {
        if (this.descriptor.getKind() != ClassKind.ENUM_CLASS) {
            return;
        }
        List enumEntries = CollectionsKt.filterIsInstance(((KtPureClassOrObject)this.element).getDeclarations(), KtEnumEntry.class);
        for (KtEnumEntry enumEntry : enumEntries) {
            ClassDescriptor descriptor2 = BindingContextUtils.getNotNull(this.bindingContext, BindingContext.CLASS, enumEntry);
            int isDeprecated = KotlinBuiltIns.isDeprecated(descriptor2) ? 131072 : 0;
            FieldVisitor fv = this.v.newField(JvmDeclarationOriginKt.OtherOrigin(enumEntry, descriptor2), 0x4019 | isDeprecated, descriptor2.getName().asString(), this.classAsmType.getDescriptor(), null, null);
            AnnotationCodegen.forField(fv, this, this.state).genAnnotations(descriptor2, null, null);
        }
        this.initializeEnumConstants(enumEntries);
    }

    private void initializeEnumConstants(@NotNull List<KtEnumEntry> enumEntries) {
        if (enumEntries == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(13);
        }
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        ExpressionCodegen codegen2 = this.createOrGetClInitCodegen();
        InstructionAdapter iv = codegen2.v;
        Type arrayAsmType = this.typeMapper.mapType(DescriptorUtilsKt.getBuiltIns(this.descriptor).getArrayType(Variance.INVARIANT, this.descriptor.getDefaultType()));
        this.v.newField(JvmDeclarationOriginKt.OtherOriginFromPure(this.myClass), 4122, ENUM_VALUES_FIELD_NAME, arrayAsmType.getDescriptor(), null, null);
        iv.iconst(enumEntries.size());
        iv.newarray(this.classAsmType);
        if (!enumEntries.isEmpty()) {
            iv.dup();
            int size = enumEntries.size();
            for (int ordinal = 0; ordinal < size; ++ordinal) {
                this.initializeEnumConstant(enumEntries, ordinal);
            }
        }
        iv.putstatic(this.classAsmType.getInternalName(), ENUM_VALUES_FIELD_NAME, arrayAsmType.getDescriptor());
    }

    private void initializeEnumConstant(@NotNull List<KtEnumEntry> enumEntries, int ordinal) {
        if (enumEntries == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(14);
        }
        ExpressionCodegen codegen2 = this.createOrGetClInitCodegen();
        InstructionAdapter iv = codegen2.v;
        KtEnumEntry enumEntry = enumEntries.get(ordinal);
        iv.dup();
        iv.iconst(ordinal);
        ClassDescriptor classDescriptor2 = BindingContextUtils.getNotNull(this.bindingContext, BindingContext.CLASS, enumEntry);
        Type implClass = this.typeMapper.mapClass(classDescriptor2);
        iv.anew(implClass);
        iv.dup();
        iv.aconst((Object)enumEntry.getName());
        iv.iconst(ordinal);
        List<KtSuperTypeListEntry> delegationSpecifiers = enumEntry.getSuperTypeListEntries();
        ResolvedCall<? extends CallableDescriptor> defaultArgumentsConstructorCall = CallUtilKt.getResolvedCall(enumEntry, this.bindingContext);
        boolean enumEntryHasSubclass = CodegenBinding.enumEntryNeedSubclass(this.bindingContext, classDescriptor2);
        if (delegationSpecifiers.size() == 1 && !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, enumEntry)) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(delegationSpecifiers.get(0), this.bindingContext);
            CallableMethod method = this.typeMapper.mapToCallableMethod((ConstructorDescriptor)resolvedCall2.getResultingDescriptor(), false);
            codegen2.invokeMethodWithArguments(method, resolvedCall2, StackValue.none());
        } else if (defaultArgumentsConstructorCall != null && !enumEntryHasSubclass) {
            codegen2.invokeFunction(defaultArgumentsConstructorCall, StackValue.none()).put(Type.VOID_TYPE, iv);
        } else {
            iv.invokespecial(implClass.getInternalName(), "<init>", "(Ljava/lang/String;I)V", false);
        }
        iv.dup();
        iv.putstatic(this.classAsmType.getInternalName(), enumEntry.getName(), this.classAsmType.getDescriptor());
        iv.astore(AsmTypes.OBJECT_TYPE);
    }

    private void generateDelegates(DelegationFieldsInfo delegationFieldsInfo) {
        for (KtSuperTypeListEntry specifier : this.myClass.getSuperTypeListEntries()) {
            DelegationFieldsInfo.Field field;
            if (!(specifier instanceof KtDelegatedSuperTypeEntry) || (field = delegationFieldsInfo.getInfo((KtDelegatedSuperTypeEntry)specifier)) == null) continue;
            this.generateDelegateField(field);
            KtExpression delegateExpression2 = ((KtDelegatedSuperTypeEntry)specifier).getDelegateExpression();
            KotlinType delegateExpressionType = delegateExpression2 != null ? this.bindingContext.getType(delegateExpression2) : null;
            ClassDescriptor superClass = JvmCodegenUtil.getSuperClass(specifier, this.state, this.bindingContext);
            if (superClass == null) continue;
            this.generateDelegates(superClass, delegateExpressionType, field);
        }
    }

    private void generateDelegateField(DelegationFieldsInfo.Field fieldInfo) {
        if (!fieldInfo.generateField) {
            return;
        }
        this.v.newField(JvmDeclarationOrigin.NO_ORIGIN, 4114, fieldInfo.name, fieldInfo.type.getDescriptor(), fieldInfo.genericSignature, null);
    }

    private void generateDelegates(@NotNull ClassDescriptor toInterface, @Nullable KotlinType delegateExpressionType, @NotNull DelegationFieldsInfo.Field field) {
        if (toInterface == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(15);
        }
        if (field == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(16);
        }
        for (Map.Entry<CallableMemberDescriptor, CallableMemberDescriptor> entry : DelegationResolver.Companion.getDelegates(this.descriptor, toInterface, delegateExpressionType).entrySet()) {
            CallableMemberDescriptor member = entry.getKey();
            CallableMemberDescriptor delegateTo = entry.getValue();
            if (member instanceof PropertyDescriptor) {
                this.propertyCodegen.genDelegate((PropertyDescriptor)member, (PropertyDescriptor)delegateTo, field.getStackValue());
                continue;
            }
            if (!(member instanceof FunctionDescriptor)) continue;
            this.functionCodegen.genDelegate((FunctionDescriptor)member, (FunctionDescriptor)delegateTo, field.getStackValue());
        }
    }

    public void addCompanionObjectPropertyToCopy(@NotNull PropertyDescriptor descriptor2, Object defaultValue) {
        if (descriptor2 == null) {
            ImplementationBodyCodegen.$$$reportNull$$$0(17);
        }
        if (this.companionObjectPropertiesToCopy == null) {
            this.companionObjectPropertiesToCopy = new ArrayList<PropertyAndDefaultValue>();
        }
        this.companionObjectPropertiesToCopy.add(new PropertyAndDefaultValue(descriptor2, defaultValue));
    }

    @Override
    protected void done() {
        for (Function2<ImplementationBodyCodegen, ClassBuilder, Unit> task : this.additionalTasks) {
            task.invoke((Object)this, (Object)this.v);
        }
        super.done();
    }

    public void addAdditionalTask(Function2<ImplementationBodyCodegen, ClassBuilder, Unit> additionalTask) {
        this.additionalTasks.add(additionalTask);
    }

    static {
        for (JavaToKotlinClassMap.PlatformMutabilityMapping platformMutabilityMapping : JavaToKotlinClassMap.INSTANCE.getMutabilityMappings()) {
            KOTLIN_MARKER_INTERFACES.put(platformMutabilityMapping.getKotlinReadOnly().asSingleFqName(), "kotlin/jvm/internal/markers/KMappedMarker");
            ClassId mutableClassId = platformMutabilityMapping.getKotlinMutable();
            KOTLIN_MARKER_INTERFACES.put(mutableClassId.asSingleFqName(), "kotlin/jvm/internal/markers/K" + mutableClassId.getRelativeClassName().asString().replace("MutableEntry", "Entry").replace(".", "$"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classAsmType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationDescriptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumEntries";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInterface";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryConstructorOfDataClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "signature";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "genPropertyOnStack";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPrimaryConstructorOfDataClass";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInterfaceCompanionWithBackingFieldsInOuter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "generateInitializers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "initializeEnumConstants";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "initializeEnumConstant";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "generateDelegates";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addCompanionObjectPropertyToCopy";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PropertyAndDefaultValue {
        public final PropertyDescriptor descriptor;
        public final Object defaultValue;

        public PropertyAndDefaultValue(@NotNull PropertyDescriptor descriptor2, Object defaultValue) {
            if (descriptor2 == null) {
                PropertyAndDefaultValue.$$$reportNull$$$0(0);
            }
            this.descriptor = descriptor2;
            this.defaultValue = defaultValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$PropertyAndDefaultValue", "<init>"));
        }
    }

    private class DataClassMethodGeneratorImpl
    extends DataClassMethodGenerator {
        private final FunctionsFromAnyGeneratorImpl functionsFromAnyGenerator;

        DataClassMethodGeneratorImpl(KtClassOrObject klass, BindingContext bindingContext) {
            super(klass, bindingContext);
            this.functionsFromAnyGenerator = new FunctionsFromAnyGeneratorImpl(klass, bindingContext, ImplementationBodyCodegen.this.descriptor, ImplementationBodyCodegen.this.classAsmType, ImplementationBodyCodegen.this.context, ImplementationBodyCodegen.this.v, ImplementationBodyCodegen.this.state);
        }

        @Override
        public void generateEqualsMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> properties2) {
            if (function2 == null) {
                DataClassMethodGeneratorImpl.$$$reportNull$$$0(0);
            }
            if (properties2 == null) {
                DataClassMethodGeneratorImpl.$$$reportNull$$$0(1);
            }
            this.functionsFromAnyGenerator.generateEqualsMethod(function2, properties2);
        }

        @Override
        public void generateHashCodeMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> properties2) {
            if (function2 == null) {
                DataClassMethodGeneratorImpl.$$$reportNull$$$0(2);
            }
            if (properties2 == null) {
                DataClassMethodGeneratorImpl.$$$reportNull$$$0(3);
            }
            this.functionsFromAnyGenerator.generateHashCodeMethod(function2, properties2);
        }

        @Override
        public void generateToStringMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> properties2) {
            if (function2 == null) {
                DataClassMethodGeneratorImpl.$$$reportNull$$$0(4);
            }
            if (properties2 == null) {
                DataClassMethodGeneratorImpl.$$$reportNull$$$0(5);
            }
            this.functionsFromAnyGenerator.generateToStringMethod(function2, properties2);
        }

        @Override
        public void generateComponentFunction(@NotNull FunctionDescriptor function2, final @NotNull ValueParameterDescriptor parameter) {
            if (function2 == null) {
                DataClassMethodGeneratorImpl.$$$reportNull$$$0(6);
            }
            if (parameter == null) {
                DataClassMethodGeneratorImpl.$$$reportNull$$$0(7);
            }
            PsiElement originalElement = DescriptorToSourceUtils.descriptorToDeclaration(parameter);
            ImplementationBodyCodegen.this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin(originalElement, function2), function2, new FunctionGenerationStrategy(){

                @Override
                public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature2, @NotNull MethodContext context2, @NotNull MemberCodegen<?> parentCodegen) {
                    if (mv == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (frameMap == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (signature2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (context2 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (parentCodegen == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    Type componentType = signature2.getReturnType();
                    InstructionAdapter iv = new InstructionAdapter(mv);
                    if (!componentType.equals((Object)Type.VOID_TYPE)) {
                        PropertyDescriptor property2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, DescriptorToSourceUtils.descriptorToDeclaration(parameter));
                        assert (property2 != null) : "Property descriptor is not found for primary constructor parameter: " + parameter;
                        JvmKotlinType propertyType = ImplementationBodyCodegen.genPropertyOnStack(iv, context2, property2, ImplementationBodyCodegen.this.classAsmType, 0, ImplementationBodyCodegen.this.state);
                        StackValue.coerce(propertyType.getType(), componentType, iv);
                    }
                    iv.areturn(componentType);
                }

                @Override
                public boolean skipNotNullAssertionsForParameters() {
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "mv";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "frameMap";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "signature";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[0] = "parentCodegen";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1";
                    objectArray[2] = "generateBody";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        @Override
        public void generateCopyFunction(final @NotNull FunctionDescriptor function2, @NotNull List<? extends KtParameter> constructorParameters) {
            if (function2 == null) {
                DataClassMethodGeneratorImpl.$$$reportNull$$$0(8);
            }
            if (constructorParameters == null) {
                DataClassMethodGeneratorImpl.$$$reportNull$$$0(9);
            }
            final Type thisDescriptorType = ImplementationBodyCodegen.this.typeMapper.mapType(ImplementationBodyCodegen.this.descriptor);
            ImplementationBodyCodegen.this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOriginFromPure(ImplementationBodyCodegen.this.myClass, function2), function2, new FunctionGenerationStrategy(){

                @Override
                public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature2, @NotNull MethodContext context2, @NotNull MemberCodegen<?> parentCodegen) {
                    if (mv == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (frameMap == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (signature2 == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (context2 == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    if (parentCodegen == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    InstructionAdapter iv = new InstructionAdapter(mv);
                    iv.anew(thisDescriptorType);
                    iv.dup();
                    ConstructorDescriptor constructor = ImplementationBodyCodegen.getPrimaryConstructorOfDataClass(ImplementationBodyCodegen.this.descriptor);
                    assert (function2.getValueParameters().size() == constructor.getValueParameters().size()) : "Number of parameters of copy function and constructor are different. Copy: " + function2.getValueParameters().size() + ", constructor: " + constructor.getValueParameters().size();
                    MutableClosure closure = ImplementationBodyCodegen.this.context.closure;
                    if (closure != null) {
                        this.pushCapturedFieldsOnStack(iv, closure);
                    }
                    int parameterIndex = 1;
                    for (ValueParameterDescriptor parameterDescriptor : function2.getValueParameters()) {
                        Type type2 = ImplementationBodyCodegen.this.typeMapper.mapType(parameterDescriptor.getType());
                        iv.load(parameterIndex, type2);
                        parameterIndex += type2.getSize();
                    }
                    Method constructorAsmMethod = ImplementationBodyCodegen.this.typeMapper.mapAsmMethod(constructor);
                    iv.invokespecial(thisDescriptorType.getInternalName(), "<init>", constructorAsmMethod.getDescriptor(), false);
                    iv.areturn(thisDescriptorType);
                }

                @Override
                public boolean skipNotNullAssertionsForParameters() {
                    return false;
                }

                private void pushCapturedFieldsOnStack(InstructionAdapter iv, MutableClosure closure) {
                    KotlinType captureReceiver;
                    ClassDescriptor captureThis = closure.getCapturedOuterClassDescriptor();
                    if (captureThis != null) {
                        iv.load(0, ImplementationBodyCodegen.this.classAsmType);
                        Type type2 = ImplementationBodyCodegen.this.typeMapper.mapType(captureThis);
                        iv.getfield(ImplementationBodyCodegen.this.classAsmType.getInternalName(), "this$0", type2.getDescriptor());
                    }
                    if ((captureReceiver = closure.getCapturedReceiverFromOuterContext()) != null) {
                        iv.load(0, ImplementationBodyCodegen.this.classAsmType);
                        Type type3 = ImplementationBodyCodegen.this.typeMapper.mapType(captureReceiver);
                        String fieldName = closure.getCapturedReceiverFieldName(ImplementationBodyCodegen.this.bindingContext, ImplementationBodyCodegen.this.state.getLanguageVersionSettings());
                        iv.getfield(ImplementationBodyCodegen.this.classAsmType.getInternalName(), fieldName, type3.getDescriptor());
                    }
                    for (Map.Entry<DeclarationDescriptor, EnclosedValueDescriptor> entry : closure.getCaptureVariables().entrySet()) {
                        DeclarationDescriptor declarationDescriptor = entry.getKey();
                        EnclosedValueDescriptor enclosedValueDescriptor = entry.getValue();
                        StackValue capturedValue = enclosedValueDescriptor.getInstanceValue();
                        Type sharedVarType = ImplementationBodyCodegen.this.typeMapper.getSharedVarType(declarationDescriptor);
                        if (sharedVarType == null) {
                            sharedVarType = ImplementationBodyCodegen.this.typeMapper.mapType((VariableDescriptor)declarationDescriptor);
                        }
                        capturedValue.put(sharedVarType, iv);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "mv";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "frameMap";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "signature";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[0] = "parentCodegen";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2";
                    objectArray[2] = "generateBody";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            ImplementationBodyCodegen.this.functionCodegen.generateDefaultIfNeeded(ImplementationBodyCodegen.this.context.intoFunction(function2), function2, OwnerKind.IMPLEMENTATION, (valueParameter, codegen2) -> {
                assert (((ClassDescriptor)function2.getContainingDeclaration()).isData()) : "Function container must have [data] modifier: " + function2;
                PropertyDescriptor property2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter);
                assert (property2 != null) : "Copy function doesn't correspond to any property: " + function2;
                return codegen2.intermediateValueForProperty(property2, false, null, StackValue.LOCAL_0);
            }, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constructorParameters";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateEqualsMethod";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateHashCodeMethod";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateToStringMethod";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateComponentFunction";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateCopyFunction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

