/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticProperty;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProvider;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScope;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.impl.FirAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitorVoid;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001*B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0016\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00112\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u00102\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u0018H\u0016J\u000e\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0011J\u0018\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/KotlinScopeProvider;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/KotlinScopeProvider;)V", "getKotlinScopeProvider", "()Lorg/jetbrains/kotlin/fir/scopes/KotlinScopeProvider;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "state", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "ensureConsistent", "", "files", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getClassLikeSymbolByFqName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassNamesInPackage", "", "Lorg/jetbrains/kotlin/name/Name;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getFirCallableContainerFile", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getFirClassifierByFqName", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getFirClassifierContainerFile", "getFirClassifierContainerFileIfAny", "getFirFilesByPackage", "getNestedClassifierScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "getTopLevelCallableSymbols", "packageFqName", "name", "recordFile", "file", "State", "resolve"})
public final class FirProviderImpl
extends FirProvider {
    private final State state;
    @NotNull
    private final FirSession session;
    @NotNull
    private final KotlinScopeProvider kotlinScopeProvider;

    @Override
    @Nullable
    public FirFile getFirCallableContainerFile(@NotNull FirCallableSymbol<?> symbol2) {
        FirProperty fir;
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        FirCallableSymbol<?> firCallableSymbol = symbol2.getOverriddenSymbol();
        if (firCallableSymbol != null) {
            FirCallableSymbol<?> firCallableSymbol2 = firCallableSymbol;
            boolean bl = false;
            boolean bl2 = false;
            FirCallableSymbol<?> it = firCallableSymbol2;
            boolean bl3 = false;
            return this.getFirCallableContainerFile(it);
        }
        if (symbol2 instanceof FirAccessorSymbol && (fir = (FirProperty)((FirAccessorSymbol)symbol2).getFir()) instanceof FirSyntheticProperty) {
            return this.getFirCallableContainerFile((FirCallableSymbol)((FirSyntheticProperty)fir).getGetter().getDelegate().getSymbol());
        }
        return this.state.getCallableContainerMap().get(symbol2);
    }

    @Override
    @Nullable
    public FirClassLikeSymbol<?> getClassLikeSymbolByFqName(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        FirClassLikeDeclaration<?> firClassLikeDeclaration = this.getFirClassifierByFqName(classId);
        return firClassLikeDeclaration != null ? firClassLikeDeclaration.getSymbol() : null;
    }

    @Override
    @NotNull
    public List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        List list2 = this.state.getCallableMap().get(new CallableId(packageFqName, null, name2, null, 8, null));
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @Nullable
    public FirScope getNestedClassifierScope(@NotNull ClassId classId) {
        FirNestedClassifierScope firNestedClassifierScope;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        FirClassLikeDeclaration<?> firClassLikeDeclaration = this.getFirClassifierByFqName(classId);
        if (!(firClassLikeDeclaration instanceof FirRegularClass)) {
            firClassLikeDeclaration = null;
        }
        FirRegularClass firRegularClass = (FirRegularClass)firClassLikeDeclaration;
        if (firRegularClass != null) {
            FirRegularClass firRegularClass2 = firRegularClass;
            boolean bl = false;
            boolean bl2 = false;
            FirRegularClass it = firRegularClass2;
            boolean bl3 = false;
            firNestedClassifierScope = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(it);
        } else {
            firNestedClassifierScope = null;
        }
        return firNestedClassifierScope;
    }

    @Override
    @NotNull
    public FirFile getFirClassifierContainerFile(@NotNull ClassId fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        FirFile firFile = this.state.getClassifierContainerFileMap().get(fqName2);
        if (firFile == null) {
            String string2 = "Couldn't find container for " + fqName2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firFile;
    }

    @Override
    @Nullable
    public FirFile getFirClassifierContainerFileIfAny(@NotNull ClassId fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.state.getClassifierContainerFileMap().get(fqName2);
    }

    @Override
    @NotNull
    public Set<Name> getClassNamesInPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Set set = this.state.getClassesInPackage().get(fqName2);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final void recordFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.recordFile(file2, this.state);
    }

    private final void recordFile(FirFile file2, State state2) {
        FqName packageName = file2.getPackageFqName();
        state2.getFileMap().merge(packageName, CollectionsKt.listOf((Object)file2), recordFile.1.INSTANCE);
        file2.acceptChildren(new FirDefaultVisitorVoid(state2, file2){
            final /* synthetic */ State $state;
            final /* synthetic */ FirFile $file;

            public void visitElement(@NotNull FirElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            }

            /*
             * WARNING - void declaration
             */
            public void visitRegularClass(@NotNull FirRegularClass regularClass) {
                Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
                ClassId classId = regularClass.getSymbol().getClassId();
                this.$state.getClassifierMap().put(classId, regularClass);
                this.$state.getClassifierContainerFileMap().put(classId, this.$file);
                if (!classId.isNestedClass() && !classId.isLocal()) {
                    Object object;
                    void $this$getOrPut$iv;
                    Map<FqName, Set<Name>> map2 = this.$state.getClassesInPackage();
                    FqName fqName2 = classId.getPackageFqName();
                    Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.packageFqName");
                    FqName key$iv = fqName2;
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl = false;
                        boolean bl2 = false;
                        Set answer$iv = new LinkedHashSet<E>();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    Set set = (Set)object;
                    Name name2 = classId.getShortClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"classId.shortClassName");
                    set.add(name2);
                }
                regularClass.acceptChildren(this);
            }

            public void visitTypeAlias(@NotNull FirTypeAlias typeAlias) {
                Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
                ClassId classId = typeAlias.getSymbol().getClassId();
                this.$state.getClassifierMap().put(classId, typeAlias);
                this.$state.getClassifierContainerFileMap().put(classId, this.$file);
            }

            public <F extends FirCallableDeclaration<F>> void visitCallableDeclaration(@NotNull FirCallableDeclaration<F> callableDeclaration) {
                Intrinsics.checkNotNullParameter(callableDeclaration, (String)"callableDeclaration");
                FirCallableSymbol<F> symbol2 = callableDeclaration.getSymbol();
                CallableId callableId = symbol2.getCallableId();
                this.$state.getCallableMap().merge(callableId, CollectionsKt.listOf(symbol2), recordFile.visitCallableDeclaration.1.INSTANCE);
                this.$state.getCallableContainerMap().put(symbol2, this.$file);
            }

            public void visitConstructor(@NotNull FirConstructor constructor) {
                Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
                this.visitCallableDeclaration(constructor);
            }

            public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction) {
                Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
                this.visitCallableDeclaration(simpleFunction);
            }

            public void visitProperty(@NotNull FirProperty property2) {
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                this.visitCallableDeclaration(property2);
            }

            public void visitEnumEntry(@NotNull FirEnumEntry enumEntry) {
                Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
                this.visitCallableDeclaration(enumEntry);
            }
            {
                this.$state = $captured_local_variable$0;
                this.$file = $captured_local_variable$1;
            }
        });
    }

    @Override
    @NotNull
    public List<FirFile> getFirFilesByPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        List list2 = this.state.getFileMap().get(fqName2);
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @Override
    @Nullable
    public FirClassLikeDeclaration<?> getFirClassifierByFqName(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        boolean bl = !classId.isLocal();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Local " + classId + " should never be used to find its corresponding classifier";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return this.state.getClassifierMap().get(classId);
    }

    public final void ensureConsistent(@NotNull List<? extends FirFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        State newState = new State();
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirFile it = (FirFile)element$iv;
            boolean bl = false;
            this.recordFile(it, newState);
        }
        $i$f$forEach = false;
        List failures = new ArrayList();
        Function4 $fun$checkMapDiff$2 = new Function4<String, Map<K, ? extends V>, Map<K, ? extends V>, Function2<? super V, ? super V, ? extends Boolean>, Unit>(failures){
            final /* synthetic */ List $failures;

            /*
             * WARNING - void declaration
             */
            public final <K, V> void invoke(@NotNull String title, @NotNull Map<K, ? extends V> a, @NotNull Map<K, ? extends V> b, @NotNull Function2<? super V, ? super V, Boolean> equal) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter(a, (String)"a");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                Intrinsics.checkNotNullParameter(equal, (String)"equal");
                boolean hasTitle = false;
                Set unionKeys = SetsKt.plus(a.keySet(), (Iterable)b.keySet());
                Object $this$map$iv = unionKeys;
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    T item$iv$iv;
                    T t = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Triple triple = new Triple((Object)it, a.get(it), b.get(it));
                    collection.add(triple);
                }
                for (Triple triple : (List)destination$iv$iv) {
                    void key;
                    Collection collection;
                    void aValue;
                    $this$map$iv = triple.component1();
                    Object $i$f$map2 = triple.component2();
                    Object bValue = triple.component3();
                    if (((Boolean)equal.invoke((Object)aValue, bValue)).booleanValue()) continue;
                    if (!hasTitle) {
                        collection = this.$failures;
                        boolean bl = false;
                        collection.add(title);
                        hasTitle = true;
                    }
                    collection = this.$failures;
                    String string2 = "diff at key = '" + key + "': was: '" + aValue + "', become: '" + bValue + '\'';
                    boolean bl = false;
                    collection.add(string2);
                }
            }

            public static /* synthetic */ void invoke$default(ensureConsistent.2 var0, String string2, Map map2, Map map3, Function2 function2, int n, Object object) {
                if ((n & 8) != 0) {
                    function2 = ensureConsistent.1.INSTANCE;
                }
                var0.invoke(string2, map2, map3, function2);
            }
            {
                this.$failures = list2;
                super(4);
            }
        };
        Function3 $fun$checkMMapDiff$3 = new Function3<String, Map<K, ? extends List<? extends V>>, Map<K, ? extends List<? extends V>>, Unit>(failures){
            final /* synthetic */ List $failures;

            /*
             * WARNING - void declaration
             */
            public final <K, V> void invoke(@NotNull String title, @NotNull Map<K, ? extends List<? extends V>> a, @NotNull Map<K, ? extends List<? extends V>> b) {
                Collection it;
                boolean $i$a$-map-FirProviderImpl$ensureConsistent$3$22;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter(a, (String)"a");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                boolean hasTitle = false;
                Set unionKeys = SetsKt.plus(a.keySet(), (Iterable)b.keySet());
                Object $this$map$iv = unionKeys;
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    T item$iv$iv;
                    T t = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    $i$a$-map-FirProviderImpl$ensureConsistent$3$22 = false;
                    Triple triple = new Triple((Object)it, a.get(it), b.get(it));
                    collection.add(triple);
                }
                for (Triple triple : (List)destination$iv$iv) {
                    boolean bl;
                    String string2;
                    Collection collection;
                    T it2;
                    T element$iv;
                    void key;
                    void aValue;
                    $this$map$iv = triple.component1();
                    List $i$f$map2 = (List)triple.component2();
                    List bValue = (List)triple.component3();
                    if (aValue == null || bValue == null) {
                        if (!hasTitle) {
                            destination$iv$iv = this.$failures;
                            $i$f$mapTo2 = false;
                            destination$iv$iv.add(title);
                            hasTitle = true;
                        }
                        destination$iv$iv = this.$failures;
                        String $i$f$mapTo2 = "diff at key = '" + key + "': was: " + aValue + ", become: " + bValue;
                        boolean bl2 = false;
                        destination$iv$iv.add($i$f$mapTo2);
                        continue;
                    }
                    Set aSet = CollectionsKt.toSet((Iterable)((Iterable)aValue));
                    Set bSet = CollectionsKt.toSet((Iterable)bValue);
                    Set aLost = SetsKt.minus((Set)aSet, (Iterable)bSet);
                    Set bNew = SetsKt.minus((Set)bSet, (Iterable)aSet);
                    it = aLost;
                    $i$a$-map-FirProviderImpl$ensureConsistent$3$22 = false;
                    if (!(!it.isEmpty())) {
                        it = bNew;
                        $i$a$-map-FirProviderImpl$ensureConsistent$3$22 = false;
                        if (!(!it.isEmpty())) continue;
                    }
                    it = this.$failures;
                    String $i$a$-map-FirProviderImpl$ensureConsistent$3$22 = "diff at key = '" + key + "':";
                    boolean bl3 = false;
                    it.add($i$a$-map-FirProviderImpl$ensureConsistent$3$22);
                    it = this.$failures;
                    $i$a$-map-FirProviderImpl$ensureConsistent$3$22 = "    Lost:";
                    bl3 = false;
                    it.add($i$a$-map-FirProviderImpl$ensureConsistent$3$22);
                    Iterable $this$forEach$iv = aLost;
                    boolean $i$f$forEach22 = false;
                    Iterator<T> iterator3 = $this$forEach$iv.iterator();
                    while (iterator3.hasNext()) {
                        it2 = element$iv = iterator3.next();
                        boolean bl4 = false;
                        collection = this.$failures;
                        string2 = "     " + it2;
                        bl = false;
                        collection.add(string2);
                    }
                    $this$forEach$iv = this.$failures;
                    String $i$f$forEach22 = "    New:";
                    boolean bl5 = false;
                    $this$forEach$iv.add($i$f$forEach22);
                    $this$forEach$iv = bNew;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator4 = $this$forEach$iv.iterator();
                    while (iterator4.hasNext()) {
                        it2 = element$iv = iterator4.next();
                        boolean bl6 = false;
                        collection = this.$failures;
                        string2 = "     " + it2;
                        bl = false;
                        collection.add(string2);
                    }
                }
            }
            {
                this.$failures = list2;
                super(3);
            }
        };
        $fun$checkMMapDiff$3.invoke("fileMap", this.state.getFileMap(), newState.getFileMap());
        ensureConsistent.2.invoke$default($fun$checkMapDiff$2, "classifierMap", this.state.getClassifierMap(), newState.getClassifierMap(), null, 8, null);
        ensureConsistent.2.invoke$default($fun$checkMapDiff$2, "classifierContainerFileMap", this.state.getClassifierContainerFileMap(), newState.getClassifierContainerFileMap(), null, 8, null);
        $fun$checkMMapDiff$3.invoke("callableMap", this.state.getCallableMap(), newState.getCallableMap());
        ensureConsistent.2.invoke$default($fun$checkMapDiff$2, "callableContainerMap", this.state.getCallableContainerMap(), newState.getCallableContainerMap(), null, 8, null);
        this.state.setFrom(newState);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final KotlinScopeProvider getKotlinScopeProvider() {
        return this.kotlinScopeProvider;
    }

    public FirProviderImpl(@NotNull FirSession session, @NotNull KotlinScopeProvider kotlinScopeProvider2) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)kotlinScopeProvider2, (String)"kotlinScopeProvider");
        this.session = session;
        this.kotlinScopeProvider = kotlinScopeProvider2;
        this.state = new State();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000R!\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR'\u0010\t\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR#\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR!\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR#\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "", "()V", "callableContainerMap", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getCallableContainerMap", "()Ljava/util/Map;", "callableMap", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "", "getCallableMap", "classesInPackage", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/name/Name;", "getClassesInPackage", "classifierContainerFileMap", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassifierContainerFileMap", "classifierMap", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getClassifierMap", "fileMap", "getFileMap", "setFrom", "", "other", "resolve"})
    private static final class State {
        @NotNull
        private final Map<FqName, List<FirFile>> fileMap;
        @NotNull
        private final Map<ClassId, FirClassLikeDeclaration<?>> classifierMap;
        @NotNull
        private final Map<ClassId, FirFile> classifierContainerFileMap;
        @NotNull
        private final Map<FqName, Set<Name>> classesInPackage;
        @NotNull
        private final Map<CallableId, List<FirCallableSymbol<?>>> callableMap;
        @NotNull
        private final Map<FirCallableSymbol<?>, FirFile> callableContainerMap;

        @NotNull
        public final Map<FqName, List<FirFile>> getFileMap() {
            return this.fileMap;
        }

        @NotNull
        public final Map<ClassId, FirClassLikeDeclaration<?>> getClassifierMap() {
            return this.classifierMap;
        }

        @NotNull
        public final Map<ClassId, FirFile> getClassifierContainerFileMap() {
            return this.classifierContainerFileMap;
        }

        @NotNull
        public final Map<FqName, Set<Name>> getClassesInPackage() {
            return this.classesInPackage;
        }

        @NotNull
        public final Map<CallableId, List<FirCallableSymbol<?>>> getCallableMap() {
            return this.callableMap;
        }

        @NotNull
        public final Map<FirCallableSymbol<?>, FirFile> getCallableContainerMap() {
            return this.callableContainerMap;
        }

        public final void setFrom(@NotNull State other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.fileMap.clear();
            this.classifierMap.clear();
            this.classifierContainerFileMap.clear();
            this.callableMap.clear();
            this.callableContainerMap.clear();
            this.fileMap.putAll(other.fileMap);
            this.classifierMap.putAll(other.classifierMap);
            this.classifierContainerFileMap.putAll(other.classifierContainerFileMap);
            this.callableMap.putAll(other.callableMap);
            this.callableContainerMap.putAll(other.callableContainerMap);
            this.classesInPackage.putAll(other.classesInPackage);
        }

        public State() {
            boolean bl = false;
            this.fileMap = new LinkedHashMap();
            bl = false;
            this.classifierMap = new LinkedHashMap();
            bl = false;
            this.classifierContainerFileMap = new LinkedHashMap();
            bl = false;
            this.classesInPackage = new LinkedHashMap();
            bl = false;
            this.callableMap = new LinkedHashMap();
            bl = false;
            this.callableContainerMap = new LinkedHashMap();
        }
    }
}

