/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsModuleCheckUtilKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsModuleChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkSuperClass", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "js.frontend"})
public final class JsModuleChecker
implements DeclarationChecker {
    public static final JsModuleChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        BindingTrace trace = context2.getTrace();
        this.checkSuperClass(declaration2, descriptor2, trace);
        if (AnnotationsUtils.getModuleName(descriptor2) == null && !AnnotationsUtils.isNonModule(descriptor2)) {
            return;
        }
        if (descriptor2 instanceof PropertyDescriptor && ((PropertyDescriptor)descriptor2).isVar()) {
            trace.report(ErrorsJs.JS_MODULE_PROHIBITED_ON_VAR.on((KtElement)((PsiElement)declaration2)));
        }
        if (!AnnotationsUtils.isNativeObject(descriptor2)) {
            trace.report(ErrorsJs.JS_MODULE_PROHIBITED_ON_NON_NATIVE.on((KtElement)((PsiElement)declaration2)));
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            boolean isFileModuleOrNonModule;
            boolean bl = isFileModuleOrNonModule = AnnotationsUtils.getFileModuleName(trace.getBindingContext(), descriptor2) != null || AnnotationsUtils.isFromNonModuleFile(trace.getBindingContext(), descriptor2);
            if (isFileModuleOrNonModule) {
                trace.report(ErrorsJs.NESTED_JS_MODULE_PROHIBITED.on((KtElement)((PsiElement)declaration2)));
            }
        }
    }

    private final void checkSuperClass(KtDeclaration declaration2, DeclarationDescriptor descriptor2, BindingTrace trace) {
        Object v3;
        ClassDescriptor superClass;
        block4: {
            if (!(descriptor2 instanceof ClassDescriptor)) {
                return;
            }
            ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor2);
            if (classDescriptor2 == null) {
                return;
            }
            superClass = classDescriptor2;
            KtDeclaration ktDeclaration = declaration2;
            if (ktDeclaration == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            }
            Iterable $this$firstOrNull$iv = ((KtClassOrObject)ktDeclaration).getSuperTypeListEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtSuperTypeListEntry entry = (KtSuperTypeListEntry)element$iv;
                boolean bl = false;
                Object object = (KotlinType)trace.get(BindingContext.TYPE, entry.getTypeReference());
                if (!Intrinsics.areEqual((Object)(object != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : null), (Object)superClass)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        KtSuperTypeListEntry psi = v3;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        KtSuperTypeListEntry ktSuperTypeListEntry = psi;
        JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext, trace, descriptor2, superClass, (PsiElement)(ktSuperTypeListEntry != null ? (KtElementImplStub)ktSuperTypeListEntry : (KtElementImplStub)((Object)declaration2)));
    }

    private JsModuleChecker() {
    }

    static {
        JsModuleChecker jsModuleChecker;
        INSTANCE = jsModuleChecker = new JsModuleChecker();
    }
}

