/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.StrictEqualityTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/serialization/js/DynamicTypeDeserializer;", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "()V", "id", "", "create", "Lorg/jetbrains/kotlin/types/KotlinType;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "flexibleId", "lowerBound", "Lorg/jetbrains/kotlin/types/SimpleType;", "upperBound", "js.serializer"})
public final class DynamicTypeDeserializer
implements FlexibleTypeDeserializer {
    @NotNull
    public static final String id = "kotlin.DynamicType";
    public static final DynamicTypeDeserializer INSTANCE;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public KotlinType create(@NotNull ProtoBuf.Type proto, @NotNull String flexibleId, @NotNull SimpleType lowerBound, @NotNull SimpleType upperBound) {
        UnwrappedType unwrappedType;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)flexibleId, (String)"flexibleId");
        Intrinsics.checkNotNullParameter((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkNotNullParameter((Object)upperBound, (String)"upperBound");
        if (Intrinsics.areEqual((Object)flexibleId, (Object)id) ^ true) {
            SimpleType simpleType2 = ErrorUtils.createErrorType("Unexpected id: " + flexibleId + ". (" + lowerBound + ".." + upperBound + ')');
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"ErrorUtils.createErrorTy\u2026owerBound..$upperBound)\")");
            return simpleType2;
        }
        SimpleType simpleType3 = TypeUtilsKt.getBuiltIns(lowerBound).getNothingType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"lowerBound.builtIns.nothingType");
        if (StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(lowerBound, simpleType3)) {
            SimpleType simpleType4 = TypeUtilsKt.getBuiltIns(upperBound).getNullableAnyType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType4, (String)"upperBound.builtIns.nullableAnyType");
            if (StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(upperBound, simpleType4)) {
                unwrappedType = DynamicTypesKt.createDynamicType(TypeUtilsKt.getBuiltIns(lowerBound));
                return unwrappedType;
            }
        }
        SimpleType simpleType5 = ErrorUtils.createErrorType("Illegal type range for dynamic type: " + lowerBound + ".." + upperBound);
        Intrinsics.checkNotNullExpressionValue((Object)simpleType5, (String)"ErrorUtils.createErrorTy\u2026lowerBound..$upperBound\")");
        unwrappedType = simpleType5;
        return unwrappedType;
    }

    private DynamicTypeDeserializer() {
    }

    static {
        DynamicTypeDeserializer dynamicTypeDeserializer;
        INSTANCE = dynamicTypeDeserializer = new DynamicTypeDeserializer();
    }
}

