/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideBuilder;
import org.jetbrains.kotlin.backend.common.overrides.FileLocalAwareLinker;
import org.jetbrains.kotlin.backend.common.serialization.CurrentModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerWithBuiltIns;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.backend.common.serialization.LegacyDescriptorUtilsKt;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.builders.TranslationPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.descriptors.IrAbstractFunctionFactory;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.linkage.IrDeserializer;
import org.jetbrains.kotlin.ir.linkage.KotlinIrLinkerInternalException;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingClassSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingEnumEntrySymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingPropertySymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSymbol;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSymbolKt;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbolKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0002\u0010\rJ\u001e\u0010:\u001a\u00020\u001b2\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001b0*H\u0014J\"\u0010>\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020\u00042\b\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020CH$J\b\u0010D\u001a\u00020EH\u0002J\u0018\u0010F\u001a\u00020<2\u0006\u0010?\u001a\u00020\u00042\b\u0010G\u001a\u0004\u0018\u00010HJ\u0018\u0010I\u001a\u00020<2\u0006\u0010?\u001a\u00020\u00042\b\u0010G\u001a\u0004\u0018\u00010HJ\u0018\u0010J\u001a\u00020<2\u0006\u0010?\u001a\u00020\u00042\b\u0010G\u001a\u0004\u0018\u00010HJ\"\u0010J\u001a\u00020<2\u0006\u0010?\u001a\u00020\u00042\b\u0010G\u001a\u0004\u0018\u00010H2\b\b\u0002\u0010K\u001a\u00020CJ\u0018\u0010L\u001a\u00020<2\u0006\u0010?\u001a\u00020\u00042\b\u0010G\u001a\u0004\u0018\u00010HJ\b\u0010M\u001a\u00020EH\u0002J\u0012\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010P\u001a\u00020\u0011H\u0002J\u0012\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010P\u001a\u00020\u0011H\u0016J\u0016\u0010S\u001a\u00020\u00112\u0006\u0010T\u001a\u00020\u00102\u0006\u0010U\u001a\u00020\u0011J&\u0010V\u001a\u00020\u001b2\u0006\u0010W\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001b0*H\u0016J \u0010X\u001a\u00020E2\b\u0010;\u001a\u0004\u0018\u00010<2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020+0*H\u0016J\u0010\u0010Z\u001a\u00020[2\u0006\u0010?\u001a\u00020\u0004H$J\u0018\u0010\\\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020\u00042\u0006\u0010]\u001a\u00020\u001bH\u0014J\u0010\u0010^\u001a\u00020[2\u0006\u0010P\u001a\u00020\u0011H\u0014J\b\u0010_\u001a\u00020EH\u0016J \u0010`\u001a\u00020\u00112\u0006\u0010a\u001a\u00020\u00102\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020eH\u0016J\u001a\u0010f\u001a\u00020\u001b2\u0006\u0010g\u001a\u00020\u00042\b\u0010a\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010h\u001a\u00020i2\u0006\u0010b\u001a\u00020cH\u0002J\u001a\u0010j\u001a\u0004\u0018\u00010k2\u0006\u0010l\u001a\u00020R2\u0006\u0010W\u001a\u00020\u0010H\u0016J\u001a\u0010m\u001a\u0004\u0018\u00010n2\u0006\u0010l\u001a\u00020R2\u0006\u0010W\u001a\u00020\u0010H\u0016J\u0012\u0010o\u001a\u0004\u0018\u00010R2\u0006\u0010P\u001a\u00020\u0011H\u0002R \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001b0\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013R\u001d\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00020\"X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0012\u0010%\u001a\u00020&X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0019R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001d\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0013R\u0014\u00104\u001a\u0004\u0018\u000105X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u001a\u00108\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u0019\u00a8\u0006p"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer;", "Lorg/jetbrains/kotlin/backend/common/overrides/FileLocalAwareLinker;", "currentModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "messageLogger", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "builtIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "exportedDependencies", "", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Ljava/util/List;)V", "actualSymbols", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getActualSymbols$ir_serialization_common", "()Ljava/util/Map;", "getBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "deserializedSymbols", "", "getDeserializedSymbols", "()Ljava/util/Set;", "deserializersForModules", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "getDeserializersForModules", "expectSymbols", "getExpectSymbols$ir_serialization_common", "expectUniqIdToActualUniqId", "getExpectUniqIdToActualUniqId", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "getFakeOverrideBuilder", "()Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "functionalInterfaceFactory", "Lorg/jetbrains/kotlin/ir/descriptors/IrAbstractFunctionFactory;", "getFunctionalInterfaceFactory", "()Lorg/jetbrains/kotlin/ir/descriptors/IrAbstractFunctionFactory;", "linkerExtensions", "", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer$IrLinkerExtension;", "getMessageLogger", "()Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "modulesWithReachableTopLevels", "getModulesWithReachableTopLevels", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "topLevelActualUniqItToDeserializer", "getTopLevelActualUniqItToDeserializer", "translationPluginContext", "Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;", "getTranslationPluginContext", "()Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;", "triedToDeserializeDeclarationForSymbol", "getTriedToDeserializeDeclarationForSymbol$ir_serialization_common", "createCurrentModuleDeserializer", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependencies", "createModuleDeserializer", "moduleDescriptor", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "strategy", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "deserializeAllReachableTopLevels", "", "deserializeFullModule", "kotlinLibrary", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "deserializeHeadersWithInlineBodies", "deserializeIrModuleHeader", "deserializationStrategy", "deserializeOnlyHeaderModule", "finalizeExpectActualLinker", "findDeserializedDeclarationForSymbol", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "symbol", "getDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "handleExpectActualMapping", "idSig", "rawSymbol", "handleNoModuleDeserializerFound", "idSignature", "init", "extensions", "isBuiltInModule", "", "maybeWrapWithBuiltInAndInit", "moduleDeserializer", "platformSpecificSymbol", "postProcess", "resolveBySignatureInModule", "signature", "kind", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer$TopLevelSymbolKind;", "moduleName", "Lorg/jetbrains/kotlin/name/Name;", "resolveModuleDeserializer", "module", "topLevelKindToSymbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "tryReferencingPropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "parent", "tryReferencingSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "tryResolveCustomDeclaration", "ir.serialization.common"})
public abstract class KotlinIrLinker
implements IrDeserializer,
FileLocalAwareLinker {
    @Nullable
    private final ModuleDescriptor currentModule;
    @NotNull
    private final IrMessageLogger messageLogger;
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final List<ModuleDescriptor> exportedDependencies;
    @NotNull
    private final Map<IdSignature, IdSignature> expectUniqIdToActualUniqId;
    @NotNull
    private final Map<IdSignature, IrModuleDeserializer> topLevelActualUniqItToDeserializer;
    @NotNull
    private final Map<IdSignature, IrSymbol> expectSymbols;
    @NotNull
    private final Map<IdSignature, IrSymbol> actualSymbols;
    @NotNull
    private final Set<IrModuleDeserializer> modulesWithReachableTopLevels;
    @NotNull
    private final Map<ModuleDescriptor, IrModuleDeserializer> deserializersForModules;
    @NotNull
    private final Set<IrSymbol> triedToDeserializeDeclarationForSymbol;
    @NotNull
    private final Set<IrSymbol> deserializedSymbols;
    private Collection<? extends IrDeserializer.IrLinkerExtension> linkerExtensions;

    public KotlinIrLinker(@Nullable ModuleDescriptor currentModule, @NotNull IrMessageLogger messageLogger, @NotNull IrBuiltIns builtIns, @NotNull SymbolTable symbolTable, @NotNull List<? extends ModuleDescriptor> exportedDependencies) {
        Intrinsics.checkNotNullParameter((Object)messageLogger, (String)"messageLogger");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter(exportedDependencies, (String)"exportedDependencies");
        this.currentModule = currentModule;
        this.messageLogger = messageLogger;
        this.builtIns = builtIns;
        this.symbolTable = symbolTable;
        this.exportedDependencies = exportedDependencies;
        boolean bl = false;
        this.expectUniqIdToActualUniqId = new LinkedHashMap();
        bl = false;
        this.topLevelActualUniqItToDeserializer = new LinkedHashMap();
        bl = false;
        this.expectSymbols = new LinkedHashMap();
        bl = false;
        this.actualSymbols = new LinkedHashMap();
        bl = false;
        this.modulesWithReachableTopLevels = new LinkedHashSet();
        bl = false;
        this.deserializersForModules = new LinkedHashMap();
        bl = false;
        this.triedToDeserializeDeclarationForSymbol = new LinkedHashSet();
        bl = false;
        this.deserializedSymbols = new LinkedHashSet();
    }

    @NotNull
    public final IrMessageLogger getMessageLogger() {
        return this.messageLogger;
    }

    @NotNull
    public final IrBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    public final Map<IdSignature, IdSignature> getExpectUniqIdToActualUniqId() {
        return this.expectUniqIdToActualUniqId;
    }

    @NotNull
    public final Map<IdSignature, IrModuleDeserializer> getTopLevelActualUniqItToDeserializer() {
        return this.topLevelActualUniqItToDeserializer;
    }

    @NotNull
    public final Map<IdSignature, IrSymbol> getExpectSymbols$ir_serialization_common() {
        return this.expectSymbols;
    }

    @NotNull
    public final Map<IdSignature, IrSymbol> getActualSymbols$ir_serialization_common() {
        return this.actualSymbols;
    }

    @NotNull
    public final Set<IrModuleDeserializer> getModulesWithReachableTopLevels() {
        return this.modulesWithReachableTopLevels;
    }

    @NotNull
    protected final Map<ModuleDescriptor, IrModuleDeserializer> getDeserializersForModules() {
        return this.deserializersForModules;
    }

    @NotNull
    public abstract FakeOverrideBuilder getFakeOverrideBuilder();

    @Nullable
    public abstract TranslationPluginContext getTranslationPluginContext();

    @NotNull
    public final Set<IrSymbol> getTriedToDeserializeDeclarationForSymbol$ir_serialization_common() {
        return this.triedToDeserializeDeclarationForSymbol;
    }

    @NotNull
    public final Set<IrSymbol> getDeserializedSymbols() {
        return this.deserializedSymbols;
    }

    @NotNull
    public IrModuleDeserializer handleNoModuleDeserializerFound(@NotNull IdSignature idSignature, @NotNull ModuleDescriptor currentModule, @NotNull Collection<? extends IrModuleDeserializer> dependencies2) {
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        Intrinsics.checkNotNullParameter((Object)currentModule, (String)"currentModule");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$handleNoModuleDeserializerFound_u24lambda_u2d0 = stringBuilder2;
        boolean bl5 = false;
        $this$handleNoModuleDeserializerFound_u24lambda_u2d0.append("Module " + currentModule.getName() + " has reference " + idSignature + ", unfortunately neither itself nor its dependencies ");
        CollectionsKt.joinTo$default((Iterable)dependencies2, (Appendable)$this$handleNoModuleDeserializerFound_u24lambda_u2d0, (CharSequence)"\n\t", (CharSequence)"[\n\t", (CharSequence)"\n]", (int)0, null, (Function1)handleNoModuleDeserializerFound.message.1.1.INSTANCE, (int)48, null);
        $this$handleNoModuleDeserializerFound_u24lambda_u2d0.append(" contain this declaration");
        $this$handleNoModuleDeserializerFound_u24lambda_u2d0.append("\n");
        $this$handleNoModuleDeserializerFound_u24lambda_u2d0.append("Please check that project configuration is correct and has required dependencies.");
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String message2 = string2;
        this.messageLogger.report(IrMessageLogger.Severity.ERROR, message2, null);
        throw KotlinIrLinkerInternalException.INSTANCE;
    }

    @NotNull
    public IrModuleDeserializer resolveModuleDeserializer(@NotNull ModuleDescriptor module2, @Nullable IdSignature signature2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        IrModuleDeserializer irModuleDeserializer = this.deserializersForModules.get(module2);
        if (irModuleDeserializer == null) {
            KotlinIrLinker kotlinIrLinker = this;
            boolean bl = false;
            boolean bl2 = false;
            KotlinIrLinker $this$resolveModuleDeserializer_u24lambda_u2d3 = kotlinIrLinker;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            StringBuilder stringBuilder2 = new StringBuilder();
            boolean bl6 = false;
            boolean bl7 = false;
            StringBuilder $this$resolveModuleDeserializer_u24lambda_u2d3_u24lambda_u2d2 = stringBuilder2;
            boolean bl8 = false;
            $this$resolveModuleDeserializer_u24lambda_u2d3_u24lambda_u2d2.append("Could not load module ");
            $this$resolveModuleDeserializer_u24lambda_u2d3_u24lambda_u2d2.append(module2);
            IdSignature idSignature = signature2;
            if (idSignature != null) {
                IdSignature idSignature2 = idSignature;
                boolean bl9 = false;
                boolean bl10 = false;
                IdSignature it = idSignature2;
                boolean bl11 = false;
                $this$resolveModuleDeserializer_u24lambda_u2d3_u24lambda_u2d2.append("; It was an attempt to find deserializer for ");
                $this$resolveModuleDeserializer_u24lambda_u2d3_u24lambda_u2d2.append(it);
            }
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            String message2 = string2;
            $this$resolveModuleDeserializer_u24lambda_u2d3.getMessageLogger().report(IrMessageLogger.Severity.ERROR, message2, null);
            throw KotlinIrLinkerInternalException.INSTANCE;
        }
        return irModuleDeserializer;
    }

    @NotNull
    protected abstract IrModuleDeserializer createModuleDeserializer(@NotNull ModuleDescriptor var1, @Nullable IrLibrary var2, @NotNull DeserializationStrategy var3);

    @NotNull
    protected abstract IrAbstractFunctionFactory getFunctionalInterfaceFactory();

    protected abstract boolean isBuiltInModule(@NotNull ModuleDescriptor var1);

    private final void deserializeAllReachableTopLevels() {
        while (true) {
            Collection collection = this.modulesWithReachableTopLevels;
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            IrModuleDeserializer moduleDeserializer = (IrModuleDeserializer)CollectionsKt.first((Iterable)this.modulesWithReachableTopLevels);
            this.modulesWithReachableTopLevels.remove(moduleDeserializer);
            moduleDeserializer.deserializeReachableDeclarations();
        }
    }

    private final DeclarationDescriptor findDeserializedDeclarationForSymbol(IrSymbol symbol2) {
        boolean bl = IrSymbolKt.isPublicApi(symbol2) || DescriptorUtilsKt.getModule(symbol2.getDescriptor()) == this.currentModule || this.platformSpecificSymbol(symbol2);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        if (this.triedToDeserializeDeclarationForSymbol.contains(symbol2) || this.deserializedSymbols.contains(symbol2)) {
            return null;
        }
        this.triedToDeserializeDeclarationForSymbol.add(symbol2);
        DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
        IrModuleDeserializer moduleDeserializer = this.resolveModuleDeserializer(DescriptorUtilsKt.getModule(descriptor2), symbol2.getSignature());
        moduleDeserializer.declareIrSymbol(symbol2);
        this.deserializeAllReachableTopLevels();
        if (!symbol2.isBound()) {
            return null;
        }
        return descriptor2;
    }

    protected boolean platformSpecificSymbol(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return false;
    }

    private final IrDeclaration tryResolveCustomDeclaration(IrSymbol symbol2) {
        Iterable<IrDeserializer.IrLinkerExtension> iterable;
        if (!symbol2.getHasDescriptor()) {
            return null;
        }
        DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
        if (descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            return null;
        }
        TranslationPluginContext translationPluginContext = this.getTranslationPluginContext();
        if (translationPluginContext == null) {
            iterable = null;
        } else {
            Object object;
            boolean bl;
            Iterable<IrDeserializer.IrLinkerExtension> iterable2;
            block10: {
                Object object2;
                Collection<? extends IrDeserializer.IrLinkerExtension> collection;
                TranslationPluginContext translationPluginContext2 = translationPluginContext;
                boolean bl2 = false;
                boolean bl3 = false;
                TranslationPluginContext ctx2 = translationPluginContext2;
                boolean bl4 = false;
                iterable2 = this.linkerExtensions;
                if (iterable2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"linkerExtensions");
                    collection = null;
                } else {
                    collection = iterable2;
                }
                iterable2 = collection;
                bl = false;
                for (IrDeserializer.IrLinkerExtension irLinkerExtension : iterable2) {
                    Object it = irLinkerExtension;
                    boolean bl5 = false;
                    if ((it = it.resolveSymbol(symbol2, ctx2)) == null) continue;
                    object2 = it;
                    break block10;
                }
                object2 = object = null;
            }
            if (object == null) {
                iterable = null;
            } else {
                iterable2 = object;
                bl = false;
                boolean bl6 = false;
                Iterable<IrDeserializer.IrLinkerExtension> it = iterable2;
                boolean bl7 = false;
                boolean bl8 = Intrinsics.areEqual((Object)symbol2.getOwner(), it);
                boolean bl9 = false;
                boolean bl10 = false;
                bl10 = false;
                boolean bl11 = false;
                if (!bl8) {
                    boolean bl12 = false;
                    String string2 = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                iterable = iterable2;
            }
        }
        return iterable;
    }

    @Override
    @Nullable
    public IrDeclaration getDeclaration(@NotNull IrSymbol symbol2) {
        IrDeclaration irDeclaration2;
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!IrSymbolKt.isPublicApi(symbol2)) {
            DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
            if (!this.platformSpecificSymbol(symbol2) && DescriptorUtilsKt.getModule(descriptor2) != this.currentModule) {
                return null;
            }
        }
        if (!symbol2.isBound() && (declarationDescriptor = this.findDeserializedDeclarationForSymbol(symbol2)) == null && (irDeclaration2 = this.tryResolveCustomDeclaration(symbol2)) == null) {
            return null;
        }
        if (!symbol2.isBound() && (LegacyDescriptorUtilsKt.isExpectMember(symbol2.getDescriptor()) || ((declarationDescriptor = symbol2.getDescriptor().getContainingDeclaration()) == null ? false : LegacyDescriptorUtilsKt.isExpectMember(declarationDescriptor)))) {
            return null;
        }
        if (!symbol2.isBound()) {
            return null;
        }
        return (IrDeclaration)symbol2.getOwner();
    }

    @Override
    @Nullable
    public IrSimpleFunctionSymbol tryReferencingSimpleFunctionByLocalSignature(@NotNull IrDeclaration parent2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        if (idSignature.isPublic()) {
            return null;
        }
        IrFile file2 = IrUtilsKt.getFile(parent2);
        ModuleDescriptor moduleDescriptor = file2.getPackageFragmentDescriptor().getContainingDeclaration();
        return this.resolveModuleDeserializer(moduleDescriptor, null).referenceSimpleFunctionByLocalSignature(file2, idSignature);
    }

    @Override
    @Nullable
    public IrPropertySymbol tryReferencingPropertyByLocalSignature(@NotNull IrDeclaration parent2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        if (idSignature.isPublic()) {
            return null;
        }
        IrFile file2 = IrUtilsKt.getFile(parent2);
        ModuleDescriptor moduleDescriptor = file2.getPackageFragmentDescriptor().getContainingDeclaration();
        return this.resolveModuleDeserializer(moduleDescriptor, null).referencePropertyByLocalSignature(file2, idSignature);
    }

    @NotNull
    protected IrModuleDeserializer createCurrentModuleDeserializer(@NotNull IrModuleFragment moduleFragment, @NotNull Collection<? extends IrModuleDeserializer> dependencies2) {
        Intrinsics.checkNotNullParameter((Object)moduleFragment, (String)"moduleFragment");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        return new CurrentModuleDeserializer(moduleFragment, dependencies2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@Nullable IrModuleFragment moduleFragment, @NotNull Collection<? extends IrDeserializer.IrLinkerExtension> extensions) {
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        this.linkerExtensions = extensions;
        if (moduleFragment != null) {
            ModuleDescriptor $this$mapTo$iv$iv;
            Iterable $this$map$iv = moduleFragment.getDescriptor().getAllDependencyModules();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                ModuleDescriptor moduleDescriptor = (ModuleDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                IrModuleDeserializer irModuleDeserializer = this.resolveModuleDeserializer((ModuleDescriptor)it, null);
                collection.add(irModuleDeserializer);
            }
            List currentModuleDependencies = (List)destination$iv$iv;
            IrModuleDeserializer currentModuleDeserializer = this.createCurrentModuleDeserializer(moduleFragment, currentModuleDependencies);
            Map<ModuleDescriptor, IrModuleDeserializer> map = this.deserializersForModules;
            $this$mapTo$iv$iv = moduleFragment.getDescriptor();
            destination$iv$iv = this.maybeWrapWithBuiltInAndInit(moduleFragment.getDescriptor(), currentModuleDeserializer);
            $i$f$mapTo = false;
            map.put($this$mapTo$iv$iv, (IrModuleDeserializer)destination$iv$iv);
        }
        Iterable $this$forEach$iv = this.deserializersForModules.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleDeserializer it = (IrModuleDeserializer)element$iv;
            boolean bl = false;
            it.init();
        }
    }

    @Override
    public void postProcess() {
        this.finalizeExpectActualLinker();
        this.getFakeOverrideBuilder().provideFakeOverrides();
        this.triedToDeserializeDeclarationForSymbol.clear();
        this.deserializedSymbols.clear();
    }

    @NotNull
    public final IrSymbol handleExpectActualMapping(@NotNull IdSignature idSig, @NotNull IrSymbol rawSymbol) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        Intrinsics.checkNotNullParameter((Object)rawSymbol, (String)"rawSymbol");
        if (this.expectUniqIdToActualUniqId.values().contains(idSig)) {
            object = this.actualSymbols;
            boolean bl = false;
            object.put((IdSignature)idSig, (IrSymbol)rawSymbol);
        }
        if ((object = this.expectUniqIdToActualUniqId.get(idSig)) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object actualSig = object2;
            boolean bl3 = false;
            IdSignature idSignature = idSig;
            boolean bl4 = false;
            boolean bl5 = false;
            IdSignature $this$handleExpectActualMapping_u24lambda_u2d11_u24lambda_u2d9 = idSignature;
            boolean bl6 = false;
            boolean bl7 = $this$handleExpectActualMapping_u24lambda_u2d11_u24lambda_u2d9.test(IdSignature.Flags.IS_EXPECT);
            bl4 = false;
            bl5 = false;
            if (_Assertions.ENABLED && !bl7) {
                boolean bl8 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            IrDelegatingSymbol<? extends IrBindableSymbol<?, ? extends IrDeclaration>, ? extends IrDeclaration, ?> referencingSymbol = IrDelegatingSymbolKt.wrapInDelegatedSymbol(rawSymbol);
            Object object3 = this.getExpectSymbols$ir_serialization_common();
            bl5 = false;
            object3.put((IdSignature)idSig, referencingSymbol);
            object3 = this.getTopLevelActualUniqItToDeserializer().get(actualSig);
            if (object3 != null) {
                Object object4 = object3;
                boolean bl9 = false;
                boolean bl10 = false;
                Object moduleDeserializer = object4;
                boolean bl11 = false;
                IrSymbol actualSymbol = this.getActualSymbols$ir_serialization_common().get(actualSig);
                if (actualSymbol == null || !actualSymbol.isBound()) {
                    ((IrModuleDeserializer)moduleDeserializer).addModuleReachableTopLevel((IdSignature)actualSig);
                }
            }
            return referencingSymbol;
        }
        return rawSymbol;
    }

    private final BinarySymbolData.SymbolKind topLevelKindToSymbolKind(IrDeserializer.TopLevelSymbolKind kind) {
        BinarySymbolData.SymbolKind symbolKind;
        IrDeserializer.TopLevelSymbolKind topLevelSymbolKind = kind;
        int n = WhenMappings.$EnumSwitchMapping$0[topLevelSymbolKind.ordinal()];
        switch (n) {
            case 1: {
                symbolKind = BinarySymbolData.SymbolKind.CLASS_SYMBOL;
                break;
            }
            case 2: {
                symbolKind = BinarySymbolData.SymbolKind.PROPERTY_SYMBOL;
                break;
            }
            case 3: {
                symbolKind = BinarySymbolData.SymbolKind.FUNCTION_SYMBOL;
                break;
            }
            case 4: {
                symbolKind = BinarySymbolData.SymbolKind.TYPEALIAS_SYMBOL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return symbolKind;
    }

    @Override
    @NotNull
    public IrSymbol resolveBySignatureInModule(@NotNull IdSignature signature2, @NotNull IrDeserializer.TopLevelSymbolKind kind, @NotNull Name moduleName) {
        IrModuleDeserializer irModuleDeserializer;
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Iterable iterable = this.deserializersForModules.entrySet();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Map.Entry it = (Map.Entry)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)((ModuleDescriptor)it.getKey()).getName(), (Object)moduleName)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        Object object = v0;
        IrModuleDeserializer irModuleDeserializer2 = irModuleDeserializer = object == null ? null : (IrModuleDeserializer)object.getValue();
        if (irModuleDeserializer == null) {
            object = "No module for name '" + moduleName + "' found";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        IrModuleDeserializer moduleDeserializer = irModuleDeserializer;
        boolean bl = Intrinsics.areEqual((Object)signature2, (Object)signature2.topLevelSignature());
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string2 = "Signature '" + signature2 + "' has to be top level";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        if (!moduleDeserializer.contains(signature2)) {
            String string3 = "No signature " + signature2 + " in module " + moduleName;
            bl4 = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        IrSymbol irSymbol2 = moduleDeserializer.deserializeIrSymbol(signature2, this.topLevelKindToSymbolKind(kind));
        bl4 = false;
        boolean bl6 = false;
        IrSymbol it = irSymbol2;
        boolean bl7 = false;
        this.deserializeAllReachableTopLevels();
        return irSymbol2;
    }

    private final void finalizeExpectActualLinker() {
        Map<IdSignature, IdSignature> $this$forEach$iv = this.expectUniqIdToActualUniqId;
        boolean $i$f$forEach = false;
        Map<IdSignature, IdSignature> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<IdSignature, IdSignature>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<IdSignature, IdSignature> element$iv;
            Map.Entry<IdSignature, IdSignature> it = element$iv = iterator2.next();
            boolean bl2 = false;
            IrSymbol expectSymbol = this.getExpectSymbols$ir_serialization_common().get(it.getKey());
            IrSymbol actualSymbol = this.getActualSymbols$ir_serialization_common().get(it.getValue());
            if (expectSymbol == null || actualSymbol == null) continue;
            IrSymbol irSymbol2 = expectSymbol;
            if (irSymbol2 instanceof IrDelegatingClassSymbolImpl) {
                ((IrDelegatingClassSymbolImpl)expectSymbol).setDelegate((IrBindableSymbol)((IrClassSymbol)actualSymbol));
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingEnumEntrySymbolImpl) {
                ((IrDelegatingEnumEntrySymbolImpl)expectSymbol).setDelegate((IrBindableSymbol)((IrEnumEntrySymbol)actualSymbol));
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingSimpleFunctionSymbolImpl) {
                ((IrDelegatingSimpleFunctionSymbolImpl)expectSymbol).setDelegate((IrBindableSymbol)((IrSimpleFunctionSymbol)actualSymbol));
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingConstructorSymbolImpl) {
                ((IrDelegatingConstructorSymbolImpl)expectSymbol).setDelegate((IrBindableSymbol)((IrConstructorSymbol)actualSymbol));
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingPropertySymbolImpl) {
                ((IrDelegatingPropertySymbolImpl)expectSymbol).setDelegate((IrBindableSymbol)((IrPropertySymbol)actualSymbol));
                continue;
            }
            String string2 = Intrinsics.stringPlus((String)"Unexpected expect symbol kind during actualization: ", (Object)expectSymbol);
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
    }

    @NotNull
    public final IrModuleFragment deserializeIrModuleHeader(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary, @NotNull DeserializationStrategy deserializationStrategy) {
        IrModuleDeserializer irModuleDeserializer;
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)((Object)deserializationStrategy), (String)"deserializationStrategy");
        Map<ModuleDescriptor, IrModuleDeserializer> $this$getOrPut$iv = this.deserializersForModules;
        boolean $i$f$getOrPut = false;
        IrModuleDeserializer value$iv = $this$getOrPut$iv.get(moduleDescriptor);
        if (value$iv == null) {
            boolean bl = false;
            IrModuleDeserializer answer$iv = this.maybeWrapWithBuiltInAndInit(moduleDescriptor, this.createModuleDeserializer(moduleDescriptor, kotlinLibrary, deserializationStrategy));
            $this$getOrPut$iv.put(moduleDescriptor, answer$iv);
            irModuleDeserializer = answer$iv;
        } else {
            irModuleDeserializer = value$iv;
        }
        IrModuleDeserializer deserializerForModule = irModuleDeserializer;
        return deserializerForModule.getModuleFragment();
    }

    public static /* synthetic */ IrModuleFragment deserializeIrModuleHeader$default(KotlinIrLinker kotlinIrLinker, ModuleDescriptor moduleDescriptor, KotlinLibrary kotlinLibrary, DeserializationStrategy deserializationStrategy, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deserializeIrModuleHeader");
        }
        if ((n & 4) != 0) {
            deserializationStrategy = DeserializationStrategy.ONLY_REFERENCED;
        }
        return kotlinIrLinker.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, deserializationStrategy);
    }

    @NotNull
    protected IrModuleDeserializer maybeWrapWithBuiltInAndInit(@NotNull ModuleDescriptor moduleDescriptor, @NotNull IrModuleDeserializer moduleDeserializer) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)moduleDeserializer, (String)"moduleDeserializer");
        return this.isBuiltInModule(moduleDescriptor) ? (IrModuleDeserializer)new IrModuleDeserializerWithBuiltIns(this.builtIns, this.getFunctionalInterfaceFactory(), moduleDeserializer) : moduleDeserializer;
    }

    @NotNull
    public final IrModuleFragment deserializeIrModuleHeader(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        DeserializationStrategy deserializationStrategy = this.exportedDependencies.contains(moduleDescriptor) ? DeserializationStrategy.ALL : DeserializationStrategy.EXPLICITLY_EXPORTED;
        return this.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, deserializationStrategy);
    }

    @NotNull
    public final IrModuleFragment deserializeFullModule(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        return this.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, DeserializationStrategy.ALL);
    }

    @NotNull
    public final IrModuleFragment deserializeOnlyHeaderModule(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        return this.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, DeserializationStrategy.ONLY_DECLARATION_HEADERS);
    }

    @NotNull
    public final IrModuleFragment deserializeHeadersWithInlineBodies(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        return this.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, DeserializationStrategy.WITH_INLINE_BODIES);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrDeserializer.TopLevelSymbolKind.values().length];
            nArray[IrDeserializer.TopLevelSymbolKind.CLASS_SYMBOL.ordinal()] = 1;
            nArray[IrDeserializer.TopLevelSymbolKind.PROPERTY_SYMBOL.ordinal()] = 2;
            nArray[IrDeserializer.TopLevelSymbolKind.FUNCTION_SYMBOL.ordinal()] = 3;
            nArray[IrDeserializer.TopLevelSymbolKind.TYPEALIAS_SYMBOL.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

