/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunInterfaceDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirFunInterfaceDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirFunInterfaceDeclarationChecker INSTANCE = new FirFunInterfaceDeclarationChecker();

    private FirFunInterfaceDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
                FirClass $this$isInterface$iv = declaration2;
                boolean $i$f$isInterface = false;
                if (!($this$isInterface$iv.getClassKind() == ClassKind.INTERFACE)) break block12;
                FirRegularClass $this$isFun$iv = declaration2;
                boolean $i$f$isFun = false;
                if ($this$isFun$iv.getStatus().isFun()) break block13;
            }
            return;
        }
        FirTypeScope scope2 = FirHelpersKt.unsubstitutedScope(declaration2, context2);
        FirSimpleFunction abstractFunction = null;
        for (Name name2 : scope2.getCallableNames()) {
            List<FirNamedFunctionSymbol> functions2 = FirScopeKt.getFunctions(scope2, name2);
            List<FirVariableSymbol<?>> properties2 = FirScopeKt.getProperties(scope2, name2);
            for (FirNamedFunctionSymbol firNamedFunctionSymbol : functions2) {
                FirMemberDeclaration $this$isAbstract$iv = (FirMemberDeclaration)firNamedFunctionSymbol.getFir();
                boolean $i$f$isAbstract = false;
                if (!($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT)) continue;
                if (abstractFunction == null) {
                    abstractFunction = (FirSimpleFunction)firNamedFunctionSymbol.getFir();
                    continue;
                }
                DiagnosticReporterKt.reportOn$default(reporter2, declaration2.getSource(), FirErrors.INSTANCE.getFUN_INTERFACE_WRONG_COUNT_OF_ABSTRACT_MEMBERS(), context2, null, 8, null);
            }
            for (FirVariableSymbol firVariableSymbol : properties2) {
                FirProperty $i$f$isAbstract;
                Object e = firVariableSymbol.getFir();
                FirProperty firProperty = $i$f$isAbstract = e instanceof FirProperty ? (FirProperty)e : null;
                if ($i$f$isAbstract == null) continue;
                FirProperty firProperty2 = $i$f$isAbstract;
                FirMemberDeclaration $this$isAbstract$iv = firProperty2;
                boolean $i$f$isAbstract2 = false;
                if (!($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT)) continue;
                FirSourceElement source = !Intrinsics.areEqual(FirHelpersKt.getContainingClass((FirSymbolOwner)firProperty2, context2), (Object)declaration2) ? declaration2.getSource() : firProperty2.getSource();
                DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getFUN_INTERFACE_CANNOT_HAVE_ABSTRACT_PROPERTIES(), context2, null, 8, null);
            }
        }
        if (abstractFunction == null) {
            DiagnosticReporterKt.reportOn$default(reporter2, declaration2.getSource(), FirErrors.INSTANCE.getFUN_INTERFACE_WRONG_COUNT_OF_ABSTRACT_MEMBERS(), context2, null, 8, null);
            return;
        }
        boolean inFunInterface = FirHelpersKt.getContainingClass((FirSymbolOwner)abstractFunction, context2) == declaration2;
        Collection collection = abstractFunction.getTypeParameters();
        boolean functions2 = false;
        if (!collection.isEmpty()) {
            DiagnosticReporterKt.reportOn$default(reporter2, inFunInterface ? abstractFunction.getSource() : declaration2.getSource(), FirErrors.INSTANCE.getFUN_INTERFACE_ABSTRACT_METHOD_WITH_TYPE_PARAMETERS(), context2, null, 8, null);
        } else {
            FirMemberDeclaration firMemberDeclaration = abstractFunction;
            boolean $i$f$isSuspend = false;
            if (firMemberDeclaration.getStatus().isSuspend() && !FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.SuspendFunctionsInFunInterfaces)) {
                DiagnosticReporterKt.reportOn$default(reporter2, inFunInterface ? abstractFunction.getSource() : declaration2.getSource(), FirErrors.INSTANCE.getFUN_INTERFACE_WITH_SUSPEND_FUNCTION(), context2, null, 8, null);
            }
        }
        Iterable iterable = abstractFunction.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : iterable) {
            FirValueParameter firValueParameter = (FirValueParameter)element$iv;
            boolean bl = false;
            if (firValueParameter.getDefaultValue() == null) continue;
            DiagnosticReporterKt.reportOn$default(reporter2, inFunInterface ? firValueParameter.getSource() : declaration2.getSource(), FirErrors.INSTANCE.getFUN_INTERFACE_ABSTRACT_METHOD_WITH_DEFAULT_VALUE(), context2, null, 8, null);
        }
    }
}

