/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableList;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.implementations.immutableList.AbstractListIterator;
import kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B-\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\r\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u000e\u0010\u0016\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\r\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J7\u0010\u0018\u001a\u00020\u00122\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\u0019\u0010\nR\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lkotlinx/collections/immutable/implementations/immutableList/TrieIterator;", "E", "Lkotlinx/collections/immutable/implementations/immutableList/AbstractListIterator;", "root", "", "", "index", "", "size", "height", "([Ljava/lang/Object;III)V", "isInRightEdge", "", "path", "[Ljava/lang/Object;", "elementAtCurrentIndex", "()Ljava/lang/Object;", "fillPath", "", "startLevel", "fillPathIfNeeded", "indexPredicate", "next", "previous", "reset", "reset$kotlinx_collections_immutable", "kotlinx-collections-immutable"})
public final class TrieIterator<E>
extends AbstractListIterator<E> {
    private Object[] path;
    private boolean isInRightEdge;
    private int height;

    public final void reset$kotlinx_collections_immutable(@NotNull Object[] root2, int index2, int size, int height) {
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        this.setIndex(index2);
        this.setSize(size);
        this.height = height;
        if (this.path.length < height) {
            this.path = new Object[height];
        }
        this.path[0] = root2;
        this.isInRightEdge = index2 == size;
        this.fillPath(index2 - (this.isInRightEdge ? 1 : 0), 1);
    }

    private final void fillPath(int index2, int startLevel) {
        int shift = (this.height - startLevel) * 5;
        for (int i = startLevel; i < this.height; ++i) {
            Object object = this.path[i - 1];
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            }
            this.path[i] = ((Object[])object)[UtilsKt.indexSegment(index2, shift)];
            shift -= 5;
        }
    }

    private final void fillPathIfNeeded(int indexPredicate) {
        int shift = 0;
        while (UtilsKt.indexSegment(this.getIndex(), shift) == indexPredicate) {
            shift += 5;
        }
        if (shift > 0) {
            int level = this.height - 1 - shift / 5;
            this.fillPath(this.getIndex(), level + 1);
        }
    }

    private final E elementAtCurrentIndex() {
        int leafBufferIndex = this.getIndex() & 0x1F;
        Object object = this.path[this.height - 1];
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<E>");
        }
        return (E)((Object[])object)[leafBufferIndex];
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw (Throwable)new NoSuchElementException();
        }
        E result2 = this.elementAtCurrentIndex();
        TrieIterator trieIterator = this;
        trieIterator.setIndex(trieIterator.getIndex() + 1);
        if (this.getIndex() == this.getSize()) {
            this.isInRightEdge = true;
            return result2;
        }
        this.fillPathIfNeeded(0);
        return result2;
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw (Throwable)new NoSuchElementException();
        }
        TrieIterator trieIterator = this;
        trieIterator.setIndex(trieIterator.getIndex() - 1);
        if (this.isInRightEdge) {
            this.isInRightEdge = false;
            return this.elementAtCurrentIndex();
        }
        this.fillPathIfNeeded(31);
        return this.elementAtCurrentIndex();
    }

    public TrieIterator(@NotNull Object[] root2, int index2, int size, int height) {
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        super(index2, size);
        this.height = height;
        this.path = new Object[this.height];
        this.isInRightEdge = index2 == size;
        this.path[0] = root2;
        this.fillPath(index2 - (this.isInRightEdge ? 1 : 0), 1);
    }
}

