/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.ex;

import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementContainer;
import org.jetbrains.jps.model.JpsElementCreator;
import org.jetbrains.jps.model.JpsElementParameterizedCreator;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementContainerEx;

public class JpsElementContainerImpl
extends JpsElementContainerEx
implements JpsElementContainer {
    private final Object myDataLock;
    private final Map<JpsElementChildRole<?>, JpsElement> myElements;
    @NotNull
    private final JpsCompositeElementBase<?> myParent;

    public JpsElementContainerImpl(@NotNull JpsCompositeElementBase<?> parent2) {
        if (parent2 == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(0);
        }
        this.myDataLock = new Object();
        this.myElements = CollectionFactory.createSmallMemoryFootprintMap((int)1);
        this.myParent = parent2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JpsElementContainerImpl(@NotNull JpsElementContainerEx original, @NotNull JpsCompositeElementBase<?> parent2) {
        if (original == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(1);
        }
        if (parent2 == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(2);
        }
        this.myDataLock = new Object();
        this.myElements = CollectionFactory.createSmallMemoryFootprintMap((int)1);
        this.myParent = parent2;
        Object object = original.getDataLock();
        synchronized (object) {
            for (Map.Entry<JpsElementChildRole<?>, JpsElement> entry : original.getElementsMap().entrySet()) {
                JpsElementChildRole<?> role = entry.getKey();
                Object copy2 = entry.getValue().getBulkModificationSupport().createCopy();
                JpsElementBase.setParent(copy2, this.myParent);
                this.myElements.put(role, (JpsElement)copy2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends JpsElement> T getChild(@NotNull JpsElementChildRole<T> role) {
        if (role == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(3);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return (T)this.myElements.get(role);
        }
    }

    @Override
    @NotNull
    public <T extends JpsElement, P, K extends JpsElementChildRole<T>> T setChild(@NotNull K role, @NotNull P param) {
        if (role == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(4);
        }
        if (param == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(5);
        }
        Object child = ((JpsElementParameterizedCreator)((Object)role)).create(param);
        Object e = this.setChild((JpsElementChildRole<T>)role, (T)child);
        if (e == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(6);
        }
        return (T)e;
    }

    @Override
    @NotNull
    public <T extends JpsElement, K extends JpsElementChildRole<T>> T setChild(@NotNull K role) {
        if (role == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(7);
        }
        Object child = ((JpsElementCreator)((Object)role)).create();
        Object e = this.setChild((JpsElementChildRole<T>)role, (T)child);
        if (e == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(8);
        }
        return (T)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public <T extends JpsElement, K extends JpsElementChildRole<T>> T getOrSetChild(@NotNull K role) {
        T added;
        block9: {
            JpsElement jpsElement;
            if (role == null) {
                JpsElementContainerImpl.$$$reportNull$$$0(9);
            }
            added = null;
            try {
                Object object = this.myDataLock;
                // MONITORENTER : object
                JpsElement cached2 = this.myElements.get(role);
                if (cached2 == null) break block9;
                JpsElement jpsElement2 = cached2;
                // MONITOREXIT : object
                if (added != null) {
                    this.fireChildSet(role, added);
                }
                jpsElement = jpsElement2;
            }
            catch (Throwable throwable) {
                if (added == null) throw throwable;
                this.fireChildSet(role, added);
                throw throwable;
            }
            if (jpsElement != null) return (T)jpsElement;
            JpsElementContainerImpl.$$$reportNull$$$0(10);
            return (T)jpsElement;
        }
        Object e = this.putChild(role, (T)((JpsElementCreator)((Object)role)).create());
        added = (T)e;
        Object e2 = e;
        // MONITOREXIT : object
        if (added != null) {
            this.fireChildSet(role, added);
        }
        Object e3 = e2;
        if (e3 != null) return (T)e3;
        JpsElementContainerImpl.$$$reportNull$$$0(11);
        return (T)e3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public <T extends JpsElement, P, K extends JpsElementChildRole<T>> T getOrSetChild(@NotNull K role, @NotNull Supplier<P> param) {
        T added;
        block8: {
            JpsElement jpsElement;
            if (role == null) {
                JpsElementContainerImpl.$$$reportNull$$$0(12);
            }
            if (param == null) {
                JpsElementContainerImpl.$$$reportNull$$$0(13);
            }
            added = null;
            try {
                Object object = this.myDataLock;
                // MONITORENTER : object
                JpsElement cached2 = this.myElements.get(role);
                if (cached2 == null) break block8;
                jpsElement = cached2;
                // MONITOREXIT : object
                if (added == null) return (T)jpsElement;
                this.fireChildSet(role, added);
            }
            catch (Throwable throwable) {
                if (added == null) throw throwable;
                this.fireChildSet(role, added);
                throw throwable;
            }
            return (T)jpsElement;
        }
        Object e = this.putChild(role, (T)((JpsElementParameterizedCreator)((Object)role)).create(param.get()));
        added = (T)e;
        Object e2 = e;
        // MONITOREXIT : object
        if (added == null) return (T)e2;
        this.fireChildSet(role, added);
        return (T)e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends JpsElement> T setChild(JpsElementChildRole<T> role, T child) {
        try {
            Object object = this.myDataLock;
            synchronized (object) {
                T t = this.putChild(role, child);
                return t;
            }
        }
        finally {
            this.fireChildSet(role, child);
        }
    }

    @NotNull
    private <T extends JpsElement> T putChild(JpsElementChildRole<T> role, T child) {
        JpsElementBase.setParent(child, this.myParent);
        this.myElements.put(role, child);
        T t = child;
        if (t == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(14);
        }
        return t;
    }

    private <T extends JpsElement> void fireChildSet(JpsElementChildRole<T> role, T child) {
        JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.fireElementAdded(child, role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends JpsElement> void removeChild(@NotNull JpsElementChildRole<T> role) {
        JpsElement removed2;
        if (role == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(15);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            removed2 = this.myElements.remove(role);
        }
        if (removed2 == null) {
            return;
        }
        JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.fireElementRemoved(removed2, role);
        }
        JpsElementBase.setParent(removed2, null);
    }

    @Override
    protected final Object getDataLock() {
        return this.myDataLock;
    }

    @Override
    protected final Map<JpsElementChildRole<?>, JpsElement> getElementsMap() {
        return this.myElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyChanges(@NotNull JpsElementContainerEx modified) {
        if (modified == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(16);
        }
        ArrayList roles = new ArrayList();
        Iterator iterator2 = this.myDataLock;
        synchronized (iterator2) {
            roles.addAll(this.myElements.keySet());
        }
        for (JpsElementChildRole jpsElementChildRole : roles) {
            this.applyChanges(jpsElementChildRole, modified);
        }
        roles.clear();
        iterator2 = modified.getDataLock();
        synchronized (iterator2) {
            roles.addAll(modified.getElementsMap().keySet());
        }
        iterator2 = this.myDataLock;
        synchronized (iterator2) {
            roles.removeAll(this.myElements.keySet());
        }
        for (JpsElementChildRole jpsElementChildRole : roles) {
            this.applyChanges(jpsElementChildRole, modified);
        }
    }

    private <T extends JpsElement> void applyChanges(JpsElementChildRole<T> role, JpsElementContainerEx modified) {
        T child = this.getChild(role);
        T modifiedChild = modified.getChild(role);
        if (child != null && modifiedChild != null) {
            JpsElement.BulkModificationSupport<?> modificationSupport = child.getBulkModificationSupport();
            modificationSupport.applyChanges(modifiedChild);
        } else if (modifiedChild == null) {
            this.removeChild(role);
        } else {
            this.setChild(role, (T)modifiedChild.getBulkModificationSupport().createCopy());
        }
    }

    @Nullable
    private JpsEventDispatcher getEventDispatcher() {
        return this.myParent.getEventDispatcher();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "role";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/ex/JpsElementContainerImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modified";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/ex/JpsElementContainerImpl";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setChild";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrSetChild";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "putChild";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setChild";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOrSetChild";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "applyChanges";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

