/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.FileDeserializationState;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.ir.util.IdSignature;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/ModuleDeserializationState;", "", "linker", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "moduleDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/BasicIrModuleDeserializer;", "(Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;Lorg/jetbrains/kotlin/backend/common/serialization/BasicIrModuleDeserializer;)V", "filesWithPendingTopLevels", "", "Lorg/jetbrains/kotlin/backend/common/serialization/FileDeserializationState;", "getLinker", "()Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "getModuleDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/BasicIrModuleDeserializer;", "addIdSignature", "", "key", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "deserializeReachableDeclarations", "enqueueFile", "fileDeserializationState", "toString", "", "ir.serialization.common"})
final class ModuleDeserializationState {
    @NotNull
    private final KotlinIrLinker linker;
    @NotNull
    private final BasicIrModuleDeserializer moduleDeserializer;
    @NotNull
    private final Set<FileDeserializationState> filesWithPendingTopLevels;

    public ModuleDeserializationState(@NotNull KotlinIrLinker linker, @NotNull BasicIrModuleDeserializer moduleDeserializer) {
        Intrinsics.checkNotNullParameter((Object)linker, (String)"linker");
        Intrinsics.checkNotNullParameter((Object)moduleDeserializer, (String)"moduleDeserializer");
        this.linker = linker;
        this.moduleDeserializer = moduleDeserializer;
        boolean bl = false;
        this.filesWithPendingTopLevels = new LinkedHashSet();
    }

    @NotNull
    public final KotlinIrLinker getLinker() {
        return this.linker;
    }

    @NotNull
    public final BasicIrModuleDeserializer getModuleDeserializer() {
        return this.moduleDeserializer;
    }

    public final void enqueueFile(@NotNull FileDeserializationState fileDeserializationState2) {
        Intrinsics.checkNotNullParameter((Object)fileDeserializationState2, (String)"fileDeserializationState");
        this.filesWithPendingTopLevels.add(fileDeserializationState2);
        this.linker.getModulesWithReachableTopLevels().add(this.moduleDeserializer);
    }

    public final void addIdSignature(@NotNull IdSignature key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        FileDeserializationState fileDeserializationState2 = this.moduleDeserializer.getModuleReversedFileIndex$ir_serialization_common().get(key);
        if (fileDeserializationState2 == null) {
            String string2 = Intrinsics.stringPlus((String)"No file found for key ", (Object)key);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        FileDeserializationState fileLocalDeserializationState = fileDeserializationState2;
        fileLocalDeserializationState.addIdSignature(key);
        this.enqueueFile(fileLocalDeserializationState);
    }

    public final void deserializeReachableDeclarations() {
        while (true) {
            Collection collection = this.filesWithPendingTopLevels;
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            FileDeserializationState pendingFileDeserializationState = (FileDeserializationState)CollectionsKt.first((Iterable)this.filesWithPendingTopLevels);
            pendingFileDeserializationState.getFileDeserializer().deserializeFileImplicitDataIfFirstUse();
            pendingFileDeserializationState.deserializeAllFileReachableTopLevel();
            this.filesWithPendingTopLevels.remove(pendingFileDeserializationState);
        }
    }

    @NotNull
    public String toString() {
        return this.moduleDeserializer.getKlib().toString();
    }
}

