/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirRenderer;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationCheckerUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.util.FirCheckersUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory1;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirStatusResolverKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkInlineFunctionBody", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "effectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "Visitor", "checkers"})
public final class FirInlineDeclarationChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final FirInlineDeclarationChecker INSTANCE = new FirInlineDeclarationChecker();

    private FirInlineDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirMemberDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        EffectiveVisibility effectiveVisibility;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirMemberDeclaration $this$isInline$iv = declaration2;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv.getStatus().isInline()) {
            return;
        }
        if (FirDeclarationCheckerUtilsKt.isLocalMember(declaration2)) {
            return;
        }
        if (!(declaration2 instanceof FirPropertyAccessor) && !(declaration2 instanceof FirSimpleFunction)) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        EffectiveVisibility effectiveVisibility2 = effectiveVisibility = object == null ? null : object.getEffectiveVisibility();
        if (effectiveVisibility == null) {
            object = "Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        EffectiveVisibility effectiveVisibility3 = effectiveVisibility;
        FirFunction function2 = (FirFunction)((Object)declaration2);
        this.checkInlineFunctionBody(function2, effectiveVisibility3, context2, reporter2);
    }

    /*
     * Unable to fully structure code
     */
    private final void checkInlineFunctionBody(FirFunction<?> function, EffectiveVisibility effectiveVisibility, CheckerContext context, DiagnosticReporter reporter) {
        var6_5 = function.getBody();
        if (var6_5 == null) {
            return;
        }
        body = var6_5;
        $this$filter$iv = function.getValueParameters();
        $i$f$filter = false;
        var9_9 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block7: {
                block6: {
                    it = (FirValueParameter)element$iv$iv;
                    $i$a$-filter-FirInlineDeclarationChecker$checkInlineFunctionBody$inlinableParameters$1 = false;
                    if (!it.isNoinline()) break block6;
                    v0 = false;
                    break block7;
                }
                type = FirTypeUtilsKt.getConeType(it.getReturnTypeRef());
                if (ConeTypeUtilsKt.isMarkedNullable(type)) ** GOTO lbl-1000
                var17_17 = type;
                session$iv = context.getSession();
                $i$f$isFunctionalType = false;
                var20_20 = InferenceUtilsKt.functionClassKind((ConeKotlinType)$this$isFunctionalType$iv, session$iv);
                if (var20_20 == null) {
                    v1 = false;
                } else {
                    kind = kind$iv = var20_20;
                    $i$a$-isFunctionalType-FirInlineDeclarationChecker$checkInlineFunctionBody$inlinableParameters$1$1 = false;
                    v1 = kind.isReflectType() == false;
                }
                if (v1) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
            }
            if (!v0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        inlinableParameters = (List)destination$iv$iv;
        visitor = new Visitor(function, effectiveVisibility, inlinableParameters, context.getSession(), reporter);
        FirCheckersUtilsKt.checkChildrenWithCustomVisitor(body, context, visitor);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B7\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ&\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0003H\u0002J$\u0010#\u001a\u00020\u00022\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u0003H\u0002J&\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\f\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0003H\u0002J.\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\f\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0003H\u0002J&\u00100\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\f\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0003H\u0002J$\u00101\u001a\u00020\u00022\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u0003H\u0002J$\u00102\u001a\u00020\u00022\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u00103\u001a\u00020*2\u0006\u0010\"\u001a\u00020\u0003H\u0002J.\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u00020*2\f\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0016\u00106\u001a\u00020\u00172\f\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!H\u0002J\u0018\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0003H\u0016J\u0018\u0010;\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\u0003H\u0016J\u0018\u0010<\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\u0006\u0010:\u001a\u00020\u0003H\u0016J\u0018\u0010=\u001a\u00020\u00022\u0006\u0010>\u001a\u00020?2\u0006\u0010:\u001a\u00020\u0003H\u0016J\u0010\u0010@\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030!H\u0002J\u0010\u0010A\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030%H\u0002J\u0014\u0010B\u001a\u00020\u0017*\u00020*2\u0006\u0010\"\u001a\u00020\u0003H\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$Visitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "inlineFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "inlineFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "inlinableParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Ljava/util/List;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;)V", "getInlinableParameters", "()Ljava/util/List;", "getInlineFunEffectiveVisibility", "()Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "getInlineFunction", "()Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "isEffectivelyPrivateApiFunction", "", "prohibitProtectedCallFromInline", "getReporter", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "checkArgumentsOfCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "targetSymbol", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "context", "checkPrivateClassMemberAccess", "calledDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "checkQualifiedAccess", "qualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "checkReceiver", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "receiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkReceiversOfQualifiedAccessExpression", "checkRecursion", "checkSuperCalls", "callExpression", "checkVisibilityAndAccess", "accessExpression", "isInvokeOrInlineExtension", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitFunctionCall", "visitQualifiedAccessExpression", "visitVariableAssignment", "variableAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "isDefinedInInlineFunction", "isInsidePrivateClass", "partOfCall", "checkers"})
    private static final class Visitor
    extends FirDefaultVisitor<Unit, CheckerContext> {
        @NotNull
        private final FirFunction<?> inlineFunction;
        @NotNull
        private final EffectiveVisibility inlineFunEffectiveVisibility;
        @NotNull
        private final List<FirValueParameter> inlinableParameters;
        @NotNull
        private final FirSession session;
        @NotNull
        private final DiagnosticReporter reporter;
        private final boolean isEffectivelyPrivateApiFunction;
        private final boolean prohibitProtectedCallFromInline;

        public Visitor(@NotNull FirFunction<?> inlineFunction2, @NotNull EffectiveVisibility inlineFunEffectiveVisibility, @NotNull List<? extends FirValueParameter> inlinableParameters, @NotNull FirSession session2, @NotNull DiagnosticReporter reporter2) {
            Intrinsics.checkNotNullParameter(inlineFunction2, (String)"inlineFunction");
            Intrinsics.checkNotNullParameter((Object)inlineFunEffectiveVisibility, (String)"inlineFunEffectiveVisibility");
            Intrinsics.checkNotNullParameter(inlinableParameters, (String)"inlinableParameters");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
            this.inlineFunction = inlineFunction2;
            this.inlineFunEffectiveVisibility = inlineFunEffectiveVisibility;
            this.inlinableParameters = inlinableParameters;
            this.session = session2;
            this.reporter = reporter2;
            this.isEffectivelyPrivateApiFunction = this.inlineFunEffectiveVisibility.getPrivateApi();
            this.prohibitProtectedCallFromInline = FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).supportsFeature(LanguageFeature.ProhibitProtectedCallFromInline);
        }

        @NotNull
        public final FirFunction<?> getInlineFunction() {
            return this.inlineFunction;
        }

        @NotNull
        public final EffectiveVisibility getInlineFunEffectiveVisibility() {
            return this.inlineFunEffectiveVisibility;
        }

        @NotNull
        public final List<FirValueParameter> getInlinableParameters() {
            return this.inlinableParameters;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull CheckerContext data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }

        @Override
        public void visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull CheckerContext data) {
            Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirCallableSymbol<?> targetSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(functionCall);
            if (targetSymbol != null) {
                this.checkReceiversOfQualifiedAccessExpression(functionCall, (AbstractFirBasedSymbol)targetSymbol, data);
                this.checkArgumentsOfCall(functionCall, (AbstractFirBasedSymbol)targetSymbol, data);
                this.checkQualifiedAccess(functionCall, (AbstractFirBasedSymbol)targetSymbol, data);
            }
        }

        @Override
        public void visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @NotNull CheckerContext data) {
            Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirCallableSymbol<?> targetSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(qualifiedAccessExpression);
            this.checkQualifiedAccess(qualifiedAccessExpression, (AbstractFirBasedSymbol)targetSymbol, data);
            this.checkReceiversOfQualifiedAccessExpression(qualifiedAccessExpression, (AbstractFirBasedSymbol)targetSymbol, data);
        }

        @Override
        public void visitVariableAssignment(@NotNull FirVariableAssignment variableAssignment, @NotNull CheckerContext data) {
            FirPropertySymbol firPropertySymbol;
            Intrinsics.checkNotNullParameter((Object)variableAssignment, (String)"variableAssignment");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirPropertyAccessorSymbol firPropertyAccessorSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(variableAssignment.getCalleeReference());
            FirPropertySymbol firPropertySymbol2 = firPropertySymbol = firPropertyAccessorSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)((Object)firPropertyAccessorSymbol) : null;
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol propertySymbol = firPropertySymbol;
            FirPropertyAccessor firPropertyAccessor = ((FirProperty)propertySymbol.getFir()).getSetter();
            FirPropertyAccessorSymbol firPropertyAccessorSymbol2 = firPropertyAccessorSymbol = firPropertyAccessor == null ? null : firPropertyAccessor.getSymbol();
            if (firPropertyAccessorSymbol == null) {
                return;
            }
            FirPropertyAccessorSymbol setterSymbol = firPropertyAccessorSymbol;
            this.checkQualifiedAccess(variableAssignment, setterSymbol, data);
        }

        private final void checkReceiversOfQualifiedAccessExpression(FirQualifiedAccessExpression qualifiedAccessExpression, AbstractFirBasedSymbol<?> targetSymbol, CheckerContext context2) {
            this.checkReceiver(qualifiedAccessExpression, qualifiedAccessExpression.getDispatchReceiver(), targetSymbol, context2);
            this.checkReceiver(qualifiedAccessExpression, qualifiedAccessExpression.getExtensionReceiver(), targetSymbol, context2);
        }

        private final void checkArgumentsOfCall(FirFunctionCall functionCall, AbstractFirBasedSymbol<?> targetSymbol, CheckerContext context2) {
            FirSimpleFunction firSimpleFunction;
            Object object = targetSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)targetSymbol : null;
            FirSimpleFunction firSimpleFunction2 = firSimpleFunction = object == null ? null : (FirSimpleFunction)((AbstractFirBasedSymbol)object).getFir();
            if (firSimpleFunction == null) {
                return;
            }
            FirSimpleFunction calledFunction = firSimpleFunction;
            FirCall $this$resolvedArgumentMapping$iv = functionCall;
            boolean $i$f$getResolvedArgumentMapping = false;
            Object argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            object = argumentList$iv instanceof FirResolvedArgumentList ? (Map)((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (object == null) {
                return;
            }
            FirNamedFunctionSymbol argumentMapping = object;
            Object object2 = argumentMapping;
            $i$f$getResolvedArgumentMapping = false;
            object = object2.entrySet().iterator();
            while (object.hasNext()) {
                FirDiagnosticFactory1<AbstractFirBasedSymbol<?>> firDiagnosticFactory1;
                FirValueParameter valueParameterOfOriginalInlineFunction;
                Object v2;
                FirExpression argument2;
                FirValueParameter valueParameter2;
                block8: {
                    FirVariableSymbol firVariableSymbol;
                    argumentList$iv = object2 = (Map.Entry)object.next();
                    boolean bl = false;
                    FirExpression wrappedArgument = (FirExpression)argumentList$iv.getKey();
                    Object object3 = object2;
                    boolean bl2 = false;
                    valueParameter2 = (FirValueParameter)object3.getValue();
                    argument2 = FirExpressionUtilKt.unwrapArgument(wrappedArgument);
                    FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(argument2);
                    FirVariableSymbol firVariableSymbol2 = firVariableSymbol = firCallableSymbol instanceof FirVariableSymbol ? (FirVariableSymbol)firCallableSymbol : null;
                    if (firVariableSymbol == null) continue;
                    FirVariableSymbol resolvedArgumentSymbol = firVariableSymbol;
                    Iterable $this$firstOrNull$iv = this.inlinableParameters;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FirValueParameter it = (FirValueParameter)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it, resolvedArgumentSymbol.getFir())) continue;
                        v2 = element$iv;
                        break block8;
                    }
                    v2 = null;
                }
                if ((valueParameterOfOriginalInlineFunction = (FirValueParameter)v2) == null) continue;
                FirMemberDeclaration $this$isInline$iv = calledFunction;
                boolean $i$f$isInline = false;
                if ($this$isInline$iv.getStatus().isInline()) {
                    if (valueParameter2.isNoinline()) {
                        firDiagnosticFactory1 = FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE();
                    } else {
                        if (!valueParameter2.isCrossinline() || valueParameterOfOriginalInlineFunction.isCrossinline()) continue;
                        firDiagnosticFactory1 = FirErrors.INSTANCE.getNON_LOCAL_RETURN_NOT_ALLOWED();
                    }
                } else {
                    firDiagnosticFactory1 = FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE();
                }
                FirDiagnosticFactory1<AbstractFirBasedSymbol<?>> factory2 = firDiagnosticFactory1;
                DiagnosticReporterKt.reportOn$default(this.reporter, argument2.getSource(), factory2, valueParameterOfOriginalInlineFunction.getSymbol(), context2, null, 16, null);
            }
        }

        private final void checkReceiver(FirQualifiedAccessExpression qualifiedAccessExpression, FirExpression receiverExpression, AbstractFirBasedSymbol<?> targetSymbol, CheckerContext context2) {
            FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(receiverExpression);
            if (firCallableSymbol == null) {
                return;
            }
            FirCallableSymbol<?> receiverSymbol = firCallableSymbol;
            if (CollectionsKt.contains((Iterable)this.inlinableParameters, receiverSymbol.getFir())) {
                FirValueParameter valueParameter2 = (FirValueParameter)receiverSymbol.getFir();
                if (!this.isInvokeOrInlineExtension(targetSymbol)) {
                    DiagnosticReporterKt.reportOn$default(this.reporter, qualifiedAccessExpression.getSource(), FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE(), valueParameter2.getSymbol(), context2, null, 16, null);
                }
            }
        }

        private final boolean isInvokeOrInlineExtension(AbstractFirBasedSymbol<?> targetSymbol) {
            ConeKotlinType coneKotlinType;
            if (!(targetSymbol instanceof FirNamedFunctionSymbol)) {
                return false;
            }
            FirSimpleFunction function2 = (FirSimpleFunction)((FirNamedFunctionSymbol)targetSymbol).getFir();
            FirMemberDeclaration $this$isInline$iv = function2;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getStatus().isInline()) {
                return true;
            }
            return Intrinsics.areEqual((Object)function2.getName(), (Object)OperatorNameConventions.INVOKE) && ((coneKotlinType = function2.getDispatchReceiverType()) == null ? false : InferenceUtilsKt.isBuiltinFunctionalType(coneKotlinType, this.session));
        }

        private final void checkQualifiedAccess(FirQualifiedAccess qualifiedAccess, AbstractFirBasedSymbol<?> targetSymbol, CheckerContext context2) {
            FirCallableMemberDeclaration targetFir;
            FirSourceElement firSourceElement = qualifiedAccess.getSource();
            if (firSourceElement == null) {
                return;
            }
            FirSourceElement source = firSourceElement;
            if (targetSymbol == null) {
                return;
            }
            Object obj = targetSymbol.getFir();
            FirCallableMemberDeclaration firCallableMemberDeclaration = targetFir = obj instanceof FirCallableMemberDeclaration ? (FirCallableMemberDeclaration)obj : null;
            if (CollectionsKt.contains((Iterable)this.inlinableParameters, targetSymbol.getFir()) && !this.partOfCall(qualifiedAccess, context2)) {
                FirValueParameter valueParameter2 = (FirValueParameter)targetSymbol.getFir();
                DiagnosticReporterKt.reportOn$default(this.reporter, source, FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE(), valueParameter2.getSymbol(), context2, null, 16, null);
            }
            this.checkVisibilityAndAccess(qualifiedAccess, targetFir, source, context2);
            this.checkRecursion(targetSymbol, source, context2);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean partOfCall(FirQualifiedAccess $this$partOfCall, CheckerContext context2) {
            boolean bl;
            block7: {
                void $this$any$iv;
                FirCall firCall;
                if (!($this$partOfCall instanceof FirExpression)) {
                    return false;
                }
                FirStatement firStatement = (FirStatement)CollectionsKt.getOrNull(context2.getQualifiedAccessOrAnnotationCalls(), (int)(context2.getQualifiedAccessOrAnnotationCalls().size() - 2));
                if (firStatement == null) {
                    return false;
                }
                FirStatement containingQualifiedAccess = firStatement;
                if (Intrinsics.areEqual((Object)$this$partOfCall, (Object)((firStatement = containingQualifiedAccess instanceof FirQualifiedAccess ? (FirQualifiedAccess)containingQualifiedAccess : null) == null ? null : firStatement.getExplicitReceiver()))) {
                    return true;
                }
                FirCall firCall2 = firCall = containingQualifiedAccess instanceof FirCall ? (FirCall)containingQualifiedAccess : null;
                if (firCall == null) {
                    return false;
                }
                FirCall call2 = firCall;
                Object $this$arguments$iv = call2;
                boolean $i$f$getArguments = false;
                $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirExpression it = (FirExpression)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)FirExpressionUtilKt.unwrapArgument(it), (Object)$this$partOfCall)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * Unable to fully structure code
         */
        private final void checkVisibilityAndAccess(FirQualifiedAccess accessExpression, FirCallableMemberDeclaration<?> calledDeclaration, FirSourceElement source, CheckerContext context) {
            if (calledDeclaration == null) {
                return;
            }
            var6_5 = FirStatusResolverKt.getPublishedApiEffectiveVisibility(calledDeclaration);
            if (var6_5 == null) {
                $this$effectiveVisibility$iv = calledDeclaration;
                $i$f$getEffectiveVisibility = false;
                var9_9 = $this$effectiveVisibility$iv.getStatus();
                var10_14 = var9_9 instanceof FirResolvedDeclarationStatus != false ? (FirResolvedDeclarationStatus)var9_9 : null;
                v0 = var11_17 = var10_14 == null ? null : var10_14.getEffectiveVisibility();
                if (var11_17 == null) {
                    var10_14 = "Effective visibility for " + FirRendererKt.render((FirElement)$this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
                    var9_10 = false;
                    throw (Throwable)new IllegalStateException(var10_14.toString());
                }
                v1 = var11_17;
            } else {
                v1 = var6_5;
            }
            recordedEffectiveVisibility = v1;
            $this$effectiveVisibility$iv = recordedEffectiveVisibility;
            $i$f$getEffectiveVisibility = false;
            var9_11 = false;
            it = $this$effectiveVisibility$iv;
            $i$a$-let-FirInlineDeclarationChecker$Visitor$checkVisibilityAndAccess$calledFunEffectiveVisibility$1 = false;
            calledFunEffectiveVisibility = Intrinsics.areEqual((Object)it, (Object)EffectiveVisibility.Local.INSTANCE) ? (EffectiveVisibility)EffectiveVisibility.Public.INSTANCE : it;
            isCalledFunPublicOrPublishedApi = calledFunEffectiveVisibility.getPublicApi();
            isInlineFunPublicOrPublishedApi = this.inlineFunEffectiveVisibility.getPublicApi();
            if (!isInlineFunPublicOrPublishedApi || isCalledFunPublicOrPublishedApi) ** GOTO lbl-1000
            $this$visibility$iv = calledDeclaration;
            $i$f$getVisibility = false;
            if ($this$visibility$iv.getStatus().getVisibility() != Visibilities.Local.INSTANCE) {
                DiagnosticReporterKt.reportOn$default(this.reporter, source, FirErrors.INSTANCE.getNON_PUBLIC_CALL_FROM_PUBLIC_INLINE(), calledDeclaration.getSymbol(), this.inlineFunction.getSymbol(), context, null, 32, null);
            } else lbl-1000:
            // 2 sources

            {
                this.checkPrivateClassMemberAccess(calledDeclaration, source, context);
                if (isInlineFunPublicOrPublishedApi) {
                    this.checkSuperCalls(calledDeclaration, accessExpression, context);
                }
            }
            isConstructorCall = calledDeclaration instanceof FirConstructor;
            if (isInlineFunPublicOrPublishedApi && this.inlineFunEffectiveVisibility.toVisibility() != Visibilities.Protected.INSTANCE && calledFunEffectiveVisibility.toVisibility() == Visibilities.Protected.INSTANCE) {
                factory = isConstructorCall != false ? FirErrors.INSTANCE.getPROTECTED_CONSTRUCTOR_CALL_FROM_PUBLIC_INLINE() : (this.prohibitProtectedCallFromInline != false ? FirErrors.INSTANCE.getPROTECTED_CALL_FROM_PUBLIC_INLINE_ERROR() : FirErrors.INSTANCE.getPROTECTED_CALL_FROM_PUBLIC_INLINE());
                DiagnosticReporterKt.reportOn$default(this.reporter, source, factory, calledDeclaration.getSymbol(), this.inlineFunction.getSymbol(), context, null, 32, null);
            }
        }

        private final void checkPrivateClassMemberAccess(FirCallableMemberDeclaration<?> calledDeclaration, FirSourceElement source, CheckerContext context2) {
            if (!this.isEffectivelyPrivateApiFunction && this.isInsidePrivateClass(calledDeclaration)) {
                DiagnosticReporterKt.reportOn$default(this.reporter, source, FirErrors.INSTANCE.getPRIVATE_CLASS_MEMBER_FROM_INLINE(), calledDeclaration.getSymbol(), this.inlineFunction.getSymbol(), context2, null, 32, null);
            }
        }

        private final void checkSuperCalls(FirCallableMemberDeclaration<?> calledDeclaration, FirQualifiedAccess callExpression, CheckerContext context2) {
            FirQualifiedAccessExpression firQualifiedAccessExpression;
            FirExpression firExpression2 = callExpression.getDispatchReceiver();
            FirQualifiedAccessExpression firQualifiedAccessExpression2 = firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
            if (firQualifiedAccessExpression == null) {
                return;
            }
            FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
            if (receiver.getCalleeReference() instanceof FirSuperReference) {
                ConeKotlinType dispatchReceiverType = FirTypeUtilsKt.getConeType(receiver.getDispatchReceiver().getTypeRef());
                AbstractFirBasedSymbol<?> abstractFirBasedSymbol = TypeUtilsKt.toSymbol(dispatchReceiverType, this.session);
                if (abstractFirBasedSymbol == null) {
                    return;
                }
                AbstractFirBasedSymbol<?> classSymbol = abstractFirBasedSymbol;
                if (!this.isDefinedInInlineFunction(classSymbol)) {
                    DiagnosticReporterKt.reportOn$default(this.reporter, callExpression.getDispatchReceiver().getSource(), FirErrors.INSTANCE.getSUPER_CALL_FROM_PUBLIC_INLINE(), calledDeclaration.getSymbol(), context2, null, 16, null);
                }
            }
        }

        private final boolean isDefinedInInlineFunction(AbstractFirBasedSymbol<?> $this$isDefinedInInlineFunction) {
            boolean bl;
            Object fir = $this$isDefinedInInlineFunction.getFir();
            if (fir instanceof FirAnonymousFunction) {
                bl = true;
            } else if (fir instanceof FirMemberDeclaration) {
                bl = FirDeclarationCheckerUtilsKt.isLocalMember((FirDeclaration)fir);
            } else if (fir instanceof FirAnonymousObject) {
                bl = true;
            } else if (fir instanceof FirRegularClass) {
                bl = FirDeclarationUtilKt.getClassId((FirClass)fir).isLocal();
            } else {
                String string2 = Intrinsics.stringPlus((String)"Unknown callable declaration type: ", (Object)FirRendererKt.render$default((FirElement)fir, null, 1, null));
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return bl;
        }

        private final void checkRecursion(AbstractFirBasedSymbol<?> targetSymbol, FirSourceElement source, CheckerContext context2) {
            if (Intrinsics.areEqual(targetSymbol, this.inlineFunction.getSymbol())) {
                DiagnosticReporterKt.reportOn$default(this.reporter, source, FirErrors.INSTANCE.getRECURSION_IN_INLINE(), targetSymbol, context2, null, 16, null);
            }
        }

        private final boolean isInsidePrivateClass(FirCallableMemberDeclaration<?> $this$isInsidePrivateClass) {
            Visibility visibility2;
            boolean $i$f$getVisibility;
            FirMemberDeclaration $this$visibility$iv;
            FirClassLikeSymbol<?> firClassLikeSymbol;
            FirClassLikeDeclaration firClassLikeDeclaration;
            Object object = ClassMembersKt.containingClass($this$isInsidePrivateClass);
            FirClassLikeDeclaration firClassLikeDeclaration2 = object == null ? null : (firClassLikeDeclaration = (firClassLikeSymbol = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, this.session)) == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir());
            if (firClassLikeDeclaration == null) {
                return false;
            }
            FirClassLikeDeclaration containingClass = firClassLikeDeclaration;
            object = containingClass;
            if (object instanceof FirAnonymousObject) {
                return false;
            }
            if (object instanceof FirRegularClass) {
                $this$visibility$iv = (FirMemberDeclaration)((Object)containingClass);
                $i$f$getVisibility = false;
                visibility2 = $this$visibility$iv.getStatus().getVisibility();
            } else if (object instanceof FirTypeAlias) {
                $this$visibility$iv = (FirMemberDeclaration)((Object)containingClass);
                $i$f$getVisibility = false;
                visibility2 = $this$visibility$iv.getStatus().getVisibility();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Visibility containingClassVisibility = visibility2;
            return Intrinsics.areEqual((Object)containingClassVisibility, (Object)Visibilities.Private.INSTANCE) || Intrinsics.areEqual((Object)containingClassVisibility, (Object)Visibilities.PrivateToThis.INSTANCE);
        }
    }
}

