/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.SimpleInstruction;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/EnumValueOf;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "canHandleFunctionWithName", "", "fqName", "", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "evaluate", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getEnumClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getEnumEntryByName", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "unwind", "", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "ir.interpreter"})
public final class EnumValueOf
extends IntrinsicBase {
    @NotNull
    public static final EnumValueOf INSTANCE = new EnumValueOf();

    private EnumValueOf() {
        super(null);
    }

    @Override
    public boolean canHandleFunctionWithName(@NotNull String fqName2, @NotNull IrDeclarationOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        return Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.enumValueOf");
    }

    private final IrClass getEnumClass(IrFunction irFunction2, IrInterpreterEnvironment environment2) {
        IrClass irClass2;
        String string2 = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(irFunction2));
        if (Intrinsics.areEqual((Object)string2, (Object)"kotlin.enumValueOf")) {
            KTypeState kType = (KTypeState)environment2.getCallStack().getState(((IrTypeParameter)CollectionsKt.first(irFunction2.getTypeParameters())).getSymbol());
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(kType.getIrType());
            Intrinsics.checkNotNull((Object)irClassSymbol);
            irClass2 = (IrClass)irClassSymbol.getOwner();
        } else {
            irClass2 = (IrClass)irFunction2.getParent();
        }
        return irClass2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrEnumEntry getEnumEntryByName(IrFunction irFunction2, IrInterpreterEnvironment environment2) {
        Object v0;
        String enumEntryName;
        IrClass enumClass2;
        block4: {
            void $this$singleOrNull$iv;
            void $this$filterIsInstanceTo$iv$iv;
            enumClass2 = this.getEnumClass(irFunction2, environment2);
            enumEntryName = StateKt.asString(environment2.getCallStack().getState(((IrValueParameter)CollectionsKt.first(irFunction2.getValueParameters())).getSymbol()));
            Iterable $this$filterIsInstance$iv = enumClass2.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrEnumEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrEnumEntry it = (IrEnumEntry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)enumEntryName)) continue;
                if (found$iv) {
                    v0 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        IrEnumEntry enumEntry = v0;
        if (enumEntry == null) {
            UtilsKt.handleUserException(new IllegalArgumentException("No enum constant " + IrUtilsKt.getFqNameWhenAvailable(enumClass2) + '.' + enumEntryName), environment2);
        }
        return enumEntry;
    }

    @Override
    @NotNull
    public List<Instruction> unwind(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Object[] objectArray = this.getEnumEntryByName(irFunction2, environment2);
        if (objectArray == null) {
            return CollectionsKt.emptyList();
        }
        Object[] enumEntry = objectArray;
        objectArray = new Instruction[]{this.customEvaluateInstruction(irFunction2, environment2), new SimpleInstruction((IrElement)enumEntry)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void evaluate(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        IrEnumEntry irEnumEntry = this.getEnumEntryByName(irFunction2, environment2);
        Intrinsics.checkNotNull((Object)irEnumEntry);
        IrEnumEntry enumEntry = irEnumEntry;
        CallStack callStack = environment2.getCallStack();
        Complex complex = environment2.getMapOfEnums().get(enumEntry.getSymbol());
        Intrinsics.checkNotNull((Object)complex);
        callStack.pushState(complex);
    }
}

