/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.runtime.structure;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function10;
import kotlin.jvm.functions.Function11;
import kotlin.jvm.functions.Function12;
import kotlin.jvm.functions.Function13;
import kotlin.jvm.functions.Function14;
import kotlin.jvm.functions.Function15;
import kotlin.jvm.functions.Function16;
import kotlin.jvm.functions.Function17;
import kotlin.jvm.functions.Function18;
import kotlin.jvm.functions.Function19;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function20;
import kotlin.jvm.functions.Function21;
import kotlin.jvm.functions.Function22;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.functions.Function8;
import kotlin.jvm.functions.Function9;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectClassUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010#\u001a\u00020$*\u0006\u0012\u0002\b\u00030\u0002\"&\u0010\u0000\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\",\u0010\t\u001a \u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u0002\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\",\u0010\n\u001a \u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0002\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u000b\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0019\u0010\u000f\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u001b\u0010\u0013\u001a\u0004\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0006*\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\"\u001f\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u0019\u0010\u001d\u001a\u00020\u001e*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u001f\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001c\u00a8\u0006%"}, d2={"FUNCTION_CLASSES", "", "Ljava/lang/Class;", "Lkotlin/Function;", "", "PRIMITIVE_CLASSES", "", "Lkotlin/reflect/KClass;", "", "PRIMITIVE_TO_WRAPPER", "WRAPPER_TO_PRIMITIVE", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassId", "(Ljava/lang/Class;)Lorg/jetbrains/kotlin/name/ClassId;", "desc", "", "getDesc", "(Ljava/lang/Class;)Ljava/lang/String;", "functionClassArity", "getFunctionClassArity", "(Ljava/lang/Class;)Ljava/lang/Integer;", "parameterizedTypeArguments", "Ljava/lang/reflect/Type;", "getParameterizedTypeArguments", "(Ljava/lang/reflect/Type;)Ljava/util/List;", "primitiveByWrapper", "getPrimitiveByWrapper", "(Ljava/lang/Class;)Ljava/lang/Class;", "safeClassLoader", "Ljava/lang/ClassLoader;", "getSafeClassLoader", "(Ljava/lang/Class;)Ljava/lang/ClassLoader;", "wrapperByPrimitive", "getWrapperByPrimitive", "isEnumClassOrSpecializedEnumEntryClass", "", "descriptors.runtime"})
public final class ReflectClassUtilKt {
    @NotNull
    private static final List<KClass<? extends Object>> PRIMITIVE_CLASSES;
    @NotNull
    private static final Map<Class<? extends Object>, Class<? extends Object>> WRAPPER_TO_PRIMITIVE;
    @NotNull
    private static final Map<Class<? extends Object>, Class<? extends Object>> PRIMITIVE_TO_WRAPPER;
    @NotNull
    private static final Map<Class<? extends Function<?>>, Integer> FUNCTION_CLASSES;

    @NotNull
    public static final ClassLoader getSafeClassLoader(@NotNull Class<?> $this$safeClassLoader) {
        ClassLoader classLoader2;
        Intrinsics.checkNotNullParameter($this$safeClassLoader, (String)"<this>");
        ClassLoader classLoader3 = $this$safeClassLoader.getClassLoader();
        if (classLoader3 == null) {
            ClassLoader classLoader4 = ClassLoader.getSystemClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader4, (String)"getSystemClassLoader()");
            classLoader2 = classLoader4;
        } else {
            classLoader2 = classLoader3;
        }
        return classLoader2;
    }

    public static final boolean isEnumClassOrSpecializedEnumEntryClass(@NotNull Class<?> $this$isEnumClassOrSpecializedEnumEntryClass) {
        Intrinsics.checkNotNullParameter($this$isEnumClassOrSpecializedEnumEntryClass, (String)"<this>");
        return Enum.class.isAssignableFrom($this$isEnumClassOrSpecializedEnumEntryClass);
    }

    @Nullable
    public static final Class<?> getPrimitiveByWrapper(@NotNull Class<?> $this$primitiveByWrapper) {
        Intrinsics.checkNotNullParameter($this$primitiveByWrapper, (String)"<this>");
        return WRAPPER_TO_PRIMITIVE.get($this$primitiveByWrapper);
    }

    @Nullable
    public static final Class<?> getWrapperByPrimitive(@NotNull Class<?> $this$wrapperByPrimitive) {
        Intrinsics.checkNotNullParameter($this$wrapperByPrimitive, (String)"<this>");
        return PRIMITIVE_TO_WRAPPER.get($this$wrapperByPrimitive);
    }

    @Nullable
    public static final Integer getFunctionClassArity(@NotNull Class<?> $this$functionClassArity) {
        Intrinsics.checkNotNullParameter($this$functionClassArity, (String)"<this>");
        Map<Class<Function<?>>, Integer> map = FUNCTION_CLASSES;
        boolean bl = false;
        return map.get($this$functionClassArity);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final ClassId getClassId(@NotNull Class<?> $this$classId) {
        ClassId classId;
        Object object;
        CharSequence charSequence;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter($this$classId, (String)"<this>");
                if ($this$classId.isPrimitive()) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can't compute ClassId for primitive type: ", $this$classId));
                }
                if ($this$classId.isArray()) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can't compute ClassId for array type: ", $this$classId));
                }
                if ($this$classId.getEnclosingMethod() != null || $this$classId.getEnclosingConstructor() != null) break block7;
                charSequence = $this$classId.getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"simpleName");
                charSequence = charSequence;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block8;
            }
            FqName fqName2 = new FqName($this$classId.getName());
            object = new ClassId(fqName2.parent(), FqName.topLevel(fqName2.shortName()), true);
            return object;
        }
        Class<?> clazz = $this$classId.getDeclaringClass();
        if (clazz == null) {
            classId = null;
        } else {
            ClassId classId2 = ReflectClassUtilKt.getClassId(clazz);
            classId = classId2.createNestedClassId(Name.identifier($this$classId.getSimpleName()));
        }
        ClassId classId3 = classId;
        charSequence = classId3 == null ? ClassId.topLevel(new FqName($this$classId.getName())) : classId3;
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"declaringClass?.classId?\u2026Id.topLevel(FqName(name))");
        object = charSequence;
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final String getDesc(@NotNull Class<?> $this$desc) {
        String string2;
        block33: {
            Intrinsics.checkNotNullParameter($this$desc, (String)"<this>");
            if (!$this$desc.isPrimitive()) break block33;
            String string3 = $this$desc.getName();
            if (string3 == null) throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unsupported primitive type: ", $this$desc));
            int n = -1;
            switch (string3.hashCode()) {
                case 64711720: {
                    if (string3.equals("boolean")) {
                        n = 1;
                    }
                    break;
                }
                case 3625364: {
                    if (string3.equals("void")) {
                        n = 2;
                    }
                    break;
                }
                case 3039496: {
                    if (string3.equals("byte")) {
                        n = 3;
                    }
                    break;
                }
                case -1325958191: {
                    if (string3.equals("double")) {
                        n = 4;
                    }
                    break;
                }
                case 3052374: {
                    if (string3.equals("char")) {
                        n = 5;
                    }
                    break;
                }
                case 109413500: {
                    if (string3.equals("short")) {
                        n = 6;
                    }
                    break;
                }
                case 97526364: {
                    if (string3.equals("float")) {
                        n = 7;
                    }
                    break;
                }
                case 104431: {
                    if (string3.equals("int")) {
                        n = 8;
                    }
                    break;
                }
                case 3327612: {
                    if (string3.equals("long")) {
                        n = 9;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    return "Z";
                }
                case 5: {
                    return "C";
                }
                case 3: {
                    return "B";
                }
                case 6: {
                    return "S";
                }
                case 8: {
                    return "I";
                }
                case 7: {
                    return "F";
                }
                case 9: {
                    return "J";
                }
                case 4: {
                    return "D";
                }
                case 2: {
                    return "V";
                }
                default: {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unsupported primitive type: ", $this$desc));
                }
            }
        }
        if ($this$desc.isArray()) {
            String string4 = $this$desc.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name");
            string2 = StringsKt.replace$default((String)string4, (char)'.', (char)'/', (boolean)false, (int)4, null);
            return string2;
        } else {
            StringBuilder stringBuilder2 = new StringBuilder().append('L');
            String string5 = $this$desc.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"name");
            string2 = stringBuilder2.append(StringsKt.replace$default((String)string5, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(';').toString();
        }
        return string2;
    }

    @NotNull
    public static final List<Type> getParameterizedTypeArguments(@NotNull Type $this$parameterizedTypeArguments) {
        Intrinsics.checkNotNullParameter((Object)$this$parameterizedTypeArguments, (String)"<this>");
        if (!($this$parameterizedTypeArguments instanceof ParameterizedType)) {
            return CollectionsKt.emptyList();
        }
        if (((ParameterizedType)$this$parameterizedTypeArguments).getOwnerType() == null) {
            Type[] typeArray = ((ParameterizedType)$this$parameterizedTypeArguments).getActualTypeArguments();
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"actualTypeArguments");
            return ArraysKt.toList((Object[])typeArray);
        }
        return SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.generateSequence((Object)$this$parameterizedTypeArguments, (Function1)parameterizedTypeArguments.1.INSTANCE), (Function1)parameterizedTypeArguments.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapIndexedTo$iv$iv;
        Pair pair;
        KClass it;
        boolean bl;
        Collection collection;
        Object $this$mapTo$iv$iv;
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(Boolean.TYPE), Reflection.getOrCreateKotlinClass(Byte.TYPE), Reflection.getOrCreateKotlinClass(Character.TYPE), Reflection.getOrCreateKotlinClass(Double.TYPE), Reflection.getOrCreateKotlinClass(Float.TYPE), Reflection.getOrCreateKotlinClass(Integer.TYPE), Reflection.getOrCreateKotlinClass(Long.TYPE), Reflection.getOrCreateKotlinClass(Short.TYPE)};
        PRIMITIVE_CLASSES = CollectionsKt.listOf((Object[])objectArray);
        Object[] $this$map$iv = (Object[])PRIMITIVE_CLASSES;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            KClass kClass2 = (KClass)t;
            collection = destination$iv$iv;
            bl = false;
            pair = TuplesKt.to((Object)JvmClassMappingKt.getJavaObjectType((KClass)it), (Object)JvmClassMappingKt.getJavaPrimitiveType((KClass)it));
            collection.add(pair);
        }
        WRAPPER_TO_PRIMITIVE = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        $this$map$iv = PRIMITIVE_CLASSES;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (KClass)t;
            collection = destination$iv$iv;
            bl = false;
            pair = TuplesKt.to((Object)JvmClassMappingKt.getJavaPrimitiveType((KClass)it), (Object)JvmClassMappingKt.getJavaObjectType((KClass)it));
            collection.add(pair);
        }
        PRIMITIVE_TO_WRAPPER = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        $this$map$iv = new Class[]{Function0.class, Function1.class, Function2.class, Function3.class, Function4.class, Function5.class, Function6.class, Function7.class, Function8.class, Function9.class, Function10.class, Function11.class, Function12.class, Function13.class, Function14.class, Function15.class, Function16.class, Function17.class, Function18.class, Function19.class, Function20.class, Function21.class, Function22.class};
        Iterable $this$mapIndexed$iv = CollectionsKt.listOf((Object[])$this$map$iv);
        boolean $i$f$mapIndexed = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void clazz;
            int n = index$iv$iv++;
            boolean bl2 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Class clazz2 = (Class)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl22 = false;
            pair = TuplesKt.to((Object)clazz, (Object)((int)i));
            collection.add(pair);
        }
        FUNCTION_CLASSES = MapsKt.toMap((Iterable)((List)var3_3));
    }
}

