/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.PrivateForInline;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeUnexpectedTypeArgumentsError;
import org.jetbrains.kotlin.fir.resolve.FirTypeResolver;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J%\u0010&\u001a\u0002H'\"\u0004\b\u0000\u0010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J:\u0010+\u001a\u0002H'\"\u0004\b\u0000\u0010'2\b\u0010,\u001a\u0004\u0018\u00010\u000f2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H'0-\u00a2\u0006\u0002\b.H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J\u000e\u00100\u001a\u0004\u0018\u00010$*\u00020$H\u0002R$\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "errorTypeAsResolved", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Z)V", "<set-?>", "areBareTypesAllowed", "getAreBareTypesAllowed", "()Z", "setAreBareTypesAllowed", "(Z)V", "currentFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getCurrentFile$annotations", "()V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "typeResolver", "Lorg/jetbrains/kotlin/fir/resolve/FirTypeResolver;", "transformFunctionTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "functionTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "data", "transformImplicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "implicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirImplicitTypeRef;", "transformResolvedTypeRef", "resolvedTypeRef", "transformType", "typeRef", "resolvedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "transformTypeRef", "withAllowedBareTypes", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withFile", "file", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "takeIfAcceptable", "resolve"})
public final class FirSpecificTypeResolverTransformer
extends FirAbstractTreeTransformer<FirScope> {
    @NotNull
    private final FirSession session;
    private final boolean errorTypeAsResolved;
    @NotNull
    private final FirTypeResolver typeResolver;
    private boolean areBareTypesAllowed;
    @JvmField
    @Nullable
    public FirFile currentFile;

    public FirSpecificTypeResolverTransformer(@NotNull FirSession session2, boolean errorTypeAsResolved) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        super(FirResolvePhase.SUPER_TYPES);
        this.session = session2;
        this.errorTypeAsResolved = errorTypeAsResolved;
        this.typeResolver = MainSessionComponentsKt.getTypeResolver(this.getSession());
    }

    public /* synthetic */ FirSpecificTypeResolverTransformer(FirSession firSession, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(firSession, bl);
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    public final boolean getAreBareTypesAllowed() {
        return this.areBareTypesAllowed;
    }

    @PrivateForInline
    public final void setAreBareTypesAllowed(boolean bl) {
        this.areBareTypesAllowed = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R withAllowedBareTypes(@NotNull Function0<? extends R> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withAllowedBareTypes = false;
        boolean oldValue = this.getAreBareTypesAllowed();
        this.setAreBareTypesAllowed(true);
        try {
            object = block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.setAreBareTypesAllowed(oldValue);
            InlineMarker.finallyEnd((int)1);
        }
        return (R)object;
    }

    @PrivateForInline
    public static /* synthetic */ void getCurrentFile$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R withFile(@Nullable FirFile file2, @NotNull Function1<? super FirSpecificTypeResolverTransformer, ? extends R> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withFile = false;
        FirFile oldValue = this.currentFile;
        this.currentFile = file2;
        try {
            object = block.invoke((Object)this);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.currentFile = oldValue;
            InlineMarker.finallyEnd((int)1);
        }
        return (R)object;
    }

    @NotNull
    public FirResolvedTypeRef transformTypeRef(@NotNull FirTypeRef typeRef, @NotNull FirScope data) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
        if (firLookupTrackerComponent != null) {
            FirFile firFile;
            FirLookupTrackerComponentKt.recordTypeLookup(firLookupTrackerComponent, typeRef, data.getScopeOwnerLookupNames(), (firFile = this.currentFile) == null ? null : firFile.getSource());
        }
        typeRef.transformChildren(this, data);
        return this.transformType(typeRef, this.typeResolver.resolveType(typeRef, data, this.areBareTypesAllowed));
    }

    @NotNull
    public FirResolvedTypeRef transformFunctionTypeRef(@NotNull FirFunctionTypeRef functionTypeRef, @NotNull FirScope data) {
        FirResolvedTypeRef firResolvedTypeRef;
        Intrinsics.checkNotNullParameter((Object)functionTypeRef, (String)"functionTypeRef");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        functionTypeRef.transformChildren(this, data);
        FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
        if (firLookupTrackerComponent != null) {
            FirFile firFile;
            FirLookupTrackerComponentKt.recordTypeLookup(firLookupTrackerComponent, functionTypeRef, data.getScopeOwnerLookupNames(), (firFile = this.currentFile) == null ? null : firFile.getSource());
        }
        ConeKotlinType resolvedType = this.takeIfAcceptable(this.typeResolver.resolveType(functionTypeRef, data, this.areBareTypesAllowed));
        if (resolvedType != null && !(resolvedType instanceof ConeClassErrorType)) {
            boolean $i$f$buildResolvedTypeRef = false;
            boolean bl = false;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            FirResolvedTypeRefBuilder $this$transformFunctionTypeRef_u24lambda_u2d0 = firResolvedTypeRefBuilder;
            boolean bl4 = false;
            $this$transformFunctionTypeRef_u24lambda_u2d0.setSource(functionTypeRef.getSource());
            $this$transformFunctionTypeRef_u24lambda_u2d0.setType(resolvedType);
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = $this$transformFunctionTypeRef_u24lambda_u2d0;
            Collection collection = firResolvedTypeRefBuilder2.getAnnotations();
            Iterable iterable = functionTypeRef.getAnnotations();
            boolean bl5 = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            $this$transformFunctionTypeRef_u24lambda_u2d0.setDelegatedTypeRef(functionTypeRef);
            firResolvedTypeRef = firResolvedTypeRefBuilder.build();
        } else {
            boolean $i$f$buildErrorTypeRef = false;
            boolean bl = false;
            FirErrorTypeRefBuilder firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
            boolean bl6 = false;
            boolean bl7 = false;
            FirErrorTypeRefBuilder $this$transformFunctionTypeRef_u24lambda_u2d1 = firErrorTypeRefBuilder;
            boolean bl8 = false;
            $this$transformFunctionTypeRef_u24lambda_u2d1.setSource(functionTypeRef.getSource());
            ConeClassErrorType coneClassErrorType = resolvedType instanceof ConeClassErrorType ? (ConeClassErrorType)resolvedType : null;
            ConeDiagnostic coneDiagnostic = coneClassErrorType == null ? null : coneClassErrorType.getDiagnostic();
            $this$transformFunctionTypeRef_u24lambda_u2d1.setDiagnostic(coneDiagnostic == null ? (ConeDiagnostic)new ConeSimpleDiagnostic(Intrinsics.stringPlus((String)"Unresolved functional type: ", (Object)FirRendererKt.render$default(functionTypeRef, null, 1, null)), null, 2, null) : coneDiagnostic);
            firResolvedTypeRef = firErrorTypeRefBuilder.build();
        }
        return firResolvedTypeRef;
    }

    private final FirResolvedTypeRef transformType(FirTypeRef typeRef, ConeKotlinType resolvedType) {
        FirResolvedTypeRef firResolvedTypeRef;
        if (!(resolvedType instanceof ConeClassErrorType)) {
            boolean $i$f$buildResolvedTypeRef = false;
            boolean bl = false;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            FirResolvedTypeRefBuilder $this$transformType_u24lambda_u2d2 = firResolvedTypeRefBuilder;
            boolean bl4 = false;
            $this$transformType_u24lambda_u2d2.setSource(typeRef.getSource());
            $this$transformType_u24lambda_u2d2.setType(resolvedType);
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = $this$transformType_u24lambda_u2d2;
            Collection collection = firResolvedTypeRefBuilder2.getAnnotations();
            Iterable iterable = typeRef.getAnnotations();
            boolean bl5 = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            $this$transformType_u24lambda_u2d2.setDelegatedTypeRef(typeRef);
            firResolvedTypeRef = firResolvedTypeRefBuilder.build();
        } else {
            FirSourceElement diagnosticSource;
            ConeUnexpectedTypeArgumentsError coneUnexpectedTypeArgumentsError;
            boolean $i$f$buildErrorTypeRef = false;
            boolean bl = false;
            FirErrorTypeRefBuilder firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
            boolean bl6 = false;
            boolean bl7 = false;
            FirErrorTypeRefBuilder $this$transformType_u24lambda_u2d3 = firErrorTypeRefBuilder;
            boolean bl8 = false;
            FirSourceElement firSourceElement = typeRef.getSource();
            FirSourceElementKind typeRefSourceKind = firSourceElement == null ? null : firSourceElement.getKind();
            ConeDiagnostic $this$safeAs$iv = ((ConeClassErrorType)resolvedType).getDiagnostic();
            boolean $i$f$safeAs = false;
            ConeDiagnostic coneDiagnostic = $this$safeAs$iv;
            if (!(coneDiagnostic instanceof ConeUnexpectedTypeArgumentsError)) {
                coneDiagnostic = null;
            }
            Object $this$safeAs$iv2 = (coneUnexpectedTypeArgumentsError = (ConeUnexpectedTypeArgumentsError)coneDiagnostic) == null ? null : coneUnexpectedTypeArgumentsError.getSource();
            boolean $i$f$safeAs2 = false;
            Object object = $this$safeAs$iv2;
            if (!(object instanceof FirSourceElement)) {
                object = null;
            }
            $this$transformType_u24lambda_u2d3.setSource((diagnosticSource = (FirSourceElement)object) != null ? (typeRefSourceKind instanceof FirFakeSourceElementKind ? FirSourceElementKt.fakeElement(diagnosticSource, (FirFakeSourceElementKind)typeRefSourceKind) : diagnosticSource) : typeRef.getSource());
            $this$transformType_u24lambda_u2d3.setDelegatedTypeRef(typeRef);
            $this$transformType_u24lambda_u2d3.setDiagnostic(((ConeClassErrorType)resolvedType).getDiagnostic());
            firResolvedTypeRef = firErrorTypeRefBuilder.build();
        }
        return firResolvedTypeRef;
    }

    private final ConeKotlinType takeIfAcceptable(ConeKotlinType $this$takeIfAcceptable) {
        ConeKotlinType coneKotlinType = $this$takeIfAcceptable;
        boolean bl = false;
        boolean bl2 = false;
        ConeKotlinType it = coneKotlinType;
        boolean bl3 = false;
        return !(!this.errorTypeAsResolved && it instanceof ConeClassErrorType) ? coneKotlinType : null;
    }

    @Override
    @NotNull
    public FirTypeRef transformResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull FirScope data) {
        Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return resolvedTypeRef;
    }

    @Override
    @NotNull
    public FirTypeRef transformImplicitTypeRef(@NotNull FirImplicitTypeRef implicitTypeRef, @NotNull FirScope data) {
        Intrinsics.checkNotNullParameter((Object)implicitTypeRef, (String)"implicitTypeRef");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return implicitTypeRef;
    }
}

