/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js.ast;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsClassModel;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDebugger;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsDocComment;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameBinding;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsRegExp;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.LocalAlias;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.serialization.js.ast.JsAstProtoBuf;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012 \u0010\u0002\u001a\u001c\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010 \u001a\u00020$2\u0006\u0010\"\u001a\u00020%H\u0002J\u0010\u0010 \u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010 \u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u000bH\u0002J\u0010\u0010,\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u0010,\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0010\u0010,\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0010\u0010,\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u0006H\u0002J\u000e\u0010,\u001a\u0002082\u0006\u00109\u001a\u00020\u0004J\u0016\u0010,\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020;J\u0010\u0010,\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010,\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020G2\u0006\u00109\u001a\u00020\u0004H\u0002J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0002J\u0018\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0002J\u0010\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0002JG\u0010V\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070\t2\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020\u00070\t2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00070[H\u0082\bR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0002\u001a\u001c\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u0016*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lorg/jetbrains/kotlin/serialization/js/ast/JsAstSerializer;", "", "jsAstValidator", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "", "pathResolver", "Lkotlin/Function1;", "Ljava/io/File;", "", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "fileStack", "Ljava/util/Deque;", "importedNames", "", "nameMap", "", "", "nameTableBuilder", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$NameTable$Builder;", "kotlin.jvm.PlatformType", "stringMap", "stringTableBuilder", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$StringTable$Builder;", "extractLocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "element", "Lcom/intellij/psi/PsiElement;", "node", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "map", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$BinaryOperation$Type;", "op", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperator;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$UnaryOperation$Type;", "Lorg/jetbrains/kotlin/js/backend/ast/JsUnaryOperator;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$SideEffects;", "sideEffects", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/SideEffectKind;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$SpecialFunction;", "specialFunction", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/SpecialFunction;", "serialize", "string", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$ClassModel;", "classModel", "Lorg/jetbrains/kotlin/js/backend/ast/JsClassModel;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Expression;", "expression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$JsImportedModule;", "module", "Lorg/jetbrains/kotlin/js/backend/ast/JsImportedModule;", "name", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Chunk;", "fragment", "output", "Ljava/io/OutputStream;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Statement;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$LocalAlias;", "alias", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/LocalAlias;", "serializeBlock", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$GlobalBlock;", "block", "Lorg/jetbrains/kotlin/js/backend/ast/JsGlobalBlock;", "serializeFragment", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Fragment;", "serializeParameter", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Parameter;", "parameter", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "serializeUnary", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$UnaryOperation;", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsUnaryOperation;", "postfix", "", "serializeVars", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Vars;", "vars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "withLocation", "fileConsumer", "locationConsumer", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Location;", "inner", "Lkotlin/Function0;", "js.serializer"})
public final class JsAstSerializer {
    @Nullable
    private final Function2<JsProgramFragment, Set<? extends JsName>, Unit> jsAstValidator;
    @NotNull
    private final Function1<File, String> pathResolver;
    private final JsAstProtoBuf.NameTable.Builder nameTableBuilder;
    private final JsAstProtoBuf.StringTable.Builder stringTableBuilder;
    @NotNull
    private final Map<JsName, Integer> nameMap;
    @NotNull
    private final Map<String, Integer> stringMap;
    @NotNull
    private final Deque<String> fileStack;
    @NotNull
    private final Set<JsName> importedNames;

    public JsAstSerializer(@Nullable Function2<? super JsProgramFragment, ? super Set<? extends JsName>, Unit> jsAstValidator, @NotNull Function1<? super File, String> pathResolver) {
        Intrinsics.checkNotNullParameter(pathResolver, (String)"pathResolver");
        this.jsAstValidator = jsAstValidator;
        this.pathResolver = pathResolver;
        this.nameTableBuilder = JsAstProtoBuf.NameTable.newBuilder();
        this.stringTableBuilder = JsAstProtoBuf.StringTable.newBuilder();
        boolean bl = false;
        this.nameMap = new LinkedHashMap();
        bl = false;
        this.stringMap = new LinkedHashMap();
        this.fileStack = new ArrayDeque();
        bl = false;
        this.importedNames = new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    public final void serialize(@NotNull JsProgramFragment fragment, @NotNull OutputStream output) {
        void $this$mapTo$iv$iv;
        void destination$iv;
        Object element$iv2;
        void $this$associateTo$iv;
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Object object = fragment.getNameBindings();
        boolean bl = false;
        Object object2 = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv2 : $this$associateTo$iv) {
            void var9_11 = destination$iv;
            JsNameBinding it = (JsNameBinding)element$iv2;
            boolean bl2 = false;
            it = TuplesKt.to((Object)it.getKey(), (Object)it.getName());
            boolean bl3 = false;
            var9_11.put(it.getFirst(), it.getSecond());
        }
        void namesBySignature = destination$iv;
        this.importedNames.clear();
        object = this;
        object2 = ((JsAstSerializer)object).importedNames;
        Map<String, JsExpression> $this$map$iv = fragment.getImports();
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var11_15 = $this$mapTo$iv$iv;
        boolean bl4 = false;
        Iterator iterator2 = var11_15.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            Object v = namesBySignature.get(it.getKey());
            Intrinsics.checkNotNull(v);
            JsName jsName = (JsName)v;
            collection.add(jsName);
        }
        Iterable iterable = (List)destination$iv$iv;
        boolean bl6 = false;
        CollectionsKt.addAll((Collection)object2, (Iterable)iterable);
        this.serialize(fragment).writeTo(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JsAstProtoBuf.Chunk serialize(@NotNull JsProgramFragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        try {
            JsAstProtoBuf.Chunk.Builder chunkBuilder = JsAstProtoBuf.Chunk.newBuilder();
            chunkBuilder.setFragment(this.serializeFragment(fragment));
            chunkBuilder.setNameTable(this.nameTableBuilder.build());
            chunkBuilder.setStringTable(this.stringTableBuilder.build());
            JsAstProtoBuf.Chunk chunk = chunkBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"chunkBuilder.build()");
            return chunk;
        }
        finally {
            this.nameTableBuilder.clear();
            this.stringTableBuilder.clear();
            this.nameMap.clear();
            this.stringMap.clear();
        }
    }

    private final JsAstProtoBuf.Fragment serializeFragment(JsProgramFragment fragment) {
        Object it;
        boolean bl;
        Object object;
        Object object2;
        JsAstProtoBuf.Fragment.Builder fragmentBuilder = JsAstProtoBuf.Fragment.newBuilder();
        fragmentBuilder.setPackageFqn(fragment.getPackageFqn());
        for (JsImportedModule jsImportedModule : fragment.getImportedModules()) {
            JsAstProtoBuf.ImportedModule.Builder importedModuleBuilder = JsAstProtoBuf.ImportedModule.newBuilder();
            importedModuleBuilder.setExternalNameId(this.serialize(jsImportedModule.getExternalName()));
            importedModuleBuilder.setInternalNameId(this.serialize(jsImportedModule.getInternalName()));
            object2 = jsImportedModule.getPlainReference();
            if (object2 != null) {
                object = object2;
                bl = false;
                boolean bl2 = false;
                Object it2 = object;
                boolean bl3 = false;
                importedModuleBuilder.setPlainReference(this.serialize((JsExpression)it2));
            }
            fragmentBuilder.addImportedModule(importedModuleBuilder);
        }
        Map<String, JsExpression> map = fragment.getImports();
        boolean importedModuleBuilder = false;
        for (Map.Entry entry : map.entrySet()) {
            object2 = entry;
            boolean bl3 = false;
            String signature2 = (String)object2.getKey();
            object = entry;
            bl = false;
            JsExpression expression2 = (JsExpression)object.getValue();
            JsAstProtoBuf.Import.Builder importBuilder = JsAstProtoBuf.Import.newBuilder();
            importBuilder.setSignatureId(this.serialize(signature2));
            importBuilder.setExpression(this.serialize(expression2));
            fragmentBuilder.addImportEntry(importBuilder);
        }
        fragmentBuilder.setDeclarationBlock(this.serializeBlock(fragment.getDeclarationBlock()));
        fragmentBuilder.setInitializerBlock(this.serializeBlock(fragment.getInitializerBlock()));
        fragmentBuilder.setExportBlock(this.serializeBlock(fragment.getExportBlock()));
        for (JsNameBinding jsNameBinding : fragment.getNameBindings()) {
            JsAstProtoBuf.NameBinding.Builder nameBindingBuilder = JsAstProtoBuf.NameBinding.newBuilder();
            nameBindingBuilder.setSignatureId(this.serialize(jsNameBinding.getKey()));
            nameBindingBuilder.setNameId(this.serialize(jsNameBinding.getName()));
            fragmentBuilder.addNameBinding(nameBindingBuilder);
        }
        Iterable $this$forEach$iv = fragment.getClasses().values();
        boolean bl4 = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (JsClassModel)element$iv;
            boolean $i$a$-forEach-JsAstSerializer$serializeFragment$332 = false;
            fragmentBuilder.addClassModel(this.serialize((JsClassModel)it));
        }
        boolean bl5 = false;
        Map inlineModuleExprMap = new LinkedHashMap();
        Object nameBindingBuilder = fragment.getInlineModuleMap();
        boolean element$iv = false;
        Iterator iterator2 = nameBindingBuilder.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object3;
            it = nameBindingBuilder = iterator2.next();
            boolean $i$a$-forEach-JsAstSerializer$serializeFragment$332 = false;
            String signature3 = (String)it.getKey();
            Object $i$a$-forEach-JsAstSerializer$serializeFragment$332 = nameBindingBuilder;
            boolean bl6 = false;
            JsExpression expression3 = (JsExpression)$i$a$-forEach-JsAstSerializer$serializeFragment$332.getValue();
            JsAstProtoBuf.InlineModule.Builder inlineModuleBuilder = JsAstProtoBuf.InlineModule.newBuilder();
            inlineModuleBuilder.setSignatureId(this.serialize(signature3));
            JsAstProtoBuf.InlineModule.Builder builder2 = inlineModuleBuilder;
            Map $this$getOrPut$iv = inlineModuleExprMap;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(expression3);
            if (value$iv == null) {
                JsAstProtoBuf.InlineModule.Builder builder3 = builder2;
                boolean bl62 = false;
                int result232 = fragmentBuilder.getModuleExpressionCount();
                fragmentBuilder.addModuleExpression(this.serialize(expression3));
                Integer n = result232;
                builder2 = builder3;
                Integer answer$iv = n;
                $this$getOrPut$iv.put(expression3, answer$iv);
                object3 = answer$iv;
            } else {
                object3 = value$iv;
            }
            builder2.setExpressionId(((Number)object3).intValue());
            fragmentBuilder.addInlineModule(inlineModuleBuilder);
        }
        JsStatement jsStatement = fragment.getTests();
        if (jsStatement != null) {
            nameBindingBuilder = jsStatement;
            boolean bl7 = false;
            boolean bl8 = false;
            Object it3 = nameBindingBuilder;
            boolean bl9 = false;
            fragmentBuilder.setTestsInvocation(this.serialize((JsStatement)it3));
        }
        JsStatement jsStatement2 = fragment.getMainFunction();
        if (jsStatement2 != null) {
            nameBindingBuilder = jsStatement2;
            boolean bl9 = false;
            boolean bl10 = false;
            Object it4 = nameBindingBuilder;
            boolean bl12 = false;
            fragmentBuilder.setMainInvocation(this.serialize((JsStatement)it4));
        }
        Map<String, JsGlobalBlock> map2 = fragment.getInlinedLocalDeclarations();
        boolean $i$f$forEach = false;
        Map<String, JsGlobalBlock> map3 = map2;
        boolean bl11 = false;
        Iterator<Map.Entry<String, JsGlobalBlock>> it4 = map3.entrySet().iterator();
        while (it4.hasNext()) {
            Map.Entry<String, JsGlobalBlock> element$iv2;
            Map.Entry<String, JsGlobalBlock> $dstr$tag$block = element$iv2 = it4.next();
            boolean bl14 = false;
            Map.Entry<String, JsGlobalBlock> bl62 = $dstr$tag$block;
            boolean result232 = false;
            String tag = bl62.getKey();
            Map.Entry<String, JsGlobalBlock> result232 = $dstr$tag$block;
            boolean bl12 = false;
            JsGlobalBlock block = result232.getValue();
            JsAstProtoBuf.InlinedLocalDeclarations.Builder builder4 = JsAstProtoBuf.InlinedLocalDeclarations.newBuilder();
            boolean bl13 = false;
            boolean bl15 = false;
            JsAstProtoBuf.InlinedLocalDeclarations.Builder $this$serializeFragment_u24lambda_u2d8_u24lambda_u2d7 = builder4;
            boolean bl18 = false;
            $this$serializeFragment_u24lambda_u2d8_u24lambda_u2d7.setTag(this.serialize(tag));
            $this$serializeFragment_u24lambda_u2d8_u24lambda_u2d7.setBlock(this.serializeBlock(block));
            JsAstProtoBuf.InlinedLocalDeclarations.Builder builder5 = builder4;
            fragmentBuilder.addInlinedLocalDeclarations(builder5.build());
        }
        Function2<JsProgramFragment, Set<? extends JsName>, Unit> function2 = this.jsAstValidator;
        if (function2 != null) {
            Function2<JsProgramFragment, Set<? extends JsName>, Unit> function22 = function2;
            boolean bl16 = false;
            bl11 = false;
            Function2<JsProgramFragment, Set<? extends JsName>, Unit> it2 = function22;
            boolean bl20 = false;
            it2.invoke((Object)fragment, this.nameMap.keySet());
        }
        JsAstProtoBuf.Fragment fragment2 = fragmentBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)fragment2, (String)"fragmentBuilder.build()");
        return fragment2;
    }

    private final JsAstProtoBuf.ClassModel serialize(JsClassModel classModel) {
        JsName it;
        JsAstProtoBuf.ClassModel.Builder builder2 = JsAstProtoBuf.ClassModel.newBuilder();
        builder2.setNameId(this.serialize(classModel.getName()));
        Object object = classModel.getSuperName();
        if (object != null) {
            JsName jsName = object;
            boolean bl = false;
            boolean bl2 = false;
            it = jsName;
            boolean bl3 = false;
            builder2.setSuperNameId(this.serialize(it));
        }
        Iterable $this$forEach$iv = classModel.getInterfaces();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (JsName)element$iv;
            boolean bl = false;
            builder2.addInterfaceNameId(this.serialize(it));
        }
        object = classModel.getPostDeclarationBlock().getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classModel.postDeclarationBlock.statements");
        object = (Collection)object;
        boolean bl = false;
        if (!object.isEmpty()) {
            builder2.setPostDeclarationBlock(this.serializeBlock(classModel.getPostDeclarationBlock()));
        }
        object = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.build()");
        return object;
    }

    private final JsAstProtoBuf.Statement serialize(JsStatement statement2) {
        JsVisitor visitor2 = new JsVisitor(this){
            private final JsAstProtoBuf.Statement.Builder builder;
            final /* synthetic */ JsAstSerializer this$0;
            {
                this.this$0 = $receiver;
                this.builder = JsAstProtoBuf.Statement.newBuilder();
            }

            public final JsAstProtoBuf.Statement.Builder getBuilder() {
                return this.builder;
            }

            public void visitReturn(@NotNull JsReturn x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Return.Builder returnBuilder = JsAstProtoBuf.Return.newBuilder();
                JsExpression jsExpression = x.getExpression();
                if (jsExpression != null) {
                    JsExpression jsExpression2 = jsExpression;
                    JsAstSerializer jsAstSerializer = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsExpression it = jsExpression2;
                    boolean bl3 = false;
                    returnBuilder.setValue(JsAstSerializer.access$serialize(jsAstSerializer, it));
                }
                this.builder.setReturnStatement(returnBuilder.build());
            }

            public void visitThrow(@NotNull JsThrow x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Throw.Builder throwBuilder = JsAstProtoBuf.Throw.newBuilder();
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.expression");
                throwBuilder.setException(JsAstSerializer.access$serialize(this.this$0, jsExpression));
                this.builder.setThrowStatement(throwBuilder.build());
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Break.Builder breakBuilder = JsAstProtoBuf.Break.newBuilder();
                JsNameRef jsNameRef = x.getLabel();
                if (jsNameRef != null) {
                    JsNameRef jsNameRef2 = jsNameRef;
                    JsAstSerializer jsAstSerializer = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsNameRef it = jsNameRef2;
                    boolean bl3 = false;
                    JsName jsName = it.getName();
                    Intrinsics.checkNotNull((Object)jsName);
                    JsName jsName2 = jsName;
                    Intrinsics.checkNotNullExpressionValue((Object)jsName2, (String)"it.name!!");
                    breakBuilder.setLabelId(JsAstSerializer.access$serialize(jsAstSerializer, jsName2));
                }
                this.builder.setBreakStatement(breakBuilder.build());
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Continue.Builder continueBuilder = JsAstProtoBuf.Continue.newBuilder();
                JsNameRef jsNameRef = x.getLabel();
                if (jsNameRef != null) {
                    JsNameRef jsNameRef2 = jsNameRef;
                    JsAstSerializer jsAstSerializer = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsNameRef it = jsNameRef2;
                    boolean bl3 = false;
                    JsName jsName = it.getName();
                    Intrinsics.checkNotNull((Object)jsName);
                    JsName jsName2 = jsName;
                    Intrinsics.checkNotNullExpressionValue((Object)jsName2, (String)"it.name!!");
                    continueBuilder.setLabelId(JsAstSerializer.access$serialize(jsAstSerializer, jsName2));
                }
                this.builder.setContinueStatement(continueBuilder.build());
            }

            public void visitDebugger(@NotNull JsDebugger x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setDebugger(JsAstProtoBuf.Debugger.newBuilder().build());
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.ExpressionStatement.Builder statementBuilder = JsAstProtoBuf.ExpressionStatement.newBuilder();
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.expression");
                statementBuilder.setExpression(JsAstSerializer.access$serialize(this.this$0, jsExpression));
                String tag = MetadataProperties.getExportedTag(x);
                if (tag != null) {
                    statementBuilder.setExportedTagId(JsAstSerializer.access$serialize(this.this$0, tag));
                }
                this.builder.setExpression(statementBuilder.build());
            }

            public void visitVars(@NotNull JsVars x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setVars(JsAstSerializer.access$serializeVars(this.this$0, x));
            }

            public void visitBlock(@NotNull JsBlock x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (x instanceof JsGlobalBlock) {
                    this.builder.setGlobalBlock(JsAstSerializer.access$serializeBlock(this.this$0, (JsGlobalBlock)x));
                } else {
                    JsAstProtoBuf.Block.Builder blockBuilder = JsAstProtoBuf.Block.newBuilder();
                    for (JsStatement part : x.getStatements()) {
                        Intrinsics.checkNotNullExpressionValue((Object)part, (String)"part");
                        blockBuilder.addStatement(JsAstSerializer.access$serialize(this.this$0, part));
                    }
                    this.builder.setBlock(blockBuilder.build());
                }
            }

            public void visitLabel(@NotNull JsLabel x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Label.Builder labelBuilder = JsAstProtoBuf.Label.newBuilder();
                Object object = x.getName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"x.name");
                labelBuilder.setNameId(JsAstSerializer.access$serialize(this.this$0, (JsName)object));
                object = x.getStatement();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"x.statement");
                labelBuilder.setInnerStatement(JsAstSerializer.access$serialize(this.this$0, (JsStatement)object));
                this.builder.setLabel(labelBuilder.build());
            }

            public void visitIf(@NotNull JsIf x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.If.Builder ifBuilder = JsAstProtoBuf.If.newBuilder();
                JsNode jsNode = x.getIfExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"x.ifExpression");
                ifBuilder.setCondition(JsAstSerializer.access$serialize(this.this$0, jsNode));
                jsNode = x.getThenStatement();
                Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"x.thenStatement");
                ifBuilder.setThenStatement(JsAstSerializer.access$serialize(this.this$0, (JsStatement)jsNode));
                jsNode = x.getElseStatement();
                if (jsNode != null) {
                    JsNode jsNode2 = jsNode;
                    JsAstSerializer jsAstSerializer = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsNode it = jsNode2;
                    boolean bl3 = false;
                    ifBuilder.setElseStatement(JsAstSerializer.access$serialize(jsAstSerializer, (JsStatement)it));
                }
                this.builder.setIfStatement(ifBuilder.build());
            }

            /*
             * WARNING - void declaration
             */
            public void visit(@NotNull JsSwitch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Switch.Builder switchBuilder = JsAstProtoBuf.Switch.newBuilder();
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.expression");
                switchBuilder.setExpression(JsAstSerializer.access$serialize(this.this$0, jsExpression));
                for (JsSwitchMember jsSwitchMember : x.getCases()) {
                    void this_$iv;
                    JsAstProtoBuf.SwitchEntry.Builder entryBuilder = JsAstProtoBuf.SwitchEntry.newBuilder();
                    Object object = this.this$0;
                    Intrinsics.checkNotNullExpressionValue((Object)jsSwitchMember, (String)"case");
                    JsNode node$iv = jsSwitchMember;
                    boolean $i$f$withLocation = false;
                    JsLocation location$iv = JsAstSerializer.access$extractLocation((JsAstSerializer)this_$iv, node$iv);
                    boolean fileChanged$iv = false;
                    if (location$iv != null) {
                        String newFile$iv;
                        String lastFile$iv = (String)JsAstSerializer.access$getFileStack$p((JsAstSerializer)this_$iv).peek();
                        boolean bl = fileChanged$iv = !Intrinsics.areEqual((Object)lastFile$iv, (Object)(newFile$iv = location$iv.getFile()));
                        if (fileChanged$iv) {
                            int it = JsAstSerializer.access$serialize((JsAstSerializer)this_$iv, newFile$iv);
                            boolean bl2 = false;
                            entryBuilder.setFileId(it);
                            JsAstSerializer.access$getFileStack$p((JsAstSerializer)this_$iv).push(location$iv.getFile());
                        }
                        JsAstProtoBuf.Location.Builder locationBuilder$iv = JsAstProtoBuf.Location.newBuilder();
                        locationBuilder$iv.setStartLine(location$iv.getStartLine());
                        locationBuilder$iv.setStartChar(location$iv.getStartChar());
                        JsAstProtoBuf.Location location2 = locationBuilder$iv.build();
                        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"locationBuilder.build()");
                        JsAstProtoBuf.Location it = location2;
                        boolean bl3 = false;
                        entryBuilder.setLocation(it);
                    }
                    boolean bl = false;
                    if (fileChanged$iv) {
                        JsAstSerializer.access$getFileStack$p((JsAstSerializer)this_$iv).pop();
                    }
                    if (jsSwitchMember instanceof JsCase) {
                        object = ((JsCase)jsSwitchMember).getCaseExpression();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"case.caseExpression");
                        entryBuilder.setLabel(JsAstSerializer.access$serialize(this.this$0, (JsExpression)object));
                    }
                    for (JsStatement part : jsSwitchMember.getStatements()) {
                        Intrinsics.checkNotNullExpressionValue((Object)part, (String)"part");
                        entryBuilder.addStatement(JsAstSerializer.access$serialize(this.this$0, part));
                    }
                    switchBuilder.addEntry(entryBuilder);
                }
                this.builder.setSwitchStatement(switchBuilder.build());
            }

            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.While.Builder whileBuilder = JsAstProtoBuf.While.newBuilder();
                JsNode jsNode = x.getCondition();
                Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"x.condition");
                whileBuilder.setCondition(JsAstSerializer.access$serialize(this.this$0, jsNode));
                jsNode = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"x.body");
                whileBuilder.setBody(JsAstSerializer.access$serialize(this.this$0, (JsStatement)jsNode));
                this.builder.setWhileStatement(whileBuilder.build());
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.DoWhile.Builder doWhileBuilder = JsAstProtoBuf.DoWhile.newBuilder();
                JsNode jsNode = x.getCondition();
                Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"x.condition");
                doWhileBuilder.setCondition(JsAstSerializer.access$serialize(this.this$0, jsNode));
                jsNode = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"x.body");
                doWhileBuilder.setBody(JsAstSerializer.access$serialize(this.this$0, (JsStatement)jsNode));
                this.builder.setDoWhileStatement(doWhileBuilder.build());
            }

            public void visitFor(@NotNull JsFor x) {
                SourceInfoAwareJsNode it;
                boolean bl;
                boolean bl2;
                JsAstSerializer jsAstSerializer;
                SourceInfoAwareJsNode sourceInfoAwareJsNode;
                JsNode jsNode;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.For.Builder forBuilder = JsAstProtoBuf.For.newBuilder();
                if (x.getInitVars() != null) {
                    jsNode = x.getInitVars();
                    Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"x.initVars");
                    forBuilder.setVariables(JsAstSerializer.access$serialize(this.this$0, jsNode));
                } else if (x.getInitExpression() != null) {
                    jsNode = x.getInitExpression();
                    Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"x.initExpression");
                    forBuilder.setExpression(JsAstSerializer.access$serialize(this.this$0, (JsExpression)jsNode));
                } else {
                    forBuilder.setEmpty(JsAstProtoBuf.EmptyInit.newBuilder().build());
                }
                jsNode = x.getCondition();
                if (jsNode != null) {
                    sourceInfoAwareJsNode = jsNode;
                    jsAstSerializer = this.this$0;
                    bl2 = false;
                    bl = false;
                    it = sourceInfoAwareJsNode;
                    boolean bl3 = false;
                    forBuilder.setCondition(JsAstSerializer.access$serialize(jsAstSerializer, (JsExpression)it));
                }
                jsNode = x.getIncrementExpression();
                if (jsNode != null) {
                    sourceInfoAwareJsNode = jsNode;
                    jsAstSerializer = this.this$0;
                    bl2 = false;
                    bl = false;
                    it = sourceInfoAwareJsNode;
                    boolean bl4 = false;
                    forBuilder.setIncrement(JsAstSerializer.access$serialize(jsAstSerializer, (JsExpression)it));
                }
                jsNode = x.getBody();
                forBuilder.setBody(JsAstSerializer.access$serialize(this.this$0, jsNode == null ? (JsStatement)JsEmpty.INSTANCE : jsNode));
                this.builder.setForStatement(forBuilder.build());
            }

            public void visitForIn(@NotNull JsForIn x) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.ForIn.Builder forInBuilder = JsAstProtoBuf.ForIn.newBuilder();
                if (x.getIterVarName() != null) {
                    object = x.getIterVarName();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"x.iterVarName");
                    forInBuilder.setNameId(JsAstSerializer.access$serialize(this.this$0, (JsName)object));
                } else if (x.getIterExpression() != null) {
                    object = x.getIterExpression();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"x.iterExpression");
                    forInBuilder.setExpression(JsAstSerializer.access$serialize(this.this$0, (JsExpression)object));
                }
                object = x.getObjectExpression();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"x.objectExpression");
                forInBuilder.setIterable(JsAstSerializer.access$serialize(this.this$0, (JsExpression)object));
                object = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"x.body");
                forInBuilder.setBody(JsAstSerializer.access$serialize(this.this$0, (JsStatement)object));
                this.builder.setForInStatement(forInBuilder.build());
            }

            public void visitTry(@NotNull JsTry x) {
                boolean bl;
                boolean bl2;
                JsAstSerializer jsAstSerializer;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Try.Builder tryBuilder = JsAstProtoBuf.Try.newBuilder();
                SourceInfoAwareJsNode sourceInfoAwareJsNode = x.getTryBlock();
                Intrinsics.checkNotNullExpressionValue((Object)sourceInfoAwareJsNode, (String)"x.tryBlock");
                tryBuilder.setTryBlock(JsAstSerializer.access$serialize(this.this$0, sourceInfoAwareJsNode));
                Object object = x.getCatches();
                Intrinsics.checkNotNullExpressionValue(object, (String)"x.catches");
                sourceInfoAwareJsNode = (JsCatch)CollectionsKt.firstOrNull(object);
                if (sourceInfoAwareJsNode != null) {
                    object = sourceInfoAwareJsNode;
                    jsAstSerializer = this.this$0;
                    bl2 = false;
                    bl = false;
                    Object c = object;
                    boolean bl3 = false;
                    JsAstProtoBuf.Catch.Builder catchBuilder = JsAstProtoBuf.Catch.newBuilder();
                    SourceInfoAwareJsNode sourceInfoAwareJsNode2 = ((JsCatch)c).getParameter();
                    Intrinsics.checkNotNullExpressionValue((Object)sourceInfoAwareJsNode2, (String)"c.parameter");
                    catchBuilder.setParameter(JsAstSerializer.access$serializeParameter(jsAstSerializer, sourceInfoAwareJsNode2));
                    sourceInfoAwareJsNode2 = ((JsCatch)c).getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)sourceInfoAwareJsNode2, (String)"c.body");
                    catchBuilder.setBody(JsAstSerializer.access$serialize(jsAstSerializer, (JsStatement)((Object)sourceInfoAwareJsNode2)));
                    tryBuilder.setCatchBlock(catchBuilder.build());
                }
                sourceInfoAwareJsNode = x.getFinallyBlock();
                if (sourceInfoAwareJsNode != null) {
                    object = sourceInfoAwareJsNode;
                    jsAstSerializer = this.this$0;
                    bl2 = false;
                    bl = false;
                    Object it = object;
                    boolean bl4 = false;
                    tryBuilder.setFinallyBlock(JsAstSerializer.access$serialize(jsAstSerializer, (JsStatement)it));
                }
                this.builder.setTryStatement(tryBuilder.build());
            }

            public void visitEmpty(@NotNull JsEmpty x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setEmpty(JsAstProtoBuf.Empty.newBuilder().build());
            }
        };
        JsAstSerializer this_$iv = this;
        boolean $i$f$withLocation = false;
        JsLocation location$iv = this_$iv.extractLocation(statement2);
        boolean fileChanged$iv = false;
        if (location$iv != null) {
            String newFile$iv;
            String lastFile$iv = (String)this_$iv.fileStack.peek();
            boolean bl = fileChanged$iv = !Intrinsics.areEqual((Object)lastFile$iv, (Object)(newFile$iv = location$iv.getFile()));
            if (fileChanged$iv) {
                int it = this_$iv.serialize(newFile$iv);
                boolean bl2 = false;
                visitor2.getBuilder().setFileId(it);
                this_$iv.fileStack.push(location$iv.getFile());
            }
            JsAstProtoBuf.Location.Builder locationBuilder$iv = JsAstProtoBuf.Location.newBuilder();
            locationBuilder$iv.setStartLine(location$iv.getStartLine());
            locationBuilder$iv.setStartChar(location$iv.getStartChar());
            JsAstProtoBuf.Location location2 = locationBuilder$iv.build();
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"locationBuilder.build()");
            JsAstProtoBuf.Location it = location2;
            boolean bl3 = false;
            visitor2.getBuilder().setLocation(it);
        }
        boolean bl = false;
        statement2.accept(visitor2);
        if (fileChanged$iv) {
            this_$iv.fileStack.pop();
        }
        if (statement2 instanceof HasMetadata && MetadataProperties.getSynthetic((HasMetadata)((Object)statement2))) {
            visitor2.getBuilder().setSynthetic(true);
        }
        JsAstProtoBuf.Statement statement3 = visitor2.getBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)statement3, (String)"visitor.builder.build()");
        return statement3;
    }

    private final JsAstProtoBuf.Expression serialize(JsExpression expression2) {
        JsVisitor visitor2 = new JsVisitor(this){
            private final JsAstProtoBuf.Expression.Builder builder;
            final /* synthetic */ JsAstSerializer this$0;
            {
                this.this$0 = $receiver;
                this.builder = JsAstProtoBuf.Expression.newBuilder();
            }

            public final JsAstProtoBuf.Expression.Builder getBuilder() {
                return this.builder;
            }

            public void visitThis(@NotNull JsThisRef x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setThisLiteral(JsAstProtoBuf.ThisLiteral.newBuilder().build());
            }

            public void visitNull(@NotNull JsNullLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setNullLiteral(JsAstProtoBuf.NullLiteral.newBuilder().build());
            }

            public void visitBoolean(@NotNull JsBooleanLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (x.getValue()) {
                    this.builder.setTrueLiteral(JsAstProtoBuf.TrueLiteral.newBuilder().build());
                } else {
                    this.builder.setFalseLiteral(JsAstProtoBuf.FalseLiteral.newBuilder().build());
                }
            }

            public void visitString(@NotNull JsStringLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                String string2 = x.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"x.value");
                this.builder.setStringLiteral(JsAstSerializer.access$serialize(this.this$0, string2));
            }

            public void visitRegExp(@NotNull JsRegExp x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.RegExpLiteral.Builder regExpBuilder = JsAstProtoBuf.RegExpLiteral.newBuilder();
                String string2 = x.getPattern();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"x.pattern");
                regExpBuilder.setPatternStringId(JsAstSerializer.access$serialize(this.this$0, string2));
                string2 = x.getFlags();
                if (string2 != null) {
                    String string3 = string2;
                    JsAstSerializer jsAstSerializer = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string3;
                    boolean bl3 = false;
                    regExpBuilder.setFlagsStringId(JsAstSerializer.access$serialize(jsAstSerializer, it));
                }
                this.builder.setRegExpLiteral(regExpBuilder.build());
            }

            public void visitInt(@NotNull JsIntLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setIntLiteral(x.value);
            }

            public void visitDouble(@NotNull JsDoubleLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setDoubleLiteral(x.value);
            }

            /*
             * WARNING - void declaration
             */
            public void visitArray(@NotNull JsArrayLiteral x) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.ArrayLiteral.Builder arrayBuilder = JsAstProtoBuf.ArrayLiteral.newBuilder();
                Iterable<JsExpression> iterable = x.getExpressions();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"x.expressions");
                iterable = iterable;
                JsAstSerializer jsAstSerializer = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsExpression it = (JsExpression)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    arrayBuilder.addElement(JsAstSerializer.access$serialize(jsAstSerializer, it));
                }
                this.builder.setArrayLiteral(arrayBuilder.build());
            }

            public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.ObjectLiteral.Builder objectBuilder = JsAstProtoBuf.ObjectLiteral.newBuilder();
                for (JsPropertyInitializer initializer2 : x.getPropertyInitializers()) {
                    JsAstProtoBuf.ObjectLiteralEntry.Builder entryBuilder = JsAstProtoBuf.ObjectLiteralEntry.newBuilder();
                    JsExpression jsExpression = initializer2.getLabelExpr();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"initializer.labelExpr");
                    entryBuilder.setKey(JsAstSerializer.access$serialize(this.this$0, jsExpression));
                    jsExpression = initializer2.getValueExpr();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"initializer.valueExpr");
                    entryBuilder.setValue(JsAstSerializer.access$serialize(this.this$0, jsExpression));
                    objectBuilder.addEntry(entryBuilder);
                }
                objectBuilder.setMultiline(x.isMultiline());
                this.builder.setObjectLiteral(objectBuilder.build());
            }

            /*
             * WARNING - void declaration
             */
            public void visitFunction(@NotNull JsFunction x) {
                Object it;
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Function.Builder functionBuilder = JsAstProtoBuf.Function.newBuilder();
                Object object = x.getParameters();
                Intrinsics.checkNotNullExpressionValue(object, (String)"x.parameters");
                object = (Iterable)object;
                Object object2 = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (JsParameter)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    functionBuilder.addParameter(JsAstSerializer.access$serializeParameter((JsAstSerializer)object2, (JsParameter)it));
                }
                object = x.getName();
                if (object != null) {
                    object2 = object;
                    JsAstSerializer jsAstSerializer = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    it = object2;
                    boolean bl3 = false;
                    functionBuilder.setNameId(JsAstSerializer.access$serialize(jsAstSerializer, (JsName)it));
                }
                object = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"x.body");
                functionBuilder.setBody(JsAstSerializer.access$serialize(this.this$0, (JsStatement)object));
                if (MetadataProperties.isLocal(x)) {
                    functionBuilder.setLocal(true);
                }
                this.builder.setFunction(functionBuilder.build());
            }

            public void visitDocComment(@NotNull JsDocComment comment) {
                Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                JsAstProtoBuf.DocComment.Builder commentBuilder = JsAstProtoBuf.DocComment.newBuilder();
                Object object = comment.getTags();
                Intrinsics.checkNotNullExpressionValue(object, (String)"comment.tags");
                boolean bl = false;
                Iterator<Map.Entry<String, Object>> iterator2 = object.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Object object2 = object = iterator2.next();
                    boolean bl2 = false;
                    String name2 = (String)object2.getKey();
                    Object object3 = object;
                    boolean bl3 = false;
                    V value2 = object3.getValue();
                    JsAstProtoBuf.DocCommentTag.Builder tagBuilder = JsAstProtoBuf.DocCommentTag.newBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
                    tagBuilder.setNameId(JsAstSerializer.access$serialize(this.this$0, name2));
                    V v = value2;
                    if (v instanceof JsNameRef) {
                        Intrinsics.checkNotNullExpressionValue(value2, (String)"value");
                        tagBuilder.setExpression(JsAstSerializer.access$serialize(this.this$0, (JsExpression)value2));
                    } else if (v instanceof String) {
                        Intrinsics.checkNotNullExpressionValue(value2, (String)"value");
                        tagBuilder.setValueStringId(JsAstSerializer.access$serialize(this.this$0, (String)value2));
                    }
                    commentBuilder.addTag(tagBuilder);
                }
                this.builder.setDocComment(commentBuilder.build());
            }

            public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.BinaryOperation.Builder binaryBuilder = JsAstProtoBuf.BinaryOperation.newBuilder();
                Object object = x.getArg1();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"x.arg1");
                binaryBuilder.setLeft(JsAstSerializer.access$serialize(this.this$0, (JsExpression)object));
                object = x.getArg2();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"x.arg2");
                binaryBuilder.setRight(JsAstSerializer.access$serialize(this.this$0, (JsExpression)object));
                object = x.getOperator();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"x.operator");
                binaryBuilder.setType(JsAstSerializer.access$map(this.this$0, (JsBinaryOperator)object));
                this.builder.setBinary(binaryBuilder.build());
            }

            public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setUnary(JsAstSerializer.access$serializeUnary(this.this$0, x, false));
            }

            public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setUnary(JsAstSerializer.access$serializeUnary(this.this$0, x, true));
            }

            public void visitConditional(@NotNull JsConditional x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Conditional.Builder conditionalBuilder = JsAstProtoBuf.Conditional.newBuilder();
                JsExpression jsExpression = x.getTestExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.testExpression");
                conditionalBuilder.setTestExpression(JsAstSerializer.access$serialize(this.this$0, jsExpression));
                jsExpression = x.getThenExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.thenExpression");
                conditionalBuilder.setThenExpression(JsAstSerializer.access$serialize(this.this$0, jsExpression));
                jsExpression = x.getElseExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.elseExpression");
                conditionalBuilder.setElseExpression(JsAstSerializer.access$serialize(this.this$0, jsExpression));
                this.builder.setConditional(conditionalBuilder.build());
            }

            public void visitArrayAccess(@NotNull JsArrayAccess x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.ArrayAccess.Builder arrayAccessBuilder = JsAstProtoBuf.ArrayAccess.newBuilder();
                JsExpression jsExpression = x.getArrayExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.arrayExpression");
                arrayAccessBuilder.setArray(JsAstSerializer.access$serialize(this.this$0, jsExpression));
                jsExpression = x.getIndexExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.indexExpression");
                arrayAccessBuilder.setIndex(JsAstSerializer.access$serialize(this.this$0, jsExpression));
                this.builder.setArrayAccess(arrayAccessBuilder.build());
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                JsName name2 = nameRef.getName();
                JsExpression qualifier = nameRef.getQualifier();
                if (name2 != null) {
                    if (qualifier != null || Intrinsics.areEqual((Object)MetadataProperties.isInline(nameRef), (Object)true)) {
                        Boolean bl;
                        JsAstProtoBuf.NameReference.Builder nameRefBuilder = JsAstProtoBuf.NameReference.newBuilder();
                        nameRefBuilder.setNameId(JsAstSerializer.access$serialize(this.this$0, name2));
                        if (qualifier != null) {
                            nameRefBuilder.setQualifier(JsAstSerializer.access$serialize(this.this$0, qualifier));
                        }
                        if ((bl = MetadataProperties.isInline(nameRef)) != null) {
                            Boolean bl2 = bl;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            boolean it = bl2;
                            boolean bl5 = false;
                            nameRefBuilder.setInlineStrategy(it ? JsAstProtoBuf.InlineStrategy.IN_PLACE : JsAstProtoBuf.InlineStrategy.NOT_INLINE);
                        }
                        this.builder.setNameReference(nameRefBuilder.build());
                    } else {
                        this.builder.setSimpleNameReference(JsAstSerializer.access$serialize(this.this$0, name2));
                    }
                } else {
                    boolean it;
                    boolean bl;
                    Object object;
                    JsAstProtoBuf.PropertyReference.Builder propertyRefBuilder = JsAstProtoBuf.PropertyReference.newBuilder();
                    Object object2 = nameRef.getIdent();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"nameRef.ident");
                    propertyRefBuilder.setStringId(JsAstSerializer.access$serialize(this.this$0, (String)object2));
                    object2 = qualifier;
                    if (object2 != null) {
                        object = object2;
                        JsAstSerializer jsAstSerializer = this.this$0;
                        bl = false;
                        it = false;
                        Object it2 = object;
                        boolean bl6 = false;
                        propertyRefBuilder.setQualifier(JsAstSerializer.access$serialize(jsAstSerializer, (JsExpression)it2));
                    }
                    object2 = MetadataProperties.isInline(nameRef);
                    if (object2 != null) {
                        object = object2;
                        boolean bl7 = false;
                        bl = false;
                        it = (Boolean)object;
                        boolean bl8 = false;
                        propertyRefBuilder.setInlineStrategy(it ? JsAstProtoBuf.InlineStrategy.IN_PLACE : JsAstProtoBuf.InlineStrategy.NOT_INLINE);
                    }
                    this.builder.setPropertyReference(propertyRefBuilder.build());
                }
            }

            /*
             * WARNING - void declaration
             */
            public void visitInvocation(@NotNull JsInvocation invocation) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
                JsAstProtoBuf.Invocation.Builder invocationBuilder = JsAstProtoBuf.Invocation.newBuilder();
                Object object = invocation.getQualifier();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invocation.qualifier");
                invocationBuilder.setQualifier(JsAstSerializer.access$serialize(this.this$0, (JsExpression)object));
                object = invocation.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invocation.arguments");
                object = (Iterable)object;
                JsAstSerializer jsAstSerializer = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsExpression it = (JsExpression)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    invocationBuilder.addArgument(JsAstSerializer.access$serialize(jsAstSerializer, it));
                }
                if (Intrinsics.areEqual((Object)MetadataProperties.isInline(invocation), (Object)true)) {
                    invocationBuilder.setInlineStrategy(JsAstProtoBuf.InlineStrategy.IN_PLACE);
                }
                this.builder.setInvocation(invocationBuilder.build());
            }

            /*
             * WARNING - void declaration
             */
            public void visitNew(@NotNull JsNew x) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Instantiation.Builder instantiationBuilder = JsAstProtoBuf.Instantiation.newBuilder();
                Object object = x.getConstructorExpression();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"x.constructorExpression");
                instantiationBuilder.setQualifier(JsAstSerializer.access$serialize(this.this$0, (JsExpression)object));
                object = x.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"x.arguments");
                object = (Iterable)object;
                JsAstSerializer jsAstSerializer = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsExpression it = (JsExpression)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    instantiationBuilder.addArgument(JsAstSerializer.access$serialize(jsAstSerializer, it));
                }
                this.builder.setInstantiation(instantiationBuilder.build());
            }
        };
        JsAstSerializer this_$iv = this;
        boolean $i$f$withLocation = false;
        JsLocation location$iv = this_$iv.extractLocation(expression2);
        boolean fileChanged$iv = false;
        if (location$iv != null) {
            String newFile$iv;
            String lastFile$iv = (String)this_$iv.fileStack.peek();
            boolean bl = fileChanged$iv = !Intrinsics.areEqual((Object)lastFile$iv, (Object)(newFile$iv = location$iv.getFile()));
            if (fileChanged$iv) {
                int it = this_$iv.serialize(newFile$iv);
                boolean bl2 = false;
                visitor2.getBuilder().setFileId(it);
                this_$iv.fileStack.push(location$iv.getFile());
            }
            JsAstProtoBuf.Location.Builder locationBuilder$iv = JsAstProtoBuf.Location.newBuilder();
            locationBuilder$iv.setStartLine(location$iv.getStartLine());
            locationBuilder$iv.setStartChar(location$iv.getStartChar());
            JsAstProtoBuf.Location location2 = locationBuilder$iv.build();
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"locationBuilder.build()");
            JsAstProtoBuf.Location it = location2;
            boolean bl3 = false;
            visitor2.getBuilder().setLocation(it);
        }
        boolean bl = false;
        expression2.accept(visitor2);
        if (fileChanged$iv) {
            this_$iv.fileStack.pop();
        }
        JsAstProtoBuf.ExpressionOrBuilder expressionOrBuilder = visitor2.getBuilder();
        boolean bl4 = false;
        boolean bl5 = false;
        JsAstProtoBuf.Expression.Builder $this$serialize_u24lambda_u2d19 = expressionOrBuilder;
        boolean bl6 = false;
        $this$serialize_u24lambda_u2d19.setSynthetic(MetadataProperties.getSynthetic(expression2));
        $this$serialize_u24lambda_u2d19.setSideEffects(this.map(MetadataProperties.getSideEffects(expression2)));
        JsImportedModule jsImportedModule = MetadataProperties.getLocalAlias(expression2);
        if (jsImportedModule != null) {
            JsImportedModule jsImportedModule2 = jsImportedModule;
            boolean bl7 = false;
            boolean bl8 = false;
            JsImportedModule it = jsImportedModule2;
            boolean bl9 = false;
            $this$serialize_u24lambda_u2d19.setLocalAlias(this.serialize(it));
        }
        expressionOrBuilder = visitor2.getBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)expressionOrBuilder, (String)"visitor.builder.build()");
        return expressionOrBuilder;
    }

    private final JsAstProtoBuf.JsImportedModule serialize(JsImportedModule module2) {
        JsAstProtoBuf.JsImportedModule.Builder moduleBuilder = JsAstProtoBuf.JsImportedModule.newBuilder();
        moduleBuilder.setExternalName(this.serialize(module2.getExternalName()));
        moduleBuilder.setInternalName(this.serialize(module2.getInternalName()));
        Object object = module2.getPlainReference();
        if (object != null) {
            JsExpression jsExpression = object;
            boolean bl = false;
            boolean bl2 = false;
            JsExpression it = jsExpression;
            boolean bl3 = false;
            moduleBuilder.setPlainReference(this.serialize(it));
        }
        object = moduleBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"moduleBuilder.build()");
        return object;
    }

    private final JsAstProtoBuf.Parameter serializeParameter(JsParameter parameter) {
        JsAstProtoBuf.Parameter.Builder parameterBuilder = JsAstProtoBuf.Parameter.newBuilder();
        Object object = parameter.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameter.name");
        parameterBuilder.setNameId(this.serialize((JsName)object));
        if (MetadataProperties.getHasDefaultValue(parameter)) {
            parameterBuilder.setHasDefaultValue(true);
        }
        object = parameterBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameterBuilder.build()");
        return object;
    }

    private final JsAstProtoBuf.GlobalBlock serializeBlock(JsGlobalBlock block) {
        JsAstProtoBuf.GlobalBlock.Builder blockBuilder = JsAstProtoBuf.GlobalBlock.newBuilder();
        for (JsStatement part : block.getStatements()) {
            Intrinsics.checkNotNullExpressionValue((Object)part, (String)"part");
            blockBuilder.addStatement(this.serialize(part));
        }
        JsAstProtoBuf.GlobalBlock globalBlock = blockBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)globalBlock, (String)"blockBuilder.build()");
        return globalBlock;
    }

    /*
     * WARNING - void declaration
     */
    private final JsAstProtoBuf.Vars serializeVars(JsVars vars) {
        JsAstProtoBuf.Vars.Builder varsBuilder = JsAstProtoBuf.Vars.newBuilder();
        Object object = vars.getVars().iterator();
        while (object.hasNext()) {
            void this_$iv;
            JsVars.JsVar varDecl = object.next();
            JsAstProtoBuf.VarDeclaration.Builder declBuilder = JsAstProtoBuf.VarDeclaration.newBuilder();
            JsAstSerializer jsAstSerializer = this;
            Intrinsics.checkNotNullExpressionValue((Object)varDecl, (String)"varDecl");
            JsNode node$iv = varDecl;
            boolean $i$f$withLocation = false;
            JsLocation location$iv = ((JsAstSerializer)this_$iv).extractLocation(node$iv);
            boolean fileChanged$iv = false;
            if (location$iv != null) {
                String newFile$iv;
                String lastFile$iv = (String)((JsAstSerializer)this_$iv).fileStack.peek();
                boolean bl = fileChanged$iv = !Intrinsics.areEqual((Object)lastFile$iv, (Object)(newFile$iv = location$iv.getFile()));
                if (fileChanged$iv) {
                    int it = ((JsAstSerializer)this_$iv).serialize(newFile$iv);
                    boolean bl2 = false;
                    declBuilder.setFileId(it);
                    ((JsAstSerializer)this_$iv).fileStack.push(location$iv.getFile());
                }
                JsAstProtoBuf.Location.Builder locationBuilder$iv = JsAstProtoBuf.Location.newBuilder();
                locationBuilder$iv.setStartLine(location$iv.getStartLine());
                locationBuilder$iv.setStartChar(location$iv.getStartChar());
                JsAstProtoBuf.Location location2 = locationBuilder$iv.build();
                Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"locationBuilder.build()");
                JsAstProtoBuf.Location it = location2;
                boolean bl3 = false;
                declBuilder.setLocation(it);
            }
            boolean bl = false;
            HasMetadata hasMetadata = varDecl.getName();
            Intrinsics.checkNotNullExpressionValue((Object)hasMetadata, (String)"varDecl.name");
            declBuilder.setNameId(this.serialize((JsName)hasMetadata));
            hasMetadata = varDecl.getInitExpression();
            if (hasMetadata != null) {
                HasMetadata hasMetadata2 = hasMetadata;
                boolean bl4 = false;
                boolean bl5 = false;
                HasMetadata it = hasMetadata2;
                boolean bl6 = false;
                declBuilder.setInitialValue(this.serialize((JsExpression)it));
            }
            if (fileChanged$iv) {
                ((JsAstSerializer)this_$iv).fileStack.pop();
            }
            varsBuilder.addDeclaration(declBuilder);
        }
        if (vars.isMultiline()) {
            varsBuilder.setMultiline(true);
        }
        if ((object = MetadataProperties.getExportedPackage(vars)) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl7 = false;
            Object it = object2;
            boolean bl8 = false;
            varsBuilder.setExportedPackageId(this.serialize((String)it));
        }
        object = varsBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"varsBuilder.build()");
        return object;
    }

    private final JsAstProtoBuf.UnaryOperation serializeUnary(JsUnaryOperation x, boolean postfix) {
        JsAstProtoBuf.UnaryOperation.Builder unaryBuilder = JsAstProtoBuf.UnaryOperation.newBuilder();
        Object object = x.getArg();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"x.arg");
        unaryBuilder.setOperand(this.serialize((JsExpression)object));
        object = x.getOperator();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"x.operator");
        unaryBuilder.setType(this.map((JsUnaryOperator)object));
        unaryBuilder.setPostfix(postfix);
        object = unaryBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"unaryBuilder.build()");
        return object;
    }

    private final JsAstProtoBuf.BinaryOperation.Type map(JsBinaryOperator op) {
        JsAstProtoBuf.BinaryOperation.Type type2;
        JsBinaryOperator jsBinaryOperator = op;
        int n = WhenMappings.$EnumSwitchMapping$0[jsBinaryOperator.ordinal()];
        switch (n) {
            case 1: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.MUL;
                break;
            }
            case 2: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.DIV;
                break;
            }
            case 3: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.MOD;
                break;
            }
            case 4: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ADD;
                break;
            }
            case 5: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.SUB;
                break;
            }
            case 6: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.SHL;
                break;
            }
            case 7: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.SHR;
                break;
            }
            case 8: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.SHRU;
                break;
            }
            case 9: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.LT;
                break;
            }
            case 10: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.LTE;
                break;
            }
            case 11: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.GT;
                break;
            }
            case 12: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.GTE;
                break;
            }
            case 13: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.INSTANCEOF;
                break;
            }
            case 14: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.IN;
                break;
            }
            case 15: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.EQ;
                break;
            }
            case 16: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.NEQ;
                break;
            }
            case 17: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.REF_EQ;
                break;
            }
            case 18: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.REF_NEQ;
                break;
            }
            case 19: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.BIT_AND;
                break;
            }
            case 20: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.BIT_XOR;
                break;
            }
            case 21: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.BIT_OR;
                break;
            }
            case 22: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.AND;
                break;
            }
            case 23: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.OR;
                break;
            }
            case 24: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG;
                break;
            }
            case 25: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_ADD;
                break;
            }
            case 26: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_SUB;
                break;
            }
            case 27: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_MUL;
                break;
            }
            case 28: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_DIV;
                break;
            }
            case 29: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_MOD;
                break;
            }
            case 30: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_SHL;
                break;
            }
            case 31: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_SHR;
                break;
            }
            case 32: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_SHRU;
                break;
            }
            case 33: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_BIT_AND;
                break;
            }
            case 34: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_BIT_OR;
                break;
            }
            case 35: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_BIT_XOR;
                break;
            }
            case 36: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.COMMA;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return type2;
    }

    private final JsAstProtoBuf.UnaryOperation.Type map(JsUnaryOperator op) {
        JsAstProtoBuf.UnaryOperation.Type type2;
        JsUnaryOperator jsUnaryOperator = op;
        int n = WhenMappings.$EnumSwitchMapping$1[jsUnaryOperator.ordinal()];
        switch (n) {
            case 1: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.BIT_NOT;
                break;
            }
            case 2: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.DEC;
                break;
            }
            case 3: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.DELETE;
                break;
            }
            case 4: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.INC;
                break;
            }
            case 5: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.NEG;
                break;
            }
            case 6: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.POS;
                break;
            }
            case 7: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.NOT;
                break;
            }
            case 8: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.TYPEOF;
                break;
            }
            case 9: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.VOID;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return type2;
    }

    private final JsAstProtoBuf.SideEffects map(SideEffectKind sideEffects) {
        JsAstProtoBuf.SideEffects sideEffects2;
        SideEffectKind sideEffectKind = sideEffects;
        int n = WhenMappings.$EnumSwitchMapping$2[sideEffectKind.ordinal()];
        switch (n) {
            case 1: {
                sideEffects2 = JsAstProtoBuf.SideEffects.AFFECTS_STATE;
                break;
            }
            case 2: {
                sideEffects2 = JsAstProtoBuf.SideEffects.DEPENDS_ON_STATE;
                break;
            }
            case 3: {
                sideEffects2 = JsAstProtoBuf.SideEffects.PURE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sideEffects2;
    }

    private final JsAstProtoBuf.SpecialFunction map(SpecialFunction specialFunction) {
        JsAstProtoBuf.SpecialFunction specialFunction2;
        SpecialFunction specialFunction3 = specialFunction;
        int n = WhenMappings.$EnumSwitchMapping$3[specialFunction3.ordinal()];
        switch (n) {
            case 1: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.DEFINE_INLINE_FUNCTION;
                break;
            }
            case 2: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.WRAP_FUNCTION;
                break;
            }
            case 3: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.TO_BOXED_CHAR;
                break;
            }
            case 4: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.UNBOX_CHAR;
                break;
            }
            case 5: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.SUSPEND_CALL;
                break;
            }
            case 6: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.COROUTINE_RESULT;
                break;
            }
            case 7: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.COROUTINE_CONTROLLER;
                break;
            }
            case 8: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.COROUTINE_RECEIVER;
                break;
            }
            case 9: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.SET_COROUTINE_RESULT;
                break;
            }
            case 10: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.GET_KCLASS;
                break;
            }
            case 11: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return specialFunction2;
    }

    private final int serialize(JsName name2) {
        Integer n;
        Map<JsName, Integer> $this$getOrPut$iv = this.nameMap;
        boolean $i$f$getOrPut = false;
        Integer value$iv = $this$getOrPut$iv.get(name2);
        if (value$iv == null) {
            Object it;
            boolean bl;
            boolean bl2;
            Object object;
            boolean bl3 = false;
            JsAstProtoBuf.Name.Builder builder2 = JsAstProtoBuf.Name.newBuilder();
            Object object2 = name2.getIdent();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"name.ident");
            builder2.setIdentifier(this.serialize((String)object2));
            builder2.setTemporary(name2.isTemporary());
            object2 = MetadataProperties.getLocalAlias(name2);
            if (object2 != null) {
                object = object2;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl4 = false;
                builder2.setLocalNameId(this.serialize((LocalAlias)it));
            }
            if (MetadataProperties.getImported(name2) && !this.importedNames.contains(name2)) {
                builder2.setImported(true);
            }
            if ((object2 = MetadataProperties.getSpecialFunction(name2)) != null) {
                object = object2;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl5 = false;
                builder2.setSpecialFunction(this.map((SpecialFunction)((Object)it)));
            }
            int result2 = this.nameTableBuilder.getEntryCount();
            this.nameTableBuilder.addEntry(builder2);
            Integer answer$iv = result2;
            $this$getOrPut$iv.put(name2, answer$iv);
            n = answer$iv;
        } else {
            n = value$iv;
        }
        return ((Number)n).intValue();
    }

    private final JsAstProtoBuf.LocalAlias serialize(LocalAlias alias) {
        JsAstProtoBuf.LocalAlias.Builder builder2 = JsAstProtoBuf.LocalAlias.newBuilder();
        builder2.setLocalNameId(this.serialize(alias.getName()));
        Object object = alias.getTag();
        if (object != null) {
            String string2 = object;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            builder2.setTag(this.serialize(it));
        }
        object = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.build()");
        return object;
    }

    private final int serialize(String string2) {
        Integer n;
        Map<String, Integer> $this$getOrPut$iv = this.stringMap;
        boolean $i$f$getOrPut = false;
        Integer value$iv = $this$getOrPut$iv.get(string2);
        if (value$iv == null) {
            boolean bl = false;
            int result2 = this.stringTableBuilder.getEntryCount();
            this.stringTableBuilder.addEntry(string2);
            Integer answer$iv = result2;
            $this$getOrPut$iv.put(string2, answer$iv);
            n = answer$iv;
        } else {
            n = value$iv;
        }
        return ((Number)n).intValue();
    }

    private final void withLocation(JsNode node, Function1<? super Integer, Unit> fileConsumer, Function1<? super JsAstProtoBuf.Location, Unit> locationConsumer, Function0<Unit> inner) {
        boolean $i$f$withLocation = false;
        JsLocation location2 = this.extractLocation(node);
        boolean fileChanged = false;
        if (location2 != null) {
            String newFile;
            String lastFile = (String)this.fileStack.peek();
            boolean bl = fileChanged = !Intrinsics.areEqual((Object)lastFile, (Object)(newFile = location2.getFile()));
            if (fileChanged) {
                fileConsumer.invoke((Object)this.serialize(newFile));
                this.fileStack.push(location2.getFile());
            }
            JsAstProtoBuf.Location.Builder locationBuilder = JsAstProtoBuf.Location.newBuilder();
            locationBuilder.setStartLine(location2.getStartLine());
            locationBuilder.setStartChar(location2.getStartChar());
            JsAstProtoBuf.Location location3 = locationBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"locationBuilder.build()");
            locationConsumer.invoke((Object)location3);
        }
        inner.invoke();
        if (fileChanged) {
            this.fileStack.pop();
        }
    }

    private final JsLocation extractLocation(JsNode node) {
        JsLocation jsLocation;
        Object source = node.getSource();
        Object object = source;
        if (object instanceof JsLocationWithSource) {
            jsLocation = ((JsLocationWithSource)source).asSimpleLocation();
        } else if (object instanceof PsiElement) {
            Intrinsics.checkNotNullExpressionValue((Object)source, (String)"source");
            jsLocation = !CallUtilKt.isFakePsiElement((PsiElement)source) ? this.extractLocation((PsiElement)source) : null;
        } else {
            jsLocation = null;
        }
        return jsLocation;
    }

    private final JsLocation extractLocation(PsiElement element) {
        PsiFile file2 = element.getContainingFile();
        Document document = file2.getViewProvider().getDocument();
        Intrinsics.checkNotNull((Object)document);
        Document document2 = document;
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"file.viewProvider.document!!");
        Document document3 = document2;
        String path2 = (String)this.pathResolver.invoke((Object)new File(file2.getViewProvider().getVirtualFile().getPath()));
        int startOffset = element.getNode().getStartOffset();
        int startLine = document3.getLineNumber(startOffset);
        int startChar = startOffset - document3.getLineStartOffset(startLine);
        return new JsLocation(path2, startLine, startChar);
    }

    public static final /* synthetic */ JsAstProtoBuf.Expression access$serialize(JsAstSerializer $this, JsExpression expression2) {
        return $this.serialize(expression2);
    }

    public static final /* synthetic */ JsAstProtoBuf.Vars access$serializeVars(JsAstSerializer $this, JsVars vars) {
        return $this.serializeVars(vars);
    }

    public static final /* synthetic */ JsAstProtoBuf.GlobalBlock access$serializeBlock(JsAstSerializer $this, JsGlobalBlock block) {
        return $this.serializeBlock(block);
    }

    public static final /* synthetic */ JsAstProtoBuf.Statement access$serialize(JsAstSerializer $this, JsStatement statement2) {
        return $this.serialize(statement2);
    }

    public static final /* synthetic */ int access$serialize(JsAstSerializer $this, JsName name2) {
        return $this.serialize(name2);
    }

    public static final /* synthetic */ JsAstProtoBuf.Parameter access$serializeParameter(JsAstSerializer $this, JsParameter parameter) {
        return $this.serializeParameter(parameter);
    }

    public static final /* synthetic */ JsAstProtoBuf.BinaryOperation.Type access$map(JsAstSerializer $this, JsBinaryOperator op) {
        return $this.map(op);
    }

    public static final /* synthetic */ JsAstProtoBuf.UnaryOperation access$serializeUnary(JsAstSerializer $this, JsUnaryOperation x, boolean postfix) {
        return $this.serializeUnary(x, postfix);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[JsBinaryOperator.values().length];
            nArray[JsBinaryOperator.MUL.ordinal()] = 1;
            nArray[JsBinaryOperator.DIV.ordinal()] = 2;
            nArray[JsBinaryOperator.MOD.ordinal()] = 3;
            nArray[JsBinaryOperator.ADD.ordinal()] = 4;
            nArray[JsBinaryOperator.SUB.ordinal()] = 5;
            nArray[JsBinaryOperator.SHL.ordinal()] = 6;
            nArray[JsBinaryOperator.SHR.ordinal()] = 7;
            nArray[JsBinaryOperator.SHRU.ordinal()] = 8;
            nArray[JsBinaryOperator.LT.ordinal()] = 9;
            nArray[JsBinaryOperator.LTE.ordinal()] = 10;
            nArray[JsBinaryOperator.GT.ordinal()] = 11;
            nArray[JsBinaryOperator.GTE.ordinal()] = 12;
            nArray[JsBinaryOperator.INSTANCEOF.ordinal()] = 13;
            nArray[JsBinaryOperator.INOP.ordinal()] = 14;
            nArray[JsBinaryOperator.EQ.ordinal()] = 15;
            nArray[JsBinaryOperator.NEQ.ordinal()] = 16;
            nArray[JsBinaryOperator.REF_EQ.ordinal()] = 17;
            nArray[JsBinaryOperator.REF_NEQ.ordinal()] = 18;
            nArray[JsBinaryOperator.BIT_AND.ordinal()] = 19;
            nArray[JsBinaryOperator.BIT_XOR.ordinal()] = 20;
            nArray[JsBinaryOperator.BIT_OR.ordinal()] = 21;
            nArray[JsBinaryOperator.AND.ordinal()] = 22;
            nArray[JsBinaryOperator.OR.ordinal()] = 23;
            nArray[JsBinaryOperator.ASG.ordinal()] = 24;
            nArray[JsBinaryOperator.ASG_ADD.ordinal()] = 25;
            nArray[JsBinaryOperator.ASG_SUB.ordinal()] = 26;
            nArray[JsBinaryOperator.ASG_MUL.ordinal()] = 27;
            nArray[JsBinaryOperator.ASG_DIV.ordinal()] = 28;
            nArray[JsBinaryOperator.ASG_MOD.ordinal()] = 29;
            nArray[JsBinaryOperator.ASG_SHL.ordinal()] = 30;
            nArray[JsBinaryOperator.ASG_SHR.ordinal()] = 31;
            nArray[JsBinaryOperator.ASG_SHRU.ordinal()] = 32;
            nArray[JsBinaryOperator.ASG_BIT_AND.ordinal()] = 33;
            nArray[JsBinaryOperator.ASG_BIT_OR.ordinal()] = 34;
            nArray[JsBinaryOperator.ASG_BIT_XOR.ordinal()] = 35;
            nArray[JsBinaryOperator.COMMA.ordinal()] = 36;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[JsUnaryOperator.values().length];
            nArray[JsUnaryOperator.BIT_NOT.ordinal()] = 1;
            nArray[JsUnaryOperator.DEC.ordinal()] = 2;
            nArray[JsUnaryOperator.DELETE.ordinal()] = 3;
            nArray[JsUnaryOperator.INC.ordinal()] = 4;
            nArray[JsUnaryOperator.NEG.ordinal()] = 5;
            nArray[JsUnaryOperator.POS.ordinal()] = 6;
            nArray[JsUnaryOperator.NOT.ordinal()] = 7;
            nArray[JsUnaryOperator.TYPEOF.ordinal()] = 8;
            nArray[JsUnaryOperator.VOID.ordinal()] = 9;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[SideEffectKind.values().length];
            nArray[SideEffectKind.AFFECTS_STATE.ordinal()] = 1;
            nArray[SideEffectKind.DEPENDS_ON_STATE.ordinal()] = 2;
            nArray[SideEffectKind.PURE.ordinal()] = 3;
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[SpecialFunction.values().length];
            nArray[SpecialFunction.DEFINE_INLINE_FUNCTION.ordinal()] = 1;
            nArray[SpecialFunction.WRAP_FUNCTION.ordinal()] = 2;
            nArray[SpecialFunction.TO_BOXED_CHAR.ordinal()] = 3;
            nArray[SpecialFunction.UNBOX_CHAR.ordinal()] = 4;
            nArray[SpecialFunction.SUSPEND_CALL.ordinal()] = 5;
            nArray[SpecialFunction.COROUTINE_RESULT.ordinal()] = 6;
            nArray[SpecialFunction.COROUTINE_CONTROLLER.ordinal()] = 7;
            nArray[SpecialFunction.COROUTINE_RECEIVER.ordinal()] = 8;
            nArray[SpecialFunction.SET_COROUTINE_RESULT.ordinal()] = 9;
            nArray[SpecialFunction.GET_KCLASS.ordinal()] = 10;
            nArray[SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE.ordinal()] = 11;
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

