/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JdkClassesKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.JvmRecordApplicabilityCheckerKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmRecordApplicabilityChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "(Lorg/jetbrains/kotlin/config/JvmTarget;)V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class JvmRecordApplicabilityChecker
implements DeclarationChecker {
    @NotNull
    private final JvmTarget jvmTarget;

    public JvmRecordApplicabilityChecker(@NotNull JvmTarget jvmTarget) {
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        this.jvmTarget = jvmTarget;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        List<KtParameter> list2;
        Object reportSupertypeOn;
        Object modifierOrName;
        KtElementImplStub reportOn;
        Object v0;
        KtAnnotationEntry it;
        Object element$iv;
        Object object;
        KtElementImplStub supertypeEntry22;
        block21: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!(descriptor2 instanceof ClassDescriptor) || !(declaration instanceof KtClassOrObject)) {
                return;
            }
            for (KtElementImplStub supertypeEntry22 : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
                ClassifierDescriptor classifierDescriptor;
                KotlinType kotlinType = (KotlinType)context2.getTrace().get(BindingContext.TYPE, supertypeEntry22.getTypeReference());
                KotlinType kotlinType2 = kotlinType;
                if (!Intrinsics.areEqual(kotlinType2 == null ? null : ((classifierDescriptor = (object = kotlinType2.getConstructor()).getDeclarationDescriptor()) == null ? null : DescriptorUtilsKt.fqNameOrNull(classifierDescriptor)), (Object)JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME())) continue;
                context2.getTrace().report(ErrorsJvm.ILLEGAL_JAVA_LANG_RECORD_SUPERTYPE.on((PsiElement)supertypeEntry22));
                return;
            }
            if (!JvmAnnotationUtilKt.isJvmRecord((ClassDescriptor)descriptor2)) {
                return;
            }
            List<KtAnnotationEntry> list3 = ((KtClassOrObject)declaration).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"declaration.annotationEntries");
            Iterable iterable = list3;
            boolean $i$f$firstOrNull = false;
            object = iterable.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getShortName(), (Object)JvmAnnotationUtilKt.getJVM_RECORD_ANNOTATION_FQ_NAME().shortName())) continue;
                v0 = element$iv;
                break block21;
            }
            v0 = null;
        }
        supertypeEntry22 = v0;
        KtElementImplStub ktElementImplStub = reportOn = supertypeEntry22 == null ? (KtElementImplStub)((Object)declaration) : (KtElementImplStub)supertypeEntry22;
        if (DescriptorUtilsKt.resolveTopLevelClass(context2.getModuleDescriptor(), JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME(), NoLookupLocation.FOR_DEFAULT_IMPORTS) == null) {
            context2.getTrace().report(ErrorsJvm.JVM_RECORD_REQUIRES_JDK15.on((PsiElement)reportOn));
            return;
        }
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JvmRecordSupport)) {
            context2.getTrace().report(Errors.UNSUPPORTED_FEATURE.on((PsiElement)reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.JvmRecordSupport), (Object)context2.getLanguageVersionSettings())));
            return;
        }
        if (!JvmRecordApplicabilityCheckerKt.access$areRecordsAllowed(this.jvmTarget, context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getEnableJvmPreview()))) {
            context2.getTrace().report(ErrorsJvm.JVM_RECORDS_ILLEGAL_BYTECODE_TARGET.on((PsiElement)reportOn));
            return;
        }
        if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_CLASS) {
            PsiElement $i$f$firstOrNull;
            object = ((KtClassOrObject)declaration).getModifierList();
            PsiElement psiElement = $i$f$firstOrNull = object == null ? null : ((KtModifierList)object).getModifier(KtTokens.ENUM_KEYWORD);
            PsiElement psiElement2 = $i$f$firstOrNull == null ? ((object = ((KtClassOrObject)declaration).getNameIdentifier()) == null ? (PsiElement)declaration : object) : $i$f$firstOrNull;
            modifierOrName = psiElement2;
            context2.getTrace().report(ErrorsJvm.ENUM_JVM_RECORD.on((PsiElement)modifierOrName));
            return;
        }
        if (!ModalityUtilsKt.isFinalClass((ClassDescriptor)descriptor2)) {
            KtModifierList ktModifierList;
            KtModifierList ktModifierList2;
            KtModifierList $i$f$firstOrNull = ((KtClassOrObject)declaration).getModifierList();
            if ($i$f$firstOrNull == null) {
                ktModifierList2 = null;
            } else {
                object = new KtModifierKeywordToken[3];
                element$iv = KtTokens.ABSTRACT_KEYWORD;
                Intrinsics.checkNotNullExpressionValue(element$iv, (String)"ABSTRACT_KEYWORD");
                object[0] = element$iv;
                element$iv = KtTokens.OPEN_KEYWORD;
                Intrinsics.checkNotNullExpressionValue(element$iv, (String)"OPEN_KEYWORD");
                object[1] = element$iv;
                element$iv = KtTokens.SEALED_KEYWORD;
                Intrinsics.checkNotNullExpressionValue(element$iv, (String)"SEALED_KEYWORD");
                object[2] = element$iv;
                ktModifierList2 = ktModifierList = JvmRecordApplicabilityCheckerKt.access$findOneOfModifiers($i$f$firstOrNull, (KtModifierKeywordToken[])object);
            }
            modifierOrName = ktModifierList == null ? (($i$f$firstOrNull = ((KtClassOrObject)declaration).getNameIdentifier()) == null ? (PsiElement)declaration : $i$f$firstOrNull) : ktModifierList;
            context2.getTrace().report(ErrorsJvm.NON_FINAL_JVM_RECORD.on((PsiElement)modifierOrName));
            return;
        }
        if (((ClassDescriptor)descriptor2).isInner()) {
            PsiElement $i$f$firstOrNull;
            object = ((KtClassOrObject)declaration).getModifierList();
            PsiElement psiElement = $i$f$firstOrNull = object == null ? null : ((KtModifierList)object).getModifier(KtTokens.INNER_KEYWORD);
            PsiElement psiElement3 = $i$f$firstOrNull == null ? ((object = ((KtClassOrObject)declaration).getNameIdentifier()) == null ? (PsiElement)declaration : object) : $i$f$firstOrNull;
            modifierOrName = psiElement3;
            context2.getTrace().report(ErrorsJvm.INNER_JVM_RECORD.on((PsiElement)modifierOrName));
            return;
        }
        if (DescriptorUtils.isLocal(descriptor2)) {
            context2.getTrace().report(ErrorsJvm.LOCAL_JVM_RECORD.on((PsiElement)reportOn));
            return;
        }
        for (KtDeclaration ktDeclaration : ((KtClassOrObject)declaration).getDeclarations()) {
            if (!(ktDeclaration instanceof KtProperty)) continue;
            element$iv = context2.getTrace().get(BindingContext.DECLARATION_TO_DESCRIPTOR, ktDeclaration);
            Substitutable<CallableDescriptor> substitutable = object = element$iv instanceof PropertyDescriptor ? (PropertyDescriptor)element$iv : null;
            if (object == null) continue;
            Object propertyDescriptor = object;
            if (!Intrinsics.areEqual(context2.getTrace().getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor), (Object)true) && ((KtProperty)ktDeclaration).getDelegate() == null) continue;
            context2.getTrace().report(ErrorsJvm.FIELD_IN_JVM_RECORD.on(ktDeclaration));
            return;
        }
        for (KtSuperTypeListEntry ktSuperTypeListEntry : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
            if (!(ktSuperTypeListEntry instanceof KtDelegatedSuperTypeEntry)) continue;
            context2.getTrace().report(ErrorsJvm.DELEGATION_BY_IN_JVM_RECORD.on((PsiElement)ktSuperTypeListEntry));
            return;
        }
        for (KotlinType kotlinType : ((ClassDescriptor)descriptor2).getTypeConstructor().getSupertypes()) {
            Object classDescriptor;
            element$iv = kotlinType.getConstructor().getDeclarationDescriptor();
            object = element$iv instanceof ClassDescriptor ? (ClassDescriptor)element$iv : null;
            if (object == null || (classDescriptor = object).getKind() == ClassKind.INTERFACE || Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)classDescriptor), (Object)JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME())) continue;
            it = ((KtClassOrObject)declaration).getNameIdentifier();
            reportSupertypeOn = element$iv = it == null ? (PsiElement)declaration : it;
            context2.getTrace().report(ErrorsJvm.JVM_RECORD_EXTENDS_CLASS.on((PsiElement)reportSupertypeOn, kotlinType));
            return;
        }
        if (!((ClassDescriptor)descriptor2).isData()) {
            context2.getTrace().report(ErrorsJvm.NON_DATA_CLASS_JVM_RECORD.on((PsiElement)reportOn));
            return;
        }
        KtPrimaryConstructor primaryConstructor2 = ((KtClassOrObject)declaration).getPrimaryConstructor();
        PsiElement psiElement = primaryConstructor2;
        List<KtParameter> list4 = list2 = psiElement == null ? CollectionsKt.emptyList() : psiElement.getValueParameters();
        if (list2.isEmpty()) {
            element$iv = primaryConstructor2;
            reportSupertypeOn = element$iv == null ? null : ((KtConstructor)element$iv).getValueParameterList();
            PsiElement psiElement4 = psiElement = reportSupertypeOn == null ? ((KtClassOrObject)declaration).getNameIdentifier() : (PsiElement)reportSupertypeOn;
            if (psiElement != null) {
                reportSupertypeOn = psiElement;
                KtParameterList it2 = reportSupertypeOn;
                boolean bl = false;
                context2.getTrace().report(ErrorsJvm.JVM_RECORD_WITHOUT_PRIMARY_CONSTRUCTOR_PARAMETERS.on((PsiElement)it2));
                return;
            }
        }
        for (KtParameter parameter : list2) {
            if (parameter.hasValOrVar() && !parameter.isMutable()) continue;
            context2.getTrace().report(ErrorsJvm.JVM_RECORD_NOT_VAL_PARAMETER.on(parameter));
            return;
        }
        for (KtParameter parameter : CollectionsKt.dropLast(list2, (int)1)) {
            if (!parameter.isVarArg()) continue;
            context2.getTrace().report(ErrorsJvm.JVM_RECORD_NOT_LAST_VARARG_PARAMETER.on(parameter));
            return;
        }
    }
}

