/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"checkOuterClassArgumentsRequired", "", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirOuterClassArgumentsRequiredCheckerKt {
    private static final void checkOuterClassArgumentsRequired(FirTypeRef typeRef, FirRegularClass declaration, CheckerContext context2, DiagnosticReporter reporter2) {
        FirClassLikeSymbol<?> symbol2;
        if (!(typeRef instanceof FirResolvedTypeRef) || typeRef instanceof FirErrorTypeRef) {
            return;
        }
        ConeKotlinType type2 = ((FirResolvedTypeRef)typeRef).getType();
        FirTypeRef delegatedTypeRef = ((FirResolvedTypeRef)typeRef).getDelegatedTypeRef();
        if (delegatedTypeRef instanceof FirUserTypeRef && type2 instanceof ConeClassLikeType && (symbol2 = LookupTagUtilsKt.toSymbol(((ConeClassLikeType)type2).getLookupTag(), context2.getSession())) instanceof FirRegularClassSymbol) {
            ConeTypeProjection[] typeArguments2 = ResolveUtilsKt.toTypeProjections(((FirUserTypeRef)delegatedTypeRef).getQualifier());
            List<FirTypeParameterSymbol> typeParameters2 = ((FirRegularClassSymbol)symbol2).getTypeParameterSymbols();
            int n = typeArguments2.length;
            int n2 = typeParameters2.size();
            while (n < n2) {
                FirRegularClassSymbol firRegularClassSymbol;
                int index2;
                FirTypeParameterSymbol typeParameter;
                if (ResolveUtilsKt.isValidTypeParameterFromOuterClass(typeParameter = typeParameters2.get(index2 = n++), declaration, context2.getSession())) continue;
                FirBasedSymbol<?> firBasedSymbol = typeParameter.getContainingDeclarationSymbol();
                FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol = firBasedSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol : null;
                if (firRegularClassSymbol == null) break;
                FirRegularClassSymbol outerClass = firRegularClassSymbol;
                DiagnosticReporterKt.reportOn$default(reporter2, typeRef.getSource(), FirErrors.INSTANCE.getOUTER_CLASS_ARGUMENTS_REQUIRED(), (Object)outerClass, context2, null, 16, null);
                break;
            }
        }
        int n = 0;
        int n3 = type2.getTypeArguments().length;
        while (n < n3) {
            Object object;
            FirTypeRefSource firTypeRefSource;
            int index3;
            Object object2;
            if ((object2 = FirHelpersKt.extractArgumentTypeRefAndSource(typeRef, index3 = n++)) == null || (object2 = (firTypeRefSource = object2).getTypeRef()) == null) continue;
            Object it = object = object2;
            boolean bl = false;
            FirOuterClassArgumentsRequiredCheckerKt.checkOuterClassArgumentsRequired((FirTypeRef)it, declaration, context2, reporter2);
        }
    }

    public static final /* synthetic */ void access$checkOuterClassArgumentsRequired(FirTypeRef typeRef, FirRegularClass declaration, CheckerContext context2, DiagnosticReporter reporter2) {
        FirOuterClassArgumentsRequiredCheckerKt.checkOuterClassArgumentsRequired(typeRef, declaration, context2, reporter2);
    }
}

