/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory2;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionWithSmartcast;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedExpression;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeConstraintSystemHasContradiction;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016JH\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J*\u0010#\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010$\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u0007*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "explicitReceiverOfQualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getExplicitReceiverOfQualifiedAccess", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "resolvedVariable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "getResolvedVariable", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "unwrapped", "getUnwrapped", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkComponentCall", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "destructuringDeclarationType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "reference", "Lorg/jetbrains/kotlin/fir/references/FirErrorNamedReference;", "property", "componentCall", "Lorg/jetbrains/kotlin/fir/expressions/FirComponentCall;", "destructuringDeclaration", "checkInitializer", "initializer", "checkers"})
public final class FirDestructuringDeclarationChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirDestructuringDeclarationChecker INSTANCE = new FirDestructuringDeclarationChecker();

    private FirDestructuringDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        FirElement firElement;
        FirElement firElement2;
        Object iterator2;
        Object object;
        FirComponentCall firComponentCall;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirSourceElement firSourceElement = declaration.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        if (Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) {
            this.checkInitializer(source, declaration.getInitializer(), reporter2, context2);
            return;
        }
        if (!Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) {
            return;
        }
        FirExpression firExpression2 = declaration.getInitializer();
        FirComponentCall firComponentCall2 = firComponentCall = firExpression2 instanceof FirComponentCall ? (FirComponentCall)firExpression2 : null;
        if (firComponentCall == null) {
            return;
        }
        FirComponentCall componentCall = firComponentCall;
        firExpression2 = this.getExplicitReceiverOfQualifiedAccess(componentCall);
        if (firExpression2 == null) {
            return;
        }
        FirExpression originalExpression = firExpression2;
        FirVariable firVariable = this.getResolvedVariable((FirQualifiedAccessExpression)originalExpression);
        if (firVariable == null) {
            return;
        }
        FirVariable originalDestructuringDeclaration = firVariable;
        Object object2 = originalDestructuringDeclaration;
        if (object2 instanceof FirProperty) {
            FirExpression firExpression3;
            FirExpression firExpression4 = originalDestructuringDeclaration.getInitializer();
            if (Intrinsics.areEqual(firExpression4 == null ? null : ((object = firExpression4.getSource()) == null ? null : ((FirSourceElement)object).getElementType()), (Object)KtNodeTypes.FOR)) {
                object = originalDestructuringDeclaration.getInitializer();
                iterator2 = object == null ? null : this.getExplicitReceiverOfQualifiedAccess((FirExpression)object);
                FirQualifiedAccessExpression firQualifiedAccessExpression = iterator2;
                FirPureAbstractElement firPureAbstractElement = firQualifiedAccessExpression == null ? null : this.getResolvedVariable(firQualifiedAccessExpression);
                Object object3 = object = firPureAbstractElement instanceof FirProperty ? (FirProperty)firPureAbstractElement : null;
                firExpression3 = object == null ? null : ((firPureAbstractElement = ((FirProperty)object).getInitializer()) == null ? null : this.getExplicitReceiverOfQualifiedAccess((FirExpression)firPureAbstractElement));
            } else {
                firExpression3 = originalDestructuringDeclaration.getInitializer();
            }
            firElement2 = firExpression3;
        } else {
            firElement2 = firElement = object2 instanceof FirValueParameter ? (FirElement)originalDestructuringDeclaration : null;
        }
        if (firElement == null) {
            return;
        }
        FirElement originalDestructuringDeclarationOrInitializer = firElement;
        object2 = ((FirPureAbstractElement)originalDestructuringDeclarationOrInitializer).getSource();
        if (object2 == null) {
            return;
        }
        Object originalDestructuringDeclarationOrInitializerSource = object2;
        object = originalDestructuringDeclarationOrInitializer;
        Object object4 = object instanceof FirVariable ? FirTypeUtilsKt.getConeType(((FirVariable)originalDestructuringDeclarationOrInitializer).getReturnTypeRef()) : (iterator2 = object instanceof FirExpression ? FirTypeUtilsKt.getConeType(((FirExpression)originalDestructuringDeclarationOrInitializer).getTypeRef()) : null);
        if (iterator2 == null) {
            return;
        }
        Object originalDestructuringDeclarationType = iterator2;
        FirNamedReference reference = componentCall.getCalleeReference();
        if (reference instanceof FirErrorNamedReference) {
            this.checkComponentCall((FirSourceElement)originalDestructuringDeclarationOrInitializerSource, (ConeKotlinType)originalDestructuringDeclarationType, (FirErrorNamedReference)reference, declaration, componentCall, originalDestructuringDeclaration, reporter2, context2);
        }
    }

    private final void checkInitializer(FirSourceElement source, FirExpression initializer2, DiagnosticReporter reporter2, CheckerContext context2) {
        boolean needToReport;
        ConeDiagnostic coneDiagnostic;
        ConeSimpleDiagnostic coneSimpleDiagnostic;
        FirExpression firExpression2 = initializer2;
        boolean bl = firExpression2 == null ? true : (firExpression2 instanceof FirErrorExpression ? ((coneSimpleDiagnostic = (coneDiagnostic = ((FirErrorExpression)initializer2).getDiagnostic()) instanceof ConeSimpleDiagnostic ? (ConeSimpleDiagnostic)coneDiagnostic : null) == null ? null : coneSimpleDiagnostic.getKind()) == DiagnosticKind.Syntax : (needToReport = false));
        if (needToReport) {
            DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getINITIALIZER_REQUIRED_FOR_DESTRUCTURING_DECLARATION(), context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkComponentCall(FirSourceElement source, ConeKotlinType destructuringDeclarationType, FirErrorNamedReference reference, FirProperty property2, FirComponentCall componentCall, FirVariable destructuringDeclaration, DiagnosticReporter reporter2, CheckerContext context2) {
        ConeDiagnostic diagnostic = reference.getDiagnostic();
        if (diagnostic instanceof ConeUnresolvedNameError) {
            DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((ConeUnresolvedNameError)diagnostic).getName(), (Object)destructuringDeclarationType, context2, null, 32, null);
        } else if (diagnostic instanceof ConeAmbiguityError) {
            Collection<FirBasedSymbol<?>> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((ConeAmbiguityError)diagnostic).getCandidates();
            Name name2 = ((ConeAmbiguityError)diagnostic).getName();
            FirDiagnosticFactory2<Name, Collection<FirBasedSymbol<?>>> firDiagnosticFactory2 = FirErrors.INSTANCE.getCOMPONENT_FUNCTION_AMBIGUITY();
            FirSourceElement firSourceElement = source;
            DiagnosticReporter diagnosticReporter = reporter2;
            boolean $i$f$map = false;
            void var12_18 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Candidate candidate2 = (Candidate)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                FirBasedSymbol<?> firBasedSymbol = it.getSymbol();
                collection.add(firBasedSymbol);
            }
            collection = (List)destination$iv$iv;
            DiagnosticReporterKt.reportOn$default(diagnosticReporter, firSourceElement, firDiagnosticFactory2, (Object)name2, (Object)collection, context2, null, 32, null);
        } else if (diagnostic instanceof ConeInapplicableCandidateError) {
            if (ConeTypeUtilsKt.isNullable(destructuringDeclarationType)) {
                DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_ON_NULLABLE(), (Object)((FirNamedFunctionSymbol)((ConeInapplicableCandidateError)diagnostic).getCandidate().getSymbol()).getCallableId().getCallableName(), context2, null, 16, null);
            }
        } else if (diagnostic instanceof ConeConstraintSystemHasContradiction) {
            ConeKotlinType componentType = FirTypeUtilsKt.getConeType(componentCall.getTypeRef());
            if (componentType instanceof ConeClassErrorType) {
                return;
            }
            ConeKotlinType expectedType2 = FirTypeUtilsKt.getConeType(property2.getReturnTypeRef());
            if (!AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, SessionUtilsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)componentType, (KotlinTypeMarker)expectedType2, false, 8, null)) {
                FirSourceElement typeMismatchSource = destructuringDeclaration instanceof FirValueParameter ? property2.getSource() : source;
                DiagnosticReporterKt.reportOn$default(reporter2, typeMismatchSource, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_RETURN_TYPE_MISMATCH(), (Object)((ConeConstraintSystemHasContradiction)diagnostic).getCandidate().getCallInfo().getName(), (Object)componentType, (Object)expectedType2, context2, null, 64, null);
            }
        }
    }

    private final FirQualifiedAccessExpression getExplicitReceiverOfQualifiedAccess(FirExpression $this$explicitReceiverOfQualifiedAccess) {
        FirExpression firExpression2;
        FirQualifiedAccess firQualifiedAccess;
        FirQualifiedAccess firQualifiedAccess2 = firQualifiedAccess = $this$explicitReceiverOfQualifiedAccess instanceof FirQualifiedAccess ? (FirQualifiedAccess)((Object)$this$explicitReceiverOfQualifiedAccess) : null;
        FirExpression firExpression3 = firQualifiedAccess == null ? null : ((firExpression2 = firQualifiedAccess.getExplicitReceiver()) == null ? null : this.getUnwrapped(firExpression2));
        return firExpression3 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression3 : null;
    }

    private final FirExpression getUnwrapped(FirExpression $this$unwrapped) {
        FirExpression firExpression2 = $this$unwrapped;
        return firExpression2 instanceof FirExpressionWithSmartcast ? (FirExpression)((FirExpressionWithSmartcast)$this$unwrapped).getOriginalExpression() : (firExpression2 instanceof FirWrappedExpression ? ((FirWrappedExpression)$this$unwrapped).getExpression() : $this$unwrapped);
    }

    private final FirVariable getResolvedVariable(FirQualifiedAccessExpression $this$resolvedVariable) {
        FirVariableSymbol firVariableSymbol;
        FirReference firReference = $this$resolvedVariable.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference = firReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firReference : null;
        FirBasedSymbol<?> firBasedSymbol = firResolvedNamedReference == null ? null : firResolvedNamedReference.getResolvedSymbol();
        FirVariableSymbol firVariableSymbol2 = firVariableSymbol = firBasedSymbol instanceof FirVariableSymbol ? (FirVariableSymbol)firBasedSymbol : null;
        if (firVariableSymbol == null) {
            return null;
        }
        FirVariableSymbol symbol2 = firVariableSymbol;
        FirPhaseManagerKt.ensureResolved(symbol2, FirResolvePhase.BODY_RESOLVE);
        return (FirVariable)symbol2.getFir();
    }
}

