/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUpperBoundViolatedHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUpperBoundViolatedDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirUpperBoundViolatedDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirUpperBoundViolatedDeclarationChecker INSTANCE = new FirUpperBoundViolatedDeclarationChecker();

    private FirUpperBoundViolatedDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        FirSourceElement firSourceElement;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        if (declaration instanceof FirClass) {
            for (FirTypeParameterRef typeParameter : ((FirClass)declaration).getTypeParameters()) {
                if (!(typeParameter instanceof FirTypeParameter)) continue;
                for (FirTypeRef bound : ((FirTypeParameter)typeParameter).getBounds()) {
                    FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated$default(bound, context2, reporter2, null, null, null, false, false, 248, null);
                }
            }
            for (FirTypeRef superTypeRef : ((FirClass)declaration).getSuperTypeRefs()) {
                FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated$default(superTypeRef, context2, reporter2, null, null, null, false, false, 248, null);
            }
        } else if (declaration instanceof FirTypeAlias) {
            FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated$default(((FirTypeAlias)declaration).getExpandedTypeRef(), context2, reporter2, null, null, null, false, true, 120, null);
        } else if (declaration instanceof FirCallableDeclaration && !(((firSourceElement = ((FirCallableDeclaration)declaration).getReturnTypeRef().getSource()) == null ? null : firSourceElement.getKind()) instanceof FirFakeSourceElementKind)) {
            FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated$default(((FirCallableDeclaration)declaration).getReturnTypeRef(), context2, reporter2, null, null, null, false, CollectionsKt.lastOrNull(context2.getContainingDeclarations()) instanceof FirTypeAlias, 120, null);
        }
    }
}

