/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinAccessibility;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory2;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002-.B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010J,\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bJ4\u0010\u001c\u001a\u00020\u0015*\u0004\u0018\u00010\u001d2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u0014\u0010#\u001a\u00020\u0007*\u00020$2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010%\u001a\u00020\u0007*\u00020$2\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u0006\u0012\u0002\b\u00030'2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u0007JD\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u0006\u0012\u0002\b\u00030'2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010(\u001a\u00020\u0007H\u0002J\u000e\u0010*\u001a\u0004\u0018\u00010\u000e*\u00020+H\u0002J\f\u0010*\u001a\u0004\u0018\u00010\u000e*\u00020,R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker;", "", "()V", "LEVEL", "Lorg/jetbrains/kotlin/name/Name;", "MESSAGE", "isExperimentalityAcceptableInContext", "", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "loadExperimentalitiesFromConeArguments", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "typeArguments", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "loadExperimentalitiesFromTypeArguments", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "reportNotAcceptedExperimentalities", "", "experimentalities", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "addExperimentalities", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "result", "Lorg/jetbrains/kotlin/utils/SmartSet;", "visited", "", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "isAnnotatedWithUseExperimentalOf", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "isExperimentalityAcceptable", "loadExperimentalities", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "fromSetter", "knownExperimentalities", "loadExperimentalityForMarkerAnnotation", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Experimentality", "OptInLevel", "checkers"})
public final class FirOptInUsageBaseChecker {
    @NotNull
    public static final FirOptInUsageBaseChecker INSTANCE = new FirOptInUsageBaseChecker();
    @NotNull
    private static final Name LEVEL;
    @NotNull
    private static final Name MESSAGE;

    private FirOptInUsageBaseChecker() {
    }

    @Nullable
    public final Experimentality loadExperimentalityForMarkerAnnotation(@NotNull FirRegularClassSymbol $this$loadExperimentalityForMarkerAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$loadExperimentalityForMarkerAnnotation, (String)"<this>");
        FirPhaseManagerKt.ensureResolved($this$loadExperimentalityForMarkerAnnotation, FirResolvePhase.BODY_RESOLVE);
        return this.loadExperimentalityForMarkerAnnotation((FirRegularClass)$this$loadExperimentalityForMarkerAnnotation.getFir());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Experimentality> loadExperimentalitiesFromTypeArguments(@NotNull CheckerContext context2, @NotNull List<? extends FirTypeProjection> typeArguments2) {
        Collection<ConeTypeProjection> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(typeArguments2, (String)"typeArguments");
        if (typeArguments2.isEmpty()) {
            return SetsKt.emptySet();
        }
        Iterable iterable = typeArguments2;
        CheckerContext checkerContext = context2;
        FirOptInUsageBaseChecker firOptInUsageBaseChecker = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeProjection firTypeProjection = (FirTypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ConeTypeProjection coneTypeProjection = FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)it);
            collection.add(coneTypeProjection);
        }
        collection = (List)destination$iv$iv;
        return firOptInUsageBaseChecker.loadExperimentalitiesFromConeArguments(checkerContext, (List<? extends ConeTypeProjection>)collection);
    }

    @NotNull
    public final Set<Experimentality> loadExperimentalitiesFromConeArguments(@NotNull CheckerContext context2, @NotNull List<? extends ConeTypeProjection> typeArguments2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(typeArguments2, (String)"typeArguments");
        if (typeArguments2.isEmpty()) {
            return SetsKt.emptySet();
        }
        SmartSet result2 = SmartSet.Companion.create();
        Iterable $this$forEach$iv = typeArguments2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConeKotlinType coneKotlinType;
            ConeTypeProjection it = (ConeTypeProjection)element$iv;
            boolean bl = false;
            if (ConeTypesKt.isStarProjection(it) || (coneKotlinType = ConeTypesKt.getType(it)) == null) continue;
            FirOptInUsageBaseChecker.addExperimentalities$default(INSTANCE, coneKotlinType, context2, result2, null, 4, null);
        }
        return result2;
    }

    @NotNull
    public final Set<Experimentality> loadExperimentalities(@NotNull FirBasedSymbol<?> $this$loadExperimentalities, @NotNull CheckerContext context2, boolean fromSetter) {
        Intrinsics.checkNotNullParameter($this$loadExperimentalities, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.loadExperimentalities($this$loadExperimentalities, context2, null, new LinkedHashSet(), fromSetter);
    }

    private final Set<Experimentality> loadExperimentalities(FirBasedSymbol<?> $this$loadExperimentalities, CheckerContext context2, SmartSet<Experimentality> knownExperimentalities, Set<FirAnnotatedDeclaration> visited2, boolean fromSetter) {
        FirSinceKotlinAccessibility accessibility;
        Object object;
        FirClassLikeSymbol<?> parentClassSymbol;
        FirAnnotatedDeclaration firAnnotatedDeclaration;
        FirPhaseManagerKt.ensureResolved($this$loadExperimentalities, FirResolvePhase.STATUS);
        Object object2 = $this$loadExperimentalities.getFir();
        FirAnnotatedDeclaration firAnnotatedDeclaration2 = firAnnotatedDeclaration = object2 instanceof FirAnnotatedDeclaration ? (FirAnnotatedDeclaration)object2 : null;
        if (firAnnotatedDeclaration == null) {
            return SetsKt.emptySet();
        }
        FirAnnotatedDeclaration fir = firAnnotatedDeclaration;
        if (!visited2.add(fir)) {
            return SetsKt.emptySet();
        }
        object2 = knownExperimentalities;
        Object result2 = object2 == null ? SmartSet.Companion.create() : object2;
        FirSession session2 = context2.getSession();
        if (fir instanceof FirCallableDeclaration) {
            Object $this$forEach$iv;
            Object $this$processDirectlyOverriddenProperties$iv;
            Object object3 = ClassMembersKt.containingClass((FirCallableDeclaration)fir);
            FirClassLikeSymbol<?> firClassLikeSymbol = object3 == null ? null : LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object3, session2);
            FirClassLikeSymbol firClassLikeSymbol2 = parentClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            if (ClassMembersKt.isSubstitutionOrIntersectionOverride((FirCallableDeclaration)fir)) {
                Object $this$processDirectlyOverriddenFunctions$iv;
                FirTypeScope parentClassScope;
                firClassLikeSymbol = parentClassSymbol;
                if (firClassLikeSymbol != null) {
                    FirPhaseManagerKt.ensureResolved((FirBasedSymbol)firClassLikeSymbol, FirResolvePhase.STATUS);
                }
                object3 = parentClassSymbol;
                FirTypeScope firTypeScope = parentClassScope = object3 == null ? null : FirHelpersKt.unsubstitutedScope((FirClassSymbol)object3, context2);
                if ($this$loadExperimentalities instanceof FirNamedFunctionSymbol) {
                    object3 = parentClassScope;
                    if (object3 != null) {
                        object = object3;
                        FirNamedFunctionSymbol functionSymbol$iv = (FirNamedFunctionSymbol)$this$loadExperimentalities;
                        boolean $i$f$processDirectlyOverriddenFunctions = false;
                        ((FirTypeScope)$this$processDirectlyOverriddenFunctions$iv).processDirectOverriddenFunctionsWithBaseScope(functionSymbol$iv, (Function2<? super FirNamedFunctionSymbol, ? super FirTypeScope, ? extends ProcessorAction>)((Function2)new Function2<FirNamedFunctionSymbol, FirTypeScope, ProcessorAction>(context2, result2, visited2){
                            final /* synthetic */ CheckerContext $context$inlined;
                            final /* synthetic */ SmartSet $result$inlined;
                            final /* synthetic */ Set $visited$inlined;
                            {
                                this.$context$inlined = checkerContext;
                                this.$result$inlined = smartSet;
                                this.$visited$inlined = set;
                                super(2);
                            }

                            @NotNull
                            public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol overridden, @NotNull FirTypeScope $noName_1) {
                                Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
                                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
                                FirNamedFunctionSymbol it = overridden;
                                boolean bl = false;
                                FirOptInUsageBaseChecker.access$loadExperimentalities(FirOptInUsageBaseChecker.INSTANCE, it, this.$context$inlined, this.$result$inlined, this.$visited$inlined, false);
                                return ProcessorAction.NEXT;
                            }
                        }));
                    }
                } else if ($this$loadExperimentalities instanceof FirPropertySymbol && (object3 = parentClassScope) != null) {
                    $this$processDirectlyOverriddenFunctions$iv = object3;
                    FirPropertySymbol propertySymbol$iv = (FirPropertySymbol)$this$loadExperimentalities;
                    boolean $i$f$processDirectlyOverriddenProperties = false;
                    ((FirTypeScope)$this$processDirectlyOverriddenProperties$iv).processDirectOverriddenPropertiesWithBaseScope(propertySymbol$iv, (Function2<? super FirPropertySymbol, ? super FirTypeScope, ? extends ProcessorAction>)((Function2)new Function2<FirPropertySymbol, FirTypeScope, ProcessorAction>(context2, result2, visited2, fromSetter){
                        final /* synthetic */ CheckerContext $context$inlined;
                        final /* synthetic */ SmartSet $result$inlined;
                        final /* synthetic */ Set $visited$inlined;
                        final /* synthetic */ boolean $fromSetter$inlined;
                        {
                            this.$context$inlined = checkerContext;
                            this.$result$inlined = smartSet;
                            this.$visited$inlined = set;
                            this.$fromSetter$inlined = bl;
                            super(2);
                        }

                        @NotNull
                        public final ProcessorAction invoke(@NotNull FirPropertySymbol overridden, @NotNull FirTypeScope $noName_1) {
                            Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
                            Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
                            FirPropertySymbol it = overridden;
                            boolean bl = false;
                            FirOptInUsageBaseChecker.access$loadExperimentalities(FirOptInUsageBaseChecker.INSTANCE, it, this.$context$inlined, this.$result$inlined, this.$visited$inlined, this.$fromSetter$inlined);
                            return ProcessorAction.NEXT;
                        }
                    }));
                }
            }
            if (!(fir instanceof FirConstructor)) {
                FirTypeRef $this$coneTypeSafe$iv = ((FirCallableDeclaration)fir).getReturnTypeRef();
                boolean $i$f$coneTypeSafe = false;
                $this$processDirectlyOverriddenProperties$iv = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = $this$processDirectlyOverriddenProperties$iv == null ? null : ((FirResolvedTypeRef)$this$processDirectlyOverriddenProperties$iv).getType();
                if (!(coneKotlinType instanceof ConeKotlinType)) {
                    coneKotlinType = null;
                }
                this.addExperimentalities(coneKotlinType, context2, (SmartSet<Experimentality>)result2, visited2);
                $this$coneTypeSafe$iv = ((FirCallableDeclaration)fir).getReceiverTypeRef();
                this.addExperimentalities($this$coneTypeSafe$iv == null ? null : FirTypeUtilsKt.getConeType($this$coneTypeSafe$iv), context2, (SmartSet<Experimentality>)result2, visited2);
                if (fir instanceof FirSimpleFunction) {
                    $this$forEach$iv = ((FirSimpleFunction)fir).getValueParameters();
                    boolean $i$f$forEach = false;
                    $this$processDirectlyOverriddenProperties$iv = $this$forEach$iv.iterator();
                    while ($this$processDirectlyOverriddenProperties$iv.hasNext()) {
                        Object element$iv = $this$processDirectlyOverriddenProperties$iv.next();
                        FirValueParameter it = (FirValueParameter)element$iv;
                        boolean bl = false;
                        INSTANCE.addExperimentalities(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()), context2, (SmartSet<Experimentality>)result2, visited2);
                    }
                }
            }
            if (($this$forEach$iv = parentClassSymbol) != null) {
                this.loadExperimentalities((FirBasedSymbol)$this$forEach$iv, context2, (SmartSet<Experimentality>)result2, visited2, false);
            }
            if (fromSetter && $this$loadExperimentalities instanceof FirPropertySymbol && ($this$forEach$iv = ((FirPropertySymbol)$this$loadExperimentalities).getSetterSymbol()) != null) {
                this.loadExperimentalities((FirBasedSymbol)$this$forEach$iv, context2, (SmartSet<Experimentality>)result2, visited2, false);
            }
        } else if ($this$loadExperimentalities instanceof FirRegularClassSymbol && fir instanceof FirRegularClass) {
            FirClassLikeDeclaration $this$isLocal$iv = (FirClassLikeDeclaration)fir;
            boolean $i$f$isLocal = false;
            if (!$this$isLocal$iv.getSymbol().getClassId().isLocal() && ($i$f$isLocal = (parentClassSymbol = FirHelpersKt.outerClassSymbol((FirClassLikeSymbol)$this$loadExperimentalities, context2))) != null) {
                this.loadExperimentalities((FirBasedSymbol)$i$f$isLocal, context2, (SmartSet<Experimentality>)result2, visited2, false);
            }
        }
        for (FirAnnotationCall annotation2 : fir.getAnnotations()) {
            FirTypeRef $this$coneTypeSafe$iv = annotation2.getAnnotationTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirPureAbstractElement it = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = it == null ? null : it.getType();
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            ConeClassLikeType annotationType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
            if (annotation2.getUseSiteTarget() == AnnotationUseSiteTarget.PROPERTY_SETTER && !fromSetter) continue;
            object = annotationType;
            CollectionsKt.addIfNotNull((Collection)result2, object == null ? null : ((it = LookupTagUtilsKt.toFirRegularClass($i$f$coneTypeSafe = ((ConeClassLikeType)object).getLookupTag(), session2)) == null ? null : this.loadExperimentalityForMarkerAnnotation((FirRegularClass)it)));
        }
        if (fir instanceof FirTypeAlias) {
            this.addExperimentalities(FirTypeUtilsKt.getConeType(((FirTypeAlias)fir).getExpandedTypeRef()), context2, (SmartSet<Experimentality>)result2, visited2);
        }
        if (FirAnnotationHelpersKt.getAnnotationByClassId(fir, OptInNames.INSTANCE.getWAS_EXPERIMENTAL_CLASS_ID()) != null && (accessibility = FirSinceKotlinHelpersKt.checkSinceKotlinVersionAccessibility(fir, context2)) instanceof FirSinceKotlinAccessibility.NotAccessibleButWasExperimental) {
            Iterable $this$forEach$iv = ((FirSinceKotlinAccessibility.NotAccessibleButWasExperimental)accessibility).getMarkerClasses();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                boolean bl = false;
                FirPhaseManagerKt.ensureResolved(it, FirResolvePhase.STATUS);
                CollectionsKt.addIfNotNull((Collection)result2, INSTANCE.loadExperimentalityForMarkerAnnotation((FirRegularClass)it.getFir()));
            }
        }
        return (Set)result2;
    }

    private final void addExperimentalities(ConeKotlinType $this$addExperimentalities, CheckerContext context2, SmartSet<Experimentality> result2, Set<FirAnnotatedDeclaration> visited2) {
        if (!($this$addExperimentalities instanceof ConeClassLikeType)) {
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(((ConeClassLikeType)$this$addExperimentalities).getLookupTag(), context2.getSession());
        if (firClassLikeSymbol != null) {
            this.loadExperimentalities((FirBasedSymbol)firClassLikeSymbol, context2, result2, visited2, false);
        }
        ConeTypeProjection[] $this$forEach$iv = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$addExperimentalities, context2.getSession(), null, 2, null).getTypeArguments();
        boolean $i$f$forEach = false;
        for (ConeTypeProjection element$iv : $this$forEach$iv) {
            ConeKotlinType coneKotlinType;
            ConeTypeProjection it = element$iv;
            boolean bl = false;
            if (ConeTypesKt.isStarProjection(it) || (coneKotlinType = ConeTypesKt.getType(it)) == null) continue;
            INSTANCE.addExperimentalities(coneKotlinType, context2, result2, visited2);
        }
    }

    static /* synthetic */ void addExperimentalities$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, ConeKotlinType coneKotlinType, CheckerContext checkerContext, SmartSet smartSet, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = new LinkedHashSet();
        }
        firOptInUsageBaseChecker.addExperimentalities(coneKotlinType, checkerContext, smartSet, set);
    }

    private final Experimentality loadExperimentalityForMarkerAnnotation(FirRegularClass $this$loadExperimentalityForMarkerAnnotation) {
        OptInLevel optInLevel;
        Object object;
        FirQualifiedAccessExpression firQualifiedAccessExpression;
        FirAnnotationCall experimental;
        block4: {
            String string2;
            FirResolvedNamedReference firResolvedNamedReference;
            FirQualifiedAccessExpression levelArgument;
            FirAnnotationCall firAnnotationCall = FirAnnotationHelpersKt.getAnnotationByClassId($this$loadExperimentalityForMarkerAnnotation, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID());
            if (firAnnotationCall == null) {
                return null;
            }
            experimental = firAnnotationCall;
            FirExpression firExpression2 = FirAnnotationUtilsKt.findArgumentByName(experimental, LEVEL);
            firQualifiedAccessExpression = levelArgument = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
            object = firQualifiedAccessExpression == null ? null : firQualifiedAccessExpression.getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = object instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object : null;
            if (firResolvedNamedReference == null) {
                string2 = null;
            } else {
                object = firResolvedNamedReference.getName();
                string2 = ((Name)object).asString();
            }
            String levelName = string2;
            OptInLevel[] $this$firstOrNull$iv = OptInLevel.values();
            boolean $i$f$firstOrNull = false;
            for (OptInLevel element$iv : $this$firstOrNull$iv) {
                OptInLevel it = element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)levelName)) continue;
                optInLevel = element$iv;
                break block4;
            }
            optInLevel = null;
        }
        object = optInLevel;
        Object level = object == null ? OptInLevel.DEFAULT : object;
        FirExpression firExpression2 = FirAnnotationUtilsKt.findArgumentByName(experimental, MESSAGE);
        FirConstExpression firConstExpression = firExpression2 instanceof FirConstExpression ? (FirConstExpression)firExpression2 : null;
        firQualifiedAccessExpression = firConstExpression == null ? null : firConstExpression.getValue();
        String message2 = firQualifiedAccessExpression instanceof String ? (String)((Object)firQualifiedAccessExpression) : null;
        return new Experimentality($this$loadExperimentalityForMarkerAnnotation.getSymbol().getClassId(), ((OptInLevel)((Object)level)).getSeverity(), message2);
    }

    public final void reportNotAcceptedExperimentalities(@NotNull Collection<Experimentality> experimentalities, @NotNull FirElement element, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter(experimentalities, (String)"experimentalities");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        for (Experimentality experimentality : experimentalities) {
            String string2;
            Object object;
            FirDiagnosticFactory2<FqName, String> diagnostic;
            ClassId annotationClassId;
            block10: {
                block9: {
                    FirDiagnosticFactory2<FqName, String> firDiagnosticFactory2;
                    annotationClassId = experimentality.component1();
                    Experimentality.Severity severity = experimentality.component2();
                    String message2 = experimentality.component3();
                    if (this.isExperimentalityAcceptableInContext(annotationClassId, context2)) continue;
                    Experimentality.Severity severity2 = severity;
                    int n = WhenMappings.$EnumSwitchMapping$0[severity2.ordinal()];
                    switch (n) {
                        case 1: {
                            firDiagnosticFactory2 = FirErrors.INSTANCE.getEXPERIMENTAL_API_USAGE();
                            break;
                        }
                        case 2: {
                            firDiagnosticFactory2 = FirErrors.INSTANCE.getEXPERIMENTAL_API_USAGE_ERROR();
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    diagnostic = firDiagnosticFactory2;
                    object = message2;
                    if (object != null) break block9;
                    Experimentality.Severity severity3 = severity;
                    int n2 = WhenMappings.$EnumSwitchMapping$0[severity3.ordinal()];
                    switch (n2) {
                        case 1: {
                            string2 = "This declaration is experimental and its usage should be marked";
                            break block10;
                        }
                        case 2: {
                            string2 = "This declaration is experimental and its usage must be marked";
                            break block10;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                string2 = object;
            }
            String reportedMessage = string2;
            FirSourceElement firSourceElement = element.getSource();
            object = annotationClassId.asSingleFqName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"annotationClassId.asSingleFqName()");
            DiagnosticReporterKt.reportOn$default(reporter2, firSourceElement, diagnostic, object, (Object)reportedMessage, context2, null, 32, null);
        }
    }

    private final boolean isExperimentalityAcceptableInContext(ClassId annotationClassId, CheckerContext context2) {
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        String string2 = annotationClassId.asFqNameString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"annotationClassId.asFqNameString()");
        String fqNameAsString = string2;
        if (languageVersionSettings.getFlag(AnalysisFlags.getUseExperimental()).contains(fqNameAsString)) {
            return true;
        }
        for (FirAnnotationContainer annotationContainer : context2.getAnnotationContainers()) {
            if (!this.isExperimentalityAcceptable(annotationContainer, annotationClassId)) continue;
            return true;
        }
        return false;
    }

    private final boolean isExperimentalityAcceptable(FirAnnotationContainer $this$isExperimentalityAcceptable, ClassId annotationClassId) {
        return FirAnnotationHelpersKt.getAnnotationByClassId($this$isExperimentalityAcceptable, annotationClassId) != null || this.isAnnotatedWithUseExperimentalOf($this$isExperimentalityAcceptable, annotationClassId);
    }

    private final boolean isAnnotatedWithUseExperimentalOf(FirAnnotationContainer $this$isAnnotatedWithUseExperimentalOf, ClassId annotationClassId) {
        for (FirAnnotationCall annotation2 : $this$isAnnotatedWithUseExperimentalOf.getAnnotations()) {
            boolean bl;
            block6: {
                Object object;
                ClassId classId;
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(annotation2.getAnnotationTypeRef());
                ConeClassLikeType coneType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
                coneKotlinType = coneType;
                if (coneKotlinType == null) {
                    classId = null;
                } else {
                    object = ((ConeClassLikeType)coneKotlinType).getLookupTag();
                    classId = ((ConeClassLikeLookupTag)object).getClassId();
                }
                if (!Intrinsics.areEqual(classId, (Object)OptInNames.INSTANCE.getOPT_IN_CLASS_ID()) || (object = FirAnnotationUtilsKt.findArgumentByName(annotation2, OptInNames.INSTANCE.getUSE_EXPERIMENTAL_ANNOTATION_CLASS())) == null) continue;
                Object annotationClasses = object;
                Iterable $this$any$iv = FirAnnotationHelpersKt.extractClassesFromArgument((FirExpression)annotationClasses);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getClassId(), (Object)annotationClassId)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static final /* synthetic */ Set access$loadExperimentalities(FirOptInUsageBaseChecker $this, FirBasedSymbol $receiver, CheckerContext context2, SmartSet knownExperimentalities, Set visited2, boolean fromSetter) {
        return $this.loadExperimentalities($receiver, context2, knownExperimentalities, visited2, fromSetter);
    }

    static {
        Name name2 = Name.identifier("level");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"level\")");
        LEVEL = name2;
        name2 = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"message\")");
        MESSAGE = name2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "severity", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "message", "", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;Ljava/lang/String;)V", "getAnnotationClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getMessage", "()Ljava/lang/String;", "getSeverity", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "Severity", "checkers"})
    public static final class Experimentality {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ClassId annotationClassId;
        @NotNull
        private final Severity severity;
        @Nullable
        private final String message;
        @NotNull
        private static final Severity DEFAULT_SEVERITY = Severity.ERROR;

        public Experimentality(@NotNull ClassId annotationClassId, @NotNull Severity severity, @Nullable String message2) {
            Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            this.annotationClassId = annotationClassId;
            this.severity = severity;
            this.message = message2;
        }

        @NotNull
        public final ClassId getAnnotationClassId() {
            return this.annotationClassId;
        }

        @NotNull
        public final Severity getSeverity() {
            return this.severity;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final ClassId component1() {
            return this.annotationClassId;
        }

        @NotNull
        public final Severity component2() {
            return this.severity;
        }

        @Nullable
        public final String component3() {
            return this.message;
        }

        @NotNull
        public final Experimentality copy(@NotNull ClassId annotationClassId, @NotNull Severity severity, @Nullable String message2) {
            Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            return new Experimentality(annotationClassId, severity, message2);
        }

        public static /* synthetic */ Experimentality copy$default(Experimentality experimentality, ClassId classId, Severity severity, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                classId = experimentality.annotationClassId;
            }
            if ((n & 2) != 0) {
                severity = experimentality.severity;
            }
            if ((n & 4) != 0) {
                string2 = experimentality.message;
            }
            return experimentality.copy(classId, severity, string2);
        }

        @NotNull
        public String toString() {
            return "Experimentality(annotationClassId=" + this.annotationClassId + ", severity=" + (Object)((Object)this.severity) + ", message=" + this.message + ')';
        }

        public int hashCode() {
            int result2 = this.annotationClassId.hashCode();
            result2 = result2 * 31 + this.severity.hashCode();
            result2 = result2 * 31 + (this.message == null ? 0 : this.message.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Experimentality)) {
                return false;
            }
            Experimentality experimentality = (Experimentality)other;
            if (!Intrinsics.areEqual((Object)this.annotationClassId, (Object)experimentality.annotationClassId)) {
                return false;
            }
            if (this.severity != experimentality.severity) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)experimentality.message);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "", "(Ljava/lang/String;I)V", "WARNING", "ERROR", "checkers"})
        public static final class Severity
        extends Enum<Severity> {
            public static final /* enum */ Severity WARNING = new Severity();
            public static final /* enum */ Severity ERROR = new Severity();
            private static final /* synthetic */ Severity[] $VALUES;

            public static Severity[] values() {
                return (Severity[])$VALUES.clone();
            }

            public static Severity valueOf(String value2) {
                return Enum.valueOf(Severity.class, value2);
            }

            static {
                $VALUES = severityArray = new Severity[]{Severity.WARNING, Severity.ERROR};
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Companion;", "", "()V", "DEFAULT_SEVERITY", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "getDEFAULT_SEVERITY", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "checkers"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Severity getDEFAULT_SEVERITY() {
                return DEFAULT_SEVERITY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$OptInLevel;", "", "severity", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "(Ljava/lang/String;ILorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;)V", "getSeverity", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "WARNING", "ERROR", "DEFAULT", "checkers"})
    private static final class OptInLevel
    extends Enum<OptInLevel> {
        @NotNull
        private final Experimentality.Severity severity;
        public static final /* enum */ OptInLevel WARNING = new OptInLevel(Experimentality.Severity.WARNING);
        public static final /* enum */ OptInLevel ERROR = new OptInLevel(Experimentality.Severity.ERROR);
        public static final /* enum */ OptInLevel DEFAULT = new OptInLevel(Experimentality.Companion.getDEFAULT_SEVERITY());
        private static final /* synthetic */ OptInLevel[] $VALUES;

        private OptInLevel(Experimentality.Severity severity) {
            this.severity = severity;
        }

        @NotNull
        public final Experimentality.Severity getSeverity() {
            return this.severity;
        }

        public static OptInLevel[] values() {
            return (OptInLevel[])$VALUES.clone();
        }

        public static OptInLevel valueOf(String value2) {
            return Enum.valueOf(OptInLevel.class, value2);
        }

        static {
            $VALUES = optInLevelArray = new OptInLevel[]{OptInLevel.WARNING, OptInLevel.ERROR, OptInLevel.DEFAULT};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Experimentality.Severity.values().length];
            nArray[Experimentality.Severity.WARNING.ordinal()] = 1;
            nArray[Experimentality.Severity.ERROR.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

