/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinImportAliasStub;
import org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtFileElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\b\u0012\u0004\u0012\u00020\u00020\u0004B!\b\u0016\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u001f\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u000b\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "Lcom/intellij/psi/stubs/PsiFileStubImpl;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinFileStub;", "Lcom/intellij/psi/stubs/PsiClassHolderFileStub;", "jetFile", "packageName", "", "isScript", "", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/lang/String;Z)V", "Lcom/intellij/util/io/StringRef;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/util/io/StringRef;Z)V", "findImportsByAlias", "", "Lorg/jetbrains/kotlin/psi/stubs/KotlinImportDirectiveStub;", "alias", "getClasses", "", "Lcom/intellij/psi/PsiClass;", "()[Lcom/intellij/psi/PsiClass;", "getPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getType", "Lcom/intellij/psi/tree/IStubFileElementType;", "toString", "psi"})
public class KotlinFileStubImpl
extends PsiFileStubImpl<KtFile>
implements KotlinFileStub,
PsiClassHolderFileStub<KtFile> {
    @NotNull
    private final StringRef packageName;
    private final boolean isScript;

    public KotlinFileStubImpl(@Nullable KtFile jetFile, @NotNull StringRef packageName, boolean isScript) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        super((PsiFile)jetFile);
        this.packageName = packageName;
        this.isScript = isScript;
    }

    public KotlinFileStubImpl(@Nullable KtFile jetFile, @NotNull String packageName, boolean isScript) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        StringRef stringRef = StringRef.fromString((String)packageName);
        Intrinsics.checkNotNull((Object)stringRef);
        this(jetFile, stringRef, isScript);
    }

    @Override
    @NotNull
    public FqName getPackageFqName() {
        String string2 = StringRef.toString((StringRef)this.packageName);
        Intrinsics.checkNotNull((Object)string2);
        return new FqName(string2);
    }

    @Override
    public boolean isScript() {
        return this.isScript;
    }

    @NotNull
    public IStubFileElementType<KotlinFileStub> getType() {
        KtFileElementType ktFileElementType = KtStubElementTypes.FILE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktFileElementType), (String)"FILE");
        return ktFileElementType;
    }

    @NotNull
    public String toString() {
        return "PsiJetFileStubImpl[package=" + this.getPackageFqName().asString() + ']';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiClass[] getClasses() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        List list2 = this.getChildrenStubs();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"childrenStubs");
        Iterable $this$filterIsInstance$iv = list2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiClassStub)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiClassStub psiClassStub = (PsiClassStub)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiClass psiClass = (PsiClass)it.getPsi();
            collection.add(psiClass);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiClass[] psiClassArray = thisCollection$iv.toArray(new PsiClass[0]);
        if (psiClassArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return psiClassArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<KotlinImportDirectiveStub> findImportsByAlias(@NotNull String alias) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Object v0;
        block5: {
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            List list2 = this.getChildrenStubs();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"childrenStubs");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                StubElement it = (StubElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getStubType(), KtStubElementTypes.IMPORT_LIST)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        Object object = v0;
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        StubElement importList = object;
        object = importList.getChildrenStubs();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"importList.childrenStubs");
        Iterable $this$filterIsInstance$iv = (Iterable)object;
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$firstOrNull = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KotlinImportDirectiveStub)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinImportAliasStub kotlinImportAliasStub;
            Object v1;
            block6: {
                KotlinImportDirectiveStub it = (KotlinImportDirectiveStub)element$iv$iv;
                boolean bl = false;
                List list3 = it.getChildrenStubs();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"it.childrenStubs");
                Iterable $this$firstIsInstanceOrNull$iv = list3;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof KotlinImportAliasStub)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            if (!Intrinsics.areEqual((Object)((kotlinImportAliasStub = (KotlinImportAliasStub)v1) == null ? null : kotlinImportAliasStub.getName()), (Object)alias)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

