/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.util;

import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ(\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\b\u001a\u00020\tJ\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/util/LibraryUtils;", "", "()V", "getAllVirtualFilesFromDirectory", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "dir", "Ljava/nio/file/Path;", "includeRoot", "", "getAllVirtualFilesFromJar", "jar", "jarFileSystem", "Lcom/intellij/openapi/vfs/impl/jar/CoreJarFileSystem;", "getAllVirtualFilesFromRoot", "root", "analysis-api-impl-base"})
public final class LibraryUtils {
    @NotNull
    public static final LibraryUtils INSTANCE = new LibraryUtils();

    private LibraryUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Collection<VirtualFile> getAllVirtualFilesFromJar(@NotNull Path jar, @NotNull CoreJarFileSystem jarFileSystem, boolean includeRoot) {
        Collection<VirtualFile> collection;
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        Intrinsics.checkNotNullParameter((Object)jarFileSystem, (String)"jarFileSystem");
        VirtualFile virtualFile = jarFileSystem.refreshAndFindFileByPath(jar + "!/");
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            Collection<VirtualFile> collection2 = INSTANCE.getAllVirtualFilesFromRoot(it, includeRoot);
            if (collection2 != null) {
                collection = collection2;
                return collection;
            }
        }
        collection = SetsKt.emptySet();
        return collection;
    }

    public static /* synthetic */ Collection getAllVirtualFilesFromJar$default(LibraryUtils libraryUtils, Path path2, CoreJarFileSystem coreJarFileSystem, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            coreJarFileSystem = new CoreJarFileSystem();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return libraryUtils.getAllVirtualFilesFromJar(path2, coreJarFileSystem, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Collection<VirtualFile> getAllVirtualFilesFromDirectory(@NotNull Path dir, boolean includeRoot) {
        Collection<VirtualFile> collection;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        VirtualFileSystem fs = StandardFileSystems.local();
        VirtualFile virtualFile = fs.findFileByPath(((Object)dir).toString());
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            Collection<VirtualFile> collection2 = INSTANCE.getAllVirtualFilesFromRoot(it, includeRoot);
            if (collection2 != null) {
                collection = collection2;
                return collection;
            }
        }
        collection = SetsKt.emptySet();
        return collection;
    }

    public static /* synthetic */ Collection getAllVirtualFilesFromDirectory$default(LibraryUtils libraryUtils, Path path2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return libraryUtils.getAllVirtualFilesFromDirectory(path2, bl);
    }

    private final Collection<VirtualFile> getAllVirtualFilesFromRoot(VirtualFile root2, boolean includeRoot) {
        Set files2 = new LinkedHashSet();
        if (includeRoot) {
            files2.add(root2);
        }
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)root2, LibraryUtils::getAllVirtualFilesFromRoot$lambda-2, arg_0 -> LibraryUtils.getAllVirtualFilesFromRoot$lambda-3(files2, arg_0));
        return files2;
    }

    private static final boolean getAllVirtualFilesFromRoot$lambda-2(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean getAllVirtualFilesFromRoot$lambda-3(Set $files, VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!virtualFile.isDirectory()) {
            $files.add(virtualFile);
        }
        return true;
    }
}

