/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.util;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.CfgContainingDeclarationUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u001a\t\u0010\u000f\u001a\u00020\u0010H\u0080\b\u001a-\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u0002H\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016\u001a'\u0010\u0017\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u000e\b\u0004\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u001a\u001a\f\u0010\u001b\u001a\u00020\b*\u00020\fH\u0000\u001a1\u0010\u001c\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u0012*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 \"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\"\u0018\u0010\u000b\u001a\u00020\f*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006!"}, d2={"ELEMENT_TAG", "", "containingKtFileIfAny", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getContainingKtFileIfAny", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Lorg/jetbrains/kotlin/psi/KtFile;", "isErrorElement", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "(Lorg/jetbrains/kotlin/fir/FirElement;)Z", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getKtDeclaration", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "checkCanceled", "", "executeOrReturnDefaultValueOnPCE", "T", "defaultValue", "action", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "executeWithoutPCE", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getElementTextInContext", "Lorg/jetbrains/kotlin/psi/KtElement;", "isNonAnonymousClassOrObject", "lockWithPCECheck", "Ljava/util/concurrent/locks/Lock;", "lockingIntervalMs", "", "(Ljava/util/concurrent/locks/Lock;JLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "low-level-api-fir"})
public final class UtilsKt {
    @NotNull
    private static final String ELEMENT_TAG = "ELEMENT";

    public static final <T> T executeOrReturnDefaultValueOnPCE(T defaultValue, @NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$executeOrReturnDefaultValueOnPCE = false;
        try {
            object = action.invoke();
        }
        catch (ProcessCanceledException e) {
            object = defaultValue;
        }
        return (T)object;
    }

    public static final <T> T executeWithoutPCE(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$executeWithoutPCE = false;
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        ProgressManager.getInstance().executeNonCancelableSection(new Runnable(result2, action){
            final /* synthetic */ Ref.ObjectRef<T> $result;
            final /* synthetic */ Function0<T> $action;
            {
                this.$result = $result;
                this.$action = $action;
            }

            public final void run() {
                this.$result.element = this.$action.invoke();
            }
        });
        return (T)result2.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T lockWithPCECheck(@NotNull Lock $this$lockWithPCECheck, long lockingIntervalMs, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)$this$lockWithPCECheck, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$lockWithPCECheck = false;
        boolean needToRun = true;
        Object result2 = null;
        while (needToRun) {
            boolean $i$f$checkCanceled = false;
            ProgressManager.checkCanceled();
            if (!$this$lockWithPCECheck.tryLock(lockingIntervalMs, TimeUnit.MILLISECONDS)) continue;
            try {
                needToRun = false;
                result2 = action.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                $this$lockWithPCECheck.unlock();
                InlineMarker.finallyEnd((int)1);
            }
        }
        Object object = result2;
        Intrinsics.checkNotNull(object);
        return (T)object;
    }

    public static final void checkCanceled() {
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
    }

    public static final boolean isErrorElement(@NotNull FirElement $this$isErrorElement) {
        Intrinsics.checkNotNullParameter((Object)$this$isErrorElement, (String)"<this>");
        return $this$isErrorElement instanceof FirDiagnosticHolder;
    }

    @NotNull
    public static final KtDeclaration getKtDeclaration(@NotNull FirDeclaration $this$ktDeclaration) {
        KtDeclaration ktDeclaration;
        Intrinsics.checkNotNullParameter((Object)$this$ktDeclaration, (String)"<this>");
        PsiElement psiElement = org.jetbrains.kotlin.fir.UtilsKt.getPsi($this$ktDeclaration);
        if (psiElement == null) {
            throw new IllegalStateException(("PSI element was not found for" + FirRendererKt.render$default($this$ktDeclaration, null, 1, null)).toString());
        }
        PsiElement psi2 = psiElement;
        PsiElement psiElement2 = psi2;
        if (psiElement2 instanceof KtDeclaration) {
            ktDeclaration = (KtDeclaration)psi2;
        } else if (psiElement2 instanceof KtObjectLiteralExpression) {
            KtObjectDeclaration ktObjectDeclaration = ((KtObjectLiteralExpression)psi2).getObjectDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"psi.objectDeclaration");
            ktDeclaration = ktObjectDeclaration;
        } else {
            StringBuilder stringBuilder2 = new StringBuilder().append("\n                   FirDeclaration.psi (").append(Reflection.getOrCreateKotlinClass($this$ktDeclaration.getClass()).getSimpleName()).append(") should be KtDeclaration but was ").append(Reflection.getOrCreateKotlinClass(psi2.getClass()).getSimpleName()).append("\n                   ");
            Object object = psi2 instanceof KtElement ? (KtElement)psi2 : null;
            if (object == null || (object = UtilsKt.getElementTextInContext((KtElement)object)) == null) {
                object = psi2.getText();
            }
            String string2 = StringsKt.trimIndent((String)stringBuilder2.append((String)object).append("\n                   \n                   ").append(FirRendererKt.render$default($this$ktDeclaration, null, 1, null)).append("\n                   ").toString());
            throw new IllegalStateException(string2.toString());
        }
        return ktDeclaration;
    }

    @Nullable
    public static final KtFile getContainingKtFileIfAny(@NotNull FirDeclaration $this$containingKtFileIfAny) {
        Intrinsics.checkNotNullParameter((Object)$this$containingKtFileIfAny, (String)"<this>");
        PsiElement psiElement = org.jetbrains.kotlin.fir.UtilsKt.getPsi($this$containingKtFileIfAny);
        PsiFile psiFile = psiElement != null ? psiElement.getContainingFile() : null;
        return psiFile instanceof KtFile ? (KtFile)psiFile : null;
    }

    public static final boolean isNonAnonymousClassOrObject(@NotNull KtDeclaration $this$isNonAnonymousClassOrObject) {
        Intrinsics.checkNotNullParameter((Object)$this$isNonAnonymousClassOrObject, (String)"<this>");
        return $this$isNonAnonymousClassOrObject instanceof KtClassOrObject && !KtPsiUtilKt.isObjectLiteral((KtClassOrObject)$this$isNonAnonymousClassOrObject);
    }

    @NotNull
    public static final String getElementTextInContext(@NotNull KtElement $this$getElementTextInContext) {
        KtElement ktElement;
        Intrinsics.checkNotNullParameter((Object)$this$getElementTextInContext, (String)"<this>");
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)$this$getElementTextInContext;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtImportDirective ktImportDirective = (KtImportDirective)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtImportDirective.class, (boolean)true);
        if (ktImportDirective != null) {
            ktElement = ktImportDirective;
        } else {
            PsiElement $this$parentOfType_u24default$iv2 = (PsiElement)$this$getElementTextInContext;
            boolean withSelf$iv2 = false;
            boolean $i$f$parentOfType2 = false;
            KtPackageDirective ktPackageDirective = (KtPackageDirective)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, KtPackageDirective.class, (boolean)true);
            if (ktPackageDirective != null) {
                ktElement = ktPackageDirective;
            } else {
                KtDeclaration ktDeclaration = CfgContainingDeclarationUtilsKt.getContainingDeclarationForPseudocode($this$getElementTextInContext);
                if (ktDeclaration != null) {
                    ktElement = ktDeclaration;
                } else {
                    KtFile ktFile = $this$getElementTextInContext.getContainingKtFile();
                    Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"containingKtFile");
                    ktElement = ktFile;
                }
            }
        }
        KtElement context = ktElement;
        StringBuilder builder2 = new StringBuilder();
        context.accept(new PsiElementVisitor($this$getElementTextInContext, builder2){
            final /* synthetic */ KtElement $this_getElementTextInContext;
            final /* synthetic */ StringBuilder $builder;
            {
                this.$this_getElementTextInContext = $receiver;
                this.$builder = $builder;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element == this.$this_getElementTextInContext) {
                    this.$builder.append("<ELEMENT>");
                }
                if (element instanceof LeafPsiElement) {
                    this.$builder.append(((LeafPsiElement)element).getText());
                } else {
                    element.acceptChildren((PsiElementVisitor)this);
                }
                if (element == this.$this_getElementTextInContext) {
                    this.$builder.append("</ELEMENT>");
                }
            }
        });
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.toString()");
        return ((Object)StringsKt.trim((CharSequence)StringsKt.trimIndent((String)string2))).toString();
    }
}

