/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir;

import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.symbols.DebugSymbolRenderer;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u00020\u0003B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B#\b\u0002\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ3\u0010\u0005\u001a\u0002H\n\"\n\b\u0002\u0010\n\u0018\u0001*\u00028\u00012\u0006\u0010\u000b\u001a\u00028\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/BuilderCache;", "From", "To", "", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "isReadOnly", "", "(Ljava/util/concurrent/ConcurrentMap;Z)V", "S", "key", "calculation", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "createReadOnlyCopy", "analysis-api-fir"})
final class BuilderCache<From, To> {
    @NotNull
    private final ConcurrentMap<From, To> cache;
    private final boolean isReadOnly;

    private BuilderCache(ConcurrentMap<From, To> cache2, boolean isReadOnly) {
        this.cache = cache2;
        this.isReadOnly = isReadOnly;
    }

    public BuilderCache() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftMap()");
        this(concurrentMap, false);
    }

    @NotNull
    public final BuilderCache<From, To> createReadOnlyCopy() {
        if (!(!this.isReadOnly)) {
            boolean bl = false;
            String string2 = "Cannot create readOnly BuilderCache from a readonly one";
            throw new IllegalStateException(string2.toString());
        }
        return new BuilderCache<From, To>(this.cache, true);
    }

    public final /* synthetic */ <S extends To> S cache(From key, Function0<? extends S> calculation) {
        Object object;
        Intrinsics.checkNotNullParameter(calculation, (String)"calculation");
        boolean $i$f$cache = false;
        if (this.isReadOnly) {
            object = this.cache.get(key);
            if (object == null) {
                object = calculation.invoke();
            }
        } else {
            ConcurrentMap $this$getOrPut$iv = this.cache;
            boolean $i$f$getOrPut = false;
            object = $this$getOrPut$iv.get(key);
            if (object == null) {
                Object default$iv = calculation.invoke();
                boolean bl = false;
                object = $this$getOrPut$iv.putIfAbsent(key, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
        }
        Object value2 = object;
        Intrinsics.reifiedOperationMarker((int)2, (String)"S");
        Object v = value2;
        if (v == null) {
            StringBuilder stringBuilder2 = new StringBuilder().append("Cannot cast ").append(Reflection.getOrCreateKotlinClass(value2.getClass())).append(" to ");
            Intrinsics.reifiedOperationMarker((int)4, (String)"S");
            StringBuilder stringBuilder3 = stringBuilder2.append(Reflection.getOrCreateKotlinClass(Object.class)).append('\n');
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.symbols.KtSymbol");
            throw new IllegalStateException(stringBuilder3.append(DebugSymbolRenderer.INSTANCE.render((KtSymbol)value2)).toString().toString());
        }
        return (S)v;
    }
}

