/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.fir.components.AvailableSymbol;
import org.jetbrains.kotlin.analysis.api.fir.components.ImportKind;
import org.jetbrains.kotlin.analysis.api.fir.utils.FirUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirModuleResolveState;
import org.jetbrains.kotlin.analysis.low.level.api.fir.element.builder.FirTowerContextProvider;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataContext;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataElement;
import org.jetbrains.kotlin.fir.declarations.builder.FirImportBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirResolvedImportBuilder;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirImportResolveTransformerKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageResolutionResult;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirExplicitSimpleImportingScope;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002J$\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ(\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00170\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u001f\u001a\u00020\u001bJ,\u0010 \u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0\u00170\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u001f\u001a\u00020\u001bJ,\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00122\u0006\u0010#\u001a\u00020$2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*J\u0014\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u00010,2\u0006\u0010-\u001a\u00020\u0018J\u001a\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010/*\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/FirShorteningContext;", "", "firResolveState", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirModuleResolveState;", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirModuleResolveState;)V", "getFirResolveState", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirModuleResolveState;", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "getFirSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "convertToImportableName", "Lorg/jetbrains/kotlin/name/FqName;", "callableSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "createFakeImportingScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "newImports", "", "createFakeResolvedImport", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "fqNameToImport", "findFirstClassifierInScopesByName", "Lorg/jetbrains/kotlin/analysis/api/fir/components/AvailableSymbol;", "Lorg/jetbrains/kotlin/name/ClassId;", "positionScopes", "targetClassName", "Lorg/jetbrains/kotlin/name/Name;", "findFunctionsInScopes", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "scopes", "name", "findPropertiesInScopes", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "findScopesAtPosition", "position", "Lorg/jetbrains/kotlin/psi/KtElement;", "towerContextProvider", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/element/builder/FirTowerContextProvider;", "getRegularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "toClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classId", "findFirstClassifierByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "analysis-api-fir"})
final class FirShorteningContext {
    @NotNull
    private final LLFirModuleResolveState firResolveState;

    public FirShorteningContext(@NotNull LLFirModuleResolveState firResolveState) {
        Intrinsics.checkNotNullParameter((Object)firResolveState, (String)"firResolveState");
        this.firResolveState = firResolveState;
    }

    @NotNull
    public final LLFirModuleResolveState getFirResolveState() {
        return this.firResolveState;
    }

    private final FirSession getFirSession() {
        return this.firResolveState.getRootModuleSession();
    }

    @Nullable
    public final AvailableSymbol<ClassId> findFirstClassifierInScopesByName(@NotNull List<? extends FirScope> positionScopes, @NotNull Name targetClassName) {
        Intrinsics.checkNotNullParameter(positionScopes, (String)"positionScopes");
        Intrinsics.checkNotNullParameter((Object)targetClassName, (String)"targetClassName");
        for (FirScope firScope2 : positionScopes) {
            FirClassifierSymbol<?> classifierSymbol;
            if (this.findFirstClassifierByName(firScope2, targetClassName) == null) continue;
            ConeClassifierLookupTag coneClassifierLookupTag = classifierSymbol.toLookupTag();
            ConeClassLikeLookupTag coneClassLikeLookupTag = coneClassifierLookupTag instanceof ConeClassLikeLookupTag ? (ConeClassLikeLookupTag)coneClassifierLookupTag : null;
            if (coneClassLikeLookupTag == null) continue;
            ConeClassLikeLookupTag classifierLookupTag = coneClassLikeLookupTag;
            return new AvailableSymbol<ClassId>(classifierLookupTag.getClassId(), ImportKind.Companion.fromScope(firScope2));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AvailableSymbol<FirNamedFunctionSymbol>> findFunctionsInScopes(@NotNull List<? extends FirScope> scopes2, @NotNull Name name2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(scopes2, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Iterable $this$flatMap$iv = scopes2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            FirScope scope2 = (FirScope)element$iv$iv;
            boolean bl = false;
            ImportKind importKind = ImportKind.Companion.fromScope(scope2);
            Iterable $this$map$iv = FirScopeKt.getFunctions(scope2, name2);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirNamedFunctionSymbol firNamedFunctionSymbol = (FirNamedFunctionSymbol)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new AvailableSymbol<void>(it, importKind));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AvailableSymbol<FirVariableSymbol<?>>> findPropertiesInScopes(@NotNull List<? extends FirScope> scopes2, @NotNull Name name2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(scopes2, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Iterable $this$flatMap$iv = scopes2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            FirScope scope2 = (FirScope)element$iv$iv;
            boolean bl = false;
            ImportKind importKind = ImportKind.Companion.fromScope(scope2);
            Iterable $this$map$iv = FirScopeKt.getProperties(scope2, name2);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirVariableSymbol firVariableSymbol = (FirVariableSymbol)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new AvailableSymbol<void>(it, importKind));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final FirClassifierSymbol<?> findFirstClassifierByName(FirScope $this$findFirstClassifierByName, Name name2) {
        void $this$processClassifiersByName$iv;
        Ref.ObjectRef element = new Ref.ObjectRef();
        FirScope firScope2 = $this$findFirstClassifierByName;
        Function1 processor$iv = new Function1<FirClassifierSymbol<?>, Unit>(element){
            final /* synthetic */ Ref.ObjectRef<FirClassifierSymbol<?>> $element;
            {
                this.$element = $element;
                super(1);
            }

            public final void invoke(@NotNull FirClassifierSymbol<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (this.$element.element == null) {
                    this.$element.element = it;
                }
            }
        };
        boolean $i$f$processClassifiersByName = false;
        $this$processClassifiersByName$iv.processClassifiersByNameWithSubstitution(name2, (Function2)new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(processor$iv){
            final /* synthetic */ Function1 $processor;
            {
                this.$processor = $processor;
                super(2);
            }

            public final void invoke(@NotNull FirClassifierSymbol<?> symbol2, @NotNull ConeSubstitutor coneSubstitutor) {
                Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
                Intrinsics.checkNotNullParameter((Object)coneSubstitutor, (String)"<anonymous parameter 1>");
                this.$processor.invoke(symbol2);
            }
        });
        return (FirClassifierSymbol)element.element;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<FirScope> findScopesAtPosition(@NotNull KtElement position, @NotNull List<FqName> newImports, @NotNull FirTowerContextProvider towerContextProvider) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List list2;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(newImports, (String)"newImports");
        Intrinsics.checkNotNullParameter((Object)towerContextProvider, (String)"towerContextProvider");
        FirTowerDataContext firTowerDataContext = towerContextProvider.getClosestAvailableParentContext(position);
        if (firTowerDataContext == null) {
            return null;
        }
        FirTowerDataContext towerDataContext = firTowerDataContext;
        List $this$findScopesAtPosition_u24lambda_u2d5 = list2 = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable iterable = towerDataContext.getNonLocalTowerDataElements();
        List list3 = $this$findScopesAtPosition_u24lambda_u2d5;
        boolean $i$f$mapNotNull = false;
        void var12_11 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirScope it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            FirTowerDataElement it = (FirTowerDataElement)element$iv$iv;
            boolean bl3 = false;
            if (it.getScope() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        list3.addAll((List)destination$iv$iv);
        CollectionsKt.addIfNotNull($this$findScopesAtPosition_u24lambda_u2d5, this.createFakeImportingScope(newImports));
        $this$findScopesAtPosition_u24lambda_u2d5.addAll((Collection)towerDataContext.getLocalScopes());
        List result2 = kotlin.collections.CollectionsKt.build((List)list2);
        return kotlin.collections.CollectionsKt.asReversed((List)result2);
    }

    /*
     * WARNING - void declaration
     */
    private final FirScope createFakeImportingScope(List<FqName> newImports) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = newImports;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirResolvedImport it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FqName it = (FqName)element$iv$iv;
            boolean bl2 = false;
            if (this.createFakeResolvedImport(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List resolvedNewImports = (List)destination$iv$iv;
        if (resolvedNewImports.isEmpty()) {
            return null;
        }
        return new FirExplicitSimpleImportingScope(resolvedNewImports, this.getFirSession(), new ScopeSession());
    }

    private final FirResolvedImport createFakeResolvedImport(FqName fqNameToImport) {
        PackageResolutionResult packageResolutionResult = FirImportResolveTransformerKt.resolveToPackageOrClass(FirSymbolProviderKt.getSymbolProvider(this.getFirSession()), fqNameToImport);
        PackageResolutionResult.PackageOrClass packageOrClass = packageResolutionResult instanceof PackageResolutionResult.PackageOrClass ? (PackageResolutionResult.PackageOrClass)packageResolutionResult : null;
        if (packageOrClass == null) {
            return null;
        }
        PackageResolutionResult.PackageOrClass packageOrClass2 = packageOrClass;
        boolean $i$f$buildImport = false;
        Object object = new FirImportBuilder();
        FirImportBuilder $this$createFakeResolvedImport_u24lambda_u2d7 = object;
        boolean bl = false;
        $this$createFakeResolvedImport_u24lambda_u2d7.setImportedFqName(fqNameToImport);
        $this$createFakeResolvedImport_u24lambda_u2d7.setAllUnder(false);
        FirImport delegateImport = ((FirImportBuilder)object).build();
        boolean $i$f$buildResolvedImport = false;
        Object $this$createFakeResolvedImport_u24lambda_u2d8 = object = new FirResolvedImportBuilder();
        boolean bl2 = false;
        ((FirResolvedImportBuilder)$this$createFakeResolvedImport_u24lambda_u2d8).setDelegate(delegateImport);
        ((FirResolvedImportBuilder)$this$createFakeResolvedImport_u24lambda_u2d8).setPackageFqName(packageOrClass2.getPackageFqName());
        return ((FirResolvedImportBuilder)object).build();
    }

    @Nullable
    public final FirRegularClass getRegularClass(@NotNull FirTypeRef typeRef) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(typeRef, this.getFirSession());
        return firRegularClassSymbol != null ? (FirRegularClass)firRegularClassSymbol.getFir() : null;
    }

    @Nullable
    public final FirClassLikeSymbol<?> toClassSymbol(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return FirSymbolProviderKt.getSymbolProvider(this.getFirSession()).getClassLikeSymbolByClassId(classId);
    }

    @Nullable
    public final FqName convertToImportableName(@NotNull FirCallableSymbol<?> callableSymbol) {
        Intrinsics.checkNotNullParameter(callableSymbol, (String)"callableSymbol");
        return FirUtilsKt.computeImportableName(callableSymbol, this.getFirSession());
    }
}

