/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.providers;

import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.FirFileBuilder;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.ModuleFileCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.providers.ProviderUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.FirElementFinder;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinPackageProvider;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010J \u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00132\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00132\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J&\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140 2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirProviderHelper;", "", "cache", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/ModuleFileCache;", "firFileBuilder", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/FirFileBuilder;", "declarationProvider", "Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProvider;", "packageProvider", "Lorg/jetbrains/kotlin/analysis/providers/KotlinPackageProvider;", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/ModuleFileCache;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/FirFileBuilder;Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProvider;Lorg/jetbrains/kotlin/analysis/providers/KotlinPackageProvider;)V", "getFirClassifierByFqName", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getPackage", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "getTopLevelCallableSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "packageFqName", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "collectCallableDeclarationsTo", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "list", "", "low-level-api-fir"})
public final class LLFirProviderHelper {
    @NotNull
    private final ModuleFileCache cache;
    @NotNull
    private final FirFileBuilder firFileBuilder;
    @NotNull
    private final KotlinDeclarationProvider declarationProvider;
    @NotNull
    private final KotlinPackageProvider packageProvider;

    public LLFirProviderHelper(@NotNull ModuleFileCache cache2, @NotNull FirFileBuilder firFileBuilder, @NotNull KotlinDeclarationProvider declarationProvider, @NotNull KotlinPackageProvider packageProvider) {
        Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)firFileBuilder, (String)"firFileBuilder");
        Intrinsics.checkNotNullParameter((Object)declarationProvider, (String)"declarationProvider");
        Intrinsics.checkNotNullParameter((Object)packageProvider, (String)"packageProvider");
        this.cache = cache2;
        this.firFileBuilder = firFileBuilder;
        this.declarationProvider = declarationProvider;
        this.packageProvider = packageProvider;
    }

    @Nullable
    public final FirClassLikeDeclaration getFirClassifierByFqName(@NotNull ClassId classId) {
        FirClassLikeDeclaration firClassLikeDeclaration;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        if (classId.isLocal()) {
            return null;
        }
        FirClassLikeDeclaration defaultValue$iv = null;
        boolean $i$f$executeOrReturnDefaultValueOnPCE = false;
        try {
            boolean bl = false;
            Optional optional = this.cache.getClassifierByClassId().computeIfAbsent(classId, arg_0 -> LLFirProviderHelper.getFirClassifierByFqName$lambda-2$lambda-1(this, classId, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"cache.classifierByClassI\u2026classifier)\n            }");
            firClassLikeDeclaration = (FirClassLikeDeclaration)ProviderUtilsKt.getOrNull(optional);
        }
        catch (ProcessCanceledException e$iv) {
            firClassLikeDeclaration = defaultValue$iv;
        }
        return firClassLikeDeclaration;
    }

    @NotNull
    public final List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        CallableId callableId = new CallableId(packageFqName, name2);
        List defaultValue$iv = CollectionsKt.emptyList();
        boolean $i$f$executeOrReturnDefaultValueOnPCE = false;
        try {
            boolean bl = false;
            list2 = this.cache.getCallableByCallableId().computeIfAbsent(callableId, arg_0 -> LLFirProviderHelper.getTopLevelCallableSymbols$lambda-9$lambda-8(this, callableId, name2, arg_0));
        }
        catch (ProcessCanceledException e$iv) {
            list2 = defaultValue$iv;
        }
        List list3 = list2;
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"executeOrReturnDefaultVa\u2026}\n            }\n        }");
        return list3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirNamedFunctionSymbol> getTopLevelFunctionSymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Iterable $this$filterIsInstance$iv = this.getTopLevelCallableSymbols(packageFqName, name2);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirNamedFunctionSymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirPropertySymbol> getTopLevelPropertySymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Iterable $this$filterIsInstance$iv = this.getTopLevelCallableSymbols(packageFqName, name2);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirPropertySymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void collectCallableDeclarationsTo(FirFile $this$collectCallableDeclarationsTo, List<FirCallableSymbol<?>> list2, Name name2) {
        Iterable $this$mapNotNullTo$iv = $this$collectCallableDeclarationsTo.getDeclarations();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirCallableSymbol<? extends FirCallableDeclaration> it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            FirDeclaration declaration = (FirDeclaration)element$iv;
            boolean bl2 = false;
            if ((declaration instanceof FirCallableDeclaration && Intrinsics.areEqual((Object)((FirCallableDeclaration)declaration).getSymbol().getCallableId().getCallableName(), (Object)name2) ? ((FirCallableDeclaration)declaration).getSymbol() : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            ((Collection)list2).add(it$iv);
        }
    }

    @Nullable
    public final FqName getPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        FqName fqName3 = fqName2;
        KotlinPackageProvider kotlinPackageProvider = this.packageProvider;
        FqName p0 = fqName3;
        boolean bl = false;
        return kotlinPackageProvider.doKotlinPackageExists(p0) ? fqName3 : null;
    }

    private static final Optional getFirClassifierByFqName$lambda-2$lambda-1(LLFirProviderHelper this$0, ClassId $classId, ClassId it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$classId, (String)"$classId");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KtClassOrObject klass = (KtClassOrObject)CollectionsKt.firstOrNull((Iterable)this$0.declarationProvider.getClassesByClassId($classId));
        KtNamedDeclaration ktNamedDeclaration = klass == null ? (KtNamedDeclaration)CollectionsKt.firstOrNull((Iterable)this$0.declarationProvider.getTypeAliasesByClassId($classId)) : (KtNamedDeclaration)(klass.getClassId() == null ? null : klass);
        if (ktNamedDeclaration == null) {
            return Optional.empty();
        }
        KtNamedDeclaration ktClass = ktNamedDeclaration;
        FirFileBuilder firFileBuilder = this$0.firFileBuilder;
        KtFile ktFile = ((KtClassLikeDeclaration)ktClass).getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"ktClass.containingKtFile");
        FirFile firFile = firFileBuilder.buildRawFirFileWithCaching(ktFile, this$0.cache);
        FirElementFinder $this$iv = FirElementFinder.INSTANCE;
        boolean $i$f$findElementIn = false;
        Ref.ObjectRef result$iv = new Ref.ObjectRef();
        ((FirElement)firFile).accept(new FirVisitorVoid(result$iv, $classId){
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ ClassId $classId$inlined;
            {
                this.$result = $result;
                this.$classId$inlined = classId;
            }

            public void visitElement(@NotNull FirElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (this.$result.element != null) {
                    return;
                }
                if (!(element instanceof FirClassLikeDeclaration) || element instanceof FirFile) {
                    element.acceptChildren(this);
                } else {
                    FirElement classifier = (FirClassLikeDeclaration)element;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)classifier.getSymbol().getClassId(), (Object)this.$classId$inlined)) {
                        this.$result.element = element;
                    } else {
                        classifier = element;
                        boolean bl2 = false;
                        if (true) {
                            element.acceptChildren(this);
                        }
                    }
                }
            }
        });
        FirClassLikeDeclaration firClassLikeDeclaration = (FirClassLikeDeclaration)((FirElement)result$iv.element);
        if (firClassLikeDeclaration == null) {
            throw new IllegalStateException(("Classifier " + $classId + " was found in file " + ((KtClassLikeDeclaration)ktClass).getContainingKtFile().getVirtualFilePath() + " but was not found in FirFile").toString());
        }
        FirClassLikeDeclaration classifier = firClassLikeDeclaration;
        return Optional.of(classifier);
    }

    private static final List getTopLevelCallableSymbols$lambda-9$lambda-8(LLFirProviderHelper this$0, CallableId $callableId, Name $name, CallableId it) {
        KtProperty it2;
        Collection collection;
        Collection collection2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callableId, (String)"$callableId");
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Set $this$getTopLevelCallableSymbols_u24lambda_u2d9_u24lambda_u2d8_u24lambda_u2d5 = collection2 = Sets.newIdentityHashSet();
        boolean bl = false;
        Iterable $this$mapTo$iv = this$0.declarationProvider.getTopLevelFunctions($callableId);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            KtNamedFunction ktNamedFunction = (KtNamedFunction)item$iv;
            collection = $this$getTopLevelCallableSymbols_u24lambda_u2d9_u24lambda_u2d8_u24lambda_u2d5;
            boolean bl2 = false;
            collection.add(it2.getContainingKtFile());
        }
        $this$mapTo$iv = this$0.declarationProvider.getTopLevelProperties($callableId);
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it2 = (KtProperty)item$iv;
            collection = $this$getTopLevelCallableSymbols_u24lambda_u2d9_u24lambda_u2d8_u24lambda_u2d5;
            boolean bl3 = false;
            collection.add(it2.getContainingKtFile());
        }
        Set files2 = collection2;
        Collection $this$getTopLevelCallableSymbols_u24lambda_u2d9_u24lambda_u2d8_u24lambda_u2d7 = collection2 = CollectionsKt.createListBuilder();
        boolean bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)files2, (String)"files");
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtFile ktFile = (KtFile)element$iv;
            boolean bl5 = false;
            FirFileBuilder firFileBuilder = this$0.firFileBuilder;
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"ktFile");
            FirFile firFile = firFileBuilder.buildRawFirFileWithCaching(ktFile, this$0.cache);
            this$0.collectCallableDeclarationsTo(firFile, (List<FirCallableSymbol<?>>)$this$getTopLevelCallableSymbols_u24lambda_u2d9_u24lambda_u2d8_u24lambda_u2d7, $name);
        }
        return CollectionsKt.build((List)collection2);
    }
}

