/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.MutableDiagnosticContext;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.FirOverridesBackwardCompatibilityHelperKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirOverrideChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverrideFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverridePropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J<\u0010\f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0016H\u0002J6\u0010\u0017\u001a\u00020\u00062\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J2\u0010\u001a\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e*\u00020\u001c2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0016H\u0002J8\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030\u000e2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J:\u0010\u001e\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J\u001d\u0010\u001f\u001a\u00020 *\u00020!2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0082\u0010J,\u0010$\u001a\u00020\u0006*\u00020\u000b2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010'\u001a\u00020\u0006*\u00020\u000b2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010(\u001a\u00020\u0006*\u00020\u000b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010)\u001a\u00020\u0006*\u00020\u000b2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010*\u001a\u00020\u0006*\u00020\u000b2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010+\u001a\u00020\u0006*\u00020\u000b2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010,\u001a\u00020\u0006*\u00020\u000b2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010-\u001a\u00020\u0006*\u00020\u000b2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010.\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0016*\u00020\u00132\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J,\u0010/\u001a\u000200*\u0002002\n\u00101\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u00102\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkMember", "member", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "containingClass", "typeCheckerState", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "firTypeScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "checkModality", "overriddenSymbols", "", "checkOverriddenExperimentalities", "memberSymbol", "overriddenMemberSymbols", "checkDeprecation", "checkMutability", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "checkReturnType", "checkVisibility", "hasAnnotationItselfOrInParent", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "reportCannotChangeAccessPrivilege", "overriding", "overridden", "reportCannotWeakenAccessPrivilege", "reportNothingToOverride", "reportOverridingFinalMember", "reportReturnTypeMismatchOnFunction", "reportTypeMismatchOnProperty", "reportTypeMismatchOnVariable", "reportVarOverriddenByVal", "retrieveDirectOverriddenOf", "substituteAllTypeParameters", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "overrideDeclaration", "baseDeclaration", "checkers"})
public final class FirOverrideChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirOverrideChecker INSTANCE = new FirOverrideChecker();

    private FirOverrideChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        TypeCheckerState typeCheckerState = TypeComponentsKt.getTypeContext(context.getSession()).newTypeCheckerState(false, false);
        FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(declaration, context);
        for (FirDeclaration it : declaration.getDeclarations()) {
            boolean bl;
            CheckerContext it2;
            if (!(it instanceof FirSimpleFunction) && !(it instanceof FirProperty)) continue;
            FirCallableDeclaration callable = (FirCallableDeclaration)it;
            boolean $i$f$withSuppressedDiagnostics = false;
            List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(callable);
            if (arguments$iv != null) {
                DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                if (diagnosticContext == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                }
                it2 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                bl = false;
                INSTANCE.checkMember(callable.getSymbol(), declaration, reporter2, typeCheckerState, firTypeScope, it2);
                continue;
            }
            it2 = (CheckerContext)((MutableDiagnosticContext)context);
            bl = false;
            INSTANCE.checkMember(callable.getSymbol(), declaration, reporter2, typeCheckerState, firTypeScope, it2);
        }
    }

    private final List<FirCallableSymbol<?>> retrieveDirectOverriddenOf(FirTypeScope $this$retrieveDirectOverriddenOf, FirCallableSymbol<?> memberSymbol) {
        List list2;
        FirCallableSymbol<?> firCallableSymbol = memberSymbol;
        if (firCallableSymbol instanceof FirNamedFunctionSymbol) {
            $this$retrieveDirectOverriddenOf.processFunctionsByName(memberSymbol.getName(), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)retrieveDirectOverriddenOf.1.INSTANCE));
            list2 = FirTypeScopeKt.getDirectOverriddenFunctions$default($this$retrieveDirectOverriddenOf, (FirNamedFunctionSymbol)memberSymbol, false, 2, null);
        } else if (firCallableSymbol instanceof FirPropertySymbol) {
            $this$retrieveDirectOverriddenOf.processPropertiesByName(memberSymbol.getName(), retrieveDirectOverriddenOf.2.INSTANCE);
            list2 = FirTypeScopeKt.getDirectOverriddenProperties$default($this$retrieveDirectOverriddenOf, (FirPropertySymbol)memberSymbol, false, 2, null);
        } else {
            throw new IllegalArgumentException("unexpected member kind " + memberSymbol);
        }
        return list2;
    }

    private final ConeKotlinType substituteAllTypeParameters(ConeKotlinType $this$substituteAllTypeParameters, FirCallableSymbol<?> overrideDeclaration, FirCallableSymbol<?> baseDeclaration, CheckerContext context) {
        List<FirTypeParameterSymbol> overrideTypeParameters = overrideDeclaration.getTypeParameterSymbols();
        if (overrideTypeParameters.isEmpty()) {
            return $this$substituteAllTypeParameters;
        }
        List<FirTypeParameterSymbol> baseTypeParameters = baseDeclaration.getTypeParameterSymbols();
        Map map = new LinkedHashMap();
        int size = Math.min(overrideTypeParameters.size(), baseTypeParameters.size());
        for (int it = 0; it < size; ++it) {
            FirTypeParameterSymbol to = overrideTypeParameters.get(it);
            FirTypeParameterSymbol from2 = baseTypeParameters.get(it);
            map.put(from2, FirNestedClassifierScopeKt.toConeType(to));
        }
        return SubstitutorsKt.substitutorByMap(map, context.getSession()).substituteOrSelf($this$substituteAllTypeParameters);
    }

    private final FirCallableSymbol<?> checkModality(List<? extends FirCallableSymbol<?>> overriddenSymbols2) {
        Iterator<FirCallableSymbol<?>> iterator2 = overriddenSymbols2.iterator();
        while (iterator2.hasNext()) {
            FirCallableSymbol<?> overridden;
            FirCallableSymbol<?> $this$modality$iv = overridden = iterator2.next();
            boolean $i$f$getModality = false;
            Modality modality = $this$modality$iv.getResolvedStatus().getModality();
            boolean isEffectivelyFinal = modality == null || modality == Modality.FINAL;
            if (!isEffectivelyFinal) continue;
            return overridden;
        }
        return null;
    }

    private final FirCallableSymbol<?> checkMutability(FirPropertySymbol $this$checkMutability, List<? extends FirCallableSymbol<?>> overriddenSymbols2) {
        Object v2;
        block2: {
            if ($this$checkMutability.isVar()) {
                return null;
            }
            Iterable iterable = overriddenSymbols2;
            for (Object t : iterable) {
                FirCallableSymbol it = (FirCallableSymbol)t;
                boolean bl = false;
                FirPropertySymbol firPropertySymbol = it instanceof FirPropertySymbol ? (FirPropertySymbol)it : null;
                boolean bl2 = firPropertySymbol != null ? firPropertySymbol.isVar() : false;
                if (!bl2) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVisibility(FirCallableSymbol<?> $this$checkVisibility, FirClass containingClass, DiagnosticReporter reporter2, List<? extends FirCallableSymbol<?>> overriddenSymbols2, CheckerContext context) {
        boolean hasVisibleBase;
        block17: {
            boolean bl;
            FirElement firElement;
            block16: {
                block19: {
                    List visibilities;
                    block18: {
                        void $this$mapNotNullTo$iv$iv;
                        void $this$mapNotNull$iv;
                        Collection<FirCallableSymbol> collection;
                        void $this$mapTo$iv$iv;
                        FirCallableSymbol firCallableSymbol;
                        FirClass firClass;
                        DiagnosticReporter diagnosticReporter;
                        Iterator $this$sortedBy$iv;
                        Object object;
                        void $this$mapTo$iv$iv2;
                        if (overriddenSymbols2.isEmpty()) {
                            return;
                        }
                        Iterable $this$map$iv = overriddenSymbols2;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            void it;
                            FirCallableSymbol firCallableSymbol2 = (FirCallableSymbol)item$iv$iv;
                            object = destination$iv$iv;
                            boolean bl2 = false;
                            void $this$visibility$iv = it;
                            boolean $i$f$getVisibility = false;
                            object.add(TuplesKt.to((Object)it, (Object)$this$visibility$iv.getResolvedStatus().getVisibility()));
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$sortedBy2 = false;
                        visibilities = CollectionsKt.sortedWith((Iterable)((Object)$this$sortedBy$iv), (Comparator)new Comparator($this$checkVisibility){
                            final /* synthetic */ FirCallableSymbol $this_checkVisibility$inlined;
                            {
                                this.$this_checkVisibility$inlined = firCallableSymbol;
                            }

                            public final int compare(T a, T b) {
                                Pair pair = (Pair)a;
                                boolean bl = false;
                                FirCallableSymbol $this$visibility$iv = this.$this_checkVisibility$inlined;
                                boolean $i$f$getVisibility = false;
                                Integer n = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                                pair = (Pair)b;
                                Comparable comparable = Integer.valueOf(n != null ? n : Integer.MIN_VALUE);
                                bl = false;
                                $this$visibility$iv = this.$this_checkVisibility$inlined;
                                $i$f$getVisibility = false;
                                Integer n2 = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(n2 != null ? n2 : Integer.MIN_VALUE));
                            }
                        });
                        if (!($this$checkVisibility instanceof FirPropertySymbol)) break block18;
                        FirPropertyAccessorSymbol firPropertyAccessorSymbol = ((FirPropertySymbol)$this$checkVisibility).getGetterSymbol();
                        if (firPropertyAccessorSymbol != null) {
                            void $this$map$iv2;
                            Iterable $i$f$sortedBy2 = overriddenSymbols2;
                            diagnosticReporter = reporter2;
                            firClass = containingClass;
                            firCallableSymbol = firPropertyAccessorSymbol;
                            object = this;
                            boolean $i$f$map2 = false;
                            destination$iv$iv = $this$map$iv2;
                            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo2 = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                FirCallableSymbol bl2 = (FirCallableSymbol)item$iv$iv;
                                collection = destination$iv$iv2;
                                boolean bl3 = false;
                                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
                                FirPropertyAccessorSymbol firPropertyAccessorSymbol2 = ((FirPropertySymbol)it).getGetterSymbol();
                                collection.add((FirCallableSymbol)(firPropertyAccessorSymbol2 != null ? (FirCallableSymbol)firPropertyAccessorSymbol2 : it));
                            }
                            collection = (List)destination$iv$iv2;
                            super.checkVisibility(firCallableSymbol, firClass, diagnosticReporter, (List<? extends FirCallableSymbol<?>>)collection, context);
                        }
                        FirPropertyAccessorSymbol firPropertyAccessorSymbol3 = ((FirPropertySymbol)$this$checkVisibility).getSetterSymbol();
                        if (firPropertyAccessorSymbol3 == null) break block19;
                        Iterable $this$map$iv2 = overriddenSymbols2;
                        diagnosticReporter = reporter2;
                        firClass = containingClass;
                        firCallableSymbol = firPropertyAccessorSymbol3;
                        object = this;
                        boolean $i$f$mapNotNull = false;
                        $this$mapTo$iv$iv = $this$mapNotNull$iv;
                        Collection destination$iv$iv3 = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator it = $this$forEach$iv$iv$iv.iterator();
                        while (it.hasNext()) {
                            FirPropertyAccessorSymbol it$iv$iv;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = it.next();
                            boolean bl4 = false;
                            FirCallableSymbol it2 = (FirCallableSymbol)element$iv$iv;
                            boolean bl5 = false;
                            Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
                            if (((FirPropertySymbol)it2).getSetterSymbol() == null) continue;
                            boolean bl6 = false;
                            destination$iv$iv3.add(it$iv$iv);
                        }
                        collection = (List)destination$iv$iv3;
                        super.checkVisibility(firCallableSymbol, firClass, diagnosticReporter, (List<? extends FirCallableSymbol<?>>)collection, context);
                        break block19;
                    }
                    for (Pair $this$mapNotNull$iv : visibilities) {
                        FirCallableSymbol overridden = (FirCallableSymbol)$this$mapNotNull$iv.component1();
                        Visibility overriddenVisibility = (Visibility)$this$mapNotNull$iv.component2();
                        FirCallableSymbol<?> $this$visibility$iv = $this$checkVisibility;
                        boolean $i$f$getVisibility = false;
                        Integer compare = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), overriddenVisibility);
                        if (compare == null) {
                            this.reportCannotChangeAccessPrivilege(reporter2, $this$checkVisibility, overridden, context);
                            break;
                        }
                        if (compare >= 0) continue;
                        this.reportCannotWeakenAccessPrivilege(reporter2, $this$checkVisibility, overridden, context);
                        break;
                    }
                }
                if ($this$checkVisibility instanceof FirPropertyAccessorSymbol) {
                    return;
                }
                CheckerContext $this$findClosest_u24default$iv = context;
                boolean $i$f$findClosest = false;
                for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                    FirElement $i$f$forEach;
                    FirDeclaration firDeclaration = it$iv;
                    if (!(firDeclaration instanceof FirFile)) {
                        firDeclaration = null;
                    }
                    if ((firElement = (FirElement)((FirFile)firDeclaration)) == null) continue;
                    FirElement it = $i$f$forEach = firElement;
                    boolean bl7 = false;
                    firElement = true ? $i$f$forEach : null;
                    if (firElement == null) {
                        continue;
                    }
                    break block16;
                }
                firElement = null;
            }
            FirFile firFile = (FirFile)firElement;
            if (firFile == null) {
                return;
            }
            FirFile file2 = firFile;
            List containingDeclarations2 = CollectionsKt.plus((Collection)context.getContainingDeclarations(), (Object)containingClass);
            FirVisibilityChecker visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context.getSession());
            Iterable $this$any$iv = overriddenSymbols2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirCallableSymbol it = (FirCallableSymbol)element$iv;
                    boolean bl8 = false;
                    FirPhaseManagerKt.ensureResolved(it, FirResolvePhase.STATUS);
                    FirCallableDeclaration fir = (FirCallableDeclaration)it.getFir();
                    if (!FirVisibilityChecker.isVisible$default(visibilityChecker, fir, context.getSession(), file2, containingDeclarations2, null, false, true, null, 160, null)) continue;
                    bl = true;
                    break block17;
                }
                bl = hasVisibleBase = false;
            }
        }
        if (!hasVisibleBase) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)$this$checkVisibility.getSource(), FirErrors.INSTANCE.getCANNOT_OVERRIDE_INVISIBLE_MEMBER(), $this$checkVisibility, CollectionsKt.first(overriddenSymbols2), (DiagnosticContext)context, null, 32, null);
        }
    }

    private final void checkDeprecation(FirCallableSymbol<?> $this$checkDeprecation, DiagnosticReporter reporter2, List<? extends FirCallableSymbol<?>> overriddenSymbols2, CheckerContext context) {
        DeprecationsPerUseSite ownDeprecation = $this$checkDeprecation.getDeprecation();
        if (ownDeprecation == null || ownDeprecation.isNotEmpty()) {
            return;
        }
        for (FirCallableSymbol<?> overriddenSymbol : overriddenSymbols2) {
            Object object;
            DeprecationsPerUseSite deprecationInfoFromOverridden;
            DeprecationInfo deprecationInfo;
            if (overriddenSymbol.getDeprecation() == null || (deprecationInfo = deprecationInfoFromOverridden.getAll()) == null && ((object = deprecationInfoFromOverridden.getBySpecificSite()) != null && (object = object.values()) != null ? (DeprecationInfo)CollectionsKt.firstOrNull((Iterable)((Iterable)object)) : (deprecationInfo = null)) == null) continue;
            DeprecationInfo deprecationFromOverriddenSymbol = deprecationInfo;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)$this$checkDeprecation.getSource(), FirErrors.INSTANCE.getOVERRIDE_DEPRECATION(), overriddenSymbol, (Object)deprecationFromOverriddenSymbol, (DiagnosticContext)context, null, 32, null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FirCallableSymbol<?> checkReturnType(FirCallableSymbol<?> $this$checkReturnType, List<? extends FirCallableSymbol<?>> overriddenSymbols2, TypeCheckerState typeCheckerState, CheckerContext context) {
        void $this$mapTo$iv$iv;
        ConeKotlinType overridingReturnType = FirTypeUtilsKt.getConeType($this$checkReturnType.getResolvedReturnTypeRef());
        if (overridingReturnType instanceof ConeErrorType) {
            return null;
        }
        Iterable $this$map$iv = overriddenSymbols2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirCallableSymbol firCallableSymbol = (FirCallableSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ConeTypeUtilsKt.upperBoundIfFlexible(FirTypeUtilsKt.getConeType(context.getReturnTypeCalculator().tryCalculateReturnType((FirCallableSymbol<?>)it))));
        }
        List bounds = (List)destination$iv$iv;
        int n = bounds.size();
        for (int it = 0; it < n; ++it) {
            boolean isReturnTypeOkForOverride;
            FirCallableSymbol<?> overriddenDeclaration = overriddenSymbols2.get(it);
            ConeKotlinType overriddenReturnType = this.substituteAllTypeParameters((ConeKotlinType)bounds.get(it), $this$checkReturnType, overriddenDeclaration, context);
            boolean bl = isReturnTypeOkForOverride = overriddenDeclaration instanceof FirPropertySymbol && ((FirPropertySymbol)overriddenDeclaration).isVar() ? AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerState, overridingReturnType, overriddenReturnType) : AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerState, (KotlinTypeMarker)overridingReturnType, (KotlinTypeMarker)overriddenReturnType, false, 8, null);
            if (isReturnTypeOkForOverride) continue;
            return overriddenDeclaration;
        }
        return null;
    }

    private final void checkMember(FirCallableSymbol<?> member2, FirClass containingClass, DiagnosticReporter reporter2, TypeCheckerState typeCheckerState, FirTypeScope firTypeScope, CheckerContext context) {
        FirCallableSymbol<?> it;
        List<FirCallableSymbol<?>> overriddenMemberSymbols = this.retrieveDirectOverriddenOf(firTypeScope, member2);
        FirCallableSymbol<?> $this$isOverride$iv = member2;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getResolvedStatus().isOverride()) {
            KtSourceElementKind kind;
            if (overriddenMemberSymbols.isEmpty() || FirOverridesBackwardCompatibilityHelperKt.getOverridesBackwardCompatibilityHelper(context.getSession()).overrideCanBeOmitted(overriddenMemberSymbols, context)) {
                return;
            }
            KtSourceElement ktSourceElement = member2.getSource();
            KtSourceElementKind ktSourceElementKind = kind = ktSourceElement != null ? ktSourceElement.getKind() : null;
            if (kind instanceof KtFakeSourceElementKind.DataClassGeneratedMembers) {
                Object v3;
                block20: {
                    Iterable iterable = overriddenMemberSymbols;
                    for (Object t : iterable) {
                        Modality modality$iv;
                        FirCallableSymbol it2 = (FirCallableSymbol)t;
                        boolean bl = false;
                        FirCallableSymbol $this$isFinal$iv = it2;
                        boolean $i$f$isFinal = false;
                        boolean bl2 = $this$isFinal$iv.getResolvedStatus().getModality() == null ? true : modality$iv == Modality.FINAL;
                        if (!bl2) continue;
                        v3 = t;
                        break block20;
                    }
                    v3 = null;
                }
                FirCallableSymbol firCallableSymbol = v3;
                if (firCallableSymbol != null) {
                    FirCallableSymbol base2 = firCallableSymbol;
                    boolean bl = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)containingClass.getSource(), FirErrors.INSTANCE.getDATA_CLASS_OVERRIDE_CONFLICT(), member2, (Object)base2, (DiagnosticContext)context, null, 32, null);
                }
                return;
            }
            if (!(kind instanceof KtRealSourceElementKind) && !(kind instanceof KtFakeSourceElementKind.PropertyFromParameter)) {
                return;
            }
            FirCallableSymbol $this$originalOrSelf$iv = (FirCallableSymbol)CollectionsKt.first(overriddenMemberSymbols);
            boolean $i$f$originalOrSelf = false;
            FirCallableDeclaration $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
            boolean $i$f$originalOrSelf2 = false;
            FirCallableDeclaration result$iv$iv = $this$originalOrSelf$iv$iv;
            while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                FirCallableDeclaration $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                boolean $i$f$originalIfFakeOverride = false;
                FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                boolean $i$f$getOriginalForSubstitutionOverride = false;
                FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv) : null;
                if (firCallableDeclaration == null) {
                    FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                    boolean $i$f$getBaseForIntersectionOverride = false;
                    firCallableDeclaration = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                }
                if (firCallableDeclaration == null) break;
                result$iv$iv = firCallableDeclaration;
            }
            FirCallableSymbol<? extends FirCallableDeclaration> firCallableSymbol = result$iv$iv.getSymbol();
            if (firCallableSymbol == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
            }
            FirCallableSymbol<? extends FirCallableDeclaration> overridden = firCallableSymbol;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(overridden);
            FirClassLikeSymbol<?> firClassLikeSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context.getSession()) : null;
            FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol originalContainingClassSymbol = firRegularClassSymbol;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)member2.getSource(), FirErrors.INSTANCE.getVIRTUAL_MEMBER_HIDDEN(), member2, (Object)originalContainingClassSymbol, (DiagnosticContext)context, null, 32, null);
            return;
        }
        if (overriddenMemberSymbols.isEmpty()) {
            this.reportNothingToOverride(reporter2, member2, context);
            return;
        }
        this.checkOverriddenExperimentalities(member2, overriddenMemberSymbols, context, reporter2);
        FirCallableSymbol<?> firCallableSymbol = this.checkModality(overriddenMemberSymbols);
        if (firCallableSymbol != null) {
            it = firCallableSymbol;
            boolean bl = false;
            INSTANCE.reportOverridingFinalMember(reporter2, member2, it, context);
        }
        if (member2 instanceof FirPropertySymbol) {
            FirCallableSymbol<?> firCallableSymbol2 = this.checkMutability((FirPropertySymbol)member2, overriddenMemberSymbols);
            if (firCallableSymbol2 != null) {
                it = firCallableSymbol2;
                boolean bl = false;
                INSTANCE.reportVarOverriddenByVal(reporter2, member2, it, context);
            }
        }
        this.checkVisibility(member2, containingClass, reporter2, overriddenMemberSymbols, context);
        this.checkDeprecation(member2, reporter2, overriddenMemberSymbols, context);
        FirCallableSymbol<?> firCallableSymbol3 = this.checkReturnType(member2, overriddenMemberSymbols, typeCheckerState, context);
        if (firCallableSymbol3 == null) {
            return;
        }
        FirCallableSymbol<?> restriction = firCallableSymbol3;
        FirCallableSymbol<?> firCallableSymbol4 = member2;
        if (firCallableSymbol4 instanceof FirNamedFunctionSymbol) {
            this.reportReturnTypeMismatchOnFunction(reporter2, member2, restriction, context);
        } else if (firCallableSymbol4 instanceof FirPropertySymbol) {
            if (((FirPropertySymbol)member2).isVar()) {
                this.reportTypeMismatchOnVariable(reporter2, member2, restriction, context);
            } else {
                this.reportTypeMismatchOnProperty(reporter2, member2, restriction, context);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOverriddenExperimentalities(FirCallableSymbol<?> memberSymbol, List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, CheckerContext context, DiagnosticReporter reporter2) {
        void $this$flatMapTo$iv$iv;
        FirOptInUsageBaseChecker $this$checkOverriddenExperimentalities_u24lambda_u2d13 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        Set overriddenExperimentalities = new LinkedHashSet();
        FirSession session2 = context.getSession();
        Iterable $this$flatMap$iv = overriddenMemberSymbols;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl2 = false;
            FirCallableSymbol firCallableSymbol = it;
            Iterable list$iv$iv = firCallableSymbol instanceof FirIntersectionOverridePropertySymbol ? ((FirIntersectionOverridePropertySymbol)it).getIntersections() : (firCallableSymbol instanceof FirIntersectionOverrideFunctionSymbol ? ((FirIntersectionOverrideFunctionSymbol)it).getIntersections() : (Collection<FirCallableSymbol<Object>>)CollectionsKt.listOf((Object)it));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List overriddenSymbolsWithUnwrappedIntersectionOverrides = (List)destination$iv$iv;
        for (FirCallableSymbol overriddenMemberSymbol : overriddenSymbolsWithUnwrappedIntersectionOverrides) {
            $this$checkOverriddenExperimentalities_u24lambda_u2d13.loadExperimentalitiesFromAnnotationTo(overriddenMemberSymbol, session2, (Collection<FirOptInUsageBaseChecker.Experimentality>)overriddenExperimentalities);
        }
        $this$checkOverriddenExperimentalities_u24lambda_u2d13.reportNotAcceptedOverrideExperimentalities(overriddenExperimentalities, memberSymbol, context, reporter2);
    }

    private final boolean hasAnnotationItselfOrInParent(FirRegularClassSymbol $this$hasAnnotationItselfOrInParent, CheckerContext context, ClassId classId) {
        FirOverrideChecker firOverrideChecker = this;
        FirRegularClassSymbol firRegularClassSymbol = $this$hasAnnotationItselfOrInParent;
        CheckerContext checkerContext = context;
        ClassId classId2 = classId;
        while (true) {
            FirRegularClassSymbol outerClassSymbol;
            FirOverrideChecker firOverrideChecker2 = firOverrideChecker;
            FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol;
            CheckerContext checkerContext2 = checkerContext;
            ClassId classId3 = classId2;
            if (FirAnnotationUtilsKt.getAnnotationByClassId(firRegularClassSymbol2, classId3) != null) {
                return true;
            }
            FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.outerClassSymbol(firRegularClassSymbol2, checkerContext2);
            if ((firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null) == null) {
                return false;
            }
            outerClassSymbol = outerClassSymbol;
            firOverrideChecker = firOverrideChecker2;
            firRegularClassSymbol = outerClassSymbol;
            checkerContext = checkerContext2;
            classId2 = classId3;
        }
    }

    private final void reportNothingToOverride(DiagnosticReporter $this$reportNothingToOverride, FirCallableSymbol<?> declaration, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportNothingToOverride, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNOTHING_TO_OVERRIDE(), declaration, (DiagnosticContext)context, null, 16, null);
    }

    private final void reportOverridingFinalMember(DiagnosticReporter $this$reportOverridingFinalMember, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        block0: {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(overridden);
            if (coneClassLikeLookupTag == null) break block0;
            ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default($this$reportOverridingFinalMember, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getOVERRIDING_FINAL_MEMBER(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context, null, 32, null);
        }
    }

    private final void reportVarOverriddenByVal(DiagnosticReporter $this$reportVarOverriddenByVal, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportVarOverriddenByVal, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getVAR_OVERRIDDEN_BY_VAL(), overriding, overridden, (DiagnosticContext)context, null, 32, null);
    }

    private final void reportCannotWeakenAccessPrivilege(DiagnosticReporter $this$reportCannotWeakenAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportCannotWeakenAccessPrivilege, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getCANNOT_WEAKEN_ACCESS_PRIVILEGE(), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context, null, 64, null);
    }

    private final void reportCannotChangeAccessPrivilege(DiagnosticReporter $this$reportCannotChangeAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportCannotChangeAccessPrivilege, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getCANNOT_CHANGE_ACCESS_PRIVILEGE(), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context, null, 64, null);
    }

    private final void reportReturnTypeMismatchOnFunction(DiagnosticReporter $this$reportReturnTypeMismatchOnFunction, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportReturnTypeMismatchOnFunction, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context, null, 32, null);
    }

    private final void reportTypeMismatchOnProperty(DiagnosticReporter $this$reportTypeMismatchOnProperty, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportTypeMismatchOnProperty, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context, null, 32, null);
    }

    private final void reportTypeMismatchOnVariable(DiagnosticReporter $this$reportTypeMismatchOnVariable, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportTypeMismatchOnVariable, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context, null, 32, null);
    }
}

