/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.Stack;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.AbstractTokenStreamPredicate;
import org.jetbrains.kotlin.parsing.KotlinParsing;
import org.jetbrains.kotlin.parsing.PrecedingCommentsBinder;
import org.jetbrains.kotlin.parsing.PrecedingDocCommentsBinder;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.kotlin.parsing.TokenStreamPattern;
import org.jetbrains.kotlin.parsing.TrailingCommentsBinder;
import org.jetbrains.kotlin.parsing.TruncatedSemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.kotlin.utils.strings.StringsKt;

abstract class AbstractKotlinParsing {
    private static final Map<String, KtKeywordToken> SOFT_KEYWORD_TEXTS = new HashMap<String, KtKeywordToken>();
    protected final SemanticWhitespaceAwarePsiBuilder myBuilder;

    public AbstractKotlinParsing(SemanticWhitespaceAwarePsiBuilder builder2) {
        this.myBuilder = builder2;
    }

    protected IElementType getLastToken() {
        int i;
        int currentOffset = this.myBuilder.getCurrentOffset();
        for (i = 1; i <= currentOffset && KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(this.myBuilder.rawLookup(-i)); ++i) {
        }
        return this.myBuilder.rawLookup(-i);
    }

    protected boolean expect(KtToken expectation, String message) {
        return this.expect(expectation, message, null);
    }

    protected PsiBuilder.Marker mark() {
        return this.myBuilder.mark();
    }

    protected void error(String message) {
        this.myBuilder.error(message);
    }

    protected boolean expect(KtToken expectation, String message, TokenSet recoverySet) {
        if (this.at(expectation)) {
            this.advance();
            return true;
        }
        if (expectation == KtTokens.IDENTIFIER && "`".equals(this.myBuilder.getTokenText())) {
            this.advance();
        }
        this.errorWithRecovery(message, recoverySet);
        return false;
    }

    protected void expectNoAdvance(KtToken expectation, String message) {
        if (this.at(expectation)) {
            this.advance();
            return;
        }
        this.error(message);
    }

    protected void errorWithRecovery(String message, TokenSet recoverySet) {
        IElementType tt = this.tt();
        if (recoverySet == null || recoverySet.contains(tt) || tt == KtTokens.LBRACE || tt == KtTokens.RBRACE || recoverySet.contains((IElementType)KtTokens.EOL_OR_SEMICOLON) && (this.eof() || tt == KtTokens.SEMICOLON || this.myBuilder.newlineBeforeCurrentToken())) {
            this.error(message);
        } else {
            this.errorAndAdvance(message);
        }
    }

    protected void errorAndAdvance(String message) {
        this.errorAndAdvance(message, 1);
    }

    protected void errorAndAdvance(String message, int advanceTokenCount) {
        PsiBuilder.Marker err = this.mark();
        this.advance(advanceTokenCount);
        err.error(message);
    }

    protected boolean eof() {
        return this.myBuilder.eof();
    }

    protected void advance() {
        this.myBuilder.advanceLexer();
    }

    protected void advance(int advanceTokenCount) {
        for (int i = 0; i < advanceTokenCount; ++i) {
            this.advance();
        }
    }

    protected void advanceAt(IElementType current) {
        assert (this._at(current));
        this.myBuilder.advanceLexer();
    }

    protected IElementType tt() {
        return this.myBuilder.getTokenType();
    }

    protected boolean _at(IElementType expectation) {
        IElementType token = this.tt();
        return this.tokenMatches(token, expectation);
    }

    private boolean tokenMatches(IElementType token, IElementType expectation) {
        if (token == expectation) {
            return true;
        }
        if (expectation == KtTokens.EOL_OR_SEMICOLON) {
            if (this.eof()) {
                return true;
            }
            if (token == KtTokens.SEMICOLON) {
                return true;
            }
            if (this.myBuilder.newlineBeforeCurrentToken()) {
                return true;
            }
        }
        return false;
    }

    protected boolean at(IElementType expectation) {
        KtKeywordToken keywordToken;
        KtKeywordToken expectedKeyword;
        if (this._at(expectation)) {
            return true;
        }
        IElementType token = this.tt();
        if (token == KtTokens.IDENTIFIER && expectation instanceof KtKeywordToken && (expectedKeyword = (KtKeywordToken)expectation).isSoft() && expectedKeyword.getValue().equals(this.myBuilder.getTokenText())) {
            this.myBuilder.remapCurrentToken(expectation);
            return true;
        }
        if (expectation == KtTokens.IDENTIFIER && token instanceof KtKeywordToken && (keywordToken = (KtKeywordToken)token).isSoft()) {
            this.myBuilder.remapCurrentToken(KtTokens.IDENTIFIER);
            return true;
        }
        return false;
    }

    protected boolean _atSet(IElementType ... tokens) {
        return this._atSet(TokenSet.create((IElementType[])tokens));
    }

    private boolean _atSet(TokenSet set) {
        IElementType token = this.tt();
        if (set.contains(token)) {
            return true;
        }
        if (set.contains((IElementType)KtTokens.EOL_OR_SEMICOLON)) {
            if (this.eof()) {
                return true;
            }
            if (token == KtTokens.SEMICOLON) {
                return true;
            }
            if (this.myBuilder.newlineBeforeCurrentToken()) {
                return true;
            }
        }
        return false;
    }

    protected boolean atSet(IElementType ... tokens) {
        return this.atSet(TokenSet.create((IElementType[])tokens));
    }

    protected boolean atSet(TokenSet set) {
        if (this._atSet(set)) {
            return true;
        }
        IElementType token = this.tt();
        if (token == KtTokens.IDENTIFIER) {
            KtKeywordToken keywordToken = SOFT_KEYWORD_TEXTS.get(this.myBuilder.getTokenText());
            if (keywordToken != null && set.contains((IElementType)keywordToken)) {
                this.myBuilder.remapCurrentToken(keywordToken);
                return true;
            }
        } else if (set.contains((IElementType)KtTokens.IDENTIFIER) && token instanceof KtKeywordToken && ((KtKeywordToken)token).isSoft()) {
            this.myBuilder.remapCurrentToken(KtTokens.IDENTIFIER);
            return true;
        }
        return false;
    }

    protected IElementType lookahead(int k) {
        return this.myBuilder.lookAhead(k);
    }

    protected boolean consumeIf(KtToken token) {
        if (this.at(token)) {
            this.advance();
            return true;
        }
        return false;
    }

    protected void skipUntil(TokenSet tokenSet) {
        boolean stopAtEolOrSemi = tokenSet.contains((IElementType)KtTokens.EOL_OR_SEMICOLON);
        while (!(this.eof() || tokenSet.contains(this.tt()) || stopAtEolOrSemi && this.at(KtTokens.EOL_OR_SEMICOLON))) {
            this.advance();
        }
    }

    protected void errorUntil(String message, TokenSet tokenSet) {
        assert (tokenSet.contains((IElementType)KtTokens.LBRACE)) : "Cannot include LBRACE into error element!";
        assert (tokenSet.contains((IElementType)KtTokens.RBRACE)) : "Cannot include RBRACE into error element!";
        PsiBuilder.Marker error = this.mark();
        this.skipUntil(tokenSet);
        error.error(message);
    }

    protected static void errorIf(PsiBuilder.Marker marker, boolean condition, String message) {
        if (condition) {
            marker.error(message);
        } else {
            marker.drop();
        }
    }

    protected int matchTokenStreamPredicate(TokenStreamPattern pattern) {
        PsiBuilder.Marker currentPosition = this.mark();
        Stack opens = new Stack();
        int openAngleBrackets = 0;
        int openBraces = 0;
        int openParentheses = 0;
        int openBrackets = 0;
        while (!this.eof() && !pattern.processToken(this.myBuilder.getCurrentOffset(), pattern.isTopLevel(openAngleBrackets, openBrackets, openBraces, openParentheses))) {
            if (this.at(KtTokens.LPAR)) {
                ++openParentheses;
                opens.push((Object)KtTokens.LPAR);
            } else if (this.at(KtTokens.LT)) {
                ++openAngleBrackets;
                opens.push((Object)KtTokens.LT);
            } else if (this.at(KtTokens.LBRACE)) {
                ++openBraces;
                opens.push((Object)KtTokens.LBRACE);
            } else if (this.at(KtTokens.LBRACKET)) {
                ++openBrackets;
                opens.push((Object)KtTokens.LBRACKET);
            } else if (this.at(KtTokens.RPAR)) {
                --openParentheses;
                if ((opens.isEmpty() || opens.pop() != KtTokens.LPAR) && pattern.handleUnmatchedClosing(KtTokens.RPAR)) {
                    break;
                }
            } else if (this.at(KtTokens.GT)) {
                --openAngleBrackets;
            } else if (this.at(KtTokens.RBRACE)) {
                --openBraces;
            } else if (this.at(KtTokens.RBRACKET)) {
                --openBrackets;
            }
            this.advance();
        }
        currentPosition.rollbackTo();
        return pattern.result();
    }

    protected boolean eol() {
        return this.myBuilder.newlineBeforeCurrentToken() || this.eof();
    }

    protected static void closeDeclarationWithCommentBinders(@NotNull PsiBuilder.Marker marker, @NotNull IElementType elementType, boolean precedingNonDocComments) {
        if (marker == null) {
            AbstractKotlinParsing.$$$reportNull$$$0(0);
        }
        if (elementType == null) {
            AbstractKotlinParsing.$$$reportNull$$$0(1);
        }
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders((WhitespacesAndCommentsBinder)(precedingNonDocComments ? PrecedingCommentsBinder.INSTANCE : PrecedingDocCommentsBinder.INSTANCE), (WhitespacesAndCommentsBinder)TrailingCommentsBinder.INSTANCE);
    }

    protected abstract KotlinParsing create(SemanticWhitespaceAwarePsiBuilder var1);

    protected KotlinParsing createTruncatedBuilder(int eofPosition) {
        return this.create(new TruncatedSemanticWhitespaceAwarePsiBuilder(this.myBuilder, eofPosition));
    }

    public String currentContext() {
        return StringsKt.substringWithContext(this.myBuilder.getOriginalText(), this.myBuilder.getCurrentOffset(), this.myBuilder.getCurrentOffset(), 20);
    }

    static {
        for (IElementType type2 : KtTokens.SOFT_KEYWORDS.getTypes()) {
            KtKeywordToken keywordToken = (KtKeywordToken)type2;
            assert (keywordToken.isSoft());
            SOFT_KEYWORD_TEXTS.put(keywordToken.getValue(), keywordToken);
        }
        for (IElementType token : KtTokens.KEYWORDS.getTypes()) {
            assert (token instanceof KtKeywordToken) : "Must be KtKeywordToken: " + token;
            assert (!((KtKeywordToken)token).isSoft()) : "Must not be soft: " + token;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "marker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "elementType";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/parsing/AbstractKotlinParsing";
        objectArray[2] = "closeDeclarationWithCommentBinders";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class AtSet
    extends AbstractTokenStreamPredicate {
        private final TokenSet lookFor;
        private final TokenSet topLevelOnly;

        public AtSet(TokenSet lookFor, TokenSet topLevelOnly) {
            this.lookFor = lookFor;
            this.topLevelOnly = topLevelOnly;
        }

        public AtSet(TokenSet lookFor) {
            this(lookFor, lookFor);
        }

        @Override
        public boolean matching(boolean topLevel) {
            return (topLevel || !AbstractKotlinParsing.this.atSet(this.topLevelOnly)) && AbstractKotlinParsing.this.atSet(this.lookFor);
        }
    }

    protected class At
    extends AbstractTokenStreamPredicate {
        private final IElementType lookFor;
        private final boolean topLevelOnly;

        public At(IElementType lookFor, boolean topLevelOnly) {
            this.lookFor = lookFor;
            this.topLevelOnly = topLevelOnly;
        }

        public At(IElementType lookFor) {
            this(lookFor, true);
        }

        @Override
        public boolean matching(boolean topLevel) {
            return (topLevel || !this.topLevelOnly) && AbstractKotlinParsing.this.at(this.lookFor);
        }
    }

    protected class OptionalMarker {
        private final PsiBuilder.Marker marker;
        private final int offset;

        public OptionalMarker(boolean actuallyMark) {
            this.marker = actuallyMark ? AbstractKotlinParsing.this.mark() : null;
            this.offset = AbstractKotlinParsing.this.myBuilder.getCurrentOffset();
        }

        public void done(IElementType elementType) {
            if (this.marker == null) {
                return;
            }
            this.marker.done(elementType);
        }

        public void error(String message) {
            if (this.marker == null) {
                return;
            }
            if (this.offset == AbstractKotlinParsing.this.myBuilder.getCurrentOffset()) {
                this.marker.drop();
            } else {
                this.marker.error(message);
            }
        }

        public void drop() {
            if (this.marker == null) {
                return;
            }
            this.marker.drop();
        }
    }
}

