/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.evaluate;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValue;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValueFactory;
import org.jetbrains.kotlin.analysis.api.components.KtConstantEvaluationMode;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBooleanTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitByteTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitCharTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitDoubleTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitFloatTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitIntTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitLongTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitShortTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitStringTypeRef;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.OperationsMapGeneratedKt;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0004*\u0006\u0012\u0002\b\u00030\u0004H\u0002J\u001c\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0004*\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0001*\u0006\u0012\u0002\b\u00030\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J*\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\rH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u0013H\u0002J\u001a\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J2\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0004\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u00132\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0002J\u001b\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0013\"\u0004\b\u0000\u0010\u001d*\u0002H\u001dH\u0002\u00a2\u0006\u0002\u0010#J\u0012\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013*\u00020$H\u0002J\u0012\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013*\u00020%H\u0002J\u0012\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013*\u00020\u0011H\u0002\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator;", "", "()V", "evaluate", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "fir", "Lorg/jetbrains/kotlin/fir/FirElement;", "mode", "Lorg/jetbrains/kotlin/analysis/api/components/KtConstantEvaluationMode;", "evaluateAsKtConstantValue", "Lorg/jetbrains/kotlin/analysis/api/base/KtConstantValue;", "evaluateFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "adaptToConstKind", "adjustType", "expectedType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "convertToNumber", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "value", "", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "other", "getOriginalFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "toCompileTimeType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "T", "toConstExpression", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "toConstantValueKind", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/types/ConstantValueKind;", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "analysis-api-fir"})
public final class FirCompileTimeConstantEvaluator {
    @NotNull
    public static final FirCompileTimeConstantEvaluator INSTANCE = new FirCompileTimeConstantEvaluator();

    private FirCompileTimeConstantEvaluator() {
    }

    @Nullable
    public final FirConstExpression<?> evaluate(@Nullable FirElement fir, @NotNull KtConstantEvaluationMode mode) {
        FirConstExpression<Object> firConstExpression;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        FirElement firElement = fir;
        if (firElement instanceof FirPropertyAccessExpression) {
            FirPropertySymbol firPropertySymbol = FirDeclarationUtilKt.getReferredPropertySymbol((FirQualifiedAccess)fir);
            firConstExpression = firPropertySymbol != null ? this.toConstExpression(firPropertySymbol, mode) : null;
        } else {
            FirBasedSymbol<?> resolvedSymbol;
            firConstExpression = firElement instanceof FirConstExpression ? this.adaptToConstKind((FirConstExpression)fir) : (firElement instanceof FirFunctionCall ? this.evaluateFunctionCall((FirFunctionCall)fir, mode) : (firElement instanceof FirNamedReference ? ((resolvedSymbol = UtilsKt.getResolvedSymbol((FirReference)fir)) instanceof FirPropertySymbol ? this.toConstExpression((FirPropertySymbol)resolvedSymbol, mode) : null) : null));
        }
        return firConstExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FirConstExpression<?> toConstExpression(FirPropertySymbol $this$toConstExpression, KtConstantEvaluationMode mode) {
        if (mode == KtConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION) {
            FirCallableSymbol $this$isConst$iv = $this$toConstExpression;
            boolean $i$f$isConst = false;
            if (!$this$isConst$iv.getResolvedStatus().isConst()) {
                return null;
            }
        }
        if (!$this$toConstExpression.isVal()) return null;
        if (!$this$toConstExpression.getHasInitializer()) return null;
        FirPhaseManagerKt.ensureResolved($this$toConstExpression, FirResolvePhase.BODY_RESOLVE);
        FirConstExpression<?> firConstExpression = this.evaluate(((FirProperty)$this$toConstExpression.getFir()).getInitializer(), mode);
        return firConstExpression;
    }

    @Nullable
    public final KtConstantValue evaluateAsKtConstantValue(@NotNull FirElement fir, @NotNull KtConstantEvaluationMode mode) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)fir, (String)"fir");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        FirConstExpression<?> firConstExpression = this.evaluate(fir, mode);
        if (firConstExpression == null) {
            return null;
        }
        FirConstExpression<?> evaluated = firConstExpression;
        KtConstantValue ktConstantValue = KtConstantValueFactory.INSTANCE.createConstantValue(evaluated.getValue(), (psiElement = UtilsKt.getPsi(evaluated)) instanceof KtElement ? (KtElement)psiElement : null);
        if (ktConstantValue == null) {
            return null;
        }
        KtConstantValue ktConstantValue2 = ktConstantValue;
        if (!Intrinsics.areEqual(ktConstantValue2.getConstantValueKind(), evaluated.getKind())) {
            boolean bl = false;
            String string2 = "Expected " + evaluated.getKind() + " for created KtConstantValue but " + ktConstantValue2.getConstantValueKind() + " found";
            throw new IllegalStateException(string2.toString());
        }
        return ktConstantValue2;
    }

    private final FirConstExpression<?> adaptToConstKind(FirConstExpression<?> $this$adaptToConstKind) {
        Object obj;
        ConstantValueKind<?> constantValueKind = $this$adaptToConstKind.getKind();
        KtSourceElement ktSourceElement = $this$adaptToConstKind.getSource();
        Object object = this.convertToNumber($this$adaptToConstKind.getKind(), (obj = $this$adaptToConstKind.getValue()) instanceof Number ? (Number)((Number)obj) : (Number)null);
        if (object == null) {
            object = $this$adaptToConstKind.getValue();
        }
        return this.toConstExpression(constantValueKind, ktSourceElement, object);
    }

    private final FirConstExpression<?> evaluateFunctionCall(FirFunctionCall functionCall, KtConstantEvaluationMode mode) {
        FirPureAbstractElement firPureAbstractElement = this.getOriginalFunction(functionCall);
        FirSimpleFunction firSimpleFunction = firPureAbstractElement instanceof FirSimpleFunction ? (FirSimpleFunction)firPureAbstractElement : null;
        if (firSimpleFunction == null) {
            return null;
        }
        FirSimpleFunction function2 = firSimpleFunction;
        FirConstExpression<?> firConstExpression = this.evaluate(functionCall.getExplicitReceiver(), mode);
        if (firConstExpression == null) {
            return null;
        }
        FirConstExpression<?> opr1 = firConstExpression;
        firPureAbstractElement = this.evaluate(opr1, function2);
        if (firPureAbstractElement != null) {
            FirPureAbstractElement it = firPureAbstractElement;
            boolean bl = false;
            return INSTANCE.adjustType((FirConstExpression<?>)it, functionCall.getTypeRef());
        }
        FirCall $this$argument$iv = functionCall;
        boolean $i$f$getArgument = false;
        FirConstExpression<?> firConstExpression2 = this.evaluate((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()), mode);
        if (firConstExpression2 == null) {
            return null;
        }
        FirConstExpression<?> opr2 = firConstExpression2;
        FirConstExpression<?> firConstExpression3 = this.evaluate(opr1, function2, opr2);
        if (firConstExpression3 != null) {
            FirConstExpression<?> it = firConstExpression3;
            boolean bl = false;
            return INSTANCE.adjustType(it, functionCall.getTypeRef());
        }
        return null;
    }

    private final FirConstExpression<?> adjustType(FirConstExpression<?> $this$adjustType, FirTypeRef expectedType) {
        FirConstExpression<?> expression2;
        FirConstExpression<?> firConstExpression;
        FirConstExpression<?> firConstExpression2;
        ConstantValueKind<?> expectedKind = this.toConstantValueKind((Object)expectedType);
        if (expectedKind != null && !Intrinsics.areEqual(expectedKind, $this$adjustType.getKind()) && $this$adjustType.getValue() instanceof Number) {
            Object obj = $this$adjustType.getValue();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
            Object object = this.convertToNumber(expectedKind, (Number)obj);
            Intrinsics.checkNotNull((Object)object);
            Object typeAdjustedValue = object;
            firConstExpression2 = this.toConstExpression(expectedKind, $this$adjustType.getSource(), typeAdjustedValue);
        } else {
            firConstExpression2 = $this$adjustType;
        }
        FirConstExpression<?> $this$adjustType_u24lambda_u2d3 = firConstExpression = (expression2 = firConstExpression2);
        boolean bl = false;
        $this$adjustType_u24lambda_u2d3.replaceTypeRef(expectedType);
        return firConstExpression;
    }

    private final <T> CompileTimeType toCompileTimeType(ConstantValueKind<T> $this$toCompileTimeType) {
        ConstantValueKind<T> constantValueKind = $this$toCompileTimeType;
        return Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE) ? CompileTimeType.BYTE : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Short.INSTANCE) ? CompileTimeType.SHORT : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Int.INSTANCE) ? CompileTimeType.INT : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Long.INSTANCE) ? CompileTimeType.LONG : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Double.INSTANCE) ? CompileTimeType.DOUBLE : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Float.INSTANCE) ? CompileTimeType.FLOAT : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Char.INSTANCE) ? CompileTimeType.CHAR : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE) ? CompileTimeType.BOOLEAN : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.String.INSTANCE) ? CompileTimeType.STRING : CompileTimeType.ANY))))))));
    }

    private final FirConstExpression<?> evaluate(FirConstExpression<?> $this$evaluate, FirSimpleFunction function2) {
        FirConstExpression<?> firConstExpression;
        Object obj;
        if ($this$evaluate.getValue() == null) {
            return null;
        }
        Object object = this.convertToNumber($this$evaluate.getKind(), (obj = $this$evaluate.getValue()) instanceof Number ? (Number)((Number)obj) : (Number)null);
        if (object != null) {
            Object opr = object;
            boolean bl = false;
            String string2 = function2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"function.name.asString()");
            Object object2 = OperationsMapGeneratedKt.evalUnaryOp(string2, INSTANCE.toCompileTimeType($this$evaluate.getKind()), opr);
            if (object2 != null) {
                Object it = object2;
                boolean bl2 = false;
                firConstExpression = INSTANCE.toConstExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
            } else {
                firConstExpression = null;
            }
        } else {
            firConstExpression = null;
        }
        return firConstExpression;
    }

    private final FirConstExpression<?> evaluate(FirConstExpression<?> $this$evaluate, FirSimpleFunction function2, FirConstExpression<?> other) {
        FirConstExpression<?> firConstExpression;
        Object obj;
        if ($this$evaluate.getValue() == null || other.getValue() == null) {
            return null;
        }
        Object object = this.convertToNumber($this$evaluate.getKind(), (obj = $this$evaluate.getValue()) instanceof Number ? (Number)((Number)obj) : (Number)null);
        if (object != null) {
            Object obj2;
            Object opr1 = object;
            boolean bl = false;
            Object object2 = INSTANCE.convertToNumber(other.getKind(), (obj2 = other.getValue()) instanceof Number ? (Number)((Number)obj2) : (Number)null);
            if (object2 != null) {
                Object opr2 = object2;
                boolean bl2 = false;
                String string2 = function2.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"function.name.asString()");
                Object object3 = OperationsMapGeneratedKt.evalBinaryOp(string2, INSTANCE.toCompileTimeType($this$evaluate.getKind()), opr1, INSTANCE.toCompileTimeType(other.getKind()), opr2);
                if (object3 != null) {
                    Object it = object3;
                    boolean bl3 = false;
                    firConstExpression = INSTANCE.toConstExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
                } else {
                    firConstExpression = null;
                }
            } else {
                firConstExpression = null;
            }
        } else {
            firConstExpression = null;
        }
        return firConstExpression;
    }

    private final ConstantValueKind<?> toConstantValueKind(FirTypeRef $this$toConstantValueKind) {
        FirTypeRef firTypeRef = $this$toConstantValueKind;
        return !(firTypeRef instanceof FirResolvedTypeRef) ? null : (!(firTypeRef instanceof FirImplicitBuiltinTypeRef) ? this.toConstantValueKind((Object)((FirResolvedTypeRef)$this$toConstantValueKind).getType()) : (firTypeRef instanceof FirImplicitByteTypeRef ? (ConstantValueKind)ConstantValueKind.Byte.INSTANCE : (firTypeRef instanceof FirImplicitDoubleTypeRef ? (ConstantValueKind)ConstantValueKind.Double.INSTANCE : (firTypeRef instanceof FirImplicitFloatTypeRef ? (ConstantValueKind)ConstantValueKind.Float.INSTANCE : (firTypeRef instanceof FirImplicitIntTypeRef ? (ConstantValueKind)ConstantValueKind.Int.INSTANCE : (firTypeRef instanceof FirImplicitLongTypeRef ? (ConstantValueKind)ConstantValueKind.Long.INSTANCE : (firTypeRef instanceof FirImplicitShortTypeRef ? (ConstantValueKind)ConstantValueKind.Short.INSTANCE : (firTypeRef instanceof FirImplicitCharTypeRef ? (ConstantValueKind)ConstantValueKind.Char.INSTANCE : (firTypeRef instanceof FirImplicitStringTypeRef ? (ConstantValueKind)ConstantValueKind.String.INSTANCE : (firTypeRef instanceof FirImplicitBooleanTypeRef ? (ConstantValueKind)ConstantValueKind.Boolean.INSTANCE : null))))))))));
    }

    private final ConstantValueKind<?> toConstantValueKind(ConeKotlinType $this$toConstantValueKind) {
        Object object;
        ConeKotlinType coneKotlinType = $this$toConstantValueKind;
        if (coneKotlinType instanceof ConeErrorType) {
            object = null;
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            String string2 = ((ConeLookupTagBasedType)$this$toConstantValueKind).getLookupTag().getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lookupTag.name.asString()");
            object = this.toConstantValueKind((Object)string2);
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            object = this.toConstantValueKind((Object)((ConeFlexibleType)$this$toConstantValueKind).getUpperBound());
        } else if (coneKotlinType instanceof ConeCapturedType) {
            object = ((ConeCapturedType)$this$toConstantValueKind).getLowerType();
            if (object == null || (object = this.toConstantValueKind(object)) == null) {
                List<ConeKotlinType> list2 = ((ConeCapturedType)$this$toConstantValueKind).getConstructor().getSupertypes();
                Intrinsics.checkNotNull(list2);
                object = this.toConstantValueKind((Object)((ConeKotlinType)CollectionsKt.first(list2)));
            }
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            object = this.toConstantValueKind((Object)((ConeDefinitelyNotNullType)$this$toConstantValueKind).getOriginal());
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            object = this.toConstantValueKind((Object)((ConeKotlinType)CollectionsKt.first((Iterable)((ConeIntersectionType)$this$toConstantValueKind).getIntersectedTypes())));
        } else if (coneKotlinType instanceof ConeStubType) {
            object = null;
        } else if (coneKotlinType instanceof ConeIntegerLiteralType) {
            object = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final ConstantValueKind<?> toConstantValueKind(String $this$toConstantValueKind) {
        ConstantValueKind constantValueKind;
        switch ($this$toConstantValueKind) {
            case "Byte": {
                constantValueKind = ConstantValueKind.Byte.INSTANCE;
                break;
            }
            case "Double": {
                constantValueKind = ConstantValueKind.Double.INSTANCE;
                break;
            }
            case "Float": {
                constantValueKind = ConstantValueKind.Float.INSTANCE;
                break;
            }
            case "Int": {
                constantValueKind = ConstantValueKind.Int.INSTANCE;
                break;
            }
            case "Long": {
                constantValueKind = ConstantValueKind.Long.INSTANCE;
                break;
            }
            case "Short": {
                constantValueKind = ConstantValueKind.Short.INSTANCE;
                break;
            }
            case "Char": {
                constantValueKind = ConstantValueKind.Char.INSTANCE;
                break;
            }
            case "String": {
                constantValueKind = ConstantValueKind.String.INSTANCE;
                break;
            }
            case "Boolean": {
                constantValueKind = ConstantValueKind.Boolean.INSTANCE;
                break;
            }
            default: {
                constantValueKind = null;
            }
        }
        return constantValueKind;
    }

    private final <T> ConstantValueKind<?> toConstantValueKind(T $this$toConstantValueKind) {
        ConstantValueKind constantValueKind;
        T t = $this$toConstantValueKind;
        if (t instanceof Byte) {
            constantValueKind = ConstantValueKind.Byte.INSTANCE;
        } else if (t instanceof Double) {
            constantValueKind = ConstantValueKind.Double.INSTANCE;
        } else if (t instanceof Float) {
            constantValueKind = ConstantValueKind.Float.INSTANCE;
        } else if (t instanceof Integer) {
            constantValueKind = ConstantValueKind.Int.INSTANCE;
        } else if (t instanceof Long) {
            constantValueKind = ConstantValueKind.Long.INSTANCE;
        } else if (t instanceof Short) {
            constantValueKind = ConstantValueKind.Short.INSTANCE;
        } else if (t instanceof Character) {
            constantValueKind = ConstantValueKind.Char.INSTANCE;
        } else if (t instanceof String) {
            constantValueKind = ConstantValueKind.String.INSTANCE;
        } else if (t instanceof Boolean) {
            constantValueKind = ConstantValueKind.Boolean.INSTANCE;
        } else if (t == null) {
            constantValueKind = ConstantValueKind.Null.INSTANCE;
        } else {
            throw new IllegalStateException("Unknown constant value".toString());
        }
        return constantValueKind;
    }

    private final Object convertToNumber(ConstantValueKind<?> $this$convertToNumber, Number value2) {
        if (value2 == null) {
            return null;
        }
        return Intrinsics.areEqual($this$convertToNumber, (Object)ConstantValueKind.Byte.INSTANCE) ? (Comparable)Byte.valueOf(value2.byteValue()) : (Intrinsics.areEqual($this$convertToNumber, (Object)ConstantValueKind.Double.INSTANCE) ? (Comparable)Double.valueOf(value2.doubleValue()) : (Intrinsics.areEqual($this$convertToNumber, (Object)ConstantValueKind.Float.INSTANCE) ? (Comparable)Float.valueOf(value2.floatValue()) : (Intrinsics.areEqual($this$convertToNumber, (Object)ConstantValueKind.Int.INSTANCE) ? (Comparable)Integer.valueOf(value2.intValue()) : (Intrinsics.areEqual($this$convertToNumber, (Object)ConstantValueKind.Long.INSTANCE) ? (Comparable)Long.valueOf(value2.longValue()) : (Intrinsics.areEqual($this$convertToNumber, (Object)ConstantValueKind.Short.INSTANCE) ? (Comparable)Short.valueOf(value2.shortValue()) : (Intrinsics.areEqual($this$convertToNumber, (Object)ConstantValueKind.UnsignedByte.INSTANCE) ? UByte.box-impl((byte)UByte.constructor-impl((byte)((byte)value2.longValue()))) : (Intrinsics.areEqual($this$convertToNumber, (Object)ConstantValueKind.UnsignedShort.INSTANCE) ? UShort.box-impl((short)UShort.constructor-impl((short)((short)value2.longValue()))) : (Intrinsics.areEqual($this$convertToNumber, (Object)ConstantValueKind.UnsignedInt.INSTANCE) ? UInt.box-impl((int)UInt.constructor-impl((int)((int)value2.longValue()))) : (Intrinsics.areEqual($this$convertToNumber, (Object)ConstantValueKind.UnsignedLong.INSTANCE) ? ULong.box-impl((long)ULong.constructor-impl((long)value2.longValue())) : null)))))))));
    }

    private final <T> FirConstExpression<T> toConstExpression(ConstantValueKind<T> $this$toConstExpression, KtSourceElement source, Object value2) {
        return FirConstExpressionBuilderKt.buildConstExpression$default(source, $this$toConstExpression, value2, null, false, 24, null);
    }

    private final FirCallableDeclaration getOriginalFunction(FirFunctionCall $this$getOriginalFunction) {
        FirBasedSymbol<?> symbol2;
        FirNamedReference reference = $this$getOriginalFunction.getCalleeReference();
        FirBasedSymbol<?> firBasedSymbol = symbol2 = reference instanceof FirResolvedNamedReference ? ((FirResolvedNamedReference)reference).getResolvedSymbol() : null;
        Object obj = firBasedSymbol != null ? firBasedSymbol.getFir() : null;
        return obj instanceof FirCallableDeclaration ? (FirCallableDeclaration)obj : null;
    }
}

