/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.renderer;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.components.KtDeclarationRendererOptions;
import org.jetbrains.kotlin.analysis.api.components.RendererModifier;
import org.jetbrains.kotlin.analysis.api.fir.renderer.ConeTypeIdeRenderer;
import org.jetbrains.kotlin.analysis.api.fir.renderer.FirAnnotationsIdeRendererKt;
import org.jetbrains.kotlin.analysis.api.fir.renderer.FirIdeRendererBase;
import org.jetbrains.kotlin.analysis.api.fir.types.PublicTypeApproximator;
import org.jetbrains.kotlin.analysis.utils.printer.PrettyPrinter;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0014\u0010\u0018\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0004J\u0014\u0010\u001a\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0017H\u0004J\u001c\u0010\u001c\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0004J\u0014\u0010 \u001a\u00020\u0014*\u00020\u00152\u0006\u0010!\u001a\u00020\u0019H\u0002J\u0014\u0010\"\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0014\u0010#\u001a\u00020\u0014*\u00020\u00152\u0006\u0010$\u001a\u00020\u0019H\u0002J\u0014\u0010%\u001a\u00020\u0014*\u00020\u00152\u0006\u0010&\u001a\u00020'H\u0004J\u0014\u0010(\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J\u001e\u0010(\u001a\u00020\u0014*\u00020\u00152\u0006\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020\u001eH\u0004J\u0014\u0010,\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/renderer/FirIdeRendererBase;", "", "options", "Lorg/jetbrains/kotlin/analysis/api/components/KtDeclarationRendererOptions;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/analysis/api/components/KtDeclarationRendererOptions;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getOptions", "()Lorg/jetbrains/kotlin/analysis/api/components/KtDeclarationRendererOptions;", "typeIdeRenderer", "Lorg/jetbrains/kotlin/analysis/api/fir/renderer/ConeTypeIdeRenderer;", "getTypeIdeRenderer", "()Lorg/jetbrains/kotlin/analysis/api/fir/renderer/ConeTypeIdeRenderer;", "getUseSiteSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "renderTypeToString", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "renderAnnotations", "", "Lorg/jetbrains/kotlin/analysis/utils/printer/PrettyPrinter;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "renderAnnotationsAndModifiers", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "renderClassifierKind", "classifier", "renderIf", "value", "", "text", "renderModality", "memberDeclaration", "renderName", "renderOverride", "callableMember", "renderSuperTypes", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "renderType", "firRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "approximate", "renderVisibility", "analysis-api-fir"})
public abstract class FirIdeRendererBase {
    @NotNull
    private final KtDeclarationRendererOptions options;
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final ConeTypeIdeRenderer typeIdeRenderer;

    public FirIdeRendererBase(@NotNull KtDeclarationRendererOptions options, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        this.options = options;
        this.useSiteSession = useSiteSession;
        this.typeIdeRenderer = new ConeTypeIdeRenderer(this.useSiteSession, this.options.getTypeRendererOptions());
    }

    @NotNull
    protected final KtDeclarationRendererOptions getOptions() {
        return this.options;
    }

    @NotNull
    protected final FirSession getUseSiteSession() {
        return this.useSiteSession;
    }

    @NotNull
    protected final ConeTypeIdeRenderer getTypeIdeRenderer() {
        return this.typeIdeRenderer;
    }

    protected final void renderAnnotations(@NotNull PrettyPrinter $this$renderAnnotations, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)$this$renderAnnotations, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.options.getModifiers().contains((Object)RendererModifier.ANNOTATIONS)) {
            boolean isSingleLineAnnotations = declaration instanceof FirValueParameter || declaration instanceof FirTypeParameter;
            FirAnnotationsIdeRendererKt.renderAnnotations($this$renderAnnotations, this.typeIdeRenderer, declaration.getAnnotations(), this.useSiteSession, isSingleLineAnnotations);
        }
    }

    @NotNull
    protected final String renderTypeToString(@NotNull ConeTypeProjection type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return this.typeIdeRenderer.renderType(type2);
    }

    protected final void renderType(@NotNull PrettyPrinter $this$renderType, @NotNull ConeTypeProjection type2) {
        Intrinsics.checkNotNullParameter((Object)$this$renderType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        $this$renderType.append(this.renderTypeToString(type2));
    }

    protected final void renderType(@NotNull PrettyPrinter $this$renderType, @NotNull FirTypeRef firRef, boolean approximate) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2;
        Intrinsics.checkNotNullParameter((Object)$this$renderType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)firRef, (String)"firRef");
        ConeKotlinType coneType = FirTypeUtilsKt.getConeType(firRef);
        boolean $this$ifTrue$iv = approximate;
        boolean $i$f$ifTrue = false;
        if ($this$ifTrue$iv) {
            boolean bl = false;
            coneKotlinType2 = PublicTypeApproximator.INSTANCE.approximateTypeToPublicDenotable(coneType, this.useSiteSession, true);
        } else {
            coneKotlinType2 = coneKotlinType = null;
        }
        if (coneKotlinType2 == null) {
            coneKotlinType = coneType;
        }
        ConeKotlinType approximatedIfNeeded = coneKotlinType;
        this.renderType($this$renderType, approximatedIfNeeded);
    }

    public static /* synthetic */ void renderType$default(FirIdeRendererBase firIdeRendererBase, PrettyPrinter prettyPrinter, FirTypeRef firTypeRef, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: renderType");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        firIdeRendererBase.renderType(prettyPrinter, firTypeRef, bl);
    }

    protected final void renderName(@NotNull PrettyPrinter $this$renderName, @NotNull FirDeclaration declaration) {
        Name name2;
        Intrinsics.checkNotNullParameter((Object)$this$renderName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof FirAnonymousObject) {
            $this$renderName.append("<no name provided>");
            return;
        }
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirRegularClass) {
            name2 = ((FirRegularClass)declaration).getName();
        } else if (firDeclaration instanceof FirSimpleFunction) {
            name2 = ((FirSimpleFunction)declaration).getName();
        } else if (firDeclaration instanceof FirProperty) {
            name2 = ((FirProperty)declaration).getName();
        } else if (firDeclaration instanceof FirValueParameter) {
            name2 = ((FirValueParameter)declaration).getName();
        } else if (firDeclaration instanceof FirTypeParameter) {
            name2 = ((FirTypeParameter)declaration).getName();
        } else if (firDeclaration instanceof FirTypeAlias) {
            name2 = ((FirTypeAlias)declaration).getName();
        } else if (firDeclaration instanceof FirEnumEntry) {
            name2 = ((FirEnumEntry)declaration).getName();
        } else if (firDeclaration instanceof FirField) {
            name2 = ((FirField)declaration).getName();
        } else {
            String string2 = "Unexpected declaration " + Reflection.getOrCreateKotlinClass(declaration.getClass()).getQualifiedName();
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
        Name name3 = name2;
        $this$renderName.append(RenderingUtilsKt.render(name3));
    }

    /*
     * WARNING - void declaration
     */
    private final void renderVisibility(PrettyPrinter $this$renderVisibility, FirMemberDeclaration declaration) {
        void currentVisibility;
        Visibility visibility2;
        void $this$applyIf$iv;
        if (declaration instanceof FirConstructor) {
            boolean bl;
            Object object = ClassMembersKt.containingClass((FirCallableDeclaration)declaration);
            if (object != null && (object = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object, this.useSiteSession)) != null) {
                FirClassSymbol $this$isEnumClass$iv = (FirClassSymbol)object;
                boolean $i$f$isEnumClass = false;
                ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                boolean $i$f$isEnumClass2 = false;
                bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
            } else {
                bl = false;
            }
            if (bl) {
                return;
            }
        }
        FirMemberDeclaration $this$visibility$iv = declaration;
        boolean $i$f$getVisibility22 = false;
        Visibility visibility3 = $this$visibility$iv.getStatus().getVisibility();
        if (!this.options.getModifiers().contains((Object)RendererModifier.VISIBILITY)) {
            return;
        }
        Visibility $i$f$getVisibility22 = visibility3;
        $i$f$getVisibility22 = Intrinsics.areEqual((Object)$i$f$getVisibility22, (Object)Visibilities.Local.INSTANCE) ? (Visibility)Visibilities.Public.INSTANCE : (Intrinsics.areEqual((Object)$i$f$getVisibility22, (Object)Visibilities.PrivateToThis.INSTANCE) ? (Visibility)Visibilities.Public.INSTANCE : (Intrinsics.areEqual((Object)$i$f$getVisibility22, (Object)Visibilities.InvisibleFake.INSTANCE) ? (Visibility)Visibilities.Public.INSTANCE : (Intrinsics.areEqual((Object)$i$f$getVisibility22, (Object)Visibilities.Inherited.INSTANCE) ? (Visibility)Visibilities.Public.INSTANCE : (Intrinsics.areEqual((Object)$i$f$getVisibility22, (Object)Visibilities.Unknown.INSTANCE) ? (Visibility)Visibilities.Public.INSTANCE : visibility3))));
        boolean if$iv = this.options.getNormalizedVisibilities();
        boolean $i$f$applyIf = false;
        if (if$iv) {
            void $this$renderVisibility_u24lambda_u241 = $this$applyIf$iv;
            boolean bl = false;
            visibility2 = $this$renderVisibility_u24lambda_u241.normalize();
        } else {
            visibility2 = currentVisibility = $this$applyIf$iv;
        }
        if (Intrinsics.areEqual((Object)currentVisibility, (Object)Visibilities.INSTANCE.getDEFAULT_VISIBILITY())) {
            return;
        }
        $this$renderVisibility.append(currentVisibility.getInternalDisplayName());
        $this$renderVisibility.append(' ');
    }

    private final void renderModality(PrettyPrinter $this$renderModality, FirMemberDeclaration memberDeclaration) {
        boolean bl;
        FirMemberDeclaration $this$modality$iv = memberDeclaration;
        boolean $i$f$getModality = false;
        Modality modality = $this$modality$iv.getStatus().getModality();
        if (modality == null) {
            return;
        }
        Modality modality2 = modality;
        FirRegularClass firRegularClass = memberDeclaration instanceof FirRegularClass ? (FirRegularClass)memberDeclaration : null;
        if (firRegularClass != null) {
            FirClass $this$isInterface$iv = firRegularClass;
            boolean $i$f$isInterface = false;
            ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
            boolean $i$f$isInterface2 = false;
            bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
        } else {
            bl = false;
        }
        if (bl) {
            return;
        }
        if (modality2 == Modality.FINAL) {
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(memberDeclaration, this.useSiteSession);
        if ((firClassLikeSymbol != null ? FirHelpersKt.getClassKind(firClassLikeSymbol) : null) == ClassKind.INTERFACE) {
            return;
        }
        FirMemberDeclaration $this$isOverride$iv = memberDeclaration;
        boolean $i$f$isOverride = false;
        if ($this$isOverride$iv.getStatus().isOverride()) {
            return;
        }
        this.renderIf($this$renderModality, this.options.getModifiers().contains((Object)RendererModifier.MODALITY), CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(modality2.name()));
    }

    private final void renderOverride(PrettyPrinter $this$renderOverride, FirMemberDeclaration callableMember) {
        if (!this.options.getModifiers().contains((Object)RendererModifier.OVERRIDE)) {
            return;
        }
        FirMemberDeclaration $this$isOverride$iv = callableMember;
        boolean $i$f$isOverride = false;
        this.renderIf($this$renderOverride, $this$isOverride$iv.getStatus().isOverride() || this.options.getForceRenderingOverrideModifier(), "override");
    }

    protected final void renderIf(@NotNull PrettyPrinter $this$renderIf, boolean value2, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)$this$renderIf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (value2) {
            $this$renderIf.append(text2);
            $this$renderIf.append(" ");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final void renderAnnotationsAndModifiers(@NotNull PrettyPrinter $this$renderAnnotationsAndModifiers, @NotNull FirMemberDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)$this$renderAnnotationsAndModifiers, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!this.options.getRenderDeclarationHeader()) {
            return;
        }
        this.renderAnnotations($this$renderAnnotationsAndModifiers, declaration);
        this.renderVisibility($this$renderAnnotationsAndModifiers, declaration);
        this.renderOverride($this$renderAnnotationsAndModifiers, declaration);
        this.renderModality($this$renderAnnotationsAndModifiers, declaration);
        $this$isExternal$iv = declaration;
        $i$f$isExternal = false;
        this.renderIf($this$renderAnnotationsAndModifiers, $this$isExternal$iv.getStatus().isExternal(), "external");
        if (!this.options.getModifiers().contains((Object)RendererModifier.EXPECT)) ** GOTO lbl-1000
        $this$isExpect$iv = declaration;
        $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.renderIf($this$renderAnnotationsAndModifiers, v0, "expect");
        if (!this.options.getModifiers().contains((Object)RendererModifier.ACTUAL)) ** GOTO lbl-1000
        $this$isActual$iv = declaration;
        $i$f$isActual = false;
        if ($this$isActual$iv.getStatus().isActual()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        this.renderIf($this$renderAnnotationsAndModifiers, v1, "actual");
        $this$isTailRec$iv = declaration;
        $i$f$isTailRec = false;
        this.renderIf($this$renderAnnotationsAndModifiers, $this$isTailRec$iv.getStatus().isTailRec(), "tailrec");
        $this$isConst$iv = declaration;
        $i$f$isConst = false;
        this.renderIf($this$renderAnnotationsAndModifiers, $this$isConst$iv.getStatus().isConst(), "const");
        $this$isInner$iv = declaration;
        $i$f$isInner = false;
        this.renderIf($this$renderAnnotationsAndModifiers, $this$isInner$iv.getStatus().isInner(), "inner");
        $this$isLateInit$iv = declaration;
        $i$f$isLateInit = false;
        this.renderIf($this$renderAnnotationsAndModifiers, $this$isLateInit$iv.getStatus().isLateInit(), "lateinit");
        $this$isSuspend$iv = declaration;
        $i$f$isSuspend = false;
        this.renderIf($this$renderAnnotationsAndModifiers, $this$isSuspend$iv.getStatus().isSuspend(), "suspend");
        $this$isInline$iv = declaration;
        $i$f$isInline = false;
        this.renderIf($this$renderAnnotationsAndModifiers, $this$isInline$iv.getStatus().isInline(), "inline");
        $this$isInfix$iv = declaration;
        $i$f$isInfix = false;
        this.renderIf($this$renderAnnotationsAndModifiers, $this$isInfix$iv.getStatus().isInfix(), "infix");
        if (!this.options.getModifiers().contains((Object)RendererModifier.OPERATOR)) ** GOTO lbl-1000
        $this$isOperator$iv = declaration;
        $i$f$isOperator = false;
        if ($this$isOperator$iv.getStatus().isOperator()) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        this.renderIf($this$renderAnnotationsAndModifiers, v2, "operator");
    }

    protected final void renderClassifierKind(@NotNull PrettyPrinter $this$renderClassifierKind, @NotNull FirDeclaration classifier) {
        Intrinsics.checkNotNullParameter((Object)$this$renderClassifierKind, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classifier, (String)"classifier");
        FirDeclaration firDeclaration = classifier;
        if (firDeclaration instanceof FirTypeAlias) {
            $this$renderClassifierKind.append("typealias");
        } else if (firDeclaration instanceof FirRegularClass) {
            CharSequence[] charSequenceArray = new CharSequence[1];
            FirRegularClass $this$isCompanion$iv = (FirRegularClass)classifier;
            boolean $i$f$isCompanion = false;
            charSequenceArray[0] = $this$isCompanion$iv.getStatus().isCompanion() ? "companion object" : ((FirRegularClass)classifier).getClassKind().getCodeRepresentation();
            StringsKt.append((Appendable)$this$renderClassifierKind, (CharSequence[])charSequenceArray);
        } else if (firDeclaration instanceof FirAnonymousObject) {
            $this$renderClassifierKind.append("object");
        } else if (firDeclaration instanceof FirEnumEntry) {
            $this$renderClassifierKind.append("enum entry");
        } else {
            throw new AssertionError((Object)("Unexpected classifier: " + classifier));
        }
        $this$renderClassifierKind.append(' ');
    }

    /*
     * WARNING - void declaration
     */
    protected final void renderSuperTypes(@NotNull PrettyPrinter $this$renderSuperTypes, @NotNull FirClass klass) {
        List supertypes2;
        block10: {
            block9: {
                Sequence sequence2;
                Sequence sequence3;
                void $this$applyIf$iv;
                Intrinsics.checkNotNullParameter((Object)$this$renderSuperTypes, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
                if (ConeBuiltinTypeUtilsKt.isNothing(ScopeUtilsKt.defaultType(klass))) {
                    return;
                }
                Sequence sequence4 = CollectionsKt.asSequence((Iterable)klass.getSuperTypeRefs());
                boolean if$iv = klass.getClassKind() == ClassKind.ENUM_CLASS;
                boolean $i$f$applyIf = false;
                if (if$iv) {
                    void $this$renderSuperTypes_u24lambda_u242 = $this$applyIf$iv;
                    boolean bl = false;
                    sequence3 = SequencesKt.filterNot((Sequence)$this$renderSuperTypes_u24lambda_u242, (Function1)renderSuperTypes.supertypes.1.1.INSTANCE);
                } else {
                    sequence3 = $this$applyIf$iv;
                }
                $this$applyIf$iv = sequence3;
                if$iv = klass.getClassKind() == ClassKind.ANNOTATION_CLASS;
                $i$f$applyIf = false;
                if (if$iv) {
                    void $this$renderSuperTypes_u24lambda_u243 = $this$applyIf$iv;
                    boolean bl = false;
                    sequence2 = SequencesKt.filterNot((Sequence)$this$renderSuperTypes_u24lambda_u243, (Function1)renderSuperTypes.supertypes.2.1.INSTANCE);
                } else {
                    sequence2 = $this$applyIf$iv;
                }
                supertypes2 = SequencesKt.toList((Sequence)sequence2);
                if (supertypes2.isEmpty()) break block9;
                FirTypeRef firTypeRef = (FirTypeRef)CollectionsKt.singleOrNull(klass.getSuperTypeRefs());
                boolean bl = firTypeRef != null ? FirTypeUtilsKt.isAny(firTypeRef) : false;
                if (!bl) break block10;
            }
            return;
        }
        $this$renderSuperTypes.append(": ");
        String separator$iv = ", ";
        String prefix$iv = "";
        String postfix$iv = "";
        boolean $i$f$printCollection = false;
        $this$renderSuperTypes.append(prefix$iv);
        Iterator iterator$iv = ((Iterable)supertypes2).iterator();
        while (iterator$iv.hasNext()) {
            void it;
            FirTypeRef firTypeRef = (FirTypeRef)iterator$iv.next();
            PrettyPrinter $this$renderSuperTypes_u24lambda_u244 = $this$renderSuperTypes;
            boolean bl = false;
            FirIdeRendererBase.renderType$default(this, $this$renderSuperTypes_u24lambda_u244, (FirTypeRef)it, false, 2, null);
            if (!iterator$iv.hasNext()) continue;
            $this$renderSuperTypes.append(separator$iv);
        }
        $this$renderSuperTypes.append(postfix$iv);
        $this$renderSuperTypes.append(' ');
    }
}

