/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone;

import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProject;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.impl.base.references.HLApiReferenceProviderService;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.standalone.RegisterComponentService;
import org.jetbrains.kotlin.analysis.decompiled.light.classes.ClsJavaStubByVirtualFileCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.services.FirSealedClassInheritorsProcessorFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.services.PackagePartProviderFactory;
import org.jetbrains.kotlin.analysis.project.structure.KtModuleScopeProvider;
import org.jetbrains.kotlin.analysis.project.structure.KtModuleScopeProviderImpl;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProvider;
import org.jetbrains.kotlin.analysis.project.structure.impl.KtModuleUtilsKt;
import org.jetbrains.kotlin.analysis.providers.KotlinAnnotationsResolverFactory;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProviderFactory;
import org.jetbrains.kotlin.analysis.providers.KotlinModificationTrackerFactory;
import org.jetbrains.kotlin.analysis.providers.KotlinPackageProviderFactory;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticAnnotationsResolverFactory;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticDeclarationProviderFactory;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticModificationTrackerFactory;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticPackageProviderFactory;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.fir.declarations.SealedClassInheritorsProvider;
import org.jetbrains.kotlin.fir.declarations.SealedClassInheritorsProviderImpl;
import org.jetbrains.kotlin.idea.references.KotlinFirReferenceContributor;
import org.jetbrains.kotlin.idea.references.KotlinReferenceProviderContributor;
import org.jetbrains.kotlin.light.classes.symbol.KotlinAsJavaFirSupport;
import org.jetbrains.kotlin.light.classes.symbol.caches.SymbolLightClassFacadeCache;
import org.jetbrains.kotlin.load.kotlin.PackagePartProvider;
import org.jetbrains.kotlin.psi.KotlinReferenceProvidersService;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a*\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u001a:\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"configureApplicationEnvironment", "", "app", "Lcom/intellij/mock/MockApplication;", "configureProjectEnvironment", "project", "Lcom/intellij/mock/MockProject;", "compilerConfig", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "packagePartProvider", "Lkotlin/Function1;", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/kotlin/load/kotlin/PackagePartProvider;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "reRegisterJavaElementFinder", "Lcom/intellij/openapi/project/Project;", "analysis-api-standalone"})
public final class StandaloneUtilsKt {
    public static final void configureApplicationEnvironment(@NotNull MockApplication app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        if (app.getServiceIfCreated(KotlinReferenceProvidersService.class) == null) {
            app.registerService(KotlinReferenceProvidersService.class, HLApiReferenceProviderService.class);
        }
        if (app.getServiceIfCreated(KotlinReferenceProviderContributor.class) == null) {
            app.registerService(KotlinReferenceProviderContributor.class, KotlinFirReferenceContributor.class);
        }
    }

    public static final void configureProjectEnvironment(@NotNull MockProject project, @NotNull CompilerConfiguration compilerConfig, @NotNull Function1<? super GlobalSearchScope, ? extends PackagePartProvider> packagePartProvider) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)compilerConfig, (String)"compilerConfig");
        Intrinsics.checkNotNullParameter(packagePartProvider, (String)"packagePartProvider");
        Collection paths$iv = KtModuleUtilsKt.getSourceFilePaths$default(compilerConfig, false, 2, null);
        boolean $i$f$getPsiFilesFromPaths = false;
        VirtualFileSystem fs$iv = StandardFileSystems.local();
        PsiManager psiManager2 = PsiManager.getInstance((Project)((Project)project));
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(project)");
        PsiManager psiManager$iv = psiManager2;
        List $this$getPsiFilesFromPaths_u24lambda_u243$iv = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (String path$iv : paths$iv) {
            PsiFileSystemItem it$iv;
            PsiFileSystemItem psiFileSystemItem$iv;
            PsiFileSystemItem psiFileSystemItem;
            VirtualFile vFile$iv;
            if (fs$iv.findFileByPath(path$iv) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)vFile$iv, (String)"fs.findFileByPath(path) ?: continue");
            if (vFile$iv.isDirectory()) {
                PsiDirectory psiDirectory = psiManager$iv.findDirectory(vFile$iv);
                if (!(psiDirectory instanceof KtFile)) {
                    psiDirectory = null;
                }
                psiFileSystemItem = (PsiFileSystemItem)((KtFile)psiDirectory);
            } else {
                PsiFile psiFile = psiManager$iv.findFile(vFile$iv);
                if (!(psiFile instanceof KtFile)) {
                    psiFile = null;
                }
                psiFileSystemItem = psiFileSystemItem$iv = (PsiFileSystemItem)((KtFile)psiFile);
            }
            if (psiFileSystemItem$iv == null) continue;
            boolean bl2 = false;
            $this$getPsiFilesFromPaths_u24lambda_u243$iv.add(it$iv);
        }
        List ktFiles = CollectionsKt.build((List)list2);
        StandaloneUtilsKt.configureProjectEnvironment(project, compilerConfig, ktFiles, packagePartProvider);
    }

    public static final void configureProjectEnvironment(@NotNull MockProject project, @NotNull CompilerConfiguration compilerConfig, @NotNull List<? extends KtFile> ktFiles, @NotNull Function1<? super GlobalSearchScope, ? extends PackagePartProvider> packagePartProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)compilerConfig, (String)"compilerConfig");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        Intrinsics.checkNotNullParameter(packagePartProvider, (String)"packagePartProvider");
        StandaloneUtilsKt.reRegisterJavaElementFinder((Project)project);
        project.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(KotlinModificationTrackerFactory.class).getQualifiedName(), (Object)new KotlinStaticModificationTrackerFactory());
        project.registerService(SymbolLightClassFacadeCache.class, (Object)new SymbolLightClassFacadeCache((Project)project));
        project.registerService(ClsJavaStubByVirtualFileCache.class, (Object)new ClsJavaStubByVirtualFileCache());
        project.registerService(KotlinAnnotationsResolverFactory.class, (Object)new KotlinStaticAnnotationsResolverFactory((Collection<? extends KtFile>)ktFiles));
        RegisterComponentService.registerLLFirResolveSessionService(project);
        project.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(FirSealedClassInheritorsProcessorFactory.class).getQualifiedName(), (Object)new FirSealedClassInheritorsProcessorFactory(){

            @NotNull
            public SealedClassInheritorsProvider createSealedClassInheritorsProvider() {
                return SealedClassInheritorsProviderImpl.INSTANCE;
            }
        });
        project.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(KtModuleScopeProvider.class).getQualifiedName(), (Object)new KtModuleScopeProviderImpl());
        project.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(ProjectStructureProvider.class).getQualifiedName(), (Object)KtModuleUtilsKt.buildKtModuleProviderByCompilerConfiguration(compilerConfig, (Project)project, ktFiles));
        project.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(KotlinDeclarationProviderFactory.class).getQualifiedName(), (Object)new KotlinStaticDeclarationProviderFactory((Collection<? extends KtFile>)ktFiles));
        project.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(KotlinPackageProviderFactory.class).getQualifiedName(), (Object)new KotlinStaticPackageProviderFactory((Collection<? extends KtFile>)ktFiles));
        project.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(PackagePartProviderFactory.class).getQualifiedName(), (Object)new PackagePartProviderFactory(packagePartProvider){
            final /* synthetic */ Function1<GlobalSearchScope, PackagePartProvider> $packagePartProvider;
            {
                this.$packagePartProvider = $packagePartProvider;
            }

            @NotNull
            public PackagePartProvider createPackagePartProviderForLibrary(@NotNull GlobalSearchScope scope2) {
                Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
                return (PackagePartProvider)this.$packagePartProvider.invoke((Object)scope2);
            }
        });
    }

    private static final void reRegisterJavaElementFinder(Project project) {
        PsiElementFinder.EP.getPoint((AreaInstance)project).unregisterExtension(JavaElementFinder.class);
        Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type com.intellij.mock.MockProject");
        MockProject $this$reRegisterJavaElementFinder_u24lambda_u240 = (MockProject)project;
        boolean bl = false;
        $this$reRegisterJavaElementFinder_u24lambda_u240.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(KtAnalysisSessionProvider.class).getQualifiedName(), (Object)new KtFirAnalysisSessionProvider((Project)$this$reRegisterJavaElementFinder_u24lambda_u240));
        $this$reRegisterJavaElementFinder_u24lambda_u240.getPicoContainer().unregisterComponent((Object)Reflection.getOrCreateKotlinClass(KotlinAsJavaSupport.class).getQualifiedName());
        $this$reRegisterJavaElementFinder_u24lambda_u240.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(KotlinAsJavaSupport.class).getQualifiedName(), (Object)new KotlinAsJavaFirSupport(project));
        PsiElementFinder.EP.getPoint((AreaInstance)project).registerExtension((Object)new JavaElementFinder(project));
    }
}

